<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/8/19
 * Time: 16:26
 */

namespace app\api\controller\plus\customer;


use app\api\controller\Controller;
use app\api\model\plus\customer\Customer as CustomerModel;

class Customer extends Controller
{

    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->user = $this->getUser();   // 用户信息
        $this->model = new CustomerModel();
    }
    private $user;
    private $model;


    /**
     * 个人客户列表
     * @return \think\response\Json
     */
    public function getmyList(){
        $list = $this->model->getmyList($this->user["user_id"]);
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 客户详情
     * @return \think\response\Json
     */
    public function getQueryList(){
        $list = $this->model->getQueryList($this->user["user_id"],$this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 根据地名获取经纬度
     * @return \think\response\Json
     */
    public function getAddress(){
        $list = $this->model->getAddress($this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 修改客户信息
     * @return \think\response\Json
     */
    public function put_my_customer(){
        $list = $this->model->put_my_customer($this->request->post());
        if ($list){
            return $this->renderSuccess('修改成功');
        }
        return $this->renderError( '修改失败');
    }

    public function getPickerList(){
        $list = $this->model->getPickerList($this->user["user_id"]);
        return $this->renderSuccess('', compact('list'));
    }

    public function getPickerList_1(){
        $list = $this->model->getPickerList_1($this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    public function getPickerList_2(){
        $list = $this->model->getPickerList_2($this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    public function serchList(){
        $list = $this->model->serchList($this->user["user_id"],$this->request->post());
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 绑定公共用户
     * @return \think\response\Json
     */
    public function getBind(){
        $list = $this->model->getBind($this->user["user_id"],$this->request->post());
       switch ((int)$list){
           case 1:
               return $this->renderError( '您当前绑定客户已达上限');
               break;
           case 2:
               return $this->renderSuccess('绑定成功');
               break;
           case 3:
               return $this->renderError( '绑定失败');
               break;
       }
    }

    /**
     * 解除绑定
     * @return \think\response\Json
     */
    public function putBind(){
        $list = $this->model->putBind($this->user["user_id"],$this->request->post());
        if ($list){
            return $this->renderSuccess('解除绑定成功');
        }
        return $this->renderError( '解除绑定失败');
    }
}