<?php

namespace app\common\model\plus\coupon;

//use think\Hook;
use app\common\model\BaseModel;

/**
 * 用户优惠券模型
 */
class UserCoupon extends BaseModel
{
    protected $name = 'user_coupon';
    protected $pk = 'user_coupon_id';

    /**
     * 追加字段
     * @var array
     */
    protected $append = ['state'];
    private static $tags = [];

    /**
     * 订单模型初始化
     */
    public static function init()
    {
        parent::init();
        // 监听优惠券处理事件
        $static = new static;
        event('UserCoupon', $static);
    }

    /**
     * 关联用户表
     */
    public function user()
    {
        return $this->belongsTo('app\common\model\user\User');
    }

    /**
     * 优惠券状态
     */
    public function getStateAttr($value, $data)
    {
        if ($data['is_use']) {
            return ['text' => '已使用', 'value' => 0];
        }
        if ($data['is_expire']) {
            return ['text' => '已过期', 'value' => 0];
        }
        return ['text' => '', 'value' => 1];
    }

    /**
     * 优惠券颜色
     */
    public function getColorAttr($value)
    {
        $status = [10 => 'blue', 20 => 'red', 30 => 'violet', 40 => 'yellow'];
        return ['text' => $status[$value], 'value' => $value];
    }

    /**
     * 优惠券类型
     */
    public function getCouponTypeAttr($value)
    {
        $status = [10 => '满减券', 20 => '折扣券'];
        return ['text' => $status[$value], 'value' => $value];
    }

    /**
     * 折扣率
     */
    public function getDiscountAttr($value)
    {
        return $value / 10;
    }

    /**
     * 有效期-开始时间
     */
    public function getStartTimeAttr($value)
    {
        return ['text' => date('Y/m/d', $value), 'value' => $value];
    }

    /**
     * 有效期-结束时间
     */
    public function getEndTimeAttr($value)
    {
        return ['text' => date('Y/m/d', $value), 'value' => $value];
    }

    /**
     * 优惠券详情
     * @param $coupon_id
     * @return array|\think\Model|null
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($coupon_id)
    {
        return static::find($coupon_id);
    }

    /**
     * 设置优惠券使用状态
     * @param $couponId
     * @param bool $isUse
     * @return UserCoupon
     */
    public static function setIsUse($couponId, $isUse = true)
    {
        $model = new static();
        return $model->where(['user_coupon_id' => $couponId])->update(['is_use' => (int)$isUse]);
    }

}