<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/8/24
 * Time: 11:04
 */

namespace app\shop\controller\user;


use app\shop\controller\Controller;
use app\shop\model\user\UserRegion as UserRegionModel;

class UserRegion extends Controller
{
    private $model;

    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new UserRegionModel();
    }


    /**
     * 省份列表
     * @return \think\response\Json
     */
    public function provinceList(){
        $list = $this->model->getProvinceList();
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 市列表
     * @return \think\response\Json
     */
    public function cityList(){
        $list = $this->model->getCityList($this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 区列表
     * @return \think\response\Json
     */
    public function regionList(){
        $list = $this->model->getRegionList($this->request->get());
        return $this->renderSuccess('', compact('list'));
    }

    /**
     * 用户地址详细信息
     * @return \think\response\Json
     */
    public function getCustomerData(){
        $list = $this->model->getCustomerData($this->request->post());
        return $this->renderSuccess('', compact('list'));
    }




}