/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    private int nextPixelOffset;
    int offset;
    private boolean imageAtOnce = false;
    Object dataArray;
    private int dataArrayLength;

    public static int BYTES_SH(int n) {
        return n;
    }

    public static int EXTRA_SH(int n) {
        return n << 7;
    }

    public static int CHANNELS_SH(int n) {
        return n << 3;
    }

    private LCMSImageLayout(int n, int n2, int n3) throws ImageLayoutException {
        this.pixelType = n2;
        this.width = n;
        this.height = 1;
        this.nextPixelOffset = n3;
        this.nextRowOffset = LCMSImageLayout.safeMult(n3, n);
        this.offset = 0;
    }

    private LCMSImageLayout(int n, int n2, int n3, int n4) throws ImageLayoutException {
        this.pixelType = n3;
        this.width = n;
        this.height = n2;
        this.nextPixelOffset = n4;
        this.nextRowOffset = LCMSImageLayout.safeMult(n4, n);
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] byArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 0;
        this.dataArray = byArray;
        this.dataArrayLength = byArray.length;
        this.verify();
    }

    public LCMSImageLayout(short[] sArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 1;
        this.dataArray = sArray;
        this.dataArrayLength = 2 * sArray.length;
        this.verify();
    }

    public LCMSImageLayout(int[] nArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 2;
        this.dataArray = nArray;
        this.dataArrayLength = 4 * nArray.length;
        this.verify();
    }

    public LCMSImageLayout(double[] dArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 3;
        this.dataArray = dArray;
        this.dataArrayLength = 8 * dArray.length;
        this.verify();
    }

    private LCMSImageLayout() {
    }

    public static LCMSImageLayout createImageLayout(BufferedImage bufferedImage) throws ImageLayoutException {
        LCMSImageLayout lCMSImageLayout = new LCMSImageLayout();
        switch (bufferedImage.getType()) {
            case 1: {
                lCMSImageLayout.pixelType = PT_ARGB_8;
                lCMSImageLayout.isIntPacked = true;
                break;
            }
            case 2: {
                lCMSImageLayout.pixelType = PT_ARGB_8;
                lCMSImageLayout.isIntPacked = true;
                break;
            }
            case 4: {
                lCMSImageLayout.pixelType = PT_ABGR_8;
                lCMSImageLayout.isIntPacked = true;
                break;
            }
            case 5: {
                lCMSImageLayout.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                lCMSImageLayout.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                lCMSImageLayout.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                lCMSImageLayout.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                ColorModel colorModel = bufferedImage.getColorModel();
                if (colorModel instanceof ComponentColorModel) {
                    int[] nArray;
                    ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                    for (int n : nArray = componentColorModel.getComponentSize()) {
                        if (n == 8) continue;
                        return null;
                    }
                    return LCMSImageLayout.createImageLayout(bufferedImage.getRaster());
                }
                return null;
            }
        }
        lCMSImageLayout.width = bufferedImage.getWidth();
        lCMSImageLayout.height = bufferedImage.getHeight();
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                lCMSImageLayout.nextRowOffset = LCMSImageLayout.safeMult(4, integerComponentRaster.getScanlineStride());
                lCMSImageLayout.nextPixelOffset = LCMSImageLayout.safeMult(4, integerComponentRaster.getPixelStride());
                lCMSImageLayout.offset = LCMSImageLayout.safeMult(4, integerComponentRaster.getDataOffset(0));
                lCMSImageLayout.dataArray = integerComponentRaster.getDataStorage();
                lCMSImageLayout.dataArrayLength = 4 * integerComponentRaster.getDataStorage().length;
                lCMSImageLayout.dataType = 2;
                if (lCMSImageLayout.nextRowOffset != lCMSImageLayout.width * 4 * integerComponentRaster.getPixelStride()) break;
                lCMSImageLayout.imageAtOnce = true;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                lCMSImageLayout.nextRowOffset = byteComponentRaster.getScanlineStride();
                lCMSImageLayout.nextPixelOffset = byteComponentRaster.getPixelStride();
                int n = bufferedImage.getSampleModel().getNumBands() - 1;
                lCMSImageLayout.offset = byteComponentRaster.getDataOffset(n);
                lCMSImageLayout.dataArray = byteComponentRaster.getDataStorage();
                lCMSImageLayout.dataArrayLength = byteComponentRaster.getDataStorage().length;
                lCMSImageLayout.dataType = 0;
                if (lCMSImageLayout.nextRowOffset != lCMSImageLayout.width * byteComponentRaster.getPixelStride()) break;
                lCMSImageLayout.imageAtOnce = true;
                break;
            }
            case 10: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                lCMSImageLayout.nextRowOffset = byteComponentRaster.getScanlineStride();
                lCMSImageLayout.nextPixelOffset = byteComponentRaster.getPixelStride();
                lCMSImageLayout.dataArrayLength = byteComponentRaster.getDataStorage().length;
                lCMSImageLayout.offset = byteComponentRaster.getDataOffset(0);
                lCMSImageLayout.dataArray = byteComponentRaster.getDataStorage();
                lCMSImageLayout.dataType = 0;
                if (lCMSImageLayout.nextRowOffset != lCMSImageLayout.width * byteComponentRaster.getPixelStride()) break;
                lCMSImageLayout.imageAtOnce = true;
                break;
            }
            case 11: {
                ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
                lCMSImageLayout.nextRowOffset = LCMSImageLayout.safeMult(2, shortComponentRaster.getScanlineStride());
                lCMSImageLayout.nextPixelOffset = LCMSImageLayout.safeMult(2, shortComponentRaster.getPixelStride());
                lCMSImageLayout.offset = LCMSImageLayout.safeMult(2, shortComponentRaster.getDataOffset(0));
                lCMSImageLayout.dataArray = shortComponentRaster.getDataStorage();
                lCMSImageLayout.dataArrayLength = 2 * shortComponentRaster.getDataStorage().length;
                lCMSImageLayout.dataType = 1;
                if (lCMSImageLayout.nextRowOffset != lCMSImageLayout.width * 2 * shortComponentRaster.getPixelStride()) break;
                lCMSImageLayout.imageAtOnce = true;
                break;
            }
            default: {
                return null;
            }
        }
        lCMSImageLayout.verify();
        return lCMSImageLayout;
    }

    private void verify() throws ImageLayoutException {
        if (this.offset < 0 || this.offset >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
        if (this.nextPixelOffset != LCMSImageLayout.getBytesPerPixel(this.pixelType)) {
            throw new ImageLayoutException("Invalid image layout");
        }
        int n = LCMSImageLayout.safeMult(this.nextRowOffset, this.height - 1);
        int n2 = LCMSImageLayout.safeMult(this.nextPixelOffset, this.width - 1);
        int n3 = LCMSImageLayout.safeAdd(this.offset, n2 = LCMSImageLayout.safeAdd(n2, n));
        if (n3 < 0 || n3 >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
    }

    static int safeAdd(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l += (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    static int safeMult(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l *= (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    public static LCMSImageLayout createImageLayout(Raster raster) {
        LCMSImageLayout lCMSImageLayout = new LCMSImageLayout();
        if (raster instanceof ByteComponentRaster && raster.getSampleModel() instanceof ComponentSampleModel) {
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
            lCMSImageLayout.pixelType = LCMSImageLayout.CHANNELS_SH(byteComponentRaster.getNumBands()) | LCMSImageLayout.BYTES_SH(1);
            int[] nArray = componentSampleModel.getBandOffsets();
            BandOrder bandOrder = BandOrder.getBandOrder(nArray);
            int n = 0;
            switch (bandOrder) {
                case INVERTED: {
                    lCMSImageLayout.pixelType |= 0x400;
                    n = componentSampleModel.getNumBands() - 1;
                    break;
                }
                case DIRECT: {
                    break;
                }
                default: {
                    return null;
                }
            }
            lCMSImageLayout.nextRowOffset = byteComponentRaster.getScanlineStride();
            lCMSImageLayout.nextPixelOffset = byteComponentRaster.getPixelStride();
            lCMSImageLayout.offset = byteComponentRaster.getDataOffset(n);
            lCMSImageLayout.dataArray = byteComponentRaster.getDataStorage();
            lCMSImageLayout.dataType = 0;
            lCMSImageLayout.width = byteComponentRaster.getWidth();
            lCMSImageLayout.height = byteComponentRaster.getHeight();
            if (lCMSImageLayout.nextRowOffset == lCMSImageLayout.width * byteComponentRaster.getPixelStride()) {
                lCMSImageLayout.imageAtOnce = true;
            }
            return lCMSImageLayout;
        }
        return null;
    }

    private static int getBytesPerPixel(int n) {
        int n2 = 7 & n;
        int n3 = 0xF & n >> 3;
        int n4 = 7 & n >> 7;
        return n2 * (n3 + n4);
    }

    private static enum BandOrder {
        DIRECT,
        INVERTED,
        ARBITRARY,
        UNKNOWN;


        public static BandOrder getBandOrder(int[] nArray) {
            BandOrder bandOrder = UNKNOWN;
            int n = nArray.length;
            block5: for (int i = 0; bandOrder != ARBITRARY && i < nArray.length; ++i) {
                switch (bandOrder) {
                    case UNKNOWN: {
                        if (nArray[i] == i) {
                            bandOrder = DIRECT;
                            continue block5;
                        }
                        if (nArray[i] == n - 1 - i) {
                            bandOrder = INVERTED;
                            continue block5;
                        }
                        bandOrder = ARBITRARY;
                        continue block5;
                    }
                    case DIRECT: {
                        if (nArray[i] == i) continue block5;
                        bandOrder = ARBITRARY;
                        continue block5;
                    }
                    case INVERTED: {
                        if (nArray[i] == n - 1 - i) continue block5;
                        bandOrder = ARBITRARY;
                    }
                }
            }
            return bandOrder;
        }
    }

    public static class ImageLayoutException
    extends Exception {
        public ImageLayoutException(String string) {
            super(string);
        }
    }
}

