/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Dependency;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Exceptions_attribute;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.RuntimeAnnotations_attribute;
import com.sun.tools.classfile.RuntimeParameterAnnotations_attribute;
import com.sun.tools.classfile.RuntimeVisibleAnnotations_attribute;
import com.sun.tools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import com.sun.tools.classfile.Signature;
import com.sun.tools.classfile.Signature_attribute;
import com.sun.tools.classfile.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Dependencies {
    private Dependency.Filter filter;
    private Dependency.Finder finder;

    public static Dependency.Finder getDefaultFinder() {
        return new APIDependencyFinder(2);
    }

    public static Dependency.Finder getAPIFinder(int n) {
        return new APIDependencyFinder(n);
    }

    public static Dependency.Finder getClassDependencyFinder() {
        return new ClassDependencyFinder();
    }

    public Dependency.Finder getFinder() {
        if (this.finder == null) {
            this.finder = Dependencies.getDefaultFinder();
        }
        return this.finder;
    }

    public void setFinder(Dependency.Finder finder) {
        finder.getClass();
        this.finder = finder;
    }

    public static Dependency.Filter getDefaultFilter() {
        return DefaultFilter.instance();
    }

    public static Dependency.Filter getRegexFilter(Pattern pattern) {
        return new TargetRegexFilter(pattern);
    }

    public static Dependency.Filter getPackageFilter(Set<String> set, boolean bl) {
        return new TargetPackageFilter(set, bl);
    }

    public Dependency.Filter getFilter() {
        if (this.filter == null) {
            this.filter = Dependencies.getDefaultFilter();
        }
        return this.filter;
    }

    public void setFilter(Dependency.Filter filter) {
        filter.getClass();
        this.filter = filter;
    }

    public Set<Dependency> findAllDependencies(ClassFileReader classFileReader, Set<String> set, boolean bl) throws ClassFileNotFoundException {
        final HashSet<Dependency> hashSet = new HashSet<Dependency>();
        Recorder recorder = new Recorder(){

            @Override
            public void addDependency(Dependency dependency) {
                hashSet.add(dependency);
            }
        };
        this.findAllDependencies(classFileReader, set, bl, recorder);
        return hashSet;
    }

    public void findAllDependencies(ClassFileReader classFileReader, Set<String> set, boolean bl, Recorder recorder) throws ClassFileNotFoundException {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        this.getFinder();
        this.getFilter();
        LinkedList<String> linkedList = new LinkedList<String>(set);
        while ((string = (String)linkedList.poll()) != null) {
            assert (!hashSet.contains(string));
            hashSet.add(string);
            ClassFile classFile = classFileReader.getClassFile(string);
            for (Dependency dependency : this.finder.findDependencies(classFile)) {
                String string2;
                recorder.addDependency(dependency);
                if (!bl || !this.filter.accepts(dependency) || hashSet.contains(string2 = dependency.getTarget().getClassName())) continue;
                linkedList.add(string2);
            }
        }
    }

    static abstract class BasicDependencyFinder
    implements Dependency.Finder {
        private Map<String, Dependency.Location> locations = new HashMap<String, Dependency.Location>();

        BasicDependencyFinder() {
        }

        Dependency.Location getLocation(String string) {
            Dependency.Location location = this.locations.get(string);
            if (location == null) {
                location = new SimpleLocation(string);
                this.locations.put(string, location);
            }
            return location;
        }

        class Visitor
        implements ConstantPool.Visitor<Void, Void>,
        Type.Visitor<Void, Void> {
            private ConstantPool constant_pool;
            private Dependency.Location origin;
            Set<Dependency> deps;

            Visitor(ClassFile classFile) {
                try {
                    this.constant_pool = classFile.constant_pool;
                    this.origin = BasicDependencyFinder.this.getLocation(classFile.getName());
                    this.deps = new HashSet<Dependency>();
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            void scan(Descriptor descriptor, Attributes attributes) {
                try {
                    this.scan(new Signature(descriptor.index).getType(this.constant_pool));
                    this.scan(attributes);
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            void scan(ConstantPool.CPInfo cPInfo) {
                cPInfo.accept(this, null);
            }

            void scan(Type type) {
                type.accept(this, null);
            }

            void scan(Attributes attributes) {
                try {
                    Signature_attribute signature_attribute = (Signature_attribute)attributes.get("Signature");
                    if (signature_attribute != null) {
                        this.scan(signature_attribute.getParsedSignature().getType(this.constant_pool));
                    }
                    this.scan((RuntimeVisibleAnnotations_attribute)attributes.get("RuntimeVisibleAnnotations"));
                    this.scan((RuntimeVisibleParameterAnnotations_attribute)attributes.get("RuntimeVisibleParameterAnnotations"));
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            private void scan(RuntimeAnnotations_attribute runtimeAnnotations_attribute) throws ConstantPoolException {
                if (runtimeAnnotations_attribute == null) {
                    return;
                }
                for (int i = 0; i < runtimeAnnotations_attribute.annotations.length; ++i) {
                    int n = runtimeAnnotations_attribute.annotations[i].type_index;
                    this.scan(new Signature(n).getType(this.constant_pool));
                }
            }

            private void scan(RuntimeParameterAnnotations_attribute runtimeParameterAnnotations_attribute) throws ConstantPoolException {
                if (runtimeParameterAnnotations_attribute == null) {
                    return;
                }
                for (int i = 0; i < runtimeParameterAnnotations_attribute.parameter_annotations.length; ++i) {
                    for (int j = 0; j < runtimeParameterAnnotations_attribute.parameter_annotations[i].length; ++j) {
                        int n = runtimeParameterAnnotations_attribute.parameter_annotations[i][j].type_index;
                        this.scan(new Signature(n).getType(this.constant_pool));
                    }
                }
            }

            void addClass(int n) throws ConstantPoolException {
                String string;
                if (n != 0 && (string = this.constant_pool.getClassInfo(n).getBaseName()) != null) {
                    this.addDependency(string);
                }
            }

            void addClasses(int[] nArray) throws ConstantPoolException {
                for (int n : nArray) {
                    this.addClass(n);
                }
            }

            private void addDependency(String string) {
                this.deps.add(new SimpleDependency(this.origin, BasicDependencyFinder.this.getLocation(string)));
            }

            @Override
            public Void visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, Void void_) {
                try {
                    if (cONSTANT_Class_info.getName().startsWith("[")) {
                        new Signature(cONSTANT_Class_info.name_index).getType(this.constant_pool).accept(this, null);
                    } else {
                        this.addDependency(cONSTANT_Class_info.getBaseName());
                    }
                    return null;
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            @Override
            public Void visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, Void void_) {
                return null;
            }

            @Override
            public Void visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, Void void_) {
                return this.visitRef(cONSTANT_Fieldref_info, void_);
            }

            @Override
            public Void visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, Void void_) {
                return null;
            }

            @Override
            public Void visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, Void void_) {
                return null;
            }

            @Override
            public Void visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, Void void_) {
                return this.visitRef(cONSTANT_InterfaceMethodref_info, void_);
            }

            @Override
            public Void visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info cONSTANT_InvokeDynamic_info, Void void_) {
                return null;
            }

            @Override
            public Void visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, Void void_) {
                return null;
            }

            @Override
            public Void visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info cONSTANT_MethodHandle_info, Void void_) {
                return null;
            }

            @Override
            public Void visitMethodType(ConstantPool.CONSTANT_MethodType_info cONSTANT_MethodType_info, Void void_) {
                return null;
            }

            @Override
            public Void visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, Void void_) {
                return this.visitRef(cONSTANT_Methodref_info, void_);
            }

            @Override
            public Void visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, Void void_) {
                try {
                    new Signature(cONSTANT_NameAndType_info.type_index).getType(this.constant_pool).accept(this, null);
                    return null;
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            @Override
            public Void visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, Void void_) {
                return null;
            }

            @Override
            public Void visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, Void void_) {
                return null;
            }

            private Void visitRef(ConstantPool.CPRefInfo cPRefInfo, Void void_) {
                try {
                    this.visitClass(cPRefInfo.getClassInfo(), void_);
                    return null;
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new ClassFileError(constantPoolException);
                }
            }

            private void findDependencies(Type type) {
                if (type != null) {
                    type.accept(this, null);
                }
            }

            private void findDependencies(List<? extends Type> list) {
                if (list != null) {
                    for (Type type : list) {
                        type.accept(this, null);
                    }
                }
            }

            @Override
            public Void visitSimpleType(Type.SimpleType simpleType, Void void_) {
                return null;
            }

            @Override
            public Void visitArrayType(Type.ArrayType arrayType, Void void_) {
                this.findDependencies(arrayType.elemType);
                return null;
            }

            @Override
            public Void visitMethodType(Type.MethodType methodType, Void void_) {
                this.findDependencies(methodType.paramTypes);
                this.findDependencies(methodType.returnType);
                this.findDependencies(methodType.throwsTypes);
                this.findDependencies(methodType.typeParamTypes);
                return null;
            }

            @Override
            public Void visitClassSigType(Type.ClassSigType classSigType, Void void_) {
                this.findDependencies(classSigType.superclassType);
                this.findDependencies(classSigType.superinterfaceTypes);
                return null;
            }

            @Override
            public Void visitClassType(Type.ClassType classType, Void void_) {
                this.findDependencies(classType.outerType);
                this.addDependency(classType.getBinaryName());
                this.findDependencies(classType.typeArgs);
                return null;
            }

            @Override
            public Void visitTypeParamType(Type.TypeParamType typeParamType, Void void_) {
                this.findDependencies(typeParamType.classBound);
                this.findDependencies(typeParamType.interfaceBounds);
                return null;
            }

            @Override
            public Void visitWildcardType(Type.WildcardType wildcardType, Void void_) {
                this.findDependencies(wildcardType.boundType);
                return null;
            }
        }
    }

    static class APIDependencyFinder
    extends BasicDependencyFinder {
        private int showAccess;

        APIDependencyFinder(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    this.showAccess = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid access 0x" + Integer.toHexString(n));
                }
            }
        }

        @Override
        public Iterable<? extends Dependency> findDependencies(ClassFile classFile) {
            try {
                BasicDependencyFinder.Visitor visitor = new BasicDependencyFinder.Visitor(classFile);
                visitor.addClass(classFile.super_class);
                visitor.addClasses(classFile.interfaces);
                for (Field object : classFile.fields) {
                    if (!this.checkAccess(object.access_flags)) continue;
                    visitor.scan(object.descriptor, object.attributes);
                }
                for (Method method : classFile.methods) {
                    if (!this.checkAccess(method.access_flags)) continue;
                    visitor.scan(method.descriptor, method.attributes);
                    Exceptions_attribute exceptions_attribute = (Exceptions_attribute)method.attributes.get("Exceptions");
                    if (exceptions_attribute == null) continue;
                    visitor.addClasses(exceptions_attribute.exception_index_table);
                }
                return visitor.deps;
            }
            catch (ConstantPoolException constantPoolException) {
                throw new ClassFileError(constantPoolException);
            }
        }

        boolean checkAccess(AccessFlags accessFlags) {
            boolean bl;
            boolean bl2 = accessFlags.is(1);
            boolean bl3 = accessFlags.is(4);
            boolean bl4 = accessFlags.is(2);
            boolean bl5 = bl = !bl2 && !bl3 && !bl4;
            if (this.showAccess == 1 && (bl3 || bl4 || bl)) {
                return false;
            }
            if (this.showAccess == 4 && (bl4 || bl)) {
                return false;
            }
            return this.showAccess != 0 || !bl4;
        }
    }

    static class ClassDependencyFinder
    extends BasicDependencyFinder {
        ClassDependencyFinder() {
        }

        @Override
        public Iterable<? extends Dependency> findDependencies(ClassFile classFile) {
            BasicDependencyFinder.Visitor visitor = new BasicDependencyFinder.Visitor(classFile);
            for (ConstantPool.CPInfo cPInfo : classFile.constant_pool.entries()) {
                visitor.scan(cPInfo);
            }
            try {
                visitor.addClass(classFile.super_class);
                visitor.addClasses(classFile.interfaces);
                visitor.scan(classFile.attributes);
                for (Field object : classFile.fields) {
                    visitor.scan(object.descriptor, object.attributes);
                }
                for (Method method : classFile.methods) {
                    visitor.scan(method.descriptor, method.attributes);
                    Exceptions_attribute exceptions_attribute = (Exceptions_attribute)method.attributes.get("Exceptions");
                    if (exceptions_attribute == null) continue;
                    visitor.addClasses(exceptions_attribute.exception_index_table);
                }
            }
            catch (ConstantPoolException constantPoolException) {
                throw new ClassFileError(constantPoolException);
            }
            return visitor.deps;
        }
    }

    static class TargetPackageFilter
    implements Dependency.Filter {
        private final Set<String> packageNames;
        private final boolean matchSubpackages;

        TargetPackageFilter(Set<String> set, boolean bl) {
            for (String string : set) {
                if (string.length() != 0) continue;
                throw new IllegalArgumentException();
            }
            this.packageNames = set;
            this.matchSubpackages = bl;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            String string = dependency.getTarget().getPackageName();
            if (this.packageNames.contains(string)) {
                return true;
            }
            if (this.matchSubpackages) {
                for (String string2 : this.packageNames) {
                    if (!string.startsWith(string2 + ".")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class TargetRegexFilter
    implements Dependency.Filter {
        private final Pattern pattern;

        TargetRegexFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            return this.pattern.matcher(dependency.getTarget().getClassName()).matches();
        }
    }

    static class DefaultFilter
    implements Dependency.Filter {
        private static DefaultFilter instance;

        DefaultFilter() {
        }

        static DefaultFilter instance() {
            if (instance == null) {
                instance = new DefaultFilter();
            }
            return instance;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            return true;
        }
    }

    static class SimpleDependency
    implements Dependency {
        private Dependency.Location origin;
        private Dependency.Location target;

        public SimpleDependency(Dependency.Location location, Dependency.Location location2) {
            this.origin = location;
            this.target = location2;
        }

        @Override
        public Dependency.Location getOrigin() {
            return this.origin;
        }

        @Override
        public Dependency.Location getTarget() {
            return this.target;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SimpleDependency)) {
                return false;
            }
            SimpleDependency simpleDependency = (SimpleDependency)object;
            return this.origin.equals(simpleDependency.origin) && this.target.equals(simpleDependency.target);
        }

        public int hashCode() {
            return this.origin.hashCode() * 31 + this.target.hashCode();
        }

        public String toString() {
            return this.origin + ":" + this.target;
        }
    }

    static class SimpleLocation
    implements Dependency.Location {
        private String name;
        private String className;

        public SimpleLocation(String string) {
            this.name = string;
            this.className = string.replace('/', '.');
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getPackageName() {
            int n = this.name.lastIndexOf(47);
            return n > 0 ? this.name.substring(0, n).replace('/', '.') : "";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SimpleLocation)) {
                return false;
            }
            return this.name.equals(((SimpleLocation)object).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Recorder {
        public void addDependency(Dependency var1);
    }

    public static interface ClassFileReader {
        public ClassFile getClassFile(String var1) throws ClassFileNotFoundException;
    }

    public static class ClassFileError
    extends Error {
        private static final long serialVersionUID = 4111110813961313203L;

        public ClassFileError(Throwable throwable) {
            this.initCause(throwable);
        }
    }

    public static class ClassFileNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3632265927794475048L;
        public final String className;

        public ClassFileNotFoundException(String string) {
            super(string);
            this.className = string;
        }

        public ClassFileNotFoundException(String string, Throwable throwable) {
            this(string);
            this.initCause(throwable);
        }
    }
}

