/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;
    final HtmlTree BR = new HtmlTree(HtmlTag.BR);

    public AllClassesFrameWriter(ConfigurationImpl configurationImpl, DocPath docPath, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, docPath);
        this.indexbuilder = indexBuilder;
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        DocPath docPath = DocPaths.ALLCLASSES_FRAME;
        try {
            AllClassesFrameWriter allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, docPath, indexBuilder);
            allClassesFrameWriter.buildAllClassesFile(true);
            allClassesFrameWriter.close();
            docPath = DocPaths.ALLCLASSES_NOFRAME;
            allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, docPath, indexBuilder);
            allClassesFrameWriter.buildAllClassesFile(false);
            allClassesFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), docPath);
            throw new DocletAbortException(iOException);
        }
    }

    protected void buildAllClassesFile(boolean bl) throws IOException {
        String string = this.configuration.getText("doclet.All_Classes");
        HtmlTree htmlTree = this.getBody(false, this.getWindowTitle(string));
        HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, this.allclassesLabel);
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.UL);
        this.addAllClasses(htmlTree3, bl);
        HtmlTree htmlTree4 = HtmlTree.DIV(HtmlStyle.indexContainer, htmlTree3);
        ((Content)htmlTree).addContent(htmlTree4);
        this.printHtmlDocument(null, false, htmlTree);
    }

    protected void addAllClasses(Content content, boolean bl) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character c = (Character)this.indexbuilder.elements()[i];
            this.addContents(this.indexbuilder.getMemberList(c), bl, content);
        }
    }

    protected void addContents(List<Doc> list, boolean bl, Content content) {
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = (ClassDoc)list.get(i);
            if (!Util.isCoreClass(classDoc)) continue;
            Content content2 = this.italicsClassName(classDoc, false);
            Content content3 = bl ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ALL_CLASSES_FRAME, classDoc).label(content2).target("classFrame")) : this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, classDoc).label(content2));
            HtmlTree htmlTree = HtmlTree.LI(content3);
            content.addContent(htmlTree);
        }
    }
}

