/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDocCatalog {
    private Set<String> packageSet;
    private Map<String, Set<ClassDoc>> allClasses;
    private Map<String, Set<ClassDoc>> ordinaryClasses;
    private Map<String, Set<ClassDoc>> exceptions;
    private Map<String, Set<ClassDoc>> enums;
    private Map<String, Set<ClassDoc>> annotationTypes;
    private Map<String, Set<ClassDoc>> errors;
    private Map<String, Set<ClassDoc>> interfaces;
    private Configuration configuration;

    public ClassDocCatalog(ClassDoc[] classDocArray, Configuration configuration) {
        this.init();
        this.configuration = configuration;
        for (int i = 0; i < classDocArray.length; ++i) {
            this.addClassDoc(classDocArray[i]);
        }
    }

    public ClassDocCatalog() {
        this.init();
    }

    private void init() {
        this.allClasses = new HashMap<String, Set<ClassDoc>>();
        this.ordinaryClasses = new HashMap<String, Set<ClassDoc>>();
        this.exceptions = new HashMap<String, Set<ClassDoc>>();
        this.enums = new HashMap<String, Set<ClassDoc>>();
        this.annotationTypes = new HashMap<String, Set<ClassDoc>>();
        this.errors = new HashMap<String, Set<ClassDoc>>();
        this.interfaces = new HashMap<String, Set<ClassDoc>>();
        this.packageSet = new HashSet<String>();
    }

    public void addClassDoc(ClassDoc classDoc) {
        if (classDoc == null) {
            return;
        }
        this.addClass(classDoc, this.allClasses);
        if (classDoc.isOrdinaryClass()) {
            this.addClass(classDoc, this.ordinaryClasses);
        } else if (classDoc.isException()) {
            this.addClass(classDoc, this.exceptions);
        } else if (classDoc.isEnum()) {
            this.addClass(classDoc, this.enums);
        } else if (classDoc.isAnnotationType()) {
            this.addClass(classDoc, this.annotationTypes);
        } else if (classDoc.isError()) {
            this.addClass(classDoc, this.errors);
        } else if (classDoc.isInterface()) {
            this.addClass(classDoc, this.interfaces);
        }
    }

    private void addClass(ClassDoc classDoc, Map<String, Set<ClassDoc>> map) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc.isIncluded() || this.configuration.nodeprecated && Util.isDeprecated((Doc)packageDoc)) {
            return;
        }
        String string = Util.getPackageName(packageDoc);
        Set<ClassDoc> set = map.get(string);
        if (set == null) {
            this.packageSet.add(string);
            set = new HashSet<ClassDoc>();
        }
        set.add(classDoc);
        map.put(string, set);
    }

    private ClassDoc[] getArray(Map<String, Set<ClassDoc>> map, String string) {
        Set<ClassDoc> set = map.get(string);
        if (set == null) {
            return new ClassDoc[0];
        }
        return set.toArray(new ClassDoc[0]);
    }

    public ClassDoc[] allClasses(PackageDoc packageDoc) {
        return packageDoc.isIncluded() ? packageDoc.allClasses() : this.getArray(this.allClasses, Util.getPackageName(packageDoc));
    }

    public ClassDoc[] allClasses(String string) {
        return this.getArray(this.allClasses, string);
    }

    public String[] packageNames() {
        return this.packageSet.toArray(new String[0]);
    }

    public boolean isKnownPackage(String string) {
        return this.packageSet.contains(string);
    }

    public ClassDoc[] errors(String string) {
        return this.getArray(this.errors, string);
    }

    public ClassDoc[] exceptions(String string) {
        return this.getArray(this.exceptions, string);
    }

    public ClassDoc[] enums(String string) {
        return this.getArray(this.enums, string);
    }

    public ClassDoc[] annotationTypes(String string) {
        return this.getArray(this.annotationTypes, string);
    }

    public ClassDoc[] interfaces(String string) {
        return this.getArray(this.interfaces, string);
    }

    public ClassDoc[] ordinaryClasses(String string) {
        return this.getArray(this.ordinaryClasses, string);
    }
}

