/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMCannotBeModifiedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.tty.Commands;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventHandler;
import com.sun.tools.example.debug.tty.EventNotifier;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class TTY
implements EventNotifier {
    EventHandler handler = null;
    private List<String> monitorCommands = new ArrayList<String>();
    private int monitorCount = 0;
    private static final String progname = "jdb";
    private static final String[][] commandList = new String[][]{{"!!", "n", "y"}, {"?", "y", "y"}, {"bytecodes", "n", "y"}, {"catch", "y", "n"}, {"class", "n", "y"}, {"classes", "n", "y"}, {"classpath", "n", "y"}, {"clear", "y", "n"}, {"connectors", "y", "y"}, {"cont", "n", "n"}, {"disablegc", "n", "n"}, {"down", "n", "y"}, {"dump", "n", "y"}, {"enablegc", "n", "n"}, {"eval", "n", "y"}, {"exclude", "y", "n"}, {"exit", "y", "y"}, {"extension", "n", "y"}, {"fields", "n", "y"}, {"gc", "n", "n"}, {"help", "y", "y"}, {"ignore", "y", "n"}, {"interrupt", "n", "n"}, {"kill", "n", "n"}, {"lines", "n", "y"}, {"list", "n", "y"}, {"load", "n", "y"}, {"locals", "n", "y"}, {"lock", "n", "n"}, {"memory", "n", "y"}, {"methods", "n", "y"}, {"monitor", "n", "n"}, {"next", "n", "n"}, {"pop", "n", "n"}, {"print", "n", "y"}, {"quit", "y", "y"}, {"read", "y", "y"}, {"redefine", "n", "n"}, {"reenter", "n", "n"}, {"resume", "n", "n"}, {"run", "y", "n"}, {"save", "n", "n"}, {"set", "n", "n"}, {"sourcepath", "y", "y"}, {"step", "n", "n"}, {"stepi", "n", "n"}, {"stop", "y", "n"}, {"suspend", "n", "n"}, {"thread", "n", "y"}, {"threadgroup", "n", "y"}, {"threadgroups", "n", "y"}, {"threadlocks", "n", "y"}, {"threads", "n", "y"}, {"trace", "n", "n"}, {"unmonitor", "n", "n"}, {"untrace", "n", "n"}, {"unwatch", "y", "n"}, {"up", "n", "y"}, {"use", "y", "y"}, {"version", "y", "y"}, {"watch", "y", "n"}, {"where", "n", "y"}, {"wherei", "n", "y"}};

    @Override
    public void vmStartEvent(VMStartEvent vMStartEvent) {
        Thread.yield();
        MessageOutput.lnprint("VM Started:");
    }

    @Override
    public void vmDeathEvent(VMDeathEvent vMDeathEvent) {
    }

    @Override
    public void vmDisconnectEvent(VMDisconnectEvent vMDisconnectEvent) {
    }

    @Override
    public void threadStartEvent(ThreadStartEvent threadStartEvent) {
    }

    @Override
    public void threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
    }

    @Override
    public void classPrepareEvent(ClassPrepareEvent classPrepareEvent) {
    }

    @Override
    public void classUnloadEvent(ClassUnloadEvent classUnloadEvent) {
    }

    @Override
    public void breakpointEvent(BreakpointEvent breakpointEvent) {
        Thread.yield();
        MessageOutput.lnprint("Breakpoint hit:");
    }

    @Override
    public void fieldWatchEvent(WatchpointEvent watchpointEvent) {
        Field field = watchpointEvent.field();
        ObjectReference objectReference = watchpointEvent.object();
        Thread.yield();
        if (watchpointEvent instanceof ModificationWatchpointEvent) {
            MessageOutput.lnprint("Field access encountered before after", new Object[]{field, watchpointEvent.valueCurrent(), ((ModificationWatchpointEvent)watchpointEvent).valueToBe()});
        } else {
            MessageOutput.lnprint("Field access encountered", field.toString());
        }
    }

    @Override
    public void stepEvent(StepEvent stepEvent) {
        Thread.yield();
        MessageOutput.lnprint("Step completed:");
    }

    @Override
    public void exceptionEvent(ExceptionEvent exceptionEvent) {
        Thread.yield();
        Location location = exceptionEvent.catchLocation();
        if (location == null) {
            MessageOutput.lnprint("Exception occurred uncaught", exceptionEvent.exception().referenceType().name());
        } else {
            MessageOutput.lnprint("Exception occurred caught", new Object[]{exceptionEvent.exception().referenceType().name(), Commands.locationString(location)});
        }
    }

    @Override
    public void methodEntryEvent(MethodEntryEvent methodEntryEvent) {
        Thread.yield();
        if (methodEntryEvent.request().suspendPolicy() != 0) {
            MessageOutput.lnprint("Method entered:");
        } else {
            MessageOutput.print("Method entered:");
            this.printLocationOfEvent(methodEntryEvent);
        }
    }

    @Override
    public boolean methodExitEvent(MethodExitEvent methodExitEvent) {
        Thread.yield();
        Method method = Env.atExitMethod();
        Method method2 = methodExitEvent.method();
        if (method == null || method.equals(method2)) {
            if (methodExitEvent.request().suspendPolicy() != 0) {
                MessageOutput.println();
            }
            if (Env.vm().canGetMethodReturnValues()) {
                MessageOutput.print("Method exitedValue:", methodExitEvent.returnValue() + "");
            } else {
                MessageOutput.print("Method exited:");
            }
            if (methodExitEvent.request().suspendPolicy() == 0) {
                this.printLocationOfEvent(methodExitEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public void vmInterrupted() {
        Thread.yield();
        this.printCurrentLocation();
        for (String string : this.monitorCommands) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            this.executeCommand(stringTokenizer);
        }
        MessageOutput.printPrompt();
    }

    @Override
    public void receivedEvent(Event event) {
    }

    private void printBaseLocation(String string, Location location) {
        MessageOutput.println("location", new Object[]{string, Commands.locationString(location)});
    }

    private void printCurrentLocation() {
        StackFrame stackFrame;
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        try {
            stackFrame = threadInfo.getCurrentFrame();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("<location unavailable>");
            return;
        }
        if (stackFrame == null) {
            MessageOutput.println("No frames on the current call stack");
        } else {
            Location location = stackFrame.location();
            this.printBaseLocation(threadInfo.getThread().name(), location);
            if (location.lineNumber() != -1) {
                String string;
                try {
                    string = Env.sourceLine(location, location.lineNumber());
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string != null) {
                    MessageOutput.println("source line number and line", new Object[]{new Integer(location.lineNumber()), string});
                }
            }
        }
        MessageOutput.println();
    }

    private void printLocationOfEvent(LocatableEvent locatableEvent) {
        this.printBaseLocation(locatableEvent.thread().name(), locatableEvent.location());
    }

    void help() {
        MessageOutput.println("zz help text");
    }

    private int isCommand(String string) {
        int n = 0;
        int n2 = commandList.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            String string2 = commandList[n3][0];
            int n4 = string2.compareTo(string);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private boolean isDisconnectCmd(int n) {
        if (n < 0 || n >= commandList.length) {
            return false;
        }
        return commandList[n][1].equals("y");
    }

    private boolean isReadOnlyCmd(int n) {
        if (n < 0 || n >= commandList.length) {
            return false;
        }
        return commandList[n][2].equals("y");
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        boolean bl = true;
        if (!string.startsWith("#")) {
            if (Character.isDigit(string.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                try {
                    int n = Integer.parseInt(string);
                    String string2 = stringTokenizer.nextToken("");
                    while (n-- > 0) {
                        this.executeCommand(new StringTokenizer(string2));
                        bl = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageOutput.println("Unrecognized command.  Try help...", string);
                }
            } else {
                int n = this.isCommand(string);
                if (n < 0) {
                    MessageOutput.println("Unrecognized command.  Try help...", string);
                } else if (!Env.connection().isOpen() && !this.isDisconnectCmd(n)) {
                    MessageOutput.println("Command not valid until the VM is started with the run command", string);
                } else if (Env.connection().isOpen() && !Env.vm().canBeModified() && !this.isReadOnlyCmd(n)) {
                    MessageOutput.println("Command is not supported on a read-only VM connection", string);
                } else {
                    Commands commands = new Commands();
                    try {
                        if (string.equals("print")) {
                            commands.commandPrint(stringTokenizer, false);
                            bl = false;
                        } else if (string.equals("eval")) {
                            commands.commandPrint(stringTokenizer, false);
                            bl = false;
                        } else if (string.equals("set")) {
                            commands.commandSet(stringTokenizer);
                            bl = false;
                        } else if (string.equals("dump")) {
                            commands.commandPrint(stringTokenizer, true);
                            bl = false;
                        } else if (string.equals("locals")) {
                            commands.commandLocals();
                        } else if (string.equals("classes")) {
                            commands.commandClasses();
                        } else if (string.equals("class")) {
                            commands.commandClass(stringTokenizer);
                        } else if (string.equals("connectors")) {
                            commands.commandConnectors(Bootstrap.virtualMachineManager());
                        } else if (string.equals("methods")) {
                            commands.commandMethods(stringTokenizer);
                        } else if (string.equals("fields")) {
                            commands.commandFields(stringTokenizer);
                        } else if (string.equals("threads")) {
                            commands.commandThreads(stringTokenizer);
                        } else if (string.equals("thread")) {
                            commands.commandThread(stringTokenizer);
                        } else if (string.equals("suspend")) {
                            commands.commandSuspend(stringTokenizer);
                        } else if (string.equals("resume")) {
                            commands.commandResume(stringTokenizer);
                        } else if (string.equals("cont")) {
                            commands.commandCont();
                        } else if (string.equals("threadgroups")) {
                            commands.commandThreadGroups();
                        } else if (string.equals("threadgroup")) {
                            commands.commandThreadGroup(stringTokenizer);
                        } else if (string.equals("catch")) {
                            commands.commandCatchException(stringTokenizer);
                        } else if (string.equals("ignore")) {
                            commands.commandIgnoreException(stringTokenizer);
                        } else if (string.equals("step")) {
                            commands.commandStep(stringTokenizer);
                        } else if (string.equals("stepi")) {
                            commands.commandStepi();
                        } else if (string.equals("next")) {
                            commands.commandNext();
                        } else if (string.equals("kill")) {
                            commands.commandKill(stringTokenizer);
                        } else if (string.equals("interrupt")) {
                            commands.commandInterrupt(stringTokenizer);
                        } else if (string.equals("trace")) {
                            commands.commandTrace(stringTokenizer);
                        } else if (string.equals("untrace")) {
                            commands.commandUntrace(stringTokenizer);
                        } else if (string.equals("where")) {
                            commands.commandWhere(stringTokenizer, false);
                        } else if (string.equals("wherei")) {
                            commands.commandWhere(stringTokenizer, true);
                        } else if (string.equals("up")) {
                            commands.commandUp(stringTokenizer);
                        } else if (string.equals("down")) {
                            commands.commandDown(stringTokenizer);
                        } else if (string.equals("load")) {
                            commands.commandLoad(stringTokenizer);
                        } else if (string.equals("run")) {
                            commands.commandRun(stringTokenizer);
                            if (this.handler == null && Env.connection().isOpen()) {
                                this.handler = new EventHandler(this, false);
                            }
                        } else if (string.equals("memory")) {
                            commands.commandMemory();
                        } else if (string.equals("gc")) {
                            commands.commandGC();
                        } else if (string.equals("stop")) {
                            commands.commandStop(stringTokenizer);
                        } else if (string.equals("clear")) {
                            commands.commandClear(stringTokenizer);
                        } else if (string.equals("watch")) {
                            commands.commandWatch(stringTokenizer);
                        } else if (string.equals("unwatch")) {
                            commands.commandUnwatch(stringTokenizer);
                        } else if (string.equals("list")) {
                            commands.commandList(stringTokenizer);
                        } else if (string.equals("lines")) {
                            commands.commandLines(stringTokenizer);
                        } else if (string.equals("classpath")) {
                            commands.commandClasspath(stringTokenizer);
                        } else if (string.equals("use") || string.equals("sourcepath")) {
                            commands.commandUse(stringTokenizer);
                        } else if (string.equals("monitor")) {
                            this.monitorCommand(stringTokenizer);
                        } else if (string.equals("unmonitor")) {
                            this.unmonitorCommand(stringTokenizer);
                        } else if (string.equals("lock")) {
                            commands.commandLock(stringTokenizer);
                            bl = false;
                        } else if (string.equals("threadlocks")) {
                            commands.commandThreadlocks(stringTokenizer);
                        } else if (string.equals("disablegc")) {
                            commands.commandDisableGC(stringTokenizer);
                            bl = false;
                        } else if (string.equals("enablegc")) {
                            commands.commandEnableGC(stringTokenizer);
                            bl = false;
                        } else if (string.equals("save")) {
                            commands.commandSave(stringTokenizer);
                            bl = false;
                        } else if (string.equals("bytecodes")) {
                            commands.commandBytecodes(stringTokenizer);
                        } else if (string.equals("redefine")) {
                            commands.commandRedefine(stringTokenizer);
                        } else if (string.equals("pop")) {
                            commands.commandPopFrames(stringTokenizer, false);
                        } else if (string.equals("reenter")) {
                            commands.commandPopFrames(stringTokenizer, true);
                        } else if (string.equals("extension")) {
                            commands.commandExtension(stringTokenizer);
                        } else if (string.equals("exclude")) {
                            commands.commandExclude(stringTokenizer);
                        } else if (string.equals("read")) {
                            this.readCommand(stringTokenizer);
                        } else if (string.equals("help") || string.equals("?")) {
                            this.help();
                        } else if (string.equals("version")) {
                            commands.commandVersion(progname, Bootstrap.virtualMachineManager());
                        } else if (string.equals("quit") || string.equals("exit")) {
                            if (this.handler != null) {
                                this.handler.shutdown();
                            }
                            Env.shutdown();
                        } else {
                            MessageOutput.println("Unrecognized command.  Try help...", string);
                        }
                    }
                    catch (VMCannotBeModifiedException vMCannotBeModifiedException) {
                        MessageOutput.println("Command is not supported on a read-only VM connection", string);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        MessageOutput.println("Command is not supported on the target VM", string);
                    }
                    catch (VMNotConnectedException vMNotConnectedException) {
                        MessageOutput.println("Command not valid until the VM is started with the run command", string);
                    }
                    catch (Exception exception) {
                        MessageOutput.printException("Internal exception:", exception);
                    }
                }
            }
        }
        if (bl) {
            MessageOutput.printPrompt();
        }
    }

    void monitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            ++this.monitorCount;
            this.monitorCommands.add(this.monitorCount + ": " + stringTokenizer.nextToken(""));
        } else {
            for (String string : this.monitorCommands) {
                MessageOutput.printDirectln(string);
            }
        }
    }

    void unmonitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                MessageOutput.println("Not a monitor number:", string);
                return;
            }
            String string2 = string + ":";
            for (String string3 : this.monitorCommands) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
                if (!stringTokenizer2.nextToken().equals(string2)) continue;
                this.monitorCommands.remove(string3);
                MessageOutput.println("Unmonitoring", string3);
                return;
            }
            MessageOutput.println("No monitor numbered:", string);
        } else {
            MessageOutput.println("Usage: unmonitor <monitor#>");
        }
    }

    void readCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!this.readCommandFile(new File(string))) {
                MessageOutput.println("Could not open:", string);
            }
        } else {
            MessageOutput.println("Usage: read <command-filename>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readCommandFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            if (file.canRead()) {
                String string;
                MessageOutput.println("*** Reading commands from", file.getPath());
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.executeCommand(stringTokenizer);
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return bufferedReader != null;
    }

    String readStartupCommandFile(String string, String string2, String string3) {
        String string4;
        File file = new File(string, string2);
        if (!file.exists()) {
            return null;
        }
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            MessageOutput.println("Could not open:", file.getPath());
            return null;
        }
        if (!(string3 != null && string3.equals(string4) || this.readCommandFile(file))) {
            MessageOutput.println("Could not open:", file.getPath());
        }
        return string4;
    }

    public TTY() throws Exception {
        MessageOutput.println("Initializing progname", progname);
        if (Env.connection().isOpen() && Env.vm().canBeModified()) {
            this.handler = new EventHandler(this, true);
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = null;
            Thread.currentThread().setPriority(5);
            String string3 = System.getProperty("user.home");
            Object object = this.readStartupCommandFile(string3, "jdb.ini", null);
            if (object == null) {
                object = this.readStartupCommandFile(string3, ".jdbrc", null);
            }
            if (this.readStartupCommandFile(string = System.getProperty("user.dir"), "jdb.ini", (String)object) == null) {
                this.readStartupCommandFile(string, ".jdbrc", (String)object);
            }
            MessageOutput.printPrompt();
            while (true) {
                if ((string3 = bufferedReader.readLine()) == null) {
                    MessageOutput.println("Input stream closed.");
                    string3 = "quit";
                }
                if (string3.startsWith("!!") && string2 != null) {
                    string3 = string2 + string3.substring(2);
                    MessageOutput.printDirectln(string3);
                }
                if (((StringTokenizer)(object = new StringTokenizer(string3))).hasMoreTokens()) {
                    string2 = string3;
                    this.executeCommand((StringTokenizer)object);
                    continue;
                }
                MessageOutput.printPrompt();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.handler.handleDisconnectedException();
            return;
        }
    }

    private static void usage() {
        MessageOutput.println("zz usage text", new Object[]{progname, File.pathSeparator});
        System.exit(1);
    }

    static void usageError(String string) {
        MessageOutput.println(string);
        MessageOutput.println();
        TTY.usage();
    }

    static void usageError(String string, String string2) {
        MessageOutput.println(string, string2);
        MessageOutput.println();
        TTY.usage();
    }

    private static boolean supportsSharedMemory() {
        for (Connector connector : Bootstrap.virtualMachineManager().allConnectors()) {
            if (connector.transport() == null || !"dt_shmem".equals(connector.transport().name())) continue;
            return true;
        }
        return false;
    }

    private static String addressToSocketArgs(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return "hostname=" + string2 + ",port=" + string3;
        }
        return "port=" + string;
    }

    private static boolean hasWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String addArgument(String string, String string2) {
        if (TTY.hasWhitespace(string2) || string2.indexOf(44) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('\"');
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            stringBuffer.append("\" ");
            return stringBuffer.toString();
        }
        return string + string2 + ' ';
    }

    public static void main(String[] stringArray) throws MissingResourceException {
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = false;
        String string3 = null;
        MessageOutput.textResources = ResourceBundle.getBundle("com.sun.tools.example.debug.tty.TTYResources", Locale.getDefault());
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string4 = stringArray[i];
            if (string4.equals("-dbgtrace")) {
                if (i == stringArray.length - 1 || !Character.isDigit(stringArray[i + 1].charAt(0))) {
                    n = 0xFFFFFF;
                    continue;
                }
                object = "";
                try {
                    object = stringArray[++i];
                    n = Integer.decode((String)object);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    TTY.usageError("dbgtrace flag value must be an integer:", (String)object);
                    return;
                }
            }
            if (string4.equals("-X")) {
                TTY.usageError("Use java minus X to see");
                return;
            }
            if (string4.equals("-v") || string4.startsWith("-v:") || string4.startsWith("-verbose") || string4.startsWith("-D") || string4.startsWith("-X") || string4.equals("-noasyncgc") || string4.equals("-prof") || string4.equals("-verify") || string4.equals("-noverify") || string4.equals("-verifyremote") || string4.equals("-verbosegc") || string4.startsWith("-ms") || string4.startsWith("-mx") || string4.startsWith("-ss") || string4.startsWith("-oss")) {
                string2 = TTY.addArgument(string2, string4);
                continue;
            }
            if (string4.equals("-tclassic")) {
                TTY.usageError("Classic VM no longer supported.");
                return;
            }
            if (string4.equals("-tclient")) {
                string2 = "-client " + string2;
                continue;
            }
            if (string4.equals("-tserver")) {
                string2 = "-server " + string2;
                continue;
            }
            if (string4.equals("-sourcepath")) {
                if (i == stringArray.length - 1) {
                    TTY.usageError("No sourcepath specified.");
                    return;
                }
                Env.setSourcePath(stringArray[++i]);
                continue;
            }
            if (string4.equals("-classpath")) {
                if (i == stringArray.length - 1) {
                    TTY.usageError("No classpath specified.");
                    return;
                }
                string2 = TTY.addArgument(string2, string4);
                string2 = TTY.addArgument(string2, stringArray[++i]);
                continue;
            }
            if (string4.equals("-attach")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string4);
                    return;
                }
                if (i == stringArray.length - 1) {
                    TTY.usageError("No attach address specified.");
                    return;
                }
                object = stringArray[++i];
                if (TTY.supportsSharedMemory()) {
                    string3 = "com.sun.jdi.SharedMemoryAttach:name=" + (String)object;
                    continue;
                }
                String string5 = TTY.addressToSocketArgs((String)object);
                string3 = "com.sun.jdi.SocketAttach:" + string5;
                continue;
            }
            if (string4.equals("-listen") || string4.equals("-listenany")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string4);
                    return;
                }
                object = null;
                if (string4.equals("-listen")) {
                    if (i == stringArray.length - 1) {
                        TTY.usageError("No attach address specified.");
                        return;
                    }
                    object = stringArray[++i];
                }
                if (TTY.supportsSharedMemory()) {
                    string3 = "com.sun.jdi.SharedMemoryListen:";
                    if (object == null) continue;
                    string3 = string3 + "name=" + (String)object;
                    continue;
                }
                string3 = "com.sun.jdi.SocketListen:";
                if (object == null) continue;
                string3 = string3 + TTY.addressToSocketArgs((String)object);
                continue;
            }
            if (string4.equals("-launch")) {
                bl = true;
                continue;
            }
            if (string4.equals("-listconnectors")) {
                object = new Commands();
                ((Commands)object).commandConnectors(Bootstrap.virtualMachineManager());
                return;
            }
            if (string4.equals("-connect")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string4);
                    return;
                }
                if (i == stringArray.length - 1) {
                    TTY.usageError("No connect specification.");
                    return;
                }
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-help")) {
                TTY.usage();
                continue;
            }
            if (string4.equals("-version")) {
                object = new Commands();
                ((Commands)object).commandVersion(progname, Bootstrap.virtualMachineManager());
                System.exit(0);
                continue;
            }
            if (string4.startsWith("-")) {
                TTY.usageError("invalid option", string4);
                return;
            }
            string = TTY.addArgument("", string4);
            ++i;
            while (i < stringArray.length) {
                string = TTY.addArgument(string, stringArray[i]);
                ++i;
            }
            break;
        }
        if (string3 == null) {
            string3 = "com.sun.jdi.CommandLineLaunch:";
        } else if (!string3.endsWith(",") && !string3.endsWith(":")) {
            string3 = string3 + ",";
        }
        string = string.trim();
        string2 = string2.trim();
        if (string.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify command line with connector:", string3);
                return;
            }
            string3 = string3 + "main=" + string + ",";
        }
        if (string2.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify target vm arguments with connector:", string3);
                return;
            }
            string3 = string3 + "options=" + string2 + ",";
        }
        try {
            if (!string3.endsWith(",")) {
                string3 = string3 + ",";
            }
            Env.init(string3, bl, n);
            new TTY();
        }
        catch (Exception exception) {
            MessageOutput.printException("Internal exception:", exception);
        }
    }
}

