/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import java.io.IOException;

public abstract class JavaLazyReadObject
extends JavaHeapObject {
    private final long offset;

    protected JavaLazyReadObject(long l) {
        this.offset = l;
    }

    @Override
    public final int getSize() {
        return this.getValueLength() + this.getClazz().getMinimumObjectSize();
    }

    protected final long getOffset() {
        return this.offset;
    }

    protected final int getValueLength() {
        try {
            return this.readValueLength();
        }
        catch (IOException iOException) {
            System.err.println("lazy read failed at offset " + this.offset);
            iOException.printStackTrace();
            return 0;
        }
    }

    protected final byte[] getValue() {
        try {
            return this.readValue();
        }
        catch (IOException iOException) {
            System.err.println("lazy read failed at offset " + this.offset);
            iOException.printStackTrace();
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    public final long getId() {
        try {
            ReadBuffer readBuffer = this.getClazz().getReadBuffer();
            int n = this.getClazz().getIdentifierSize();
            if (n == 4) {
                return (long)readBuffer.getInt(this.offset) & Snapshot.SMALL_ID_MASK;
            }
            return readBuffer.getLong(this.offset);
        }
        catch (IOException iOException) {
            System.err.println("lazy read failed at offset " + this.offset);
            iOException.printStackTrace();
            return -1L;
        }
    }

    protected abstract int readValueLength() throws IOException;

    protected abstract byte[] readValue() throws IOException;

    protected static Number makeId(long l) {
        if ((l & (Snapshot.SMALL_ID_MASK ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return new Integer((int)l);
        }
        return new Long(l);
    }

    protected static long getIdValue(Number number) {
        long l = number.longValue();
        if (number instanceof Integer) {
            l &= Snapshot.SMALL_ID_MASK;
        }
        return l;
    }

    protected final long objectIdAt(int n, byte[] byArray) {
        int n2 = this.getClazz().getIdentifierSize();
        if (n2 == 4) {
            return (long)JavaLazyReadObject.intAt(n, byArray) & Snapshot.SMALL_ID_MASK;
        }
        return JavaLazyReadObject.longAt(n, byArray);
    }

    protected static byte byteAt(int n, byte[] byArray) {
        return byArray[n];
    }

    protected static boolean booleanAt(int n, byte[] byArray) {
        return (byArray[n] & 0xFF) != 0;
    }

    protected static char charAt(int n, byte[] byArray) {
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        return (char)((n2 << 8) + n3);
    }

    protected static short shortAt(int n, byte[] byArray) {
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    protected static int intAt(int n, byte[] byArray) {
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    protected static long longAt(int n, byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            int n2 = byArray[n++] & 0xFF;
            l |= (long)n2;
        }
        return l;
    }

    protected static float floatAt(int n, byte[] byArray) {
        int n2 = JavaLazyReadObject.intAt(n, byArray);
        return Float.intBitsToFloat(n2);
    }

    protected static double doubleAt(int n, byte[] byArray) {
        long l = JavaLazyReadObject.longAt(n, byArray);
        return Double.longBitsToDouble(l);
    }
}

