/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaBoolean;
import com.sun.tools.hat.internal.model.JavaByte;
import com.sun.tools.hat.internal.model.JavaChar;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaDouble;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaFloat;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaInt;
import com.sun.tools.hat.internal.model.JavaLazyReadObject;
import com.sun.tools.hat.internal.model.JavaLong;
import com.sun.tools.hat.internal.model.JavaObjectRef;
import com.sun.tools.hat.internal.model.JavaShort;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.JavaValueArray;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import java.io.IOException;

public class JavaObject
extends JavaLazyReadObject {
    private Object clazz;

    public JavaObject(long l, long l2) {
        super(l2);
        this.clazz = JavaObject.makeId(l);
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.clazz instanceof JavaClass) {
            return;
        }
        if (this.clazz instanceof Number) {
            long l = JavaObject.getIdValue((Number)this.clazz);
            this.clazz = snapshot.findThing(l);
            if (!(this.clazz instanceof JavaClass)) {
                int n;
                this.warn("Class " + Long.toHexString(l) + " not found, " + "adding fake class!");
                ReadBuffer readBuffer = snapshot.getReadBuffer();
                int n2 = snapshot.getIdentifierSize();
                long l2 = this.getOffset() + (long)(2 * n2) + 4L;
                try {
                    n = readBuffer.getInt(l2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                this.clazz = snapshot.addFakeInstanceClass(l, n);
            }
        } else {
            throw new InternalError("should not reach here");
        }
        JavaClass javaClass = (JavaClass)this.clazz;
        javaClass.resolve(snapshot);
        this.parseFields(this.getValue(), true);
        javaClass.addInstance(this);
        super.resolve(snapshot);
    }

    @Override
    public boolean isSameTypeAs(JavaThing javaThing) {
        if (!(javaThing instanceof JavaObject)) {
            return false;
        }
        JavaObject javaObject = (JavaObject)javaThing;
        return this.getClazz().equals(javaObject.getClazz());
    }

    @Override
    public JavaClass getClazz() {
        return (JavaClass)this.clazz;
    }

    public JavaThing[] getFields() {
        return this.parseFields(this.getValue(), false);
    }

    public JavaThing getField(String string) {
        JavaThing[] javaThingArray = this.getFields();
        JavaField[] javaFieldArray = this.getClazz().getFieldsForInstance();
        for (int i = 0; i < javaFieldArray.length; ++i) {
            if (!javaFieldArray[i].getName().equals(string)) continue;
            return javaThingArray[i];
        }
        return null;
    }

    @Override
    public int compareTo(JavaThing javaThing) {
        if (javaThing instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)javaThing;
            return this.getClazz().getName().compareTo(javaObject.getClazz().getName());
        }
        return super.compareTo(javaThing);
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor javaHeapObjectVisitor) {
        super.visitReferencedObjects(javaHeapObjectVisitor);
        JavaThing[] javaThingArray = this.getFields();
        for (int i = 0; i < javaThingArray.length; ++i) {
            if (javaThingArray[i] == null || javaHeapObjectVisitor.mightExclude() && javaHeapObjectVisitor.exclude(this.getClazz().getClassForField(i), this.getClazz().getFieldForInstance(i)) || !(javaThingArray[i] instanceof JavaHeapObject)) continue;
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThingArray[i]);
        }
    }

    @Override
    public boolean refersOnlyWeaklyTo(Snapshot snapshot, JavaThing javaThing) {
        if (snapshot.getWeakReferenceClass() != null) {
            int n = snapshot.getReferentFieldIndex();
            if (snapshot.getWeakReferenceClass().isAssignableFrom(this.getClazz())) {
                JavaThing[] javaThingArray = this.getFields();
                for (int i = 0; i < javaThingArray.length; ++i) {
                    if (i == n || javaThingArray[i] != javaThing) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String describeReferenceTo(JavaThing javaThing, Snapshot snapshot) {
        JavaThing[] javaThingArray = this.getFields();
        for (int i = 0; i < javaThingArray.length; ++i) {
            if (javaThingArray[i] != javaThing) continue;
            JavaField javaField = this.getClazz().getFieldForInstance(i);
            return "field " + javaField.getName();
        }
        return super.describeReferenceTo(javaThing, snapshot);
    }

    @Override
    public String toString() {
        if (this.getClazz().isString()) {
            JavaThing javaThing = this.getField("value");
            if (javaThing instanceof JavaValueArray) {
                return ((JavaValueArray)javaThing).valueString();
            }
            return "null";
        }
        return super.toString();
    }

    @Override
    protected final int readValueLength() throws IOException {
        JavaClass javaClass = this.getClazz();
        int n = javaClass.getIdentifierSize();
        long l = this.getOffset() + (long)(2 * n) + 4L;
        return javaClass.getReadBuffer().getInt(l);
    }

    @Override
    protected final byte[] readValue() throws IOException {
        long l;
        JavaClass javaClass = this.getClazz();
        int n = javaClass.getIdentifierSize();
        ReadBuffer readBuffer = javaClass.getReadBuffer();
        int n2 = readBuffer.getInt(l = this.getOffset() + (long)(2 * n) + 4L);
        if (n2 == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        readBuffer.get(l + 4L, byArray);
        return byArray;
    }

    private JavaThing[] parseFields(byte[] byArray, boolean bl) {
        JavaClass javaClass = this.getClazz();
        int n = javaClass.getNumFieldsForInstance();
        JavaField[] javaFieldArray = javaClass.getFields();
        JavaThing[] javaThingArray = new JavaThing[n];
        Snapshot snapshot = javaClass.getSnapshot();
        int n2 = snapshot.getIdentifierSize();
        int n3 = 0;
        n -= javaFieldArray.length;
        JavaClass javaClass2 = javaClass;
        int n4 = 0;
        int n5 = 0;
        while (n5 < javaThingArray.length) {
            while (n3 >= javaFieldArray.length) {
                javaClass2 = javaClass2.getSuperclass();
                javaFieldArray = javaClass2.getFields();
                n3 = 0;
                n -= javaFieldArray.length;
            }
            JavaField javaField = javaFieldArray[n3];
            char c = javaField.getSignature().charAt(0);
            switch (c) {
                case 'L': 
                case '[': {
                    long l = this.objectIdAt(n4, byArray);
                    n4 += n2;
                    JavaObjectRef javaObjectRef = new JavaObjectRef(l);
                    javaThingArray[n + n3] = javaObjectRef.dereference(snapshot, javaField, bl);
                    break;
                }
                case 'Z': {
                    byte by = JavaObject.byteAt(n4, byArray);
                    ++n4;
                    javaThingArray[n + n3] = new JavaBoolean(by != 0);
                    break;
                }
                case 'B': {
                    byte by = JavaObject.byteAt(n4, byArray);
                    ++n4;
                    javaThingArray[n + n3] = new JavaByte(by);
                    break;
                }
                case 'S': {
                    short s = JavaObject.shortAt(n4, byArray);
                    n4 += 2;
                    javaThingArray[n + n3] = new JavaShort(s);
                    break;
                }
                case 'C': {
                    char c2 = JavaObject.charAt(n4, byArray);
                    n4 += 2;
                    javaThingArray[n + n3] = new JavaChar(c2);
                    break;
                }
                case 'I': {
                    int n6 = JavaObject.intAt(n4, byArray);
                    n4 += 4;
                    javaThingArray[n + n3] = new JavaInt(n6);
                    break;
                }
                case 'J': {
                    long l = JavaObject.longAt(n4, byArray);
                    n4 += 8;
                    javaThingArray[n + n3] = new JavaLong(l);
                    break;
                }
                case 'F': {
                    float f = JavaObject.floatAt(n4, byArray);
                    n4 += 4;
                    javaThingArray[n + n3] = new JavaFloat(f);
                    break;
                }
                case 'D': {
                    double d = JavaObject.doubleAt(n4, byArray);
                    n4 += 8;
                    javaThingArray[n + n3] = new JavaDouble(d);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid signature: " + c);
                }
            }
            ++n5;
            ++n3;
        }
        return javaThingArray;
    }

    private void warn(String string) {
        System.out.println("WARNING: " + string);
    }
}

