/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheFSInfo
extends FSInfo {
    private Map<File, Entry> cache = new ConcurrentHashMap<File, Entry>();

    public static void preRegister(Context context) {
        context.put(FSInfo.class, new Context.Factory<FSInfo>(){

            @Override
            public FSInfo make(Context context) {
                CacheFSInfo cacheFSInfo = new CacheFSInfo();
                context.put(FSInfo.class, cacheFSInfo);
                return cacheFSInfo;
            }
        });
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public File getCanonicalFile(File file) {
        Entry entry = this.getEntry(file);
        return entry.canonicalFile;
    }

    @Override
    public boolean exists(File file) {
        Entry entry = this.getEntry(file);
        return entry.exists;
    }

    @Override
    public boolean isDirectory(File file) {
        Entry entry = this.getEntry(file);
        return entry.isDirectory;
    }

    @Override
    public boolean isFile(File file) {
        Entry entry = this.getEntry(file);
        return entry.isFile;
    }

    @Override
    public List<File> getJarClassPath(File file) throws IOException {
        Entry entry = this.getEntry(file);
        if (entry.jarClassPath == null) {
            entry.jarClassPath = super.getJarClassPath(file);
        }
        return entry.jarClassPath;
    }

    private Entry getEntry(File file) {
        Entry entry = this.cache.get(file);
        if (entry == null) {
            entry = new Entry();
            entry.canonicalFile = super.getCanonicalFile(file);
            entry.exists = super.exists(file);
            entry.isDirectory = super.isDirectory(file);
            entry.isFile = super.isFile(file);
            this.cache.put(file, entry);
        }
        return entry;
    }

    private static class Entry {
        File canonicalFile;
        boolean exists;
        boolean isFile;
        boolean isDirectory;
        List<File> jarClassPath;

        private Entry() {
        }
    }
}

