/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacFiler
implements Filer,
Closeable {
    private static final String ALREADY_OPENED = "Output stream or writer has already been opened.";
    private static final String NOT_FOR_READING = "FileObject was not opened for reading.";
    private static final String NOT_FOR_WRITING = "FileObject was not opened for writing.";
    JavaFileManager fileManager;
    Log log;
    Context context;
    boolean lastRound;
    private final boolean lint;
    private final Set<FileObject> fileObjectHistory;
    private final Set<String> openTypeNames;
    private Set<String> generatedSourceNames;
    private final Map<String, JavaFileObject> generatedClasses;
    private Set<JavaFileObject> generatedSourceFileObjects;
    private final Set<String> aggregateGeneratedSourceNames;
    private final Set<String> aggregateGeneratedClassNames;

    JavacFiler(Context context) {
        this.context = context;
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        this.fileObjectHistory = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceNames = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceFileObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedClasses = Collections.synchronizedMap(new LinkedHashMap());
        this.openTypeNames = Collections.synchronizedSet(new LinkedHashSet());
        this.aggregateGeneratedSourceNames = new LinkedHashSet<String>();
        this.aggregateGeneratedClassNames = new LinkedHashSet<String>();
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        return this.createSourceOrClassFile(true, charSequence.toString());
    }

    @Override
    public JavaFileObject createClassFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        return this.createSourceOrClassFile(false, charSequence.toString());
    }

    private JavaFileObject createSourceOrClassFile(boolean bl, String string) throws IOException {
        Object object;
        Object object2;
        int n;
        if (this.lint && (n = string.lastIndexOf(".")) != -1) {
            object2 = string.substring(n);
            Object object3 = object = bl ? ".java" : ".class";
            if (((String)object2).equals(object)) {
                this.log.warning("proc.suspicious.class.name", string, object);
            }
        }
        this.checkNameAndExistence(string, bl);
        StandardLocation standardLocation = bl ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
        object2 = bl ? JavaFileObject.Kind.SOURCE : JavaFileObject.Kind.CLASS;
        object = this.fileManager.getJavaFileForOutput(standardLocation, string, (JavaFileObject.Kind)((Object)object2), null);
        this.checkFileReopening((FileObject)object, true);
        if (this.lastRound) {
            this.log.warning("proc.file.create.last.round", string);
        }
        if (bl) {
            this.aggregateGeneratedSourceNames.add(string);
        } else {
            this.aggregateGeneratedClassNames.add(string);
        }
        this.openTypeNames.add(string);
        return new FilerOutputJavaFileObject(string, (JavaFileObject)object);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2, Element ... elementArray) throws IOException {
        this.locationCheck(location);
        String string = charSequence.toString();
        if (string.length() > 0) {
            this.checkName(string);
        }
        FileObject fileObject = this.fileManager.getFileForOutput(location, string, charSequence2.toString(), null);
        this.checkFileReopening(fileObject, true);
        if (fileObject instanceof JavaFileObject) {
            return new FilerOutputJavaFileObject(null, (JavaFileObject)fileObject);
        }
        return new FilerOutputFileObject(null, fileObject);
    }

    private void locationCheck(JavaFileManager.Location location) {
        StandardLocation standardLocation;
        if (location instanceof StandardLocation && !(standardLocation = (StandardLocation)location).isOutputLocation()) {
            throw new IllegalArgumentException("Resource creation not supported in location " + standardLocation);
        }
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2) throws IOException {
        FileObject fileObject;
        String string = charSequence.toString();
        if (string.length() > 0) {
            this.checkName(string);
        }
        if ((fileObject = location.isOutputLocation() ? this.fileManager.getFileForOutput(location, charSequence.toString(), charSequence2.toString(), null) : this.fileManager.getFileForInput(location, charSequence.toString(), charSequence2.toString())) == null) {
            String string2 = charSequence.length() == 0 ? charSequence2.toString() : charSequence + "/" + charSequence2;
            throw new FileNotFoundException(string2);
        }
        this.checkFileReopening(fileObject, false);
        return new FilerInputFileObject(fileObject);
    }

    private void checkName(String string) throws FilerException {
        this.checkName(string, false);
    }

    private void checkName(String string, boolean bl) throws FilerException {
        if (!SourceVersion.isName(string) && !this.isPackageInfo(string, bl)) {
            if (this.lint) {
                this.log.warning("proc.illegal.file.name", string);
            }
            throw new FilerException("Illegal name " + string);
        }
    }

    private boolean isPackageInfo(String string, boolean bl) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return bl ? string.equals("package-info") : false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return SourceVersion.isName(string2) && string3.equals("package-info");
    }

    private void checkNameAndExistence(String string, boolean bl) throws FilerException {
        this.checkName(string, bl);
        if (this.aggregateGeneratedSourceNames.contains(string) || this.aggregateGeneratedClassNames.contains(string)) {
            if (this.lint) {
                this.log.warning("proc.type.recreate", string);
            }
            throw new FilerException("Attempt to recreate a file for type " + string);
        }
    }

    private void checkFileReopening(FileObject fileObject, boolean bl) throws FilerException {
        for (FileObject fileObject2 : this.fileObjectHistory) {
            if (!this.fileManager.isSameFile(fileObject2, fileObject)) continue;
            if (this.lint) {
                this.log.warning("proc.file.reopening", fileObject.getName());
            }
            throw new FilerException("Attempt to reopen a file for path " + fileObject.getName());
        }
        if (bl) {
            this.fileObjectHistory.add(fileObject);
        }
    }

    public boolean newFiles() {
        return !this.generatedSourceNames.isEmpty() || !this.generatedClasses.isEmpty();
    }

    public Set<String> getGeneratedSourceNames() {
        return this.generatedSourceNames;
    }

    public Set<JavaFileObject> getGeneratedSourceFileObjects() {
        return this.generatedSourceFileObjects;
    }

    public Map<String, JavaFileObject> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public void warnIfUnclosedFiles() {
        if (!this.openTypeNames.isEmpty()) {
            this.log.warning("proc.unclosed.type.files", this.openTypeNames.toString());
        }
    }

    public void newRound(Context context) {
        this.context = context;
        this.log = Log.instance(context);
        this.clearRoundState();
    }

    void setLastRound(boolean bl) {
        this.lastRound = bl;
    }

    @Override
    public void close() {
        this.clearRoundState();
        this.fileObjectHistory.clear();
        this.openTypeNames.clear();
        this.aggregateGeneratedSourceNames.clear();
        this.aggregateGeneratedClassNames.clear();
    }

    private void clearRoundState() {
        this.generatedSourceNames.clear();
        this.generatedSourceFileObjects.clear();
        this.generatedClasses.clear();
    }

    public void displayState() {
        PrintWriter printWriter = this.context.get(Log.outKey);
        printWriter.println("File Object History : " + this.fileObjectHistory);
        printWriter.println("Open Type Names     : " + this.openTypeNames);
        printWriter.println("Gen. Src Names      : " + this.generatedSourceNames);
        printWriter.println("Gen. Cls Names      : " + this.generatedClasses.keySet());
        printWriter.println("Agg. Gen. Src Names : " + this.aggregateGeneratedSourceNames);
        printWriter.println("Agg. Gen. Cls Names : " + this.aggregateGeneratedClassNames);
    }

    public String toString() {
        return "javac Filer";
    }

    private void closeFileObject(String string, FileObject fileObject) {
        if (string != null) {
            if (!(fileObject instanceof JavaFileObject)) {
                throw new AssertionError((Object)("JavaFileOject not found for " + fileObject));
            }
            JavaFileObject javaFileObject = (JavaFileObject)fileObject;
            switch (javaFileObject.getKind()) {
                case SOURCE: {
                    this.generatedSourceNames.add(string);
                    this.generatedSourceFileObjects.add(javaFileObject);
                    this.openTypeNames.remove(string);
                    break;
                }
                case CLASS: {
                    this.generatedClasses.put(string, javaFileObject);
                    this.openTypeNames.remove(string);
                    break;
                }
            }
        }
    }

    private class FilerWriter
    extends FilterWriter {
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerWriter(String string, FileObject fileObject) throws IOException {
            super(fileObject.openWriter());
            this.closed = false;
            this.typeName = string;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerOutputStream
    extends FilterOutputStream {
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerOutputStream(String string, FileObject fileObject) throws IOException {
            super(fileObject.openOutputStream());
            this.closed = false;
            this.typeName = string;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerInputJavaFileObject
    extends FilerInputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerInputJavaFileObject(JavaFileObject javaFileObject) {
            super(javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(string, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerInputFileObject
    extends ForwardingFileObject<FileObject> {
        FilerInputFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }

    private class FilerOutputJavaFileObject
    extends FilerOutputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerOutputJavaFileObject(String string, JavaFileObject javaFileObject) {
            super(string, javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(string, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerOutputFileObject
    extends ForwardingFileObject<FileObject> {
        private boolean opened;
        private String name;

        FilerOutputFileObject(String string, FileObject fileObject) {
            super(fileObject);
            this.opened = false;
            this.name = string;
        }

        @Override
        public synchronized OutputStream openOutputStream() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerOutputStream(this.name, this.fileObject);
        }

        @Override
        public synchronized Writer openWriter() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerWriter(this.name, this.fileObject);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public Reader openReader(boolean bl) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public CharSequence getCharContent(boolean bl) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

