/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> iterable) {
        ListBuffer<List<N>> listBuffer = new ListBuffer<List<N>>();
        ListBuffer listBuffer2 = new ListBuffer();
        int n = 0;
        for (TarjanNode tarjanNode : iterable) {
            if (tarjanNode.index != -1) continue;
            n += GraphUtils.tarjan(tarjanNode, n, listBuffer2, listBuffer);
        }
        return listBuffer.toList();
    }

    private static <D, N extends TarjanNode<D>> int tarjan(N n, int n2, ListBuffer<N> listBuffer, ListBuffer<List<N>> listBuffer2) {
        n.index = n2;
        n.lowlink = n2++;
        listBuffer.prepend(n);
        n.active = true;
        Object tarjanNode = n.getAllDependencies().iterator();
        while (tarjanNode.hasNext()) {
            TarjanNode<D> object;
            TarjanNode<D> tarjanNode2 = object = tarjanNode.next();
            if (tarjanNode2.index == -1) {
                GraphUtils.tarjan(tarjanNode2, n2, listBuffer, listBuffer2);
                n.lowlink = Math.min(n.lowlink, tarjanNode2.lowlink);
                continue;
            }
            if (!listBuffer.contains(tarjanNode2)) continue;
            n.lowlink = Math.min(n.lowlink, tarjanNode2.index);
        }
        if (n.lowlink == n.index) {
            ListBuffer<Object> listBuffer3 = new ListBuffer<Object>();
            do {
                tarjanNode = (TarjanNode)listBuffer.remove();
                ((TarjanNode)tarjanNode).active = false;
                listBuffer3.add(tarjanNode);
            } while (tarjanNode != n);
            listBuffer2.add(listBuffer3.toList());
        }
        return n2;
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> iterable, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("digraph %s {\n", string));
        stringBuilder.append(String.format("label = \"%s\";\n", string2));
        for (TarjanNode<D> tarjanNode : iterable) {
            stringBuilder.append(String.format("%s [label = \"%s\"];\n", tarjanNode.hashCode(), tarjanNode.toString()));
        }
        for (TarjanNode<D> tarjanNode : iterable) {
            for (DependencyKind dependencyKind : tarjanNode.getSupportedDependencyKinds()) {
                for (TarjanNode<D> tarjanNode2 : tarjanNode.getDependenciesByKind(dependencyKind)) {
                    stringBuilder.append(String.format("%s -> %s [label = \" %s \" style = %s ];\n", tarjanNode.hashCode(), tarjanNode2.hashCode(), tarjanNode.getDependencyName(tarjanNode2, dependencyKind), dependencyKind.getDotStyle()));
                }
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D d) {
            super(d);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getAllDependencies();

        public abstract Iterable<? extends TarjanNode<D>> getDependenciesByKind(DependencyKind var1);

        @Override
        public int compareTo(TarjanNode<D> tarjanNode) {
            return this.index < tarjanNode.index ? -1 : (this.index == tarjanNode.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D d) {
            this.data = d;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Iterable<? extends Node<D>> getAllDependencies();

        public abstract String getDependencyName(Node<D> var1, DependencyKind var2);

        public String toString() {
            return this.data.toString();
        }
    }

    public static interface DependencyKind {
        public String getDotStyle();
    }
}

