/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    protected PrintWriter errWriter;
    protected PrintWriter warnWriter;
    protected PrintWriter noticeWriter;
    protected int MaxErrors;
    protected int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean suppressNotes;
    public boolean dumpOnError;
    public boolean multipleErrors;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    public boolean compressedOutput;
    private JavacMessages messages;
    private DiagnosticHandler diagnosticHandler;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    private static boolean useRawMessages = false;

    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener diagnosticListener;
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        this.diagListener = diagnosticListener = context.get(DiagnosticListener.class);
        this.diagnosticHandler = new DefaultDiagnosticHandler();
        this.messages = JavacMessages.instance(context);
        this.messages.add("com.sun.tools.javac.resources.javac");
        final Options options = Options.instance(context);
        this.initOptions(options);
        options.addListener(new Runnable(){

            @Override
            public void run() {
                Log.this.initOptions(options);
            }
        });
    }

    private void initOptions(Options options) {
        this.dumpOnError = options.isSet(Option.DOE);
        this.promptOnError = options.isSet(Option.PROMPT);
        this.emitWarnings = options.isUnset(Option.XLINT_CUSTOM, "none");
        this.suppressNotes = options.isSet("suppressNotes");
        this.MaxErrors = this.getIntOption(options, Option.XMAXERRS, this.getDefaultMaxErrors());
        this.MaxWarnings = this.getIntOption(options, Option.XMAXWARNS, this.getDefaultMaxWarnings());
        boolean bl = options.isSet("rawDiagnostics");
        this.diagFormatter = bl ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        String string = options.get("expectKeys");
        if (string != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(string.split(", *")));
        }
    }

    private int getIntOption(Options options, Option option, int n) {
        String string = options.get(option);
        try {
            if (string != null) {
                int n2 = Integer.parseInt(string);
                return n2 <= 0 ? Integer.MAX_VALUE : n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected int getDefaultMaxErrors() {
        return 100;
    }

    protected int getDefaultMaxWarnings() {
        return 100;
    }

    static PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject javaFileObject, EndPosTable endPosTable) {
        javaFileObject.getClass();
        this.getSource(javaFileObject).setEndPosTable(endPosTable);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter) {
        this.diagFormatter = diagnosticFormatter;
    }

    public PrintWriter getWriter(WriterKind writerKind) {
        switch (writerKind) {
            case NOTICE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setWriter(WriterKind writerKind, PrintWriter printWriter) {
        printWriter.getClass();
        switch (writerKind) {
            case NOTICE: {
                this.noticeWriter = printWriter;
                break;
            }
            case WARNING: {
                this.warnWriter = printWriter;
                break;
            }
            case ERROR: {
                this.errWriter = printWriter;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setWriters(PrintWriter printWriter) {
        printWriter.getClass();
        this.warnWriter = this.errWriter = printWriter;
        this.noticeWriter = this.errWriter;
    }

    public void initRound(Log log) {
        this.noticeWriter = log.noticeWriter;
        this.warnWriter = log.warnWriter;
        this.errWriter = log.errWriter;
        this.sourceMap = log.sourceMap;
        this.recorded = log.recorded;
        this.nerrors = log.nerrors;
        this.nwarnings = log.nwarnings;
    }

    public void popDiagnosticHandler(DiagnosticHandler diagnosticHandler) {
        Assert.check(this.diagnosticHandler == diagnosticHandler);
        this.diagnosticHandler = diagnosticHandler.prev;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void flush(WriterKind writerKind) {
        this.getWriter(writerKind).flush();
    }

    protected boolean shouldReport(JavaFileObject javaFileObject, int n) {
        boolean bl;
        if (this.multipleErrors || javaFileObject == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> pair = new Pair<JavaFileObject, Integer>(javaFileObject, n);
        boolean bl2 = bl = !this.recorded.contains(pair);
        if (bl) {
            this.recorded.add(pair);
        }
        return bl;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(this.localize("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int n, PrintWriter printWriter) {
        String string;
        String string2 = string = this.source == null ? null : this.source.getLine(n);
        if (string == null) {
            return;
        }
        int n2 = this.source.getColumnNumber(n, false);
        Log.printRawLines(printWriter, string);
        for (int i = 0; i < n2 - 1; ++i) {
            printWriter.print(string.charAt(i) == '\t' ? "\t" : " ");
        }
        printWriter.println("^");
        printWriter.flush();
    }

    public void printNewline() {
        this.noticeWriter.println();
    }

    public void printNewline(WriterKind writerKind) {
        this.getWriter(writerKind).println();
    }

    public void printLines(String string, Object ... objectArray) {
        Log.printRawLines(this.noticeWriter, this.localize(string, objectArray));
    }

    public void printLines(PrefixKind prefixKind, String string, Object ... objectArray) {
        Log.printRawLines(this.noticeWriter, this.localize(prefixKind, string, objectArray));
    }

    public void printLines(WriterKind writerKind, String string, Object ... objectArray) {
        Log.printRawLines(this.getWriter(writerKind), this.localize(string, objectArray));
    }

    public void printLines(WriterKind writerKind, PrefixKind prefixKind, String string, Object ... objectArray) {
        Log.printRawLines(this.getWriter(writerKind), this.localize(prefixKind, string, objectArray));
    }

    public void printRawLines(String string) {
        Log.printRawLines(this.noticeWriter, string);
    }

    public void printRawLines(WriterKind writerKind, String string) {
        Log.printRawLines(this.getWriter(writerKind), string);
    }

    public static void printRawLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    public void printVerbose(String string, Object ... objectArray) {
        Log.printRawLines(this.noticeWriter, this.localize("verbose." + string, objectArray));
    }

    @Override
    protected void directError(String string, Object ... objectArray) {
        Log.printRawLines(this.errWriter, this.localize(string, objectArray));
        this.errWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.writeDiagnostic(this.diags.warning(this.source, diagnosticPosition, string, objectArray));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic jCDiagnostic) {
        this.diagnosticHandler.report(jCDiagnostic);
    }

    protected void writeDiagnostic(JCDiagnostic jCDiagnostic) {
        if (this.diagListener != null) {
            this.diagListener.report(jCDiagnostic);
            return;
        }
        PrintWriter printWriter = this.getWriterForDiagnosticType(jCDiagnostic.getType());
        Log.printRawLines(printWriter, this.diagFormatter.format(jCDiagnostic, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (jCDiagnostic.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType diagnosticType) {
        switch (diagnosticType) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return JavacMessages.getDefaultLocalizedString(PrefixKind.COMPILER_MISC.key(string), objectArray);
    }

    public String localize(String string, Object ... objectArray) {
        return this.localize(PrefixKind.COMPILER_MISC, string, objectArray);
    }

    public String localize(PrefixKind prefixKind, String string, Object ... objectArray) {
        if (useRawMessages) {
            return prefixKind.key(string);
        }
        return this.messages.getLocalizedString(prefixKind.key(string), objectArray);
    }

    private void printRawError(int n, String string) {
        if (this.source == null || n == -1) {
            Log.printRawLines(this.errWriter, "error: " + string);
        } else {
            int n2 = this.source.getLineNumber(n);
            JavaFileObject javaFileObject = this.source.getFile();
            if (javaFileObject != null) {
                Log.printRawLines(this.errWriter, javaFileObject.getName() + ":" + n2 + ": " + string);
            }
            this.printErrLine(n, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n, String string) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), n)) {
            this.printRawError(n, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n, "warning: " + string);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format((Locale)null, string, objectArray);
    }

    private class DefaultDiagnosticHandler
    extends DiagnosticHandler {
        private DefaultDiagnosticHandler() {
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
            if (Log.this.expectDiagKeys != null) {
                Log.this.expectDiagKeys.remove(jCDiagnostic.getCode());
            }
            switch (jCDiagnostic.getType()) {
                case FRAGMENT: {
                    throw new IllegalArgumentException();
                }
                case NOTE: {
                    if (!Log.this.emitWarnings && !jCDiagnostic.isMandatory() || Log.this.suppressNotes) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    break;
                }
                case WARNING: {
                    if (!Log.this.emitWarnings && !jCDiagnostic.isMandatory() || Log.this.nwarnings >= Log.this.MaxWarnings) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    ++Log.this.nwarnings;
                    break;
                }
                case ERROR: {
                    if (Log.this.nerrors >= Log.this.MaxErrors || !Log.this.shouldReport(jCDiagnostic.getSource(), jCDiagnostic.getIntPosition())) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    ++Log.this.nerrors;
                }
            }
            if (jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.COMPRESSED)) {
                Log.this.compressedOutput = true;
            }
        }
    }

    public static enum WriterKind {
        NOTICE,
        WARNING,
        ERROR;

    }

    public static class DeferredDiagnosticHandler
    extends DiagnosticHandler {
        private Queue<JCDiagnostic> deferred = new ListBuffer<JCDiagnostic>();
        private final Filter<JCDiagnostic> filter;

        public DeferredDiagnosticHandler(Log log) {
            this(log, null);
        }

        public DeferredDiagnosticHandler(Log log, Filter<JCDiagnostic> filter) {
            this.filter = filter;
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
            if (!jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) && (this.filter == null || this.filter.accepts(jCDiagnostic))) {
                this.deferred.add(jCDiagnostic);
            } else {
                this.prev.report(jCDiagnostic);
            }
        }

        public Queue<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics(EnumSet.allOf(Diagnostic.Kind.class));
        }

        public void reportDeferredDiagnostics(Set<Diagnostic.Kind> set) {
            JCDiagnostic jCDiagnostic;
            while ((jCDiagnostic = this.deferred.poll()) != null) {
                if (!set.contains((Object)jCDiagnostic.getKind())) continue;
                this.prev.report(jCDiagnostic);
            }
            this.deferred = null;
        }
    }

    public static class DiscardDiagnosticHandler
    extends DiagnosticHandler {
        public DiscardDiagnosticHandler(Log log) {
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
        }
    }

    public static abstract class DiagnosticHandler {
        protected DiagnosticHandler prev;

        protected void install(Log log) {
            this.prev = log.diagnosticHandler;
            log.diagnosticHandler = this;
        }

        public abstract void report(JCDiagnostic var1);
    }

    public static enum PrefixKind {
        JAVAC("javac."),
        COMPILER_MISC("compiler.misc.");

        final String value;

        private PrefixKind(String string2) {
            this.value = string2;
        }

        public String key(String string) {
            return this.value + string;
        }
    }
}

