/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v2_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.monitor.AbstractMonitor;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;
import sun.jvmstat.perfdata.monitor.MonitorDataException;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.MonitorStructureException;
import sun.jvmstat.perfdata.monitor.MonitorTypeException;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;
import sun.jvmstat.perfdata.monitor.PerfIntegerMonitor;
import sun.jvmstat.perfdata.monitor.PerfLongMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringConstantMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringVariableMonitor;
import sun.jvmstat.perfdata.monitor.v2_0.PerfDataBufferPrologue;
import sun.jvmstat.perfdata.monitor.v2_0.TypeCode;

public class PerfDataBuffer
extends PerfDataBufferImpl {
    private static final boolean DEBUG = false;
    private static final int syncWaitMs = Integer.getInteger("sun.jvmstat.perdata.syncWaitMs", 5000);
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private static final int PERFDATA_ENTRYLENGTH_OFFSET = 0;
    private static final int PERFDATA_ENTRYLENGTH_SIZE = 4;
    private static final int PERFDATA_NAMEOFFSET_OFFSET = 4;
    private static final int PERFDATA_NAMEOFFSET_SIZE = 4;
    private static final int PERFDATA_VECTORLENGTH_OFFSET = 8;
    private static final int PERFDATA_VECTORLENGTH_SIZE = 4;
    private static final int PERFDATA_DATATYPE_OFFSET = 12;
    private static final int PERFDATA_DATATYPE_SIZE = 1;
    private static final int PERFDATA_FLAGS_OFFSET = 13;
    private static final int PERFDATA_FLAGS_SIZE = 1;
    private static final int PERFDATA_DATAUNITS_OFFSET = 14;
    private static final int PERFDATA_DATAUNITS_SIZE = 1;
    private static final int PERFDATA_DATAVAR_OFFSET = 15;
    private static final int PERFDATA_DATAVAR_SIZE = 1;
    private static final int PERFDATA_DATAOFFSET_OFFSET = 16;
    private static final int PERFDATA_DATAOFFSET_SIZE = 4;
    PerfDataBufferPrologue prologue;
    int nextEntry;
    long lastNumEntries;
    IntegerMonitor overflow;
    ArrayList<Monitor> insertedMonitors;

    public PerfDataBuffer(ByteBuffer byteBuffer, int n) throws MonitorException {
        super(byteBuffer, n);
        this.prologue = new PerfDataBufferPrologue(byteBuffer);
        this.buffer.order(this.prologue.getByteOrder());
    }

    @Override
    protected void buildMonitorMap(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        this.buffer.rewind();
        this.buildPseudoMonitors(map);
        this.synchWithTarget();
        this.nextEntry = this.prologue.getEntryOffset();
        int n = this.prologue.getNumEntries();
        Monitor monitor = this.getNextMonitorEntry();
        while (monitor != null) {
            map.put(monitor.getName(), monitor);
            monitor = this.getNextMonitorEntry();
        }
        this.lastNumEntries = n;
        this.insertedMonitors = new ArrayList<Monitor>(map.values());
    }

    @Override
    protected void getNewMonitors(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        int n = this.prologue.getNumEntries();
        if ((long)n > this.lastNumEntries) {
            this.lastNumEntries = n;
            Monitor monitor = this.getNextMonitorEntry();
            while (monitor != null) {
                String string = monitor.getName();
                if (!map.containsKey(string)) {
                    map.put(string, monitor);
                    if (this.insertedMonitors != null) {
                        this.insertedMonitors.add(monitor);
                    }
                }
                monitor = this.getNextMonitorEntry();
            }
        }
    }

    @Override
    protected MonitorStatus getMonitorStatus(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        assert (this.insertedMonitors != null);
        this.getNewMonitors(map);
        ArrayList arrayList = EMPTY_LIST;
        ArrayList<Monitor> arrayList2 = this.insertedMonitors;
        this.insertedMonitors = new ArrayList();
        return new MonitorStatus(arrayList2, arrayList);
    }

    protected void buildPseudoMonitors(Map<String, Monitor> map) {
        AbstractMonitor abstractMonitor = null;
        String string = null;
        IntBuffer intBuffer = null;
        string = "sun.perfdata.majorVersion";
        intBuffer = this.prologue.majorVersionBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.NONE, Variability.CONSTANT, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.minorVersion";
        intBuffer = this.prologue.minorVersionBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.NONE, Variability.CONSTANT, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.size";
        intBuffer = this.prologue.sizeBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.used";
        intBuffer = this.prologue.usedBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.overflow";
        intBuffer = this.prologue.overflowBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        this.overflow = abstractMonitor;
        string = "sun.perfdata.timestamp";
        LongBuffer longBuffer = this.prologue.modificationTimeStampBuffer();
        abstractMonitor = new PerfLongMonitor(string, Units.TICKS, Variability.MONOTONIC, false, longBuffer);
        map.put(string, abstractMonitor);
    }

    protected void synchWithTarget() throws MonitorException {
        long l = System.currentTimeMillis() + (long)syncWaitMs;
        this.log("synchWithTarget: " + this.lvmid + " ");
        while (!this.prologue.isAccessible()) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= l) continue;
            this.logln("failed: " + this.lvmid);
            throw new MonitorException("Could not synchronize with target");
        }
        this.logln("success: " + this.lvmid);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Monitor getNextMonitorEntry() throws MonitorException {
        void var1_6;
        byte by;
        Object var1_1 = null;
        if (this.nextEntry % 4 != 0) {
            throw new MonitorStructureException("Misaligned entry index: " + Integer.toHexString(this.nextEntry));
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new MonitorStructureException("Entry index out of bounds: " + Integer.toHexString(this.nextEntry) + ", limit = " + Integer.toHexString(this.buffer.limit()));
        }
        if (this.nextEntry == this.buffer.limit()) {
            this.logln("getNextMonitorEntry(): nextEntry == buffer.limit(): returning");
            return null;
        }
        this.buffer.position(this.nextEntry);
        int n = this.buffer.position();
        int n2 = this.buffer.getInt();
        if (n2 < 0 || n2 > this.buffer.limit()) {
            throw new MonitorStructureException("Invalid entry length: entryLength = " + n2 + " (0x" + Integer.toHexString(n2) + ")");
        }
        if (n + n2 > this.buffer.limit()) {
            throw new MonitorStructureException("Entry extends beyond end of buffer:  entryStart = 0x" + Integer.toHexString(n) + " entryLength = 0x" + Integer.toHexString(n2) + " buffer limit = 0x" + Integer.toHexString(this.buffer.limit()));
        }
        if (n2 == 0) {
            return null;
        }
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        byte by2 = this.buffer.get();
        byte by3 = this.buffer.get();
        byte by4 = this.buffer.get();
        byte by5 = this.buffer.get();
        int n5 = this.buffer.getInt();
        this.dump_entry_fixed(n, n3, n4, by2, by3, by4, by5, n5);
        Units units = Units.toUnits(by4);
        Variability variability = Variability.toVariability(by5);
        TypeCode typeCode = null;
        boolean bl = (by3 & 1) != 0;
        try {
            typeCode = TypeCode.toTypeCode(by2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MonitorStructureException("Illegal type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", type_code = " + Integer.toHexString(by2));
        }
        if (n3 > n2) {
            throw new MonitorStructureException("Field extends beyond entry bounds entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name_offset = 0x" + Integer.toHexString(n3));
        }
        if (n5 > n2) {
            throw new MonitorStructureException("Field extends beyond entry bounds: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", data_offset = 0x" + Integer.toHexString(n5));
        }
        if (variability == Variability.INVALID) {
            throw new MonitorDataException("Invalid variability attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", variability = 0x" + Integer.toHexString(by5));
        }
        if (units == Units.INVALID) {
            throw new MonitorDataException("Invalid units attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", units = 0x" + Integer.toHexString(by4));
        }
        assert (this.buffer.position() == n + n3);
        assert (n5 > n3);
        int n6 = n5 - n3;
        assert (n6 < n2);
        byte[] byArray = new byte[n6];
        int n7 = 0;
        while ((by = this.buffer.get()) != 0 && n7 < n6) {
            byArray[n7++] = by;
        }
        assert (n7 < n6);
        assert (this.buffer.position() <= n + n5);
        String string = new String(byArray, 0, n7);
        int n8 = n2 - n5;
        this.buffer.position(n + n5);
        this.dump_entry_variable(string, this.buffer, n8);
        if (n4 == 0) {
            if (typeCode != TypeCode.LONG) throw new MonitorTypeException("Unexpected type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name = " + string + ", type_code = " + typeCode + " (0x" + Integer.toHexString(by2) + ")");
            LongBuffer longBuffer = this.buffer.asLongBuffer();
            longBuffer.limit(1);
            PerfLongMonitor perfLongMonitor = new PerfLongMonitor(string, units, variability, bl, longBuffer);
        } else {
            if (typeCode != TypeCode.BYTE) throw new MonitorTypeException("Unexpected type code encountered: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + ", name = " + string + ", type_code = " + typeCode + " (0x" + Integer.toHexString(by2) + ")");
            if (units != Units.STRING) {
                throw new MonitorTypeException("Unexpected vector type encounterd: entry_offset = " + Integer.toHexString(this.nextEntry) + ", name = " + string + ", type_code = " + typeCode + " (0x" + Integer.toHexString(by2) + ")" + ", units = " + units + " (0x" + Integer.toHexString(by4) + ")");
            }
            ByteBuffer byteBuffer = this.buffer.slice();
            byteBuffer.limit(n4);
            if (variability == Variability.CONSTANT) {
                PerfStringConstantMonitor perfStringConstantMonitor = new PerfStringConstantMonitor(string, bl, byteBuffer);
            } else if (variability == Variability.VARIABLE) {
                PerfStringVariableMonitor perfStringVariableMonitor = new PerfStringVariableMonitor(string, bl, byteBuffer, n4 - 1);
            } else {
                if (variability == Variability.MONOTONIC) {
                    throw new MonitorDataException("Unexpected variability attribute: entry_offset = 0x" + Integer.toHexString(this.nextEntry) + " name = " + string + ", variability = " + variability + " (0x" + Integer.toHexString(by5) + ")");
                }
                assert (false);
            }
        }
        this.nextEntry = n + n2;
        return var1_6;
    }

    private void dumpAll(Map<String, Monitor> map, int n) {
    }

    private void dump_entry_fixed(int n, int n2, int n3, byte by, byte by2, byte by3, byte by4, int n4) {
    }

    private void dump_entry_variable(String string, ByteBuffer byteBuffer, int n) {
    }

    private void logln(String string) {
    }

    private void log(String string) {
    }
}

