/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic.jrmp;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.rmi.rmic.newrmic.BatchEnvironment;
import sun.rmi.rmic.newrmic.jrmp.Util;

final class RemoteClass {
    private final BatchEnvironment env;
    private final ClassDoc implClass;
    private ClassDoc[] remoteInterfaces;
    private Method[] remoteMethods;
    private long interfaceHash;

    static RemoteClass forClass(BatchEnvironment batchEnvironment, ClassDoc classDoc) {
        RemoteClass remoteClass = new RemoteClass(batchEnvironment, classDoc);
        if (remoteClass.init()) {
            return remoteClass;
        }
        return null;
    }

    private RemoteClass(BatchEnvironment batchEnvironment, ClassDoc classDoc) {
        this.env = batchEnvironment;
        this.implClass = classDoc;
    }

    ClassDoc classDoc() {
        return this.implClass;
    }

    ClassDoc[] remoteInterfaces() {
        return (ClassDoc[])this.remoteInterfaces.clone();
    }

    Method[] remoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    long interfaceHash() {
        return this.interfaceHash;
    }

    private boolean init() {
        Object object;
        if (this.implClass.isInterface()) {
            this.env.error("rmic.cant.make.stubs.for.interface", this.implClass.qualifiedName());
            return false;
        }
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        for (object = this.implClass; object != null; object = object.superclass()) {
            for (Object object2 : object.interfaces()) {
                if (arrayList.contains(object2) || !object2.subclassOf(this.env.docRemote())) continue;
                arrayList.add((ClassDoc)object2);
                if (!this.env.verbose()) continue;
                this.env.output("[found remote interface: " + object2.qualifiedName() + "]");
            }
            if (object != this.implClass || !arrayList.isEmpty()) continue;
            if (this.implClass.subclassOf(this.env.docRemote())) {
                this.env.error("rmic.must.implement.remote.directly", this.implClass.qualifiedName());
            } else {
                this.env.error("rmic.must.implement.remote", this.implClass.qualifiedName());
            }
            return false;
        }
        this.remoteInterfaces = arrayList.toArray(new ClassDoc[arrayList.size()]);
        object = new HashMap();
        boolean bl = false;
        for (ClassDoc classDoc : arrayList) {
            if (this.collectRemoteMethods(classDoc, (Map<String, Method>)object)) continue;
            bl = true;
        }
        if (bl) {
            return false;
        }
        Object[] objectArray = object.keySet().toArray(new String[object.size()]);
        Arrays.sort(objectArray);
        this.remoteMethods = new Method[object.size()];
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            Object object2;
            this.remoteMethods[i] = (Method)object.get(objectArray[i]);
            if (!this.env.verbose()) continue;
            object2 = "[found remote method <" + i + ">: " + this.remoteMethods[i].operationString();
            ClassDoc[] classDocArray = this.remoteMethods[i].exceptionTypes();
            if (classDocArray.length > 0) {
                object2 = (String)object2 + " throws ";
                for (int j = 0; j < classDocArray.length; ++j) {
                    if (j > 0) {
                        object2 = (String)object2 + ", ";
                    }
                    object2 = (String)object2 + classDocArray[j].qualifiedName();
                }
            }
            object2 = (String)object2 + "\n\tname and descriptor = \"" + this.remoteMethods[i].nameAndDescriptor();
            object2 = (String)object2 + "\n\tmethod hash = " + this.remoteMethods[i].methodHash() + "]";
            this.env.output((String)object2);
        }
        this.interfaceHash = this.computeInterfaceHash();
        return true;
    }

    private boolean collectRemoteMethods(ClassDoc classDoc, Map<String, Method> map) {
        if (!classDoc.isInterface()) {
            throw new AssertionError((Object)(classDoc.qualifiedName() + " not an interface"));
        }
        boolean bl = false;
        block0: for (MethodDoc methodDoc : classDoc.methods()) {
            Method method;
            String string;
            Object object2;
            boolean bl2 = false;
            for (Object object2 : methodDoc.thrownExceptions()) {
                if (!this.env.docRemoteException().subclassOf(object2)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.env.error("rmic.must.throw.remoteexception", classDoc.qualifiedName(), methodDoc.name() + methodDoc.signature());
                bl = true;
                continue;
            }
            MethodDoc methodDoc2 = this.findImplMethod(methodDoc);
            if (methodDoc2 != null) {
                for (ClassDoc classDoc2 : methodDoc2.thrownExceptions()) {
                    if (classDoc2.subclassOf(this.env.docException())) continue;
                    this.env.error("rmic.must.only.throw.exception", methodDoc2.name() + methodDoc2.signature(), classDoc2.qualifiedName());
                    bl = true;
                    continue block0;
                }
            }
            if ((object2 = map.get(string = (method = new Method(methodDoc)).nameAndDescriptor())) != null) {
                method = method.mergeWith((Method)object2);
            }
            map.put(string, method);
        }
        for (MethodDoc methodDoc : classDoc.interfaces()) {
            if (this.collectRemoteMethods((ClassDoc)methodDoc, map)) continue;
            bl = true;
        }
        return !bl;
    }

    private MethodDoc findImplMethod(MethodDoc methodDoc) {
        String string = methodDoc.name();
        String string2 = Util.methodDescriptorOf(methodDoc);
        for (MethodDoc methodDoc2 : this.implClass.methods()) {
            if (!string.equals(methodDoc2.name()) || !string2.equals(Util.methodDescriptorOf(methodDoc2))) continue;
            return methodDoc2;
        }
        return null;
    }

    private long computeInterfaceHash() {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            dataOutputStream.writeInt(1);
            Method[] objectArray = this.remoteMethods;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = objectArray[i];
                MethodDoc methodDoc = method.methodDoc();
                dataOutputStream.writeUTF(methodDoc.name());
                dataOutputStream.writeUTF(Util.methodDescriptorOf(methodDoc));
                ClassDoc[] classDocArray = methodDoc.thrownExceptions();
                Arrays.sort(classDocArray, new ClassDocComparator());
                for (ClassDoc classDoc : classDocArray) {
                    dataOutputStream.writeUTF(Util.binaryNameOf(classDoc));
                }
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (n = 0; n < Math.min(8, byArray.length); ++n) {
                l += (long)(byArray[n] & 0xFF) << n * 8;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        return l;
    }

    final class Method
    implements Cloneable {
        private final MethodDoc methodDoc;
        private final String operationString;
        private final String nameAndDescriptor;
        private final long methodHash;
        private ClassDoc[] exceptionTypes;

        Method(MethodDoc methodDoc) {
            this.methodDoc = methodDoc;
            this.exceptionTypes = methodDoc.thrownExceptions();
            Arrays.sort(this.exceptionTypes, new ClassDocComparator());
            this.operationString = this.computeOperationString();
            this.nameAndDescriptor = methodDoc.name() + Util.methodDescriptorOf(methodDoc);
            this.methodHash = this.computeMethodHash();
        }

        MethodDoc methodDoc() {
            return this.methodDoc;
        }

        Type[] parameterTypes() {
            Parameter[] parameterArray = this.methodDoc.parameters();
            Type[] typeArray = new Type[parameterArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = parameterArray[i].type();
            }
            return typeArray;
        }

        ClassDoc[] exceptionTypes() {
            return (ClassDoc[])this.exceptionTypes.clone();
        }

        long methodHash() {
            return this.methodHash;
        }

        String operationString() {
            return this.operationString;
        }

        String nameAndDescriptor() {
            return this.nameAndDescriptor;
        }

        Method mergeWith(Method method) {
            if (!this.nameAndDescriptor().equals(method.nameAndDescriptor())) {
                throw new AssertionError((Object)("attempt to merge method \"" + method.nameAndDescriptor() + "\" with \"" + this.nameAndDescriptor()));
            }
            ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
            this.collectCompatibleExceptions(method.exceptionTypes, this.exceptionTypes, arrayList);
            this.collectCompatibleExceptions(this.exceptionTypes, method.exceptionTypes, arrayList);
            Method method2 = this.clone();
            method2.exceptionTypes = arrayList.toArray(new ClassDoc[arrayList.size()]);
            return method2;
        }

        protected Method clone() {
            try {
                return (Method)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }

        private void collectCompatibleExceptions(ClassDoc[] classDocArray, ClassDoc[] classDocArray2, List<ClassDoc> list) {
            block0: for (ClassDoc classDoc : classDocArray) {
                if (list.contains(classDoc)) continue;
                for (ClassDoc classDoc2 : classDocArray2) {
                    if (!classDoc.subclassOf(classDoc2)) continue;
                    list.add(classDoc);
                    continue block0;
                }
            }
        }

        private long computeMethodHash() {
            long l = 0L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
                String string = this.nameAndDescriptor();
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
                byte[] byArray = messageDigest.digest();
                for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                    l += (long)(byArray[i] & 0xFF) << i * 8;
                }
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AssertionError((Object)noSuchAlgorithmException);
            }
            return l;
        }

        private String computeOperationString() {
            Type type = this.methodDoc.returnType();
            String string = type.qualifiedTypeName() + " " + this.methodDoc.name() + "(";
            Parameter[] parameterArray = this.methodDoc.parameters();
            for (int i = 0; i < parameterArray.length; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + parameterArray[i].type().toString();
            }
            string = string + ")" + type.dimension();
            return string;
        }
    }

    private static class ClassDocComparator
    implements Comparator<ClassDoc> {
        private ClassDocComparator() {
        }

        @Override
        public int compare(ClassDoc classDoc, ClassDoc classDoc2) {
            return Util.binaryNameOf(classDoc).compareTo(Util.binaryNameOf(classDoc2));
        }
    }
}

