/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.tools.asm.ClassConstantData;
import sun.tools.asm.ConstantPoolData;
import sun.tools.asm.FieldConstantData;
import sun.tools.asm.NameAndTypeConstantData;
import sun.tools.asm.NameAndTypeData;
import sun.tools.asm.NumberConstantData;
import sun.tools.asm.StringConstantData;
import sun.tools.asm.StringExpressionConstantData;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;
import sun.tools.java.RuntimeConstants;
import sun.tools.java.Type;
import sun.tools.tree.StringExpression;

public final class ConstantPool
implements RuntimeConstants {
    Hashtable<Object, ConstantPoolData> hash = new Hashtable(101);

    public int index(Object object) {
        return this.hash.get((Object)object).index;
    }

    public void put(Object object) {
        ConstantPoolData constantPoolData = this.hash.get(object);
        if (constantPoolData == null) {
            if (object instanceof String) {
                constantPoolData = new StringConstantData(this, (String)object);
            } else if (object instanceof StringExpression) {
                constantPoolData = new StringExpressionConstantData(this, (StringExpression)object);
            } else if (object instanceof ClassDeclaration) {
                constantPoolData = new ClassConstantData(this, (ClassDeclaration)object);
            } else if (object instanceof Type) {
                constantPoolData = new ClassConstantData(this, (Type)object);
            } else if (object instanceof MemberDefinition) {
                constantPoolData = new FieldConstantData(this, (MemberDefinition)object);
            } else if (object instanceof NameAndTypeData) {
                constantPoolData = new NameAndTypeConstantData(this, (NameAndTypeData)object);
            } else if (object instanceof Number) {
                constantPoolData = new NumberConstantData(this, (Number)object);
            }
            this.hash.put(object, constantPoolData);
        }
    }

    public void write(Environment environment, DataOutputStream dataOutputStream) throws IOException {
        int n;
        ConstantPoolData[] constantPoolDataArray = new ConstantPoolData[this.hash.size()];
        String[] stringArray = new String[constantPoolDataArray.length];
        int n2 = 1;
        int n3 = 0;
        for (n = 0; n < 5; ++n) {
            int n4 = n3;
            Enumeration<ConstantPoolData> enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                ConstantPoolData constantPoolData = enumeration.nextElement();
                if (constantPoolData.order() != n) continue;
                stringArray[n3] = ConstantPool.sortKey(constantPoolData);
                constantPoolDataArray[n3++] = constantPoolData;
            }
            ConstantPool.xsort(constantPoolDataArray, stringArray, n4, n3 - 1);
        }
        for (n = 0; n < constantPoolDataArray.length; ++n) {
            ConstantPoolData constantPoolData = constantPoolDataArray[n];
            constantPoolData.index = n2;
            n2 += constantPoolData.width();
        }
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n3; ++n) {
            constantPoolDataArray[n].write(environment, dataOutputStream, this);
        }
    }

    private static String sortKey(ConstantPoolData constantPoolData) {
        if (constantPoolData instanceof NumberConstantData) {
            Number number = ((NumberConstantData)constantPoolData).num;
            String string = number.toString();
            int n = 3;
            if (number instanceof Integer) {
                n = 0;
            } else if (number instanceof Float) {
                n = 1;
            } else if (number instanceof Long) {
                n = 2;
            }
            return "\u0000" + (char)(string.length() + n << 8) + string;
        }
        if (constantPoolData instanceof StringExpressionConstantData) {
            return (String)((StringExpressionConstantData)constantPoolData).str.getValue();
        }
        if (constantPoolData instanceof FieldConstantData) {
            MemberDefinition memberDefinition = ((FieldConstantData)constantPoolData).field;
            return memberDefinition.getName() + " " + memberDefinition.getType().getTypeSignature() + " " + memberDefinition.getClassDeclaration().getName();
        }
        if (constantPoolData instanceof NameAndTypeConstantData) {
            return ((NameAndTypeConstantData)constantPoolData).name + " " + ((NameAndTypeConstantData)constantPoolData).type;
        }
        if (constantPoolData instanceof ClassConstantData) {
            return ((ClassConstantData)constantPoolData).name;
        }
        return ((StringConstantData)constantPoolData).str;
    }

    private static void xsort(ConstantPoolData[] constantPoolDataArray, String[] stringArray, int n, int n2) {
        Object object;
        if (n >= n2) {
            return;
        }
        String string = stringArray[n];
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            while (n3 <= n2 && stringArray[n3].compareTo(string) <= 0) {
                ++n3;
            }
            while (n4 >= n && stringArray[n4].compareTo(string) > 0) {
                --n4;
            }
            if (n3 >= n4) continue;
            ConstantPoolData constantPoolData = constantPoolDataArray[n3];
            object = stringArray[n3];
            constantPoolDataArray[n3] = constantPoolDataArray[n4];
            constantPoolDataArray[n4] = constantPoolData;
            stringArray[n3] = stringArray[n4];
            stringArray[n4] = object;
        }
        int n5 = n4;
        object = constantPoolDataArray[n];
        String string2 = stringArray[n];
        constantPoolDataArray[n] = constantPoolDataArray[n5];
        constantPoolDataArray[n5] = object;
        stringArray[n] = stringArray[n5];
        stringArray[n5] = string2;
        ConstantPool.xsort(constantPoolDataArray, stringArray, n, n5 - 1);
        ConstantPool.xsort(constantPoolDataArray, stringArray, n5 + 1, n2);
    }
}

