/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jcmd;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.attach.HotSpotVirtualMachine;
import sun.tools.jcmd.Arguments;
import sun.tools.jstat.JStatLogger;

public class JCmd {
    public static void main(String[] stringArray) {
        List<VirtualMachineDescriptor> list;
        List<VirtualMachineDescriptor> list2;
        Arguments arguments = null;
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error parsing arguments: " + illegalArgumentException.getMessage() + "\n");
            Arguments.usage();
            System.exit(1);
        }
        if (arguments.isShowUsage()) {
            Arguments.usage();
            System.exit(1);
        }
        if (arguments.isListProcesses()) {
            list2 = VirtualMachine.list();
            for (VirtualMachineDescriptor iterator : list2) {
                System.out.println(iterator.id() + " " + iterator.displayName());
            }
            System.exit(0);
        }
        list2 = new ArrayList<VirtualMachineDescriptor>();
        if (arguments.getPid() == 0) {
            list = VirtualMachine.list();
            for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
                if (JCmd.isJCmdProcess(virtualMachineDescriptor)) continue;
                list2.add((VirtualMachineDescriptor)((Object)virtualMachineDescriptor.id()));
            }
        } else if (arguments.getProcessSubstring() != null) {
            list = VirtualMachine.list();
            for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
                if (JCmd.isJCmdProcess(virtualMachineDescriptor)) continue;
                try {
                    String string = JCmd.getMainClass(virtualMachineDescriptor);
                    if (string == null || string.indexOf(arguments.getProcessSubstring()) == -1) continue;
                    list2.add((VirtualMachineDescriptor)((Object)virtualMachineDescriptor.id()));
                }
                catch (URISyntaxException | MonitorException exception) {
                    if (exception.getMessage() != null) {
                        System.err.println(exception.getMessage());
                        continue;
                    }
                    Throwable throwable = exception.getCause();
                    if (throwable != null && throwable.getMessage() != null) {
                        System.err.println(throwable.getMessage());
                        continue;
                    }
                    exception.printStackTrace();
                }
            }
            if (list2.isEmpty()) {
                System.err.println("Could not find any processes matching : '" + arguments.getProcessSubstring() + "'");
                System.exit(1);
            }
        } else if (arguments.getPid() == -1) {
            System.err.println("Invalid pid specified");
            System.exit(1);
        } else {
            list2.add((VirtualMachineDescriptor)((Object)(arguments.getPid() + "")));
        }
        boolean bl = true;
        for (String string : list2) {
            System.out.println(string + ":");
            if (arguments.isListCounters()) {
                JCmd.listCounters(string);
                continue;
            }
            try {
                JCmd.executeCommandForPid(string, arguments.getCommand());
            }
            catch (AttachOperationFailedException attachOperationFailedException) {
                System.err.println(attachOperationFailedException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        System.exit(bl ? 0 : 1);
    }

    private static void executeCommandForPid(String string, String string2) throws AttachNotSupportedException, IOException, UnsupportedEncodingException {
        String[] stringArray;
        VirtualMachine virtualMachine = VirtualMachine.attach(string);
        HotSpotVirtualMachine hotSpotVirtualMachine = (HotSpotVirtualMachine)virtualMachine;
        for (String string3 : stringArray = string2.split("\\n")) {
            if (string3.trim().equals("stop")) break;
            try (InputStream inputStream = hotSpotVirtualMachine.executeJCmd(string3);){
                int n;
                byte[] byArray = new byte[256];
                boolean bl = false;
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    String string4 = new String(byArray, 0, n, "UTF-8");
                    System.out.print(string4);
                    bl = true;
                } while (n > 0);
                if (bl) continue;
                System.out.println("Command executed successfully");
            }
        }
        virtualMachine.detach();
    }

    private static void listCounters(String string) {
        VmIdentifier vmIdentifier = null;
        try {
            vmIdentifier = new VmIdentifier(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("Malformed VM Identifier: " + string);
            return;
        }
        try {
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, -1);
            JStatLogger jStatLogger = new JStatLogger(monitoredVm);
            jStatLogger.printSnapShot("\\w*", new AscendingMonitorComparator(), false, true, System.out);
            monitoredHost.detach(monitoredVm);
        }
        catch (MonitorException monitorException) {
            monitorException.printStackTrace();
        }
    }

    private static boolean isJCmdProcess(VirtualMachineDescriptor virtualMachineDescriptor) {
        try {
            String string = JCmd.getMainClass(virtualMachineDescriptor);
            return string != null && string.equals(JCmd.class.getName());
        }
        catch (URISyntaxException | MonitorException exception) {
            return false;
        }
    }

    private static String getMainClass(VirtualMachineDescriptor virtualMachineDescriptor) throws URISyntaxException, MonitorException {
        try {
            String string = null;
            VmIdentifier vmIdentifier = new VmIdentifier(virtualMachineDescriptor.id());
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, -1);
            string = MonitoredVmUtil.mainClass(monitoredVm, true);
            monitoredHost.detach(monitoredVm);
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static class AscendingMonitorComparator
    implements Comparator<Monitor> {
        AscendingMonitorComparator() {
        }

        @Override
        public int compare(Monitor monitor, Monitor monitor2) {
            String string = monitor.getName();
            String string2 = monitor2.getName();
            return string.compareTo(string2);
        }
    }
}

