/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.tools.jstat.Alignment;
import sun.tools.jstat.Expression;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.ParserException;
import sun.tools.jstat.Scale;

public class ColumnFormat
extends OptionFormat {
    private int number;
    private int width;
    private Alignment align = Alignment.CENTER;
    private Scale scale = Scale.RAW;
    private String format;
    private String header;
    private Expression expression;
    private Object previousValue;

    public ColumnFormat(int n) {
        super("Column" + n);
        this.number = n;
    }

    public void validate() throws ParserException {
        if (this.expression == null) {
            throw new ParserException("Missing data statement in column " + this.number);
        }
        if (this.header == null) {
            throw new ParserException("Missing header statement in column " + this.number);
        }
        if (this.format == null) {
            this.format = "0";
        }
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setAlignment(Alignment alignment) {
        this.align = alignment;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public Alignment getAlignment() {
        return this.align;
    }

    public Scale getScale() {
        return this.scale;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setPreviousValue(Object object) {
        this.previousValue = object;
    }

    public Object getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public void printFormat(int n) {
        String string = "  ";
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        System.out.println(stringBuilder + this.name + " {");
        System.out.println(stringBuilder + string + "name=" + this.name + ";data=" + this.expression.toString() + ";header=" + this.header + ";format=" + this.format + ";width=" + this.width + ";scale=" + this.scale.toString() + ";align=" + this.align.toString());
        for (OptionFormat optionFormat : this.children) {
            optionFormat.printFormat(n + 1);
        }
        System.out.println(stringBuilder + "}");
    }

    public String getValue() {
        return null;
    }
}

