/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.Expression;
import sun.tools.jstat.ExpressionEvaluator;
import sun.tools.jstat.Identifier;
import sun.tools.jstat.Literal;
import sun.tools.jstat.Operator;

public class ExpressionExecuter
implements ExpressionEvaluator {
    private static final boolean debug = Boolean.getBoolean("ExpressionEvaluator.debug");
    private MonitoredVm vm;
    private HashMap<String, Object> map = new HashMap();

    ExpressionExecuter(MonitoredVm monitoredVm) {
        this.vm = monitoredVm;
    }

    @Override
    public Object evaluate(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (debug) {
            System.out.println("Evaluating expression: " + expression);
        }
        if (expression instanceof Literal) {
            return ((Literal)expression).getValue();
        }
        if (expression instanceof Identifier) {
            Identifier identifier = (Identifier)expression;
            if (this.map.containsKey(identifier.getName())) {
                return this.map.get(identifier.getName());
            }
            Monitor monitor = (Monitor)identifier.getValue();
            Object object = monitor.getValue();
            this.map.put(identifier.getName(), object);
            return object;
        }
        Expression expression2 = expression.getLeft();
        Expression expression3 = expression.getRight();
        Operator operator = expression.getOperator();
        if (operator == null) {
            return this.evaluate(expression2);
        }
        Double d = new Double(((Number)this.evaluate(expression2)).doubleValue());
        Double d2 = new Double(((Number)this.evaluate(expression3)).doubleValue());
        double d3 = operator.eval(d, d2);
        if (debug) {
            System.out.println("Performed Operation: " + d + operator + d2 + " = " + d3);
        }
        return new Double(d3);
    }
}

