/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.Closure;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.Expression;
import sun.tools.jstat.ExpressionExecuter;

public class RowClosure
implements Closure {
    private MonitoredVm vm;
    private StringBuilder row = new StringBuilder();

    public RowClosure(MonitoredVm monitoredVm) {
        this.vm = monitoredVm;
    }

    @Override
    public void visit(Object object, boolean bl) throws MonitorException {
        if (!(object instanceof ColumnFormat)) {
            return;
        }
        ColumnFormat columnFormat = (ColumnFormat)object;
        String string = null;
        ExpressionExecuter expressionExecuter = new ExpressionExecuter(this.vm);
        Expression expression = columnFormat.getExpression();
        Object object2 = expressionExecuter.evaluate(expression);
        if (object2 instanceof String) {
            string = (String)object2;
        } else if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            double d2 = columnFormat.getScale().scale(d);
            DecimalFormat decimalFormat = new DecimalFormat(columnFormat.getFormat());
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("-");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            string = decimalFormat.format(d2);
        }
        columnFormat.setPreviousValue(object2);
        string = columnFormat.getAlignment().align(string, columnFormat.getWidth());
        this.row.append(string);
        if (bl) {
            this.row.append(" ");
        }
    }

    public String getRow() {
        return this.row.toString();
    }
}

