/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.Menus;
import ij.gui.ImageCanvas;
import ij.gui.NewImage;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.Animator;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filters;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.text.TextWindow;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Prefs {
    public static final String PROPS_NAME = "IJ_Props.txt";
    public static final String PREFS_NAME = "IJ_Prefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String SHOW_ALL_COLOR = "showcolor";
    public static final String JPEG = "jpeg";
    public static final String FPS = "fps";
    public static final String DIV_BY_ZERO_VALUE = "div-by-zero";
    public static final String NOISE_SD = "noise.sd";
    public static final String MENU_SIZE = "menu.size";
    public static final String THREADS = "threads";
    public static final String KEY_PREFIX = ".";
    private static final int USE_POINTER = 1;
    private static final int ANTIALIASING = 2;
    private static final int INTERPOLATE = 4;
    private static final int ONE_HUNDRED_PERCENT = 8;
    private static final int BLACK_BACKGROUND = 16;
    private static final int JFILE_CHOOSER = 32;
    private static final int UNUSED = 64;
    private static final int BLACK_CANVAS = 128;
    private static final int WEIGHTED = 256;
    private static final int AUTO_MEASURE = 512;
    private static final int REQUIRE_CONTROL = 1024;
    private static final int USE_INVERTING_LUT = 2048;
    private static final int ANTIALIASED_TOOLS = 4096;
    private static final int INTEL_BYTE_ORDER = 8192;
    private static final int DOUBLE_BUFFER = 16384;
    private static final int NO_POINT_LABELS = 32768;
    private static final int NO_BORDER = 65536;
    private static final int SHOW_ALL_SLICE_ONLY = 131072;
    private static final int COPY_HEADERS = 262144;
    private static final int NO_ROW_NUMBERS = 524288;
    private static final int MOVE_TO_MISC = 0x100000;
    private static final int ADD_TO_MANAGER = 0x200000;
    private static final int RUN_SOCKET_LISTENER = 0x400000;
    private static final int MULTI_POINT_MODE = 0x800000;
    private static final int ROTATE_YZ = 0x1000000;
    private static final int FLIP_XZ = 0x2000000;
    private static final int DONT_SAVE_HEADERS = 0x4000000;
    private static final int DONT_SAVE_ROW_NUMBERS = 0x8000000;
    private static final int NO_CLICK_TO_GC = 0x10000000;
    private static final int AVOID_RESLICE_INTERPOLATION = 0x20000000;
    private static final int KEEP_UNDO_BUFFERS = 0x40000000;
    public static final String OPTIONS = "prefs.options";
    public static final String vistaHint = "";
    private static final int USE_SYSTEM_PROXIES = 1;
    private static final int USE_FILE_CHOOSER = 2;
    private static final int SUBPIXEL_RESOLUTION = 4;
    private static final int ENHANCED_LINE_TOOL = 8;
    private static final int SKIP_RAW_DIALOG = 16;
    private static final int REVERSE_NEXT_PREVIOUS_ORDER = 32;
    private static final int AUTO_RUN_EXAMPLES = 64;
    private static final int SHOW_ALL_POINTS = 128;
    public static final String OPTIONS2 = "prefs.options2";
    public static String separator = System.getProperty("file.separator");
    public static boolean usePointerCursor;
    public static boolean antialiasedText;
    public static boolean interpolateScaledImages;
    public static boolean open100Percent;
    public static boolean blackBackground;
    public static boolean useJFileChooser;
    public static boolean weightedColor;
    public static boolean blackCanvas;
    public static boolean pointAutoMeasure;
    public static boolean pointAutoNextSlice;
    public static boolean requireControlKey;
    public static boolean useInvertingLut;
    public static boolean antialiasedTools;
    public static boolean intelByteOrder;
    public static boolean doubleBuffer;
    public static boolean noPointLabels;
    public static boolean disableUndo;
    public static boolean noBorder;
    public static boolean showAllSliceOnly;
    public static boolean copyColumnHeaders;
    public static boolean noRowNumbers;
    public static boolean moveToMisc;
    public static boolean pointAddToManager;
    public static boolean pointAddToOverlay;
    public static boolean padEdges;
    public static boolean runSocketListener;
    public static boolean multiPointMode;
    public static boolean openDicomsAsFloat;
    public static boolean verticalProfile;
    public static boolean rotateYZ;
    public static boolean flipXZ;
    public static boolean dontSaveHeaders;
    public static boolean dontSaveRowNumbers;
    public static boolean noClickToGC;
    public static boolean reflexAngle;
    public static boolean avoidResliceInterpolation;
    public static boolean keepUndoBuffers;
    public static boolean useNamesAsLabels;
    public static boolean useSystemProxies;
    public static boolean useFileChooser;
    public static boolean subPixelResolution;
    public static boolean autoContrast;
    public static boolean enhancedLineTool;
    public static boolean keepArrowSelections;
    public static boolean paintDoubleBuffered;
    public static boolean skipRawDialog;
    public static boolean reverseNextPreviousOrder;
    public static boolean autoRunExamples;
    public static boolean showAllPoints;
    public static boolean setIJMenuBar;
    public static boolean alwaysOnTop;
    public static boolean splineFitLines;
    static Properties ijPrefs;
    static Properties props;
    static String prefsDir;
    static String imagesURL;
    static String homeDir;
    static int threads;
    static int transparentIndex;
    static boolean commandLineMacro;
    private static boolean resetPreferences;

    public static String load(Object ij, Applet applet) {
        InputStream f = ij.getClass().getResourceAsStream("/IJ_Props.txt");
        if (applet != null) {
            return Prefs.loadAppletProps(f, applet);
        }
        if (homeDir == null) {
            homeDir = System.getProperty("user.dir");
        }
        if (f == null) {
            try {
                f = new FileInputStream(homeDir + "/" + PROPS_NAME);
            }
            catch (FileNotFoundException e) {
                f = null;
            }
        }
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar or in " + homeDir;
        }
        f = new BufferedInputStream(f);
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        Prefs.loadOptions();
        return null;
    }

    static String loadAppletProps(InputStream f, Applet applet) {
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar";
        }
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        try {
            URL url = new URL(applet.getDocumentBase(), "images/");
            imagesURL = url.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static void setImagesURL(String url) {
        imagesURL = url;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static String getImageJDir() {
        String path = Menus.getImageJPath();
        if (path == null) {
            return homeDir + File.separator;
        }
        return path;
    }

    public static String getPrefsDir() {
        if (prefsDir == null) {
            String dir = System.getProperty("user.home");
            dir = IJ.isMacOSX() ? dir + "/Library/Preferences" : dir + File.separator + ".imagej";
            prefsDir = dir;
        }
        return prefsDir;
    }

    static void setHomeDir(String path) {
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        homeDir = path;
    }

    public static String getDefaultDirectory() {
        if (commandLineMacro) {
            return null;
        }
        return Prefs.getString(DIR_IMAGE);
    }

    public static String getString(String key) {
        return props.getProperty(key);
    }

    public static String getString(String key, String defaultString) {
        if (props == null) {
            return defaultString;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultString;
        }
        return s;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return s.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException e) {
                IJ.write(vistaHint + e);
            }
        }
        return defaultValue;
    }

    public static double getDouble(String key, double defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static Color getColor(String key, Color defaultColor) {
        int i = Prefs.getInt(key, 2730);
        if (i == 2730) {
            return defaultColor;
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String path = Prefs.getPrefsDir() + separator + PREFS_NAME;
        boolean ok = Prefs.loadPrefs(path);
        if (!ok && (ok = Prefs.loadPrefs(path = IJ.isWindows() ? homeDir + separator + PREFS_NAME : System.getProperty("user.home") + separator + PREFS_NAME))) {
            new File(path).delete();
        }
    }

    static boolean loadPrefs(String path) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            ijPrefs.load(is);
            ((InputStream)is).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void savePreferences() {
        String path = null;
        try {
            File f;
            Properties prefs = new Properties();
            String dir = OpenDialog.getDefaultDirectory();
            if (dir != null) {
                prefs.put(DIR_IMAGE, dir);
            }
            prefs.put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            prefs.put(SHOW_ALL_COLOR, Tools.c2hex(ImageCanvas.getShowAllColor()));
            prefs.put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            prefs.put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            prefs.put(JPEG, Integer.toString(FileSaver.getJpegQuality()));
            prefs.put(FPS, Double.toString(Animator.getFrameRate()));
            prefs.put(DIV_BY_ZERO_VALUE, Double.toString(FloatBlitter.divideByZeroValue));
            prefs.put(NOISE_SD, Double.toString(Filters.getSD()));
            if (threads > 1) {
                prefs.put(THREADS, Integer.toString(threads));
            }
            if (IJ.isMacOSX()) {
                useJFileChooser = false;
            }
            Prefs.saveOptions(prefs);
            Prefs.savePluginPrefs(prefs);
            IJ.getInstance().savePreferences(prefs);
            Menus.savePreferences(prefs);
            ParticleAnalyzer.savePreferences(prefs);
            Analyzer.savePreferences(prefs);
            ImportDialog.savePreferences(prefs);
            PlotWindow.savePreferences(prefs);
            NewImage.savePreferences(prefs);
            String prefsDir = Prefs.getPrefsDir();
            path = prefsDir + separator + PREFS_NAME;
            if (prefsDir.endsWith(".imagej") && !(f = new File(prefsDir)).exists()) {
                f.mkdir();
            }
            if (resetPreferences) {
                f = new File(path);
                if (!f.exists()) {
                    IJ.error("Edit>Options>Reset", "Unable to reset preferences. File not found at\n" + path);
                }
                boolean rtn = f.delete();
                resetPreferences = false;
            } else {
                Prefs.savePrefs(prefs, path);
            }
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = vistaHint + t;
            }
            int delay = 4000;
            try {
                new TextWindow("Error Saving Preferences:\n" + path, msg, 500, 200);
                IJ.wait(delay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void resetPreferences() {
        resetPreferences = true;
    }

    static void loadOptions() {
        int defaultOptions = 545263618 + (!IJ.isMacOSX() ? 0x400000 : 0);
        int options = Prefs.getInt(OPTIONS, defaultOptions);
        usePointerCursor = (options & 1) != 0;
        antialiasedText = false;
        interpolateScaledImages = (options & 4) != 0;
        open100Percent = (options & 8) != 0;
        blackBackground = (options & 0x10) != 0;
        useJFileChooser = (options & 0x20) != 0;
        boolean bl = weightedColor = (options & 0x100) != 0;
        if (weightedColor) {
            ColorProcessor.setWeightingFactors(0.299, 0.587, 0.114);
        }
        blackCanvas = (options & 0x80) != 0;
        requireControlKey = (options & 0x400) != 0;
        useInvertingLut = (options & 0x800) != 0;
        antialiasedTools = (options & 0x1000) != 0;
        intelByteOrder = (options & 0x2000) != 0;
        noBorder = (options & 0x10000) != 0;
        showAllSliceOnly = (options & 0x20000) != 0;
        copyColumnHeaders = (options & 0x40000) != 0;
        noRowNumbers = (options & 0x80000) != 0;
        moveToMisc = (options & 0x100000) != 0;
        runSocketListener = (options & 0x400000) != 0;
        multiPointMode = (options & 0x800000) != 0;
        rotateYZ = (options & 0x1000000) != 0;
        flipXZ = (options & 0x2000000) != 0;
        dontSaveHeaders = (options & 0x4000000) != 0;
        dontSaveRowNumbers = (options & 0x8000000) != 0;
        noClickToGC = (options & 0x10000000) != 0;
        avoidResliceInterpolation = (options & 0x20000000) != 0;
        keepUndoBuffers = (options & 0x40000000) != 0;
        defaultOptions = !IJ.isMacOSX() ? 2 : 0;
        int options2 = Prefs.getInt(OPTIONS2, defaultOptions);
        useSystemProxies = (options2 & 1) != 0;
        useFileChooser = (options2 & 2) != 0;
        subPixelResolution = (options2 & 4) != 0;
        enhancedLineTool = (options2 & 8) != 0;
        skipRawDialog = (options2 & 0x10) != 0;
        reverseNextPreviousOrder = (options2 & 0x20) != 0;
        autoRunExamples = (options2 & 0x40) != 0;
        showAllPoints = (options2 & 0x80) != 0;
    }

    static void saveOptions(Properties prefs) {
        int options = (usePointerCursor ? 1 : 0) + (antialiasedText ? 2 : 0) + (interpolateScaledImages ? 4 : 0) + (open100Percent ? 8 : 0) + (blackBackground ? 16 : 0) + (useJFileChooser ? 32 : 0) + (blackCanvas ? 128 : 0) + (weightedColor ? 256 : 0) + (requireControlKey ? 1024 : 0) + (useInvertingLut ? 2048 : 0) + (antialiasedTools ? 4096 : 0) + (intelByteOrder ? 8192 : 0) + (doubleBuffer ? 16384 : 0) + (noPointLabels ? 32768 : 0) + (noBorder ? 65536 : 0) + (showAllSliceOnly ? 131072 : 0) + (copyColumnHeaders ? 262144 : 0) + (noRowNumbers ? 524288 : 0) + (moveToMisc ? 0x100000 : 0) + (runSocketListener ? 0x400000 : 0) + (multiPointMode ? 0x800000 : 0) + (rotateYZ ? 0x1000000 : 0) + (flipXZ ? 0x2000000 : 0) + (dontSaveHeaders ? 0x4000000 : 0) + (dontSaveRowNumbers ? 0x8000000 : 0) + (noClickToGC ? 0x10000000 : 0) + (avoidResliceInterpolation ? 0x20000000 : 0) + (keepUndoBuffers ? 0x40000000 : 0);
        prefs.put(OPTIONS, Integer.toString(options));
        int options2 = (useSystemProxies ? 1 : 0) + (useFileChooser ? 2 : 0) + (subPixelResolution ? 4 : 0) + (enhancedLineTool ? 8 : 0) + (skipRawDialog ? 16 : 0) + (reverseNextPreviousOrder ? 32 : 0) + (autoRunExamples ? 64 : 0) + (showAllPoints ? 128 : 0);
        prefs.put(OPTIONS2, Integer.toString(options2));
    }

    public static void set(String key, String text) {
        if (key.indexOf(46) < 1) {
            throw new IllegalArgumentException("Key must have a prefix");
        }
        if (text == null) {
            ijPrefs.remove(KEY_PREFIX + key);
        } else {
            ijPrefs.put(KEY_PREFIX + key, text);
        }
    }

    public static void set(String key, int value) {
        Prefs.set(key, Integer.toString(value));
    }

    public static void set(String key, double value) {
        Prefs.set(key, vistaHint + value);
    }

    public static void set(String key, boolean value) {
        Prefs.set(key, vistaHint + value);
    }

    public static String get(String key, String defaultValue) {
        String value = ijPrefs.getProperty(KEY_PREFIX + key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static double get(String key, double defaultValue) {
        String s = ijPrefs.getProperty(KEY_PREFIX + key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static boolean get(String key, boolean defaultValue) {
        String value = ijPrefs.getProperty(KEY_PREFIX + key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static void saveLocation(String key, Point loc) {
        Prefs.set(key, loc.x + "," + loc.y);
    }

    public static Point getLocation(String key) {
        String value = ijPrefs.getProperty(KEY_PREFIX + key);
        if (value == null) {
            return null;
        }
        int index = value.indexOf(",");
        if (index == -1) {
            return null;
        }
        double xloc = Tools.parseDouble(value.substring(0, index));
        if (Double.isNaN(xloc) || index == value.length() - 1) {
            return null;
        }
        double yloc = Tools.parseDouble(value.substring(index + 1));
        if (Double.isNaN(yloc)) {
            return null;
        }
        Point p = new Point((int)xloc, (int)yloc);
        Dimension screen = null;
        screen = IJ.debugMode ? Toolkit.getDefaultToolkit().getScreenSize() : IJ.getScreenSize();
        if (p.x > screen.width - 100 || p.y > screen.height - 40) {
            return null;
        }
        return p;
    }

    static void savePluginPrefs(Properties prefs) {
        Enumeration<Object> e = ijPrefs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(KEY_PREFIX) != 0) continue;
            prefs.put(key, ijPrefs.getProperty(key));
        }
    }

    public static void savePrefs(Properties prefs, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        prefs.store(bos, "ImageJ 1.51j Preferences");
        bos.close();
    }

    public static int getThreads() {
        if (threads == 0) {
            threads = Prefs.getInt(THREADS, 0);
            int processors = Runtime.getRuntime().availableProcessors();
            if (threads < 1 || threads > processors) {
                threads = processors;
            }
        }
        return threads;
    }

    public static void setThreads(int n) {
        if (n < 1) {
            n = 1;
        }
        threads = n;
    }

    public static void setTransparentIndex(int index) {
        if (index < -1 || index > 255) {
            index = -1;
        }
        transparentIndex = index;
    }

    public static int getTransparentIndex() {
        return transparentIndex;
    }

    public static Properties getControlPanelProperties() {
        return ijPrefs;
    }

    public static String defaultResultsExtension() {
        return Prefs.get("options.ext", ".xls");
    }

    static {
        antialiasedTools = true;
        doubleBuffer = true;
        autoRunExamples = true;
        setIJMenuBar = IJ.isMacOSX();
        ijPrefs = new Properties();
        props = new Properties(ijPrefs);
        transparentIndex = -1;
    }
}

