/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class BatchConverter
implements PlugIn,
ActionListener {
    private static final String[] formats = new String[]{"TIFF", "8-bit TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = formats[0];
    private static double scale = 1.0;
    private static boolean useBioFormats;
    private static int interpolationMethod;
    private static boolean averageWhenDownSizing;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private Button input;
    private Button output;
    private TextField inputDir;
    private TextField outputDir;
    private GenericDialog gd;

    public void run(String arg) {
        if (!this.showDialog()) {
            return;
        }
        String inputPath = this.inputDir.getText();
        if (inputPath.equals("")) {
            IJ.error("Batch Converter", "Please choose an input folder");
            return;
        }
        String outputPath = this.outputDir.getText();
        if (outputPath.equals("")) {
            IJ.error("Batch Converter", "Please choose an output folder");
            return;
        }
        File f1 = new File(inputPath);
        if (!f1.exists() || !f1.isDirectory()) {
            IJ.error("Batch Converter", "Input does not exist or is not a folder\n \n" + inputPath);
            return;
        }
        File f2 = new File(outputPath);
        if (!(outputPath.equals("") || f2.exists() && f2.isDirectory())) {
            IJ.error("Batch Converter", "Output does not exist or is not a folder\n \n" + outputPath);
            return;
        }
        String[] list = new File(inputPath).list();
        IJ.resetEscape();
        Opener opener = new Opener();
        opener.setSilentMode(true);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < list.length && !IJ.escapePressed(); ++i) {
            String path;
            if (IJ.debugMode) {
                IJ.log(i + "  " + list[i]);
            }
            if (new File(path = inputPath + list[i]).isDirectory() || list[i].startsWith(".") || list[i].endsWith(".avi") || list[i].endsWith(".AVI")) continue;
            IJ.showStatus(i + "/" + list.length);
            IJ.showProgress(i + 1, list.length);
            ImagePlus imp = null;
            IJ.redirectErrorMessages(true);
            imp = useBioFormats ? Opener.openUsingBioFormats(path) : opener.openImage(inputPath, list[i]);
            IJ.redirectErrorMessages(false);
            if (imp == null) {
                String reader = useBioFormats ? "Bio-Formats not found or" : "IJ.openImage()";
                IJ.log(reader + " returned null: " + path);
                continue;
            }
            if (scale != 1.0) {
                int width = (int)(scale * (double)imp.getWidth());
                int height = (int)(scale * (double)imp.getHeight());
                ImageProcessor ip = imp.getProcessor();
                ip.setInterpolationMethod(interpolationMethod);
                ip.setProgressBar(null);
                imp.setProcessor(null, ip.resize(width, height, averageWhenDownSizing));
                ip = null;
            }
            if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                if (imp.getBitDepth() == 24) {
                    IJ.run(imp, "8-bit Color", "number=256");
                } else {
                    IJ.run(imp, "8-bit", "");
                }
            }
            IJ.saveAs(imp, format, outputPath + list[i]);
            imp.close();
            imp = null;
        }
        IJ.showStatus(list.length + " files converted in " + IJ.d2s((double)(System.currentTimeMillis() - t0) / 1000.0, 2) + " seconds");
        IJ.showProgress(1, 1);
        Prefs.set("batch.input", this.inputDir.getText());
        Prefs.set("batch.output", this.outputDir.getText());
    }

    private boolean showDialog() {
        this.gd = new GenericDialog("Batch Convert");
        this.addPanels(this.gd);
        this.gd.setInsets(15, 0, 5);
        this.gd.addChoice("Output_format:", formats, format);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addNumericField("Scale factor:", scale, 2);
        this.gd.addCheckbox("Average when downsizing", averageWhenDownSizing);
        this.gd.addCheckbox("Read images using Bio-Formats", useBioFormats);
        this.gd.setOKLabel("Convert");
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        format = this.gd.getNextChoice();
        interpolationMethod = this.gd.getNextChoiceIndex();
        scale = this.gd.getNextNumber();
        averageWhenDownSizing = this.gd.getNextBoolean();
        useBioFormats = this.gd.getNextBoolean();
        return true;
    }

    void addPanels(GenericDialog gd) {
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.input = new Button("Input...");
        this.input.addActionListener(this);
        p.add(this.input);
        this.inputDir = new TextField(Prefs.get("batch.input", ""), 45);
        p.add(this.inputDir);
        gd.addPanel(p);
        p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.output = new Button("Output...");
        this.output.addActionListener(this);
        p.add(this.output);
        this.outputDir = new TextField(Prefs.get("batch.output", ""), 45);
        p.add(this.outputDir);
        gd.addPanel(p);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String s = source == this.input ? "Input" : "Output";
        String path = IJ.getDirectory(s + " Folder");
        if (path == null) {
            return;
        }
        if (source == this.input) {
            this.inputDir.setText(path);
        } else {
            this.outputDir.setText(path);
        }
        if (IJ.isMacOSX()) {
            this.gd.setVisible(false);
            this.gd.setVisible(true);
        }
    }

    static {
        interpolationMethod = 1;
    }
}

