/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.process.FloatPolygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class RoiScaler
implements PlugIn {
    private static double defaultXScale = 1.5;
    private static double defaultYScale = 1.5;
    private double xscale;
    private double yscale;
    private boolean centered;

    public void run(String arg) {
        Roi roi2;
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Scale", "This command requires a selection");
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        if (!IJ.macroRunning()) {
            defaultXScale = this.xscale;
            defaultYScale = this.yscale;
        }
        if ((roi2 = RoiScaler.scale(roi, this.xscale, this.yscale, this.centered)) == null) {
            return;
        }
        Undo.setup(8, imp);
        roi = (Roi)roi.clone();
        imp.setRoi(roi2);
        Roi.previousRoi = roi;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Scale Selection");
        gd.addNumericField("X scale factor:", defaultXScale, 2, 3, "");
        gd.addNumericField("Y scale factor:", defaultYScale, 2, 3, "");
        gd.addCheckbox("Centered", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.xscale = gd.getNextNumber();
        this.yscale = gd.getNextNumber();
        this.centered = gd.getNextBoolean();
        return true;
    }

    public static Roi scale(Roi roi, double xscale, double yscale, boolean centered) {
        if (roi instanceof ShapeRoi) {
            return RoiScaler.scaleShape((ShapeRoi)roi, xscale, yscale, centered);
        }
        FloatPolygon poly = roi.getFloatPolygon();
        int type = roi.getType();
        if (type == 5) {
            Line line = (Line)roi;
            double x1 = line.x1d;
            double y1 = line.y1d;
            double x2 = line.x2d;
            double y2 = line.y2d;
            poly = new FloatPolygon();
            poly.addPoint(x1, y1);
            poly.addPoint(x2, y2);
        }
        Rectangle r = roi.getBounds();
        double xbase = (double)r.x - ((double)r.width * xscale - (double)r.width) / 2.0;
        double ybase = (double)r.y - ((double)r.height * yscale - (double)r.height) / 2.0;
        for (int i = 0; i < poly.npoints; ++i) {
            if (centered) {
                poly.xpoints[i] = (float)((double)(poly.xpoints[i] - (float)r.x) * xscale + xbase);
                poly.ypoints[i] = (float)((double)(poly.ypoints[i] - (float)r.y) * yscale + ybase);
                continue;
            }
            poly.xpoints[i] = (float)((double)poly.xpoints[i] * xscale);
            poly.ypoints[i] = (float)((double)poly.ypoints[i] * yscale);
        }
        Roi roi2 = null;
        if (type == 5) {
            roi2 = new Line(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
        } else if (type == 10) {
            roi2 = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        } else {
            if (type == 0) {
                type = 2;
            }
            if (type == 0 && poly.npoints > 4) {
                type = 3;
            }
            if (type == 1 || type == 4) {
                type = 3;
            }
            roi2 = new PolygonRoi(poly.xpoints, poly.ypoints, poly.npoints, type);
        }
        roi2.setStrokeColor(roi.getStrokeColor());
        if (roi.getStroke() != null) {
            roi2.setStroke(roi.getStroke());
        }
        return roi2;
    }

    private static Roi scaleShape(ShapeRoi roi, double xscale, double yscale, boolean centered) {
        Rectangle r = roi.getBounds();
        Shape shape = roi.getShape();
        AffineTransform at = new AffineTransform();
        at.scale(xscale, yscale);
        if (!centered) {
            at.translate(r.x, r.y);
        }
        Shape shape2 = at.createTransformedShape(shape);
        ShapeRoi roi2 = new ShapeRoi(shape2);
        if (centered) {
            int xbase = (int)(centered ? (double)r.x - ((double)r.width * xscale - (double)r.width) / 2.0 : (double)r.x);
            int ybase = (int)(centered ? (double)r.y - ((double)r.height * yscale - (double)r.height) / 2.0 : (double)r.y);
            roi2.setLocation(xbase, ybase);
        }
        return roi2;
    }
}

