/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

@BaseCmd.Syntax(cmd="d2j-asm-verify", syntax="[options] <jar0> [jar1 ... jarN]", desc="Verify .class in jar")
public class AsmVerify
extends BaseCmd {
    static Field buf;
    @BaseCmd.Opt(opt="d", longOpt="detail", hasArg=false, description="Print detail error message")
    boolean detail = false;

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        return n == -1 ? name : "o";
    }

    public static void main(String ... args) {
        new AsmVerify().doMain(args);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer a, PrintWriter pw) throws IllegalArgumentException {
        Frame[] frames = a.getFrames();
        Textifier t = new Textifier();
        TraceMethodVisitor mv = new TraceMethodVisitor((Printer)t);
        String format = "%05d %-" + (method.maxStack + method.maxLocals + 6) + "s|%s";
        for (int j = 0; j < method.instructions.size(); ++j) {
            method.instructions.get(j).accept((MethodVisitor)mv);
            StringBuffer s = new StringBuffer();
            Frame f = frames[j];
            if (f == null) {
                s.append('?');
            } else {
                int k;
                for (k = 0; k < f.getLocals(); ++k) {
                    s.append(AsmVerify.getShortName(f.getLocal(k).toString()));
                }
                s.append(" : ");
                for (k = 0; k < f.getStackSize(); ++k) {
                    s.append(AsmVerify.getShortName(f.getStack(k).toString()));
                }
            }
            try {
                pw.printf(format, j, s, buf.get(t));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (TryCatchBlockNode tryCatchBlockNode : method.tryCatchBlocks) {
            tryCatchBlockNode.accept((MethodVisitor)mv);
            try {
                pw.print(" " + buf.get(t));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        pw.println();
        pw.flush();
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            this.usage();
            return;
        }
        ArrayList<Path> files = new ArrayList<Path>();
        for (String fn : this.remainingArgs) {
            Path file = new File(fn).toPath();
            if (!Files.exists(file, new LinkOption[0])) {
                System.err.println(fn + " is not exists");
                this.usage();
                return;
            }
            files.add(file);
        }
        for (Path file : files) {
            System.out.println("verify " + file);
            AsmVerify.walkJarOrDir((Path)file, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                public void visitFile(Path file, String relative) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        ClassReader cr = new ClassReader(Files.readAllBytes(file));
                        ClassNode cn = new ClassNode();
                        cr.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)cn, false), 14);
                        for (MethodNode method : cn.methods) {
                            BasicVerifier verifier = new BasicVerifier();
                            Analyzer a = new Analyzer((Interpreter)verifier);
                            try {
                                a.analyze(cn.name, method);
                            }
                            catch (Exception ex) {
                                System.err.println("Error verify method " + cr.getClassName() + "." + method.name + " " + method.desc);
                                if (!AsmVerify.this.detail) continue;
                                ex.printStackTrace(System.err);
                                AsmVerify.printAnalyzerResult(method, a, new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8)));
                            }
                        }
                    }
                }
            });
        }
    }

    static {
        try {
            buf = Printer.class.getDeclaredField("buf");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        buf.setAccessible(true);
    }
}

