/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.expr;

import com.googlecode.d2j.Method;
import com.googlecode.d2j.Proto;
import com.googlecode.dex2jar.ir.LabelAndLocalMapper;
import com.googlecode.dex2jar.ir.Util;
import com.googlecode.dex2jar.ir.expr.AbstractInvokeExpr;
import com.googlecode.dex2jar.ir.expr.Value;

public class InvokeExpr
extends AbstractInvokeExpr {
    public Method method;

    @Override
    protected void releaseMemory() {
        this.method = null;
        super.releaseMemory();
    }

    @Override
    public Proto getProto() {
        return this.method.getProto();
    }

    public InvokeExpr(Value.VT type, Value[] args, String ownerType, String methodName, String[] argmentTypes, String returnType) {
        super(type, args);
        this.method = new Method(ownerType, methodName, argmentTypes, returnType);
    }

    public InvokeExpr(Value.VT type, Value[] args, Method method) {
        super(type, args);
        this.method = method;
    }

    @Override
    public Value clone() {
        return new InvokeExpr(this.vt, this.cloneOps(), this.method);
    }

    @Override
    public Value clone(LabelAndLocalMapper mapper) {
        return new InvokeExpr(this.vt, this.cloneOps(mapper), this.method);
    }

    @Override
    public String toString0() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.vt == Value.VT.INVOKE_NEW) {
            sb.append("new ").append(Util.toShortClassName(this.method.getOwner())).append('(');
        } else {
            sb.append(this.vt == Value.VT.INVOKE_STATIC ? Util.toShortClassName(this.method.getOwner()) : this.ops[0]).append('.').append(this.method.getName()).append('(');
        }
        boolean first = true;
        int n = i = this.vt == Value.VT.INVOKE_STATIC || this.vt == Value.VT.INVOKE_NEW ? 0 : 1;
        while (i < this.ops.length) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.ops[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public String getOwner() {
        return this.method.getOwner();
    }

    public String getRet() {
        return this.method.getReturnType();
    }

    public String getName() {
        return this.method.getName();
    }

    public String[] getArgs() {
        return this.method.getParameterTypes();
    }
}

