/*
 * Decompiled with CFR 0.152.
 */
package android.support.graphics.drawable;

import android.graphics.Path;
import android.util.Log;
import java.util.ArrayList;

class PathParser {
    private static final String LOGTAG = "PathParser";

    PathParser() {
    }

    private static void addNode(ArrayList<PathDataNode> arrayList, char c2, float[] fArray) {
        arrayList.add(new PathDataNode(c2, fArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canMorph(PathDataNode[] pathDataNodeArray, PathDataNode[] pathDataNodeArray2) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (pathDataNodeArray == null) return bl3;
        if (pathDataNodeArray2 == null) {
            return bl2;
        }
        bl3 = bl2;
        if (pathDataNodeArray.length != pathDataNodeArray2.length) return bl3;
        int n2 = 0;
        while (n2 < pathDataNodeArray.length) {
            bl3 = bl2;
            if (pathDataNodeArray[n2].type != pathDataNodeArray2[n2].type) return bl3;
            bl3 = bl2;
            if (pathDataNodeArray[n2].params.length != pathDataNodeArray2[n2].params.length) return bl3;
            ++n2;
        }
        return true;
    }

    private static float[] copyOfRange(float[] fArray, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = fArray.length;
        if (n2 < 0 || n2 > n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n4 = Math.min(n3 -= n2, n4 - n2);
        float[] fArray2 = new float[n3];
        System.arraycopy(fArray, n2, fArray2, 0, n4);
        return fArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathDataNode[] createNodesFromPathData(String pathDataNodeArray) {
        if (pathDataNodeArray == null) {
            return null;
        }
        ArrayList<PathDataNode> arrayList = new ArrayList<PathDataNode>();
        int n2 = 1;
        int n3 = 0;
        while (n2 < pathDataNodeArray.length()) {
            String string2 = pathDataNodeArray.substring(n3, n2 = PathParser.nextStart((String)pathDataNodeArray, n2)).trim();
            if (string2.length() > 0) {
                float[] fArray = PathParser.getFloats(string2);
                PathParser.addNode(arrayList, string2.charAt(0), fArray);
            }
            int n4 = n2 + 1;
            n3 = n2;
            n2 = n4;
        }
        if (n2 - n3 != 1) return arrayList.toArray(new PathDataNode[arrayList.size()]);
        if (n3 >= pathDataNodeArray.length()) return arrayList.toArray(new PathDataNode[arrayList.size()]);
        PathParser.addNode(arrayList, pathDataNodeArray.charAt(n3), new float[0]);
        return arrayList.toArray(new PathDataNode[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path createPathFromPathData(String string2) {
        Path path = new Path();
        PathDataNode[] pathDataNodeArray = PathParser.createNodesFromPathData(string2);
        if (pathDataNodeArray == null) return null;
        try {
            PathDataNode.nodesToPath(pathDataNodeArray, path);
            return path;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Error in parsing " + string2, runtimeException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathDataNode[] deepCopyNodes(PathDataNode[] pathDataNodeArray) {
        if (pathDataNodeArray == null) {
            return null;
        }
        PathDataNode[] pathDataNodeArray2 = new PathDataNode[pathDataNodeArray.length];
        int n2 = 0;
        while (n2 < pathDataNodeArray.length) {
            pathDataNodeArray2[n2] = new PathDataNode(pathDataNodeArray[n2]);
            ++n2;
        }
        return pathDataNodeArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void extract(String string2, int n2, ExtractFloatResult extractFloatResult) {
        int n3;
        extractFloatResult.mEndWithNegOrDot = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n3 = n2; n3 < string2.length(); ++n3) {
            switch (string2.charAt(n3)) {
                case ' ': 
                case ',': {
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case '-': {
                    if (n3 != n2 && !bl2) {
                        extractFloatResult.mEndWithNegOrDot = true;
                        bl2 = false;
                        bl4 = true;
                        break;
                    }
                }
                default: {
                    bl2 = false;
                    break;
                }
                case '.': {
                    if (!bl3) {
                        bl2 = false;
                        bl3 = true;
                        break;
                    }
                    extractFloatResult.mEndWithNegOrDot = true;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    bl2 = true;
                }
            }
            if (bl4) break;
        }
        extractFloatResult.mEndPosition = n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static float[] getFloats(String object) {
        int n2;
        int n3 = ((String)object).charAt(0) == 'z' ? 1 : 0;
        if (n3 | (n2 = ((String)object).charAt(0) == 'Z' ? 1 : 0)) {
            return new float[0];
        }
        try {
            float[] fArray = new float[((String)object).length()];
            Object object2 = new ExtractFloatResult();
            int n4 = ((String)object).length();
            n3 = 0;
            n2 = 1;
            while (true) {
                if (n2 >= n4) {
                    object2 = PathParser.copyOfRange(fArray, 0, n3);
                    return object2;
                }
                PathParser.extract((String)object, n2, (ExtractFloatResult)object2);
                int n5 = ((ExtractFloatResult)object2).mEndPosition;
                if (n2 < n5) {
                    int n6 = n3 + 1;
                    fArray[n3] = Float.parseFloat(((String)object).substring(n2, n5));
                    n3 = n6;
                }
                if (((ExtractFloatResult)object2).mEndWithNegOrDot) {
                    n2 = n5;
                    continue;
                }
                n2 = n5 + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("error in parsing \"" + (String)object + "\"", numberFormatException);
        }
    }

    private static int nextStart(String string2, int n2) {
        char c2;
        while (n2 < string2.length() && (((c2 = string2.charAt(n2)) - 65) * (c2 - 90) > 0 && (c2 - 97) * (c2 - 122) > 0 || c2 == 'e' || c2 == 'E')) {
            ++n2;
        }
        return n2;
    }

    public static void updateNodes(PathDataNode[] pathDataNodeArray, PathDataNode[] pathDataNodeArray2) {
        for (int i2 = 0; i2 < pathDataNodeArray2.length; ++i2) {
            pathDataNodeArray[i2].type = pathDataNodeArray2[i2].type;
            for (int i3 = 0; i3 < pathDataNodeArray2[i2].params.length; ++i3) {
                pathDataNodeArray[i2].params[i3] = pathDataNodeArray2[i2].params[i3];
            }
        }
    }

    private static class ExtractFloatResult {
        int mEndPosition;
        boolean mEndWithNegOrDot;

        private ExtractFloatResult() {
        }
    }

    public static class PathDataNode {
        float[] params;
        char type;

        private PathDataNode(char c2, float[] fArray) {
            this.type = c2;
            this.params = fArray;
        }

        private PathDataNode(PathDataNode pathDataNode) {
            this.type = pathDataNode.type;
            this.params = PathParser.copyOfRange(pathDataNode.params, 0, pathDataNode.params.length);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private static void addCommand(Path var0, float[] var1_1, char var2_2, char var3_3, float[] var4_4) {
            var5_5 = var1_1[0];
            var6_6 = var1_1[1];
            var7_7 = var1_1[2];
            var8_8 = var1_1[3];
            var9_9 = var1_1[4];
            var10_10 = var1_1[5];
            switch (var3_3) {
                default: {
                    var11_11 = 2;
                    break;
                }
                case 'Z': 
                case 'z': {
                    var0.close();
                    var0.moveTo(var9_9, var10_10);
                    var8_8 = var10_10;
                    var7_7 = var9_9;
                    var6_6 = var10_10;
                    var5_5 = var9_9;
                    var11_11 = 2;
                    break;
                }
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    var11_11 = 2;
                    break;
                }
                case 'H': 
                case 'V': 
                case 'h': 
                case 'v': {
                    var11_11 = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    var11_11 = 6;
                    break;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    var11_11 = 4;
                    break;
                }
                case 'A': 
                case 'a': {
                    var11_11 = 7;
                    break;
                }
            }
            var12_12 = '\u0000';
            var13_13 = var6_6;
            var14_14 = var2_2;
            var6_6 = var5_5;
            var5_5 = var13_13;
            var2_2 = var12_12;
            while (true) {
                block43: {
                    block38: {
                        block37: {
                            block40: {
                                block39: {
                                    block42: {
                                        block41: {
                                            block36: {
                                                if (var2_2 >= var4_4.length) break block36;
                                                switch (var3_3) {
                                                    default: {
                                                        var13_13 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var9_9;
                                                        var9_9 = var13_13;
                                                        break;
                                                    }
                                                    case 'm': {
                                                        var6_6 += var4_4[var2_2 + '\u0000'];
                                                        var5_5 = var4_4[var2_2 + '\u0001'] + var5_5;
                                                        if (var2_2 > '\u0000') {
                                                            var0.rLineTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                            var13_13 = var9_9;
                                                            var9_9 = var10_10;
                                                            var10_10 = var8_8;
                                                            var8_8 = var13_13;
                                                            break;
                                                        }
                                                        var0.rMoveTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                        var15_15 = var5_5;
                                                        var13_13 = var6_6;
                                                        var10_10 = var8_8;
                                                        var9_9 = var5_5;
                                                        var8_8 = var6_6;
                                                        var5_5 = var15_15;
                                                        var6_6 = var13_13;
                                                        break;
                                                    }
                                                    case 'M': {
                                                        var5_5 = var4_4[var2_2 + '\u0000'];
                                                        var6_6 = var4_4[var2_2 + '\u0001'];
                                                        if (var2_2 > '\u0000') {
                                                            var0.lineTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                            var13_13 = var5_5;
                                                            var5_5 = var9_9;
                                                            var9_9 = var10_10;
                                                            var10_10 = var8_8;
                                                            var8_8 = var5_5;
                                                            var5_5 = var6_6;
                                                            var6_6 = var13_13;
                                                            break;
                                                        }
                                                        var0.moveTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                        var15_15 = var6_6;
                                                        var13_13 = var5_5;
                                                        var10_10 = var8_8;
                                                        var9_9 = var6_6;
                                                        var8_8 = var5_5;
                                                        var5_5 = var15_15;
                                                        var6_6 = var13_13;
                                                        break;
                                                    }
                                                    case 'l': {
                                                        var0.rLineTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                        var15_15 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var4_4[var2_2 + '\u0001'];
                                                        var13_13 += var5_5;
                                                        var6_6 += var15_15;
                                                        var5_5 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var5_5;
                                                        var5_5 = var13_13;
                                                        break;
                                                    }
                                                    case 'L': {
                                                        var0.lineTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                        var6_6 = var4_4[var2_2 + '\u0000'];
                                                        var5_5 = var4_4[var2_2 + '\u0001'];
                                                        var13_13 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var13_13;
                                                        break;
                                                    }
                                                    case 'h': {
                                                        var0.rLineTo(var4_4[var2_2 + '\u0000'], 0.0f);
                                                        var13_13 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var6_6 + var13_13;
                                                        var6_6 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var6_6;
                                                        var6_6 = var13_13;
                                                        break;
                                                    }
                                                    case 'H': {
                                                        var0.lineTo(var4_4[var2_2 + '\u0000'], var5_5);
                                                        var6_6 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var13_13;
                                                        break;
                                                    }
                                                    case 'v': {
                                                        var0.rLineTo(0.0f, var4_4[var2_2 + '\u0000']);
                                                        var15_15 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var9_9;
                                                        var5_5 = var15_15 + var5_5;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var13_13;
                                                        break;
                                                    }
                                                    case 'V': {
                                                        var0.lineTo(var6_6, var4_4[var2_2 + '\u0000']);
                                                        var13_13 = var4_4[var2_2 + '\u0000'];
                                                        var5_5 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var8_8;
                                                        var8_8 = var5_5;
                                                        var5_5 = var13_13;
                                                        break;
                                                    }
                                                    case 'c': {
                                                        var0.rCubicTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3], var4_4[var2_2 + 4], var4_4[var2_2 + 5]);
                                                        var7_7 = var4_4[var2_2 + 2];
                                                        var15_15 = var4_4[var2_2 + 3];
                                                        var8_8 = var4_4[var2_2 + 4];
                                                        var13_13 = var4_4[var2_2 + 5];
                                                        var7_7 = var6_6 + var7_7;
                                                        var13_13 += var5_5;
                                                        var6_6 += var8_8;
                                                        var8_8 = var9_9;
                                                        var5_5 = var15_15 + var5_5;
                                                        var9_9 = var10_10;
                                                        var10_10 = var5_5;
                                                        var5_5 = var13_13;
                                                        break;
                                                    }
                                                    case 'C': {
                                                        var0.cubicTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3], var4_4[var2_2 + 4], var4_4[var2_2 + 5]);
                                                        var6_6 = var4_4[var2_2 + 4];
                                                        var5_5 = var4_4[var2_2 + 5];
                                                        var7_7 = var4_4[var2_2 + 2];
                                                        var13_13 = var4_4[var2_2 + 3];
                                                        var8_8 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var13_13;
                                                        break;
                                                    }
                                                    case 's': {
                                                        if (var14_14 != 'c' && var14_14 != 's' && var14_14 != 'C' && var14_14 != 'S') break block37;
                                                        var7_7 = var6_6 - var7_7;
                                                        var8_8 = var5_5 - var8_8;
                                                        break block38;
                                                    }
                                                    case 'S': {
                                                        if (var14_14 != 'c' && var14_14 != 's' && var14_14 != 'C' && var14_14 != 'S') break block39;
                                                        var7_7 = 2.0f * var6_6 - var7_7;
                                                        var5_5 = 2.0f * var5_5 - var8_8;
                                                        var8_8 = var7_7;
                                                        break block40;
                                                    }
                                                    case 'q': {
                                                        var0.rQuadTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3]);
                                                        var7_7 = var4_4[var2_2 + '\u0000'];
                                                        var15_15 = var4_4[var2_2 + '\u0001'];
                                                        var8_8 = var4_4[var2_2 + 2];
                                                        var13_13 = var4_4[var2_2 + 3];
                                                        var7_7 = var6_6 + var7_7;
                                                        var13_13 += var5_5;
                                                        var6_6 += var8_8;
                                                        var8_8 = var9_9;
                                                        var5_5 = var15_15 + var5_5;
                                                        var9_9 = var10_10;
                                                        var10_10 = var5_5;
                                                        var5_5 = var13_13;
                                                        break;
                                                    }
                                                    case 'Q': {
                                                        var0.quadTo(var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3]);
                                                        var7_7 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var4_4[var2_2 + '\u0001'];
                                                        var6_6 = var4_4[var2_2 + 2];
                                                        var5_5 = var4_4[var2_2 + 3];
                                                        var8_8 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var13_13;
                                                        break;
                                                    }
                                                    case 't': {
                                                        if (var14_14 != 'q' && var14_14 != 't' && var14_14 != 'Q' && var14_14 != 'T') break block41;
                                                        var7_7 = var6_6 - var7_7;
                                                        var8_8 = var5_5 - var8_8;
                                                        break block42;
                                                    }
                                                    case 'T': {
                                                        if (var14_14 == 'q' || var14_14 == 't' || var14_14 == 'Q') ** GOTO lbl219
                                                        var15_15 = var5_5;
                                                        var13_13 = var6_6;
                                                        if (var14_14 != 'T') ** GOTO lbl221
lbl219:
                                                        // 2 sources

                                                        var13_13 = 2.0f * var6_6 - var7_7;
                                                        var15_15 = 2.0f * var5_5 - var8_8;
lbl221:
                                                        // 2 sources

                                                        var0.quadTo(var13_13, var15_15, var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                                        var6_6 = var4_4[var2_2 + '\u0000'];
                                                        var5_5 = var4_4[var2_2 + '\u0001'];
                                                        var7_7 = var13_13;
                                                        var8_8 = var9_9;
                                                        var9_9 = var10_10;
                                                        var10_10 = var15_15;
                                                        break;
                                                    }
                                                    case 'a': {
                                                        var13_13 = var4_4[var2_2 + 5];
                                                        var16_16 = var4_4[var2_2 + 6];
                                                        var8_8 = var4_4[var2_2 + '\u0000'];
                                                        var7_7 = var4_4[var2_2 + '\u0001'];
                                                        var15_15 = var4_4[var2_2 + 2];
                                                        var17_17 = var4_4[var2_2 + 3] != 0.0f;
                                                        var18_18 = var4_4[var2_2 + 4] != 0.0f;
                                                        PathDataNode.drawArc(var0, var6_6, var5_5, var13_13 + var6_6, var16_16 + var5_5, var8_8, var7_7, var15_15, var17_17, var18_18);
                                                        var13_13 = var4_4[var2_2 + 6] + var5_5;
                                                        var8_8 = var9_9;
                                                        var7_7 = var6_6 += var4_4[var2_2 + 5];
                                                        var5_5 = var13_13;
                                                        var9_9 = var10_10;
                                                        var10_10 = var13_13;
                                                        break;
                                                    }
                                                    case 'A': {
                                                        var15_15 = var4_4[var2_2 + 5];
                                                        var7_7 = var4_4[var2_2 + 6];
                                                        var8_8 = var4_4[var2_2 + '\u0000'];
                                                        var13_13 = var4_4[var2_2 + '\u0001'];
                                                        var16_16 = var4_4[var2_2 + 2];
                                                        var17_17 = var4_4[var2_2 + 3] != 0.0f;
                                                        if (var4_4[var2_2 + 4] != 0.0f) {
                                                            var18_18 = true;
                                                        } else {
                                                            var18_18 = false;
                                                            ** break;
                                                        }
lbl257:
                                                        // 2 sources

                                                        PathDataNode.drawArc(var0, var6_6, var5_5, var15_15, var7_7, var8_8, var13_13, var16_16, var17_17, var18_18);
                                                        var6_6 = var4_4[var2_2 + 5];
                                                        var13_13 = var4_4[var2_2 + 6];
                                                        var8_8 = var9_9;
                                                        var7_7 = var6_6;
                                                        var5_5 = var13_13;
                                                        var9_9 = var10_10;
                                                        var10_10 = var13_13;
                                                        break;
                                                    }
                                                }
                                                break block43;
                                            }
                                            var1_1[0] = var6_6;
                                            var1_1[1] = var5_5;
                                            var1_1[2] = var7_7;
                                            var1_1[3] = var8_8;
                                            var1_1[4] = var9_9;
                                            var1_1[5] = var10_10;
                                            return;
                                        }
                                        var8_8 = 0.0f;
                                        var7_7 = 0.0f;
                                    }
                                    var0.rQuadTo(var7_7, var8_8, var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001']);
                                    var16_16 = var4_4[var2_2 + '\u0000'];
                                    var15_15 = var4_4[var2_2 + '\u0001'];
                                    var13_13 = var6_6 + var7_7;
                                    var15_15 += var5_5;
                                    var6_6 += var16_16;
                                    var7_7 = var9_9;
                                    var9_9 = var10_10;
                                    var10_10 = var8_8 += var5_5;
                                    var8_8 = var7_7;
                                    var7_7 = var13_13;
                                    var5_5 = var15_15;
                                    break block43;
                                }
                                var8_8 = var6_6;
                            }
                            var0.cubicTo(var8_8, var5_5, var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3]);
                            var7_7 = var4_4[var2_2 + '\u0000'];
                            var13_13 = var4_4[var2_2 + '\u0001'];
                            var6_6 = var4_4[var2_2 + 2];
                            var5_5 = var4_4[var2_2 + 3];
                            var8_8 = var9_9;
                            var9_9 = var10_10;
                            var10_10 = var13_13;
                            break block43;
                        }
                        var8_8 = 0.0f;
                        var7_7 = 0.0f;
                    }
                    var0.rCubicTo(var7_7, var8_8, var4_4[var2_2 + '\u0000'], var4_4[var2_2 + '\u0001'], var4_4[var2_2 + 2], var4_4[var2_2 + 3]);
                    var7_7 = var4_4[var2_2 + '\u0000'];
                    var15_15 = var4_4[var2_2 + '\u0001'];
                    var8_8 = var4_4[var2_2 + 2];
                    var13_13 = var4_4[var2_2 + 3];
                    var7_7 = var6_6 + var7_7;
                    var13_13 += var5_5;
                    var6_6 += var8_8;
                    var8_8 = var9_9;
                    var5_5 = var15_15 + var5_5;
                    var9_9 = var10_10;
                    var10_10 = var5_5;
                    var5_5 = var13_13;
                }
                var2_2 = (char)(var2_2 + var11_11);
                var13_13 = var8_8;
                var14_14 = var3_3;
                var8_8 = var10_10;
                var10_10 = var9_9;
                var9_9 = var13_13;
            }
        }

        private static void arcToBezier(Path path, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
            int n2 = (int)Math.ceil(Math.abs(4.0 * d10 / Math.PI));
            double d11 = Math.cos(d8);
            double d12 = Math.sin(d8);
            double d13 = Math.cos(d9);
            double d14 = Math.sin(d9);
            d8 = -d4;
            double d15 = -d4;
            double d16 = d10 / (double)n2;
            d15 = d14 * (d15 * d12) + d13 * (d5 * d11);
            d8 = d8 * d11 * d14 - d5 * d12 * d13;
            d10 = d9;
            d9 = d7;
            d7 = d6;
            d6 = d15;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d17 = d10 + d16;
                d14 = Math.sin(d17);
                double d18 = Math.cos(d17);
                d15 = d4 * d11 * d18 + d2 - d5 * d12 * d14;
                d13 = d5 * d11 * d14 + (d4 * d12 * d18 + d3);
                double d19 = -d4 * d11 * d14 - d5 * d12 * d18;
                d14 = d18 * (d5 * d11) + d14 * (-d4 * d12);
                d18 = Math.tan((d17 - d10) / 2.0);
                d10 = Math.sin(d17 - d10);
                d10 = (Math.sqrt(d18 * (3.0 * d18) + 4.0) - 1.0) * d10 / 3.0;
                path.cubicTo((float)(d8 * d10 + d7), (float)(d9 + d6 * d10), (float)(d15 - d10 * d19), (float)(d13 - d10 * d14), (float)d15, (float)d13);
                d8 = d19;
                d10 = d17;
                d9 = d13;
                d7 = d15;
                d6 = d14;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void drawArc(Path path, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl2, boolean bl3) {
            double d2 = Math.toRadians(f8);
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = ((double)f2 * d3 + (double)f3 * d4) / (double)f6;
            double d6 = ((double)(-f2) * d4 + (double)f3 * d3) / (double)f7;
            double d7 = ((double)f4 * d3 + (double)f5 * d4) / (double)f6;
            double d8 = ((double)(-f4) * d4 + (double)f5 * d3) / (double)f7;
            double d9 = d5 - d7;
            double d10 = d6 - d8;
            double d11 = (d5 + d7) / 2.0;
            double d12 = (d6 + d8) / 2.0;
            double d13 = d9 * d9 + d10 * d10;
            if (d13 == 0.0) {
                Log.w((String)PathParser.LOGTAG, (String)" Points are coincident");
                return;
            }
            double d14 = 1.0 / d13 - 0.25;
            if (d14 < 0.0) {
                Log.w((String)PathParser.LOGTAG, (String)("Points are too far apart " + d13));
                float f9 = (float)(Math.sqrt(d13) / 1.99999);
                PathDataNode.drawArc(path, f2, f3, f4, f5, f6 * f9, f7 * f9, f8, bl2, bl3);
                return;
            }
            d13 = Math.sqrt(d14);
            d9 *= d13;
            d10 *= d13;
            if (bl2 == bl3) {
                d11 -= d10;
                d12 = d9 + d12;
            } else {
                d11 = d10 + d11;
                d12 -= d9;
            }
            d5 = Math.atan2(d6 - d12, d5 - d11);
            bl2 = (d7 = Math.atan2(d8 - d12, d7 - d11) - d5) >= 0.0;
            d8 = d7;
            if (bl3 != bl2) {
                d8 = d7 > 0.0 ? d7 - Math.PI * 2 : d7 + Math.PI * 2;
            }
            d11 = (double)f6 * d11;
            PathDataNode.arcToBezier(path, d11 * d3 - (d12 *= (double)f7) * d4, d11 * d4 + d12 * d3, f6, f7, f2, f3, d2, d5, d8);
        }

        public static void nodesToPath(PathDataNode[] pathDataNodeArray, Path path) {
            float[] fArray = new float[6];
            char c2 = 'm';
            char c3 = c2;
            for (int i2 = 0; i2 < pathDataNodeArray.length; ++i2) {
                PathDataNode.addCommand(path, fArray, c3, pathDataNodeArray[i2].type, pathDataNodeArray[i2].params);
                c2 = pathDataNodeArray[i2].type;
                c3 = c2;
            }
        }

        public void interpolatePathDataNode(PathDataNode pathDataNode, PathDataNode pathDataNode2, float f2) {
            for (int i2 = 0; i2 < pathDataNode.params.length; ++i2) {
                this.params[i2] = pathDataNode.params[i2] * (1.0f - f2) + pathDataNode2.params[i2] * f2;
            }
        }
    }
}

