/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManagerImpl;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;

final class BackStackState
implements Parcelable {
    public static final Parcelable.Creator<BackStackState> CREATOR = new Parcelable.Creator<BackStackState>(){

        public BackStackState createFromParcel(Parcel parcel) {
            return new BackStackState(parcel);
        }

        public BackStackState[] newArray(int n2) {
            return new BackStackState[n2];
        }
    };
    final int mBreadCrumbShortTitleRes;
    final CharSequence mBreadCrumbShortTitleText;
    final int mBreadCrumbTitleRes;
    final CharSequence mBreadCrumbTitleText;
    final int mIndex;
    final String mName;
    final int[] mOps;
    final ArrayList<String> mSharedElementSourceNames;
    final ArrayList<String> mSharedElementTargetNames;
    final int mTransition;
    final int mTransitionStyle;

    public BackStackState(Parcel parcel) {
        this.mOps = parcel.createIntArray();
        this.mTransition = parcel.readInt();
        this.mTransitionStyle = parcel.readInt();
        this.mName = parcel.readString();
        this.mIndex = parcel.readInt();
        this.mBreadCrumbTitleRes = parcel.readInt();
        this.mBreadCrumbTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mBreadCrumbShortTitleRes = parcel.readInt();
        this.mBreadCrumbShortTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mSharedElementSourceNames = parcel.createStringArrayList();
        this.mSharedElementTargetNames = parcel.createStringArrayList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackState(BackStackRecord backStackRecord) {
        int n2;
        BackStackRecord.Op op = backStackRecord.mHead;
        int n3 = 0;
        while (op != null) {
            n2 = n3;
            if (op.removed != null) {
                n2 = n3 + op.removed.size();
            }
            op = op.next;
            n3 = n2;
        }
        this.mOps = new int[n3 + backStackRecord.mNumOp * 7];
        if (!backStackRecord.mAddToBackStack) {
            throw new IllegalStateException("Not on back stack");
        }
        op = backStackRecord.mHead;
        n3 = 0;
        while (true) {
            if (op == null) {
                this.mTransition = backStackRecord.mTransition;
                this.mTransitionStyle = backStackRecord.mTransitionStyle;
                this.mName = backStackRecord.mName;
                this.mIndex = backStackRecord.mIndex;
                this.mBreadCrumbTitleRes = backStackRecord.mBreadCrumbTitleRes;
                this.mBreadCrumbTitleText = backStackRecord.mBreadCrumbTitleText;
                this.mBreadCrumbShortTitleRes = backStackRecord.mBreadCrumbShortTitleRes;
                this.mBreadCrumbShortTitleText = backStackRecord.mBreadCrumbShortTitleText;
                this.mSharedElementSourceNames = backStackRecord.mSharedElementSourceNames;
                this.mSharedElementTargetNames = backStackRecord.mSharedElementTargetNames;
                return;
            }
            int[] nArray = this.mOps;
            int n4 = n3 + 1;
            nArray[n3] = op.cmd;
            nArray = this.mOps;
            n2 = n4 + 1;
            n3 = op.fragment != null ? op.fragment.mIndex : -1;
            nArray[n4] = n3;
            nArray = this.mOps;
            n4 = n2 + 1;
            nArray[n2] = op.enterAnim;
            nArray = this.mOps;
            n3 = n4 + 1;
            nArray[n4] = op.exitAnim;
            nArray = this.mOps;
            n4 = n3 + 1;
            nArray[n3] = op.popEnterAnim;
            nArray = this.mOps;
            n2 = n4 + 1;
            nArray[n4] = op.popExitAnim;
            if (op.removed != null) {
                n4 = op.removed.size();
                nArray = this.mOps;
                n3 = n2 + 1;
                nArray[n2] = n4;
                for (n2 = 0; n2 < n4; ++n2, ++n3) {
                    this.mOps[n3] = op.removed.get((int)n2).mIndex;
                }
            } else {
                nArray = this.mOps;
                n3 = n2 + 1;
                nArray[n2] = 0;
            }
            op = op.next;
        }
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BackStackRecord instantiate(FragmentManagerImpl fragmentManagerImpl) {
        BackStackRecord backStackRecord = new BackStackRecord(fragmentManagerImpl);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= this.mOps.length) {
                backStackRecord.mTransition = this.mTransition;
                backStackRecord.mTransitionStyle = this.mTransitionStyle;
                backStackRecord.mName = this.mName;
                backStackRecord.mIndex = this.mIndex;
                backStackRecord.mAddToBackStack = true;
                backStackRecord.mBreadCrumbTitleRes = this.mBreadCrumbTitleRes;
                backStackRecord.mBreadCrumbTitleText = this.mBreadCrumbTitleText;
                backStackRecord.mBreadCrumbShortTitleRes = this.mBreadCrumbShortTitleRes;
                backStackRecord.mBreadCrumbShortTitleText = this.mBreadCrumbShortTitleText;
                backStackRecord.mSharedElementSourceNames = this.mSharedElementSourceNames;
                backStackRecord.mSharedElementTargetNames = this.mSharedElementTargetNames;
                backStackRecord.bumpBackStackNesting(1);
                return backStackRecord;
            }
            BackStackRecord.Op op = new BackStackRecord.Op();
            int[] nArray = this.mOps;
            int n4 = n3 + 1;
            op.cmd = nArray[n3];
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)"FragmentManager", (String)("Instantiate " + backStackRecord + " op #" + n2 + " base fragment #" + this.mOps[n4]));
            }
            int[] nArray2 = this.mOps;
            n3 = n4 + 1;
            op.fragment = (n4 = nArray2[n4]) >= 0 ? fragmentManagerImpl.mActive.get(n4) : null;
            int[] nArray3 = this.mOps;
            n4 = n3 + 1;
            op.enterAnim = nArray3[n3];
            int[] nArray4 = this.mOps;
            n3 = n4 + 1;
            op.exitAnim = nArray4[n4];
            int[] nArray5 = this.mOps;
            n4 = n3 + 1;
            op.popEnterAnim = nArray5[n3];
            int[] nArray6 = this.mOps;
            n3 = n4 + 1;
            op.popExitAnim = nArray6[n4];
            int[] nArray7 = this.mOps;
            n4 = n3 + 1;
            int n5 = nArray7[n3];
            n3 = n4;
            if (n5 > 0) {
                op.removed = new ArrayList(n5);
                int n6 = 0;
                while (true) {
                    n3 = ++n4;
                    if (n6 >= n5) break;
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("Instantiate " + backStackRecord + " set remove fragment #" + this.mOps[n4]));
                    }
                    Fragment fragment = fragmentManagerImpl.mActive.get(this.mOps[n4]);
                    op.removed.add(fragment);
                    ++n6;
                }
            }
            backStackRecord.mEnterAnim = op.enterAnim;
            backStackRecord.mExitAnim = op.exitAnim;
            backStackRecord.mPopEnterAnim = op.popEnterAnim;
            backStackRecord.mPopExitAnim = op.popExitAnim;
            backStackRecord.addOp(op);
            ++n2;
        }
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeIntArray(this.mOps);
        parcel.writeInt(this.mTransition);
        parcel.writeInt(this.mTransitionStyle);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mIndex);
        parcel.writeInt(this.mBreadCrumbTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbTitleText, (Parcel)parcel, (int)0);
        parcel.writeInt(this.mBreadCrumbShortTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbShortTitleText, (Parcel)parcel, (int)0);
        parcel.writeStringList(this.mSharedElementSourceNames);
        parcel.writeStringList(this.mSharedElementTargetNames);
    }
}

