/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ImageView;
import java.util.List;
import java.util.Map;

public abstract class SharedElementCallback {
    private static final String BUNDLE_SNAPSHOT_BITMAP = "sharedElement:snapshot:bitmap";
    private static final String BUNDLE_SNAPSHOT_IMAGE_MATRIX = "sharedElement:snapshot:imageMatrix";
    private static final String BUNDLE_SNAPSHOT_IMAGE_SCALETYPE = "sharedElement:snapshot:imageScaleType";
    private static int MAX_IMAGE_SIZE = 0x100000;
    private Matrix mTempMatrix;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap createDrawableBitmap(Drawable drawable2) {
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable2.getIntrinsicHeight();
        if (n2 <= 0) return null;
        if (n3 <= 0) {
            return null;
        }
        float f2 = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(n2 * n3));
        if (drawable2 instanceof BitmapDrawable && f2 == 1.0f) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        n2 = (int)((float)n2 * f2);
        int n4 = (int)((float)n3 * f2);
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Rect rect = drawable2.getBounds();
        int n5 = rect.left;
        int n6 = rect.top;
        n3 = rect.right;
        int n7 = rect.bottom;
        drawable2.setBounds(0, 0, n2, n4);
        drawable2.draw(canvas);
        drawable2.setBounds(n5, n6, n3, n7);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Parcelable onCaptureSharedElementSnapshot(View view, Matrix object, RectF rectF) {
        void var3_5;
        Drawable drawable2;
        ImageView imageView;
        if (view instanceof ImageView) {
            imageView = (ImageView)view;
            drawable2 = imageView.getDrawable();
            Drawable drawable3 = imageView.getBackground();
            if (drawable2 != null && drawable3 == null && (drawable3 = SharedElementCallback.createDrawableBitmap(drawable2)) != null) {
                drawable2 = new Bundle();
                drawable2.putParcelable(BUNDLE_SNAPSHOT_BITMAP, (Parcelable)drawable3);
                drawable2.putString(BUNDLE_SNAPSHOT_IMAGE_SCALETYPE, imageView.getScaleType().toString());
                if (imageView.getScaleType() != ImageView.ScaleType.MATRIX) return drawable2;
                view = imageView.getImageMatrix();
                float[] fArray = new float[9];
                view.getValues(fArray);
                drawable2.putFloatArray(BUNDLE_SNAPSHOT_IMAGE_MATRIX, fArray);
                return drawable2;
            }
        }
        int n2 = Math.round(var3_5.width());
        int n3 = Math.round(var3_5.height());
        imageView = null;
        drawable2 = imageView;
        if (n2 <= 0) return drawable2;
        drawable2 = imageView;
        if (n3 <= 0) return drawable2;
        float f2 = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(n2 * n3));
        n2 = (int)((float)n2 * f2);
        n3 = (int)((float)n3 * f2);
        if (this.mTempMatrix == null) {
            this.mTempMatrix = new Matrix();
        }
        this.mTempMatrix.set(object);
        this.mTempMatrix.postTranslate(-var3_5.left, -var3_5.top);
        this.mTempMatrix.postScale(f2, f2);
        drawable2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas((Bitmap)drawable2);
        canvas.concat(this.mTempMatrix);
        view.draw(canvas);
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View onCreateSnapshotView(Context context, Parcelable object) {
        Matrix matrix = null;
        if (object instanceof Bundle) {
            Bundle bundle = (Bundle)object;
            Bitmap bitmap = (Bitmap)bundle.getParcelable(BUNDLE_SNAPSHOT_BITMAP);
            if (bitmap == null) {
                return matrix;
            }
            context = new ImageView(context);
            context.setImageBitmap(bitmap);
            context.setScaleType(ImageView.ScaleType.valueOf((String)bundle.getString(BUNDLE_SNAPSHOT_IMAGE_SCALETYPE)));
            if (context.getScaleType() != ImageView.ScaleType.MATRIX) return context;
            float[] fArray = bundle.getFloatArray(BUNDLE_SNAPSHOT_IMAGE_MATRIX);
            matrix = new Matrix();
            matrix.setValues(fArray);
            context.setImageMatrix(matrix);
            return context;
        }
        if (!(object instanceof Bitmap)) return null;
        Bitmap bitmap = (Bitmap)object;
        context = new ImageView(context);
        context.setImageBitmap(bitmap);
        return context;
    }

    public void onMapSharedElements(List<String> list, Map<String, View> map) {
    }

    public void onRejectSharedElements(List<View> list) {
    }

    public void onSharedElementEnd(List<String> list, List<View> list2, List<View> list3) {
    }

    public void onSharedElementStart(List<String> list, List<View> list2, List<View> list3) {
    }
}

