/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Log;
import android.util.SparseArray;

public abstract class WakefulBroadcastReceiver
extends BroadcastReceiver {
    private static final String EXTRA_WAKE_LOCK_ID = "android.support.content.wakelockid";
    private static final SparseArray<PowerManager.WakeLock> mActiveWakeLocks = new SparseArray();
    private static int mNextId = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean completeWakefulIntent(Intent sparseArray) {
        boolean bl2 = false;
        int n2 = sparseArray.getIntExtra(EXTRA_WAKE_LOCK_ID, 0);
        if (n2 == 0) {
            return bl2;
        }
        sparseArray = mActiveWakeLocks;
        synchronized (sparseArray) {
            Object object = (PowerManager.WakeLock)mActiveWakeLocks.get(n2);
            if (object != null) {
                object.release();
                mActiveWakeLocks.remove(n2);
                return true;
            }
            object = new StringBuilder();
            Log.w((String)"WakefulBroadcastReceiver", (String)((StringBuilder)object).append("No active wake lock id #").append(n2).toString());
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComponentName startWakefulService(Context object, Intent intent) {
        SparseArray<PowerManager.WakeLock> sparseArray = mActiveWakeLocks;
        synchronized (sparseArray) {
            int n2 = mNextId++;
            if (mNextId <= 0) {
                mNextId = 1;
            }
            intent.putExtra(EXTRA_WAKE_LOCK_ID, n2);
            intent = object.startService(intent);
            if (intent == null) {
                return null;
            }
            PowerManager powerManager = (PowerManager)object.getSystemService("power");
            object = new StringBuilder();
            object = powerManager.newWakeLock(1, ((StringBuilder)object).append("wake:").append(intent.flattenToShortString()).toString());
            object.setReferenceCounted(false);
            object.acquire(60000L);
            mActiveWakeLocks.put(n2, object);
            return intent;
        }
    }
}

