/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompatApi21;
import android.support.v4.content.res.ResourcesCompatApi23;
import android.support.v4.content.res.ResourcesCompatIcsMr1;

public final class ResourcesCompat {
    private ResourcesCompat() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ColorInt
    public static int getColor(@NonNull Resources resources, @ColorRes int n2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT < 23) return resources.getColor(n2);
        return ResourcesCompatApi23.getColor(resources, n2, theme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static ColorStateList getColorStateList(@NonNull Resources resources, @ColorRes int n2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT < 23) return resources.getColorStateList(n2);
        return ResourcesCompatApi23.getColorStateList(resources, n2, theme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Drawable getDrawable(@NonNull Resources resources, @DrawableRes int n2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT < 21) return resources.getDrawable(n2);
        return ResourcesCompatApi21.getDrawable(resources, n2, theme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Drawable getDrawableForDensity(@NonNull Resources resources, @DrawableRes int n2, int n3, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return ResourcesCompatApi21.getDrawableForDensity(resources, n2, n3, theme);
        }
        if (Build.VERSION.SDK_INT < 15) return resources.getDrawable(n2);
        return ResourcesCompatIcsMr1.getDrawableForDensity(resources, n2, n3);
    }
}

