/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.BundleCompat;
import android.support.v4.media.MediaBrowserCompatApi21;
import android.support.v4.media.MediaBrowserCompatApi23;
import android.support.v4.media.MediaBrowserCompatUtils;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MediaBrowserCompat {
    public static final String EXTRA_PAGE = "android.media.browse.extra.PAGE";
    public static final String EXTRA_PAGE_SIZE = "android.media.browse.extra.PAGE_SIZE";
    private static final String TAG = "MediaBrowserCompat";
    private final MediaBrowserImpl mImpl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MediaBrowserCompat(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mImpl = new MediaBrowserImplApi23(context, componentName, connectionCallback, bundle);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mImpl = new MediaBrowserImplApi21(context, componentName, connectionCallback, bundle);
            return;
        }
        this.mImpl = new MediaBrowserImplBase(context, componentName, connectionCallback, bundle);
    }

    public void connect() {
        this.mImpl.connect();
    }

    public void disconnect() {
        this.mImpl.disconnect();
    }

    @Nullable
    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public void getItem(@NonNull String string2, @NonNull ItemCallback itemCallback) {
        this.mImpl.getItem(string2, itemCallback);
    }

    @NonNull
    public String getRoot() {
        return this.mImpl.getRoot();
    }

    @NonNull
    public ComponentName getServiceComponent() {
        return this.mImpl.getServiceComponent();
    }

    @NonNull
    public MediaSessionCompat.Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public boolean isConnected() {
        return this.mImpl.isConnected();
    }

    public void subscribe(@NonNull String string2, @NonNull Bundle bundle, @NonNull SubscriptionCallback subscriptionCallback) {
        if (bundle == null) {
            throw new IllegalArgumentException("options are null");
        }
        this.mImpl.subscribe(string2, bundle, subscriptionCallback);
    }

    public void subscribe(@NonNull String string2, @NonNull SubscriptionCallback subscriptionCallback) {
        this.mImpl.subscribe(string2, null, subscriptionCallback);
    }

    public void unsubscribe(@NonNull String string2) {
        this.mImpl.unsubscribe(string2, null);
    }

    public void unsubscribe(@NonNull String string2, @NonNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("options are null");
        }
        this.mImpl.unsubscribe(string2, bundle);
    }

    private static class CallbackHandler
    extends Handler {
        private final MediaBrowserServiceCallbackImpl mCallbackImpl;
        private WeakReference<Messenger> mCallbacksMessengerRef;

        CallbackHandler(MediaBrowserServiceCallbackImpl mediaBrowserServiceCallbackImpl) {
            this.mCallbackImpl = mediaBrowserServiceCallbackImpl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Message message) {
            if (this.mCallbacksMessengerRef == null) {
                return;
            }
            Bundle bundle = message.getData();
            bundle.setClassLoader(MediaSessionCompat.class.getClassLoader());
            switch (message.what) {
                default: {
                    Log.w((String)MediaBrowserCompat.TAG, (String)("Unhandled message: " + message + "\n  Client version: " + 1 + "\n  Service version: " + message.arg1));
                    return;
                }
                case 1: {
                    this.mCallbackImpl.onServiceConnected((Messenger)this.mCallbacksMessengerRef.get(), bundle.getString("data_media_item_id"), (MediaSessionCompat.Token)bundle.getParcelable("data_media_session_token"), bundle.getBundle("data_root_hints"));
                    return;
                }
                case 2: {
                    this.mCallbackImpl.onConnectionFailed((Messenger)this.mCallbacksMessengerRef.get());
                    return;
                }
                case 3: 
            }
            this.mCallbackImpl.onLoadChildren((Messenger)this.mCallbacksMessengerRef.get(), bundle.getString("data_media_item_id"), bundle.getParcelableArrayList("data_media_item_list"), bundle.getBundle("data_options"));
        }

        void setCallbacksMessenger(Messenger messenger) {
            this.mCallbacksMessengerRef = new WeakReference<Messenger>(messenger);
        }
    }

    public static class ConnectionCallback {
        private ConnectionCallbackInternal mConnectionCallbackInternal;
        final Object mConnectionCallbackObj;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ConnectionCallback() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mConnectionCallbackObj = MediaBrowserCompatApi21.createConnectionCallback(new StubApi21());
                return;
            }
            this.mConnectionCallbackObj = null;
        }

        public void onConnected() {
        }

        public void onConnectionFailed() {
        }

        public void onConnectionSuspended() {
        }

        void setInternalConnectionCallback(ConnectionCallbackInternal connectionCallbackInternal) {
            this.mConnectionCallbackInternal = connectionCallbackInternal;
        }

        static interface ConnectionCallbackInternal {
            public void onConnected();

            public void onConnectionFailed();

            public void onConnectionSuspended();
        }

        private class StubApi21
        implements MediaBrowserCompatApi21.ConnectionCallback {
            private StubApi21() {
            }

            @Override
            public void onConnected() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnected();
                }
                ConnectionCallback.this.onConnected();
            }

            @Override
            public void onConnectionFailed() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionFailed();
                }
                ConnectionCallback.this.onConnectionFailed();
            }

            @Override
            public void onConnectionSuspended() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionSuspended();
                }
                ConnectionCallback.this.onConnectionSuspended();
            }
        }
    }

    public static abstract class ItemCallback {
        final Object mItemCallbackObj;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ItemCallback() {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mItemCallbackObj = MediaBrowserCompatApi23.createItemCallback(new StubApi23());
                return;
            }
            this.mItemCallbackObj = null;
        }

        public void onError(@NonNull String string2) {
        }

        public void onItemLoaded(MediaItem mediaItem) {
        }

        private class StubApi23
        implements MediaBrowserCompatApi23.ItemCallback {
            private StubApi23() {
            }

            @Override
            public void onError(@NonNull String string2) {
                ItemCallback.this.onError(string2);
            }

            @Override
            public void onItemLoaded(Parcel parcel) {
                parcel.setDataPosition(0);
                MediaItem mediaItem = (MediaItem)MediaItem.CREATOR.createFromParcel(parcel);
                parcel.recycle();
                ItemCallback.this.onItemLoaded(mediaItem);
            }
        }
    }

    private static class ItemReceiver
    extends ResultReceiver {
        private final ItemCallback mCallback;
        private final String mMediaId;

        ItemReceiver(String string2, ItemCallback itemCallback, Handler handler) {
            super(handler);
            this.mMediaId = string2;
            this.mCallback = itemCallback;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void onReceiveResult(int n2, Bundle bundle) {
            bundle.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            if (n2 != 0 || bundle == null || !bundle.containsKey("media_item")) {
                this.mCallback.onError(this.mMediaId);
                return;
            }
            if ((bundle = bundle.getParcelable("media_item")) instanceof MediaItem) {
                this.mCallback.onItemLoaded((MediaItem)bundle);
                return;
            }
            this.mCallback.onError(this.mMediaId);
        }
    }

    static interface MediaBrowserImpl {
        public void connect();

        public void disconnect();

        @Nullable
        public Bundle getExtras();

        public void getItem(@NonNull String var1, @NonNull ItemCallback var2);

        @NonNull
        public String getRoot();

        public ComponentName getServiceComponent();

        @NonNull
        public MediaSessionCompat.Token getSessionToken();

        public boolean isConnected();

        public void subscribe(@NonNull String var1, Bundle var2, @NonNull SubscriptionCallback var3);

        public void unsubscribe(@NonNull String var1, Bundle var2);
    }

    static class MediaBrowserImplApi21
    implements ConnectionCallback.ConnectionCallbackInternal,
    MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl {
        private static final boolean DBG = false;
        protected Object mBrowserObj;
        private Messenger mCallbacksMessenger;
        private final CallbackHandler mHandler = new CallbackHandler(this);
        private ServiceBinderWrapper mServiceBinderWrapper;
        private final ComponentName mServiceComponent;
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();

        public MediaBrowserImplApi21(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            this.mServiceComponent = componentName;
            connectionCallback.setInternalConnectionCallback(this);
            this.mBrowserObj = MediaBrowserCompatApi21.createBrowser(context, componentName, connectionCallback.mConnectionCallbackObj, bundle);
        }

        @Override
        public void connect() {
            MediaBrowserCompatApi21.connect(this.mBrowserObj);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void disconnect() {
            if (this.mServiceBinderWrapper != null && this.mCallbacksMessenger != null) {
                try {
                    this.mServiceBinderWrapper.unregisterCallbackMessenger(this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error unregistering client messenger.");
                }
            }
            MediaBrowserCompatApi21.disconnect(this.mBrowserObj);
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            return MediaBrowserCompatApi21.getExtras(this.mBrowserObj);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void getItem(final @NonNull String string2, final @NonNull ItemCallback itemCallback) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("mediaId is empty.");
            }
            if (itemCallback == null) {
                throw new IllegalArgumentException("cb is null.");
            }
            if (!MediaBrowserCompatApi21.isConnected(this.mBrowserObj)) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        itemCallback.onError(string2);
                    }
                });
                return;
            }
            if (this.mServiceBinderWrapper == null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        itemCallback.onItemLoaded(null);
                    }
                });
                return;
            }
            ItemReceiver itemReceiver = new ItemReceiver(string2, itemCallback, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(string2, itemReceiver);
                return;
            }
            catch (RemoteException remoteException) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error getting media item: " + string2));
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        itemCallback.onError(string2);
                    }
                });
                return;
            }
        }

        @Override
        @NonNull
        public String getRoot() {
            return MediaBrowserCompatApi21.getRoot(this.mBrowserObj);
        }

        @Override
        public ComponentName getServiceComponent() {
            return MediaBrowserCompatApi21.getServiceComponent(this.mBrowserObj);
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            return MediaSessionCompat.Token.fromToken(MediaBrowserCompatApi21.getSessionToken(this.mBrowserObj));
        }

        @Override
        public boolean isConnected() {
            return MediaBrowserCompatApi21.isConnected(this.mBrowserObj);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnected() {
            Bundle bundle = MediaBrowserCompatApi21.getExtras(this.mBrowserObj);
            if (bundle == null) {
                return;
            }
            if ((bundle = BundleCompat.getBinder(bundle, "extra_messenger")) == null) return;
            this.mServiceBinderWrapper = new ServiceBinderWrapper((IBinder)bundle);
            this.mCallbacksMessenger = new Messenger((Handler)this.mHandler);
            this.mHandler.setCallbacksMessenger(this.mCallbacksMessenger);
            try {
                this.mServiceBinderWrapper.registerCallbackMessenger(this.mCallbacksMessenger);
            }
            catch (RemoteException remoteException) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error registering client messenger.");
            }
            this.onServiceConnected(this.mCallbacksMessenger, null, null, null);
        }

        @Override
        public void onConnectionFailed() {
        }

        @Override
        public void onConnectionFailed(Messenger messenger) {
        }

        @Override
        public void onConnectionSuspended() {
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mHandler.setCallbacksMessenger(null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onLoadChildren(Messenger object, String string2, List list, @NonNull Bundle bundle) {
            if (this.mCallbacksMessenger != object) {
                return;
            }
            object = (Subscription)this.mSubscriptions.get(string2);
            if (object == null) return;
            ((Subscription)object).getCallback(bundle).onChildrenLoaded(string2, list, bundle);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected(Messenger object, String object2, MediaSessionCompat.Token list, Bundle object3) {
            Iterator<Map.Entry<String, Subscription>> iterator = this.mSubscriptions.entrySet().iterator();
            block2: while (iterator.hasNext()) {
                Map.Entry<String, Subscription> entry = iterator.next();
                String string2 = entry.getKey();
                Subscription subscription = entry.getValue();
                List<Bundle> list2 = subscription.getOptionsList();
                List<SubscriptionCallback> list3 = subscription.getCallbacks();
                int n2 = 0;
                while (true) {
                    if (n2 >= list2.size()) continue block2;
                    if (list2.get(n2) == null) {
                        MediaBrowserCompatApi21.subscribe(this.mBrowserObj, string2, ((SubscriptionCallbackApi21)list3.get(n2)).mSubscriptionCallbackObj);
                    } else {
                        try {
                            this.mServiceBinderWrapper.addSubscription(string2, list2.get(n2), this.mCallbacksMessenger);
                        }
                        catch (RemoteException remoteException) {
                            Log.d((String)MediaBrowserCompat.TAG, (String)("addSubscription failed with RemoteException parentId=" + string2));
                        }
                    }
                    ++n2;
                }
                break;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void subscribe(@NonNull String string2, Bundle bundle, @NonNull SubscriptionCallback object) {
            block8: {
                block7: {
                    SubscriptionCallbackApi21 subscriptionCallbackApi21 = new SubscriptionCallbackApi21((SubscriptionCallback)object, bundle);
                    Subscription subscription = (Subscription)this.mSubscriptions.get(string2);
                    object = subscription;
                    if (subscription == null) {
                        object = new Subscription();
                        this.mSubscriptions.put(string2, (Subscription)object);
                    }
                    ((Subscription)object).setCallbackForOptions(subscriptionCallbackApi21, bundle);
                    if (!MediaBrowserCompatApi21.isConnected(this.mBrowserObj)) break block7;
                    if (bundle != null && this.mServiceBinderWrapper != null) break block8;
                    MediaBrowserCompatApi21.subscribe(this.mBrowserObj, string2, subscriptionCallbackApi21.mSubscriptionCallbackObj);
                }
                return;
            }
            try {
                this.mServiceBinderWrapper.addSubscription(string2, bundle, this.mCallbacksMessenger);
                return;
            }
            catch (RemoteException remoteException) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error subscribing media item: " + string2));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void unsubscribe(@NonNull String string2, Bundle bundle) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            Subscription subscription = (Subscription)this.mSubscriptions.get(string2);
            if (subscription != null && subscription.remove(bundle)) {
                if (bundle == null || this.mServiceBinderWrapper == null) {
                    if (this.mServiceBinderWrapper != null || subscription.isEmpty()) {
                        MediaBrowserCompatApi21.unsubscribe(this.mBrowserObj, string2);
                    }
                } else if (this.mServiceBinderWrapper == null) {
                    try {
                        this.mServiceBinderWrapper.removeSubscription(string2, bundle, this.mCallbacksMessenger);
                    }
                    catch (RemoteException remoteException) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + string2));
                    }
                }
            }
            if (subscription != null && subscription.isEmpty()) {
                this.mSubscriptions.remove(string2);
            }
        }
    }

    static class MediaBrowserImplApi23
    extends MediaBrowserImplApi21 {
        public MediaBrowserImplApi23(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            super(context, componentName, connectionCallback, bundle);
        }

        @Override
        public void getItem(@NonNull String string2, @NonNull ItemCallback itemCallback) {
            MediaBrowserCompatApi23.getItem(this.mBrowserObj, string2, itemCallback.mItemCallbackObj);
        }
    }

    static class MediaBrowserImplBase
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl {
        private static final int CONNECT_STATE_CONNECTED = 2;
        private static final int CONNECT_STATE_CONNECTING = 1;
        private static final int CONNECT_STATE_DISCONNECTED = 0;
        private static final int CONNECT_STATE_SUSPENDED = 3;
        private static final boolean DBG = false;
        private final ConnectionCallback mCallback;
        private Messenger mCallbacksMessenger;
        private final Context mContext;
        private Bundle mExtras;
        private final CallbackHandler mHandler = new CallbackHandler(this);
        private MediaSessionCompat.Token mMediaSessionToken;
        private final Bundle mRootHints;
        private String mRootId;
        private ServiceBinderWrapper mServiceBinderWrapper;
        private final ComponentName mServiceComponent;
        private MediaServiceConnection mServiceConnection;
        private int mState = 0;
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();

        public MediaBrowserImplBase(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (connectionCallback == null) {
                throw new IllegalArgumentException("connection callback must not be null");
            }
            this.mContext = context;
            this.mServiceComponent = componentName;
            this.mCallback = connectionCallback;
            this.mRootHints = bundle;
        }

        static /* synthetic */ ServiceBinderWrapper access$1102(MediaBrowserImplBase mediaBrowserImplBase, ServiceBinderWrapper serviceBinderWrapper) {
            mediaBrowserImplBase.mServiceBinderWrapper = serviceBinderWrapper;
            return serviceBinderWrapper;
        }

        static /* synthetic */ Messenger access$1202(MediaBrowserImplBase mediaBrowserImplBase, Messenger messenger) {
            mediaBrowserImplBase.mCallbacksMessenger = messenger;
            return messenger;
        }

        static /* synthetic */ int access$1402(MediaBrowserImplBase mediaBrowserImplBase, int n2) {
            mediaBrowserImplBase.mState = n2;
            return n2;
        }

        private void forceCloseConnection() {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            }
            this.mState = 0;
            this.mServiceConnection = null;
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mHandler.setCallbacksMessenger(null);
            this.mRootId = null;
            this.mMediaSessionToken = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static String getStateLabel(int n2) {
            switch (n2) {
                default: {
                    return "UNKNOWN/" + n2;
                }
                case 0: {
                    return "CONNECT_STATE_DISCONNECTED";
                }
                case 1: {
                    return "CONNECT_STATE_CONNECTING";
                }
                case 2: {
                    return "CONNECT_STATE_CONNECTED";
                }
                case 3: 
            }
            return "CONNECT_STATE_SUSPENDED";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isCurrent(Messenger messenger, String string2) {
            if (this.mCallbacksMessenger == messenger) return true;
            if (this.mState == 0) return false;
            Log.i((String)MediaBrowserCompat.TAG, (String)(string2 + " for " + this.mServiceComponent + " with mCallbacksMessenger=" + this.mCallbacksMessenger + " this=" + this));
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void connect() {
            MediaServiceConnection mediaServiceConnection;
            if (this.mState != 0) {
                throw new IllegalStateException("connect() called while not disconnected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            if (this.mServiceBinderWrapper != null) {
                throw new RuntimeException("mServiceBinderWrapper should be null. Instead it is " + this.mServiceBinderWrapper);
            }
            if (this.mCallbacksMessenger != null) {
                throw new RuntimeException("mCallbacksMessenger should be null. Instead it is " + this.mCallbacksMessenger);
            }
            this.mState = 1;
            Intent intent = new Intent("android.media.browse.MediaBrowserService");
            intent.setComponent(this.mServiceComponent);
            this.mServiceConnection = mediaServiceConnection = new MediaServiceConnection();
            boolean bl2 = false;
            try {
                boolean bl3;
                bl2 = bl3 = this.mContext.bindService(intent, (ServiceConnection)this.mServiceConnection, 1);
            }
            catch (Exception exception) {
                Log.e((String)MediaBrowserCompat.TAG, (String)("Failed binding to service " + this.mServiceComponent));
            }
            if (!bl2) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mediaServiceConnection == MediaBrowserImplBase.this.mServiceConnection) {
                            MediaBrowserImplBase.this.forceCloseConnection();
                            MediaBrowserImplBase.this.mCallback.onConnectionFailed();
                        }
                    }
                });
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void disconnect() {
            if (this.mCallbacksMessenger != null) {
                try {
                    this.mServiceBinderWrapper.disconnect(this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + this.mServiceComponent));
                }
            }
            this.forceCloseConnection();
        }

        void dump() {
            Log.d((String)MediaBrowserCompat.TAG, (String)"MediaBrowserCompat...");
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceComponent=" + this.mServiceComponent));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallback=" + this.mCallback));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootHints=" + this.mRootHints));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mState=" + MediaBrowserImplBase.getStateLabel(this.mState)));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceConnection=" + this.mServiceConnection));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceBinderWrapper=" + this.mServiceBinderWrapper));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallbacksMessenger=" + this.mCallbacksMessenger));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootId=" + this.mRootId));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mMediaSessionToken=" + this.mMediaSessionToken));
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mExtras;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void getItem(final @NonNull String string2, final @NonNull ItemCallback itemCallback) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("mediaId is empty.");
            }
            if (itemCallback == null) {
                throw new IllegalArgumentException("cb is null.");
            }
            if (this.mState != 2) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        itemCallback.onError(string2);
                    }
                });
                return;
            }
            ItemReceiver itemReceiver = new ItemReceiver(string2, itemCallback, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(string2, itemReceiver);
                return;
            }
            catch (RemoteException remoteException) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error getting media item.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        itemCallback.onError(string2);
                    }
                });
                return;
            }
        }

        @Override
        @NonNull
        public String getRoot() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getRoot() called while not connected(state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mRootId;
        }

        @Override
        @NonNull
        public ComponentName getServiceComponent() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
            }
            return this.mServiceComponent;
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.mState + ")");
            }
            return this.mMediaSessionToken;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isConnected() {
            if (this.mState != 2) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onConnectionFailed(Messenger messenger) {
            Log.e((String)MediaBrowserCompat.TAG, (String)("onConnectFailed for " + this.mServiceComponent));
            if (!this.isCurrent(messenger, "onConnectFailed")) {
                return;
            }
            if (this.mState != 1) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.forceCloseConnection();
            this.mCallback.onConnectionFailed();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onLoadChildren(Messenger object, String string2, List list, Bundle bundle) {
            if (!this.isCurrent((Messenger)object, "onLoadChildren")) {
                return;
            }
            object = (Subscription)this.mSubscriptions.get(string2);
            if (object == null) return;
            if ((object = ((Subscription)object).getCallback(bundle)) == null) return;
            if (bundle == null) {
                ((SubscriptionCallback)object).onChildrenLoaded(string2, list);
                return;
            }
            ((SubscriptionCallback)object).onChildrenLoaded(string2, list, bundle);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected(Messenger object, String string2, MediaSessionCompat.Token iterator, Bundle bundle) {
            if (!this.isCurrent((Messenger)object, "onConnect")) {
                return;
            }
            if (this.mState != 1) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.mRootId = string2;
            this.mMediaSessionToken = iterator;
            this.mExtras = bundle;
            this.mState = 2;
            this.mCallback.onConnected();
            try {
                object = this.mSubscriptions.entrySet().iterator();
                block2: while (true) {
                    if (!object.hasNext()) return;
                    iterator = (Map.Entry)object.next();
                    string2 = (String)iterator.getKey();
                    iterator = ((Subscription)iterator.getValue()).getOptionsList().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        bundle = iterator.next();
                        this.mServiceBinderWrapper.addSubscription(string2, bundle, this.mCallbacksMessenger);
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"addSubscription failed with RemoteException.");
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void subscribe(@NonNull String string2, Bundle bundle, @NonNull SubscriptionCallback subscriptionCallback) {
            Subscription subscription;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            if (subscriptionCallback == null) {
                throw new IllegalArgumentException("callback is null");
            }
            Subscription subscription2 = subscription = (Subscription)this.mSubscriptions.get(string2);
            if (subscription == null) {
                subscription2 = new Subscription();
                this.mSubscriptions.put(string2, subscription2);
            }
            subscription2.setCallbackForOptions(subscriptionCallback, bundle);
            if (this.mState != 2) return;
            try {
                this.mServiceBinderWrapper.addSubscription(string2, bundle, this.mCallbacksMessenger);
                return;
            }
            catch (RemoteException remoteException) {
                Log.d((String)MediaBrowserCompat.TAG, (String)("addSubscription failed with RemoteException parentId=" + string2));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void unsubscribe(@NonNull String string2, Bundle bundle) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            Subscription subscription = (Subscription)this.mSubscriptions.get(string2);
            if (subscription != null && subscription.remove(bundle) && this.mState == 2) {
                try {
                    this.mServiceBinderWrapper.removeSubscription(string2, bundle, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + string2));
                }
            }
            if (subscription != null && subscription.isEmpty()) {
                this.mSubscriptions.remove(string2);
            }
        }

        private class MediaServiceConnection
        implements ServiceConnection {
            private MediaServiceConnection() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isCurrent(String string2) {
                if (MediaBrowserImplBase.this.mServiceConnection == this) return true;
                if (MediaBrowserImplBase.this.mState == 0) return false;
                Log.i((String)MediaBrowserCompat.TAG, (String)(string2 + " for " + MediaBrowserImplBase.this.mServiceComponent + " with mServiceConnection=" + MediaBrowserImplBase.this.mServiceConnection + " this=" + this));
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void postOrRun(Runnable runnable) {
                if (Thread.currentThread() == MediaBrowserImplBase.this.mHandler.getLooper().getThread()) {
                    runnable.run();
                    return;
                }
                MediaBrowserImplBase.this.mHandler.post(runnable);
            }

            public void onServiceConnected(final ComponentName componentName, final IBinder iBinder) {
                this.postOrRun(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (!MediaServiceConnection.this.isCurrent("onServiceConnected")) {
                            return;
                        }
                        MediaBrowserImplBase.access$1102(MediaBrowserImplBase.this, new ServiceBinderWrapper(iBinder));
                        MediaBrowserImplBase.access$1202(MediaBrowserImplBase.this, new Messenger((Handler)MediaBrowserImplBase.this.mHandler));
                        MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(MediaBrowserImplBase.this.mCallbacksMessenger);
                        MediaBrowserImplBase.access$1402(MediaBrowserImplBase.this, 1);
                        try {
                            MediaBrowserImplBase.this.mServiceBinderWrapper.connect(MediaBrowserImplBase.this.mContext, MediaBrowserImplBase.this.mRootHints, MediaBrowserImplBase.this.mCallbacksMessenger);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + MediaBrowserImplBase.this.mServiceComponent));
                            return;
                        }
                    }
                });
            }

            public void onServiceDisconnected(final ComponentName componentName) {
                this.postOrRun(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (!MediaServiceConnection.this.isCurrent("onServiceDisconnected")) {
                            return;
                        }
                        MediaBrowserImplBase.access$1102(MediaBrowserImplBase.this, null);
                        MediaBrowserImplBase.access$1202(MediaBrowserImplBase.this, null);
                        MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(null);
                        MediaBrowserImplBase.access$1402(MediaBrowserImplBase.this, 3);
                        MediaBrowserImplBase.this.mCallback.onConnectionSuspended();
                    }
                });
            }
        }
    }

    static interface MediaBrowserServiceCallbackImpl {
        public void onConnectionFailed(Messenger var1);

        public void onLoadChildren(Messenger var1, String var2, List var3, Bundle var4);

        public void onServiceConnected(Messenger var1, String var2, MediaSessionCompat.Token var3, Bundle var4);
    }

    public static class MediaItem
    implements Parcelable {
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel parcel) {
                return new MediaItem(parcel);
            }

            public MediaItem[] newArray(int n2) {
                return new MediaItem[n2];
            }
        };
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        private final MediaDescriptionCompat mDescription;
        private final int mFlags;

        private MediaItem(Parcel parcel) {
            this.mFlags = parcel.readInt();
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(parcel);
        }

        public MediaItem(@NonNull MediaDescriptionCompat mediaDescriptionCompat, int n2) {
            if (mediaDescriptionCompat == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty((CharSequence)mediaDescriptionCompat.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = n2;
            this.mDescription = mediaDescriptionCompat;
        }

        public int describeContents() {
            return 0;
        }

        @NonNull
        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        public int getFlags() {
            return this.mFlags;
        }

        @NonNull
        public String getMediaId() {
            return this.mDescription.getMediaId();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isBrowsable() {
            if ((this.mFlags & 1) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isPlayable() {
            if ((this.mFlags & 2) == 0) return false;
            return true;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MediaItem{");
            stringBuilder.append("mFlags=").append(this.mFlags);
            stringBuilder.append(", mDescription=").append(this.mDescription);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.mFlags);
            this.mDescription.writeToParcel(parcel, n2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }

    private static class ServiceBinderWrapper {
        private Messenger mMessenger;

        public ServiceBinderWrapper(IBinder iBinder) {
            this.mMessenger = new Messenger(iBinder);
        }

        private void sendRequest(int n2, Bundle bundle, Messenger messenger) throws RemoteException {
            Message message = Message.obtain();
            message.what = n2;
            message.arg1 = 1;
            message.setData(bundle);
            message.replyTo = messenger;
            this.mMessenger.send(message);
        }

        void addSubscription(String string2, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", string2);
            bundle2.putBundle("data_options", bundle);
            this.sendRequest(3, bundle2, messenger);
        }

        void connect(Context context, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_package_name", context.getPackageName());
            bundle2.putBundle("data_root_hints", bundle);
            this.sendRequest(1, bundle2, messenger);
        }

        void disconnect(Messenger messenger) throws RemoteException {
            this.sendRequest(2, null, messenger);
        }

        void getMediaItem(String string2, ResultReceiver resultReceiver) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_media_item_id", string2);
            bundle.putParcelable("data_result_receiver", (Parcelable)resultReceiver);
            this.sendRequest(5, bundle, null);
        }

        void registerCallbackMessenger(Messenger messenger) throws RemoteException {
            this.sendRequest(6, null, messenger);
        }

        void removeSubscription(String string2, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", string2);
            bundle2.putBundle("data_options", bundle);
            this.sendRequest(4, bundle2, messenger);
        }

        void unregisterCallbackMessenger(Messenger messenger) throws RemoteException {
            this.sendRequest(7, null, messenger);
        }
    }

    private static class Subscription {
        private final List<SubscriptionCallback> mCallbacks = new ArrayList<SubscriptionCallback>();
        private final List<Bundle> mOptionsList = new ArrayList<Bundle>();

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SubscriptionCallback getCallback(Bundle object) {
            void var1_3;
            for (int i2 = 0; i2 < this.mOptionsList.size(); ++i2) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i2), object)) continue;
                SubscriptionCallback subscriptionCallback = this.mCallbacks.get(i2);
                return var1_3;
            }
            return var1_3;
        }

        public List<SubscriptionCallback> getCallbacks() {
            return this.mCallbacks;
        }

        public List<Bundle> getOptionsList() {
            return this.mOptionsList;
        }

        public boolean isEmpty() {
            return this.mCallbacks.isEmpty();
        }

        public boolean remove(Bundle bundle) {
            boolean bl2 = false;
            int n2 = 0;
            while (true) {
                block4: {
                    boolean bl3;
                    block3: {
                        bl3 = bl2;
                        if (n2 >= this.mOptionsList.size()) break block3;
                        if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(n2), bundle)) break block4;
                        this.mCallbacks.remove(n2);
                        this.mOptionsList.remove(n2);
                        bl3 = true;
                    }
                    return bl3;
                }
                ++n2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setCallbackForOptions(SubscriptionCallback subscriptionCallback, Bundle bundle) {
            for (int i2 = 0; i2 < this.mOptionsList.size(); ++i2) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i2), bundle)) continue;
                this.mCallbacks.set(i2, subscriptionCallback);
                return;
            }
            this.mCallbacks.add(subscriptionCallback);
            this.mOptionsList.add(bundle);
        }
    }

    public static abstract class SubscriptionCallback {
        public void onChildrenLoaded(@NonNull String string2, List<MediaItem> list) {
        }

        public void onChildrenLoaded(@NonNull String string2, List<MediaItem> list, @NonNull Bundle bundle) {
        }

        public void onError(@NonNull String string2) {
        }

        public void onError(@NonNull String string2, @NonNull Bundle bundle) {
        }
    }

    static class SubscriptionCallbackApi21
    extends SubscriptionCallback {
        private Bundle mOptions;
        SubscriptionCallback mSubscriptionCallback;
        private final Object mSubscriptionCallbackObj;

        public SubscriptionCallbackApi21(SubscriptionCallback subscriptionCallback, Bundle bundle) {
            this.mSubscriptionCallback = subscriptionCallback;
            this.mOptions = bundle;
            this.mSubscriptionCallbackObj = MediaBrowserCompatApi21.createSubscriptionCallback(new StubApi21());
        }

        @Override
        public void onChildrenLoaded(@NonNull String string2, List<MediaItem> list) {
            this.mSubscriptionCallback.onChildrenLoaded(string2, list);
        }

        @Override
        public void onChildrenLoaded(@NonNull String string2, List<MediaItem> list, @NonNull Bundle bundle) {
            this.mSubscriptionCallback.onChildrenLoaded(string2, list, bundle);
        }

        @Override
        public void onError(@NonNull String string2) {
            this.mSubscriptionCallback.onError(string2);
        }

        @Override
        public void onError(@NonNull String string2, @NonNull Bundle bundle) {
            this.mSubscriptionCallback.onError(string2, bundle);
        }

        private class StubApi21
        implements MediaBrowserCompatApi21.SubscriptionCallback {
            private StubApi21() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onChildrenLoaded(@NonNull String string2, List<Parcel> iterator) {
                ArrayList<MediaItem> arrayList = null;
                if (iterator != null) {
                    arrayList = new ArrayList<MediaItem>();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Parcel parcel = (Parcel)iterator.next();
                        parcel.setDataPosition(0);
                        arrayList.add((MediaItem)MediaItem.CREATOR.createFromParcel(parcel));
                        parcel.recycle();
                    }
                }
                if (SubscriptionCallbackApi21.this.mOptions != null) {
                    SubscriptionCallbackApi21.this.onChildrenLoaded(string2, MediaBrowserCompatUtils.applyOptions(arrayList, SubscriptionCallbackApi21.this.mOptions), SubscriptionCallbackApi21.this.mOptions);
                    return;
                }
                SubscriptionCallbackApi21.this.onChildrenLoaded(string2, arrayList);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onError(@NonNull String string2) {
                if (SubscriptionCallbackApi21.this.mOptions != null) {
                    SubscriptionCallbackApi21.this.onError(string2, SubscriptionCallbackApi21.this.mOptions);
                    return;
                }
                SubscriptionCallbackApi21.this.onError(string2);
            }
        }
    }
}

