/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.media.browse.MediaBrowser;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MediaBrowserCompatApi21 {
    static final String NULL_MEDIA_ITEM_ID = "android.support.v4.media.MediaBrowserCompat.NULL_MEDIA_ITEM";

    MediaBrowserCompatApi21() {
    }

    public static void connect(Object object) {
        ((MediaBrowser)object).connect();
    }

    public static Object createBrowser(Context context, ComponentName componentName, Object object, Bundle bundle) {
        return new MediaBrowser(context, componentName, (MediaBrowser.ConnectionCallback)object, bundle);
    }

    public static Object createConnectionCallback(ConnectionCallback connectionCallback) {
        return new ConnectionCallbackProxy<ConnectionCallback>(connectionCallback);
    }

    public static Object createSubscriptionCallback(SubscriptionCallback subscriptionCallback) {
        return new SubscriptionCallbackProxy<SubscriptionCallback>(subscriptionCallback);
    }

    public static void disconnect(Object object) {
        ((MediaBrowser)object).disconnect();
    }

    public static Bundle getExtras(Object object) {
        return ((MediaBrowser)object).getExtras();
    }

    public static String getRoot(Object object) {
        return ((MediaBrowser)object).getRoot();
    }

    public static ComponentName getServiceComponent(Object object) {
        return ((MediaBrowser)object).getServiceComponent();
    }

    public static Object getSessionToken(Object object) {
        return ((MediaBrowser)object).getSessionToken();
    }

    public static boolean isConnected(Object object) {
        return ((MediaBrowser)object).isConnected();
    }

    public static void subscribe(Object object, String string2, Object object2) {
        ((MediaBrowser)object).subscribe(string2, (MediaBrowser.SubscriptionCallback)object2);
    }

    public static void unsubscribe(Object object, String string2) {
        ((MediaBrowser)object).unsubscribe(string2);
    }

    static interface ConnectionCallback {
        public void onConnected();

        public void onConnectionFailed();

        public void onConnectionSuspended();
    }

    static class ConnectionCallbackProxy<T extends ConnectionCallback>
    extends MediaBrowser.ConnectionCallback {
        protected final T mConnectionCallback;

        public ConnectionCallbackProxy(T t2) {
            this.mConnectionCallback = t2;
        }

        public void onConnected() {
            this.mConnectionCallback.onConnected();
        }

        public void onConnectionFailed() {
            this.mConnectionCallback.onConnectionFailed();
        }

        public void onConnectionSuspended() {
            this.mConnectionCallback.onConnectionSuspended();
        }
    }

    static interface SubscriptionCallback {
        public void onChildrenLoaded(@NonNull String var1, List<Parcel> var2);

        public void onError(@NonNull String var1);
    }

    static class SubscriptionCallbackProxy<T extends SubscriptionCallback>
    extends MediaBrowser.SubscriptionCallback {
        protected final T mSubscriptionCallback;

        public SubscriptionCallbackProxy(T t2) {
            this.mSubscriptionCallback = t2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onChildrenLoaded(@NonNull String string2, List<MediaBrowser.MediaItem> object) {
            Object object2 = object;
            if (object != null) {
                object2 = object;
                if (object.size() == 1) {
                    object2 = object;
                    if (((MediaBrowser.MediaItem)object.get(0)).getMediaId().equals(MediaBrowserCompatApi21.NULL_MEDIA_ITEM_ID)) {
                        object2 = null;
                    }
                }
            }
            if (object2 != null) {
                object = new ArrayList();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    MediaBrowser.MediaItem mediaItem = (MediaBrowser.MediaItem)iterator.next();
                    object2 = Parcel.obtain();
                    mediaItem.writeToParcel((Parcel)object2, 0);
                    object.add(object2);
                }
            } else {
                object = null;
            }
            this.mSubscriptionCallback.onChildrenLoaded(string2, (List<Parcel>)object);
        }

        public void onError(@NonNull String string2) {
            this.mSubscriptionCallback.onError(string2);
        }
    }
}

