/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintManager;
import android.print.pdf.PrintedPdfDocument;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PrintHelperKitkat {
    public static final int COLOR_MODE_COLOR = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    private static final String LOG_TAG = "PrintHelperKitkat";
    private static final int MAX_PRINT_SIZE = 3500;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    public static final int SCALE_MODE_FILL = 2;
    public static final int SCALE_MODE_FIT = 1;
    int mColorMode = 2;
    final Context mContext;
    BitmapFactory.Options mDecodeOptions = null;
    private final Object mLock = new Object();
    int mOrientation = 1;
    int mScaleMode = 2;

    PrintHelperKitkat(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bitmap convertBitmapForColorMode(Bitmap bitmap, int n2) {
        if (n2 != 1) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        canvas.setBitmap(null);
        return bitmap2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Matrix getMatrix(int n2, int n3, RectF rectF, int n4) {
        Matrix matrix = new Matrix();
        float f2 = rectF.width() / (float)n2;
        f2 = n4 == 2 ? Math.max(f2, rectF.height() / (float)n3) : Math.min(f2, rectF.height() / (float)n3);
        matrix.postScale(f2, f2);
        matrix.postTranslate((rectF.width() - (float)n2 * f2) / 2.0f, (rectF.height() - f2 * (float)n3) / 2.0f);
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap loadBitmap(Uri object, BitmapFactory.Options options) throws FileNotFoundException {
        Object object2 = null;
        if (object == null) throw new IllegalArgumentException("bad argument to loadBitmap");
        if (this.mContext == null) {
            throw new IllegalArgumentException("bad argument to loadBitmap");
        }
        try {
            object2 = object = this.mContext.getContentResolver().openInputStream((Uri)object);
            options = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options);
            if (object == null) return options;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {
                Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
                throw throwable;
            }
            throw throwable;
        }
        try {
            ((InputStream)object).close();
            return options;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)"close fail ", (Throwable)iOException);
            return options;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap loadConstrainedBitmap(Uri object, int n2) throws FileNotFoundException {
        int n3 = 1;
        BitmapFactory.Options options = null;
        if (n2 <= 0) throw new IllegalArgumentException("bad argument to getScaledBitmap");
        if (object == null) throw new IllegalArgumentException("bad argument to getScaledBitmap");
        if (this.mContext == null) {
            throw new IllegalArgumentException("bad argument to getScaledBitmap");
        }
        Object object2 = new BitmapFactory.Options();
        object2.inJustDecodeBounds = true;
        this.loadBitmap((Uri)object, (BitmapFactory.Options)object2);
        int n4 = object2.outWidth;
        int n5 = object2.outHeight;
        object2 = options;
        if (n4 <= 0) return object2;
        if (n5 <= 0) {
            return options;
        }
        for (int i2 = Math.max(n4, n5); i2 > n2; i2 >>>= 1, n3 <<= 1) {
        }
        object2 = options;
        if (n3 <= 0) return object2;
        object2 = options;
        if (Math.min(n4, n5) / n3 <= 0) return object2;
        object2 = this.mLock;
        synchronized (object2) {
            this.mDecodeOptions = options = new BitmapFactory.Options();
            this.mDecodeOptions.inMutable = true;
            this.mDecodeOptions.inSampleSize = n3;
            options = this.mDecodeOptions;
        }
        try {
            object2 = this.loadBitmap((Uri)object, options);
            return object2;
        }
        finally {
            object = this.mLock;
            synchronized (object) {
                this.mDecodeOptions = null;
                return object2;
            }
        }
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getScaleMode() {
        return this.mScaleMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printBitmap(final String string2, final Bitmap bitmap, final OnPrintFinishCallback onPrintFinishCallback) {
        if (bitmap == null) {
            return;
        }
        final int n2 = this.mScaleMode;
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        PrintAttributes.MediaSize mediaSize = PrintAttributes.MediaSize.UNKNOWN_PORTRAIT;
        if (bitmap.getWidth() > bitmap.getHeight()) {
            mediaSize = PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE;
        }
        mediaSize = new PrintAttributes.Builder().setMediaSize(mediaSize).setColorMode(this.mColorMode).build();
        printManager.print(string2, new PrintDocumentAdapter(){
            private PrintAttributes mAttributes;

            public void onFinish() {
                if (onPrintFinishCallback != null) {
                    onPrintFinishCallback.onFinish();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void onLayout(PrintAttributes printAttributes, PrintAttributes printAttributes2, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                boolean bl2 = true;
                this.mAttributes = printAttributes2;
                cancellationSignal = new PrintDocumentInfo.Builder(string2).setContentType(1).setPageCount(1).build();
                if (printAttributes2.equals((Object)printAttributes)) {
                    bl2 = false;
                }
                layoutResultCallback.onLayoutFinished((PrintDocumentInfo)cancellationSignal, bl2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onWrite(PageRange[] bitmap2, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                cancellationSignal = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                bitmap2 = PrintHelperKitkat.this.convertBitmapForColorMode(bitmap, this.mAttributes.getColorMode());
                try {
                    PdfDocument.Page page = cancellationSignal.startPage(1);
                    RectF rectF = new RectF(page.getInfo().getContentRect());
                    rectF = PrintHelperKitkat.this.getMatrix(bitmap2.getWidth(), bitmap2.getHeight(), rectF, n2);
                    page.getCanvas().drawBitmap(bitmap2, (Matrix)rectF, null);
                    cancellationSignal.finishPage(page);
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                        cancellationSignal.writeTo((OutputStream)fileOutputStream);
                        writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                        return;
                    }
                    catch (IOException iOException) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)iOException);
                        writeResultCallback.onWriteFailed(null);
                        return;
                    }
                }
                finally {
                    if (cancellationSignal != null) {
                        cancellationSignal.close();
                    }
                    if (parcelFileDescriptor != null) {
                        parcelFileDescriptor.close();
                    }
                    if (bitmap2 != bitmap) {
                        bitmap2.recycle();
                    }
                }
            }
        }, (PrintAttributes)mediaSize);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void printBitmap(final String string2, final Uri uri, final OnPrintFinishCallback onPrintFinishCallback) throws FileNotFoundException {
        PrintDocumentAdapter printDocumentAdapter = new PrintDocumentAdapter(){
            private PrintAttributes mAttributes;
            Bitmap mBitmap = null;
            AsyncTask<Uri, Boolean, Bitmap> mLoadBitmap;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void cancelLoad() {
                Object object = PrintHelperKitkat.this.mLock;
                synchronized (object) {
                    if (PrintHelperKitkat.this.mDecodeOptions != null) {
                        PrintHelperKitkat.this.mDecodeOptions.requestCancelDecode();
                        PrintHelperKitkat.this.mDecodeOptions = null;
                    }
                    return;
                }
            }

            public void onFinish() {
                super.onFinish();
                this.cancelLoad();
                if (this.mLoadBitmap != null) {
                    this.mLoadBitmap.cancel(true);
                }
                if (onPrintFinishCallback != null) {
                    onPrintFinishCallback.onFinish();
                }
                if (this.mBitmap != null) {
                    this.mBitmap.recycle();
                    this.mBitmap = null;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void onLayout(final PrintAttributes printAttributes, final PrintAttributes printAttributes2, final CancellationSignal cancellationSignal, final PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                boolean bl2 = true;
                this.mAttributes = printAttributes2;
                if (cancellationSignal.isCanceled()) {
                    layoutResultCallback.onLayoutCancelled();
                    return;
                }
                if (this.mBitmap == null) {
                    this.mLoadBitmap = new AsyncTask<Uri, Boolean, Bitmap>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        protected Bitmap doInBackground(Uri ... bitmap) {
                            try {
                                return PrintHelperKitkat.this.loadConstrainedBitmap(uri, 3500);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                return null;
                            }
                        }

                        protected void onCancelled(Bitmap bitmap) {
                            layoutResultCallback.onLayoutCancelled();
                            mLoadBitmap = null;
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        protected void onPostExecute(Bitmap bitmap) {
                            boolean bl2 = true;
                            super.onPostExecute((Object)bitmap);
                            mBitmap = bitmap;
                            if (bitmap != null) {
                                bitmap = new PrintDocumentInfo.Builder(string2).setContentType(1).setPageCount(1).build();
                                if (printAttributes2.equals((Object)printAttributes)) {
                                    bl2 = false;
                                }
                                layoutResultCallback.onLayoutFinished((PrintDocumentInfo)bitmap, bl2);
                            } else {
                                layoutResultCallback.onLayoutFailed(null);
                            }
                            mLoadBitmap = null;
                        }

                        protected void onPreExecute() {
                            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                                public void onCancel() {
                                    this.cancelLoad();
                                    this.cancel(false);
                                }
                            });
                        }
                    }.execute((Object[])new Uri[0]);
                    return;
                }
                cancellationSignal = new PrintDocumentInfo.Builder(string2).setContentType(1).setPageCount(1).build();
                if (printAttributes2.equals((Object)printAttributes)) {
                    bl2 = false;
                }
                layoutResultCallback.onLayoutFinished((PrintDocumentInfo)cancellationSignal, bl2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onWrite(PageRange[] bitmap, ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                cancellationSignal = new PrintedPdfDocument(PrintHelperKitkat.this.mContext, this.mAttributes);
                bitmap = PrintHelperKitkat.this.convertBitmapForColorMode(this.mBitmap, this.mAttributes.getColorMode());
                try {
                    PdfDocument.Page page = cancellationSignal.startPage(1);
                    RectF rectF = new RectF(page.getInfo().getContentRect());
                    rectF = PrintHelperKitkat.this.getMatrix(this.mBitmap.getWidth(), this.mBitmap.getHeight(), rectF, mScaleMode);
                    page.getCanvas().drawBitmap(bitmap, (Matrix)rectF, null);
                    cancellationSignal.finishPage(page);
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                        cancellationSignal.writeTo((OutputStream)fileOutputStream);
                        writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                        return;
                    }
                    catch (IOException iOException) {
                        Log.e((String)PrintHelperKitkat.LOG_TAG, (String)"Error writing printed content", (Throwable)iOException);
                        writeResultCallback.onWriteFailed(null);
                        return;
                    }
                }
                finally {
                    if (cancellationSignal != null) {
                        cancellationSignal.close();
                    }
                    if (parcelFileDescriptor != null) {
                        parcelFileDescriptor.close();
                    }
                    if (bitmap != this.mBitmap) {
                        bitmap.recycle();
                    }
                }
            }
        };
        PrintManager printManager = (PrintManager)this.mContext.getSystemService("print");
        uri = new PrintAttributes.Builder();
        uri.setColorMode(this.mColorMode);
        if (this.mOrientation == 1) {
            uri.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_LANDSCAPE);
        } else if (this.mOrientation == 2) {
            uri.setMediaSize(PrintAttributes.MediaSize.UNKNOWN_PORTRAIT);
        }
        printManager.print(string2, printDocumentAdapter, uri.build());
    }

    public void setColorMode(int n2) {
        this.mColorMode = n2;
    }

    public void setOrientation(int n2) {
        this.mOrientation = n2;
    }

    public void setScaleMode(int n2) {
        this.mScaleMode = n2;
    }

    public static interface OnPrintFinishCallback {
        public void onFinish();
    }
}

