/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.provider.DocumentsContractApi19;
import android.support.v4.provider.DocumentsContractApi21;
import android.support.v4.provider.RawDocumentFile;
import android.support.v4.provider.SingleDocumentFile;
import android.support.v4.provider.TreeDocumentFile;
import java.io.File;

public abstract class DocumentFile {
    static final String TAG = "DocumentFile";
    private final DocumentFile mParent;

    DocumentFile(DocumentFile documentFile) {
        this.mParent = documentFile;
    }

    public static DocumentFile fromFile(File file) {
        return new RawDocumentFile(null, file);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DocumentFile fromSingleUri(Context object, Uri uri) {
        void var1_4;
        void var0_2;
        if (Build.VERSION.SDK_INT < 19) return var0_2;
        SingleDocumentFile singleDocumentFile = new SingleDocumentFile(null, (Context)object, (Uri)var1_4);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DocumentFile fromTreeUri(Context object, Uri uri) {
        void var1_4;
        void var0_2;
        if (Build.VERSION.SDK_INT < 21) return var0_2;
        TreeDocumentFile treeDocumentFile = new TreeDocumentFile(null, (Context)object, DocumentsContractApi21.prepareTreeUri((Uri)var1_4));
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDocumentUri(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT < 19) return false;
        return DocumentsContractApi19.isDocumentUri(context, uri);
    }

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract DocumentFile createDirectory(String var1);

    public abstract DocumentFile createFile(String var1, String var2);

    public abstract boolean delete();

    public abstract boolean exists();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentFile findFile(String object) {
        DocumentFile[] documentFileArray = this.listFiles();
        int n2 = documentFileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DocumentFile documentFile = documentFileArray[n3];
            if (((String)object).equals(documentFile.getName())) {
                return documentFile;
            }
            ++n3;
        }
        return null;
    }

    public abstract String getName();

    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract String getType();

    public abstract Uri getUri();

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract long lastModified();

    public abstract long length();

    public abstract DocumentFile[] listFiles();

    public abstract boolean renameTo(String var1);
}

