/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

class ICUCompatIcs {
    private static final String TAG = "ICUCompatIcs";
    private static Method sAddLikelySubtagsMethod;
    private static Method sGetScriptMethod;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class<?> clazz = Class.forName("libcore.icu.ICU");
            if (clazz == null) return;
            sGetScriptMethod = clazz.getMethod("getScript", String.class);
            sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
            return;
        }
        catch (Exception exception) {
            sGetScriptMethod = null;
            sAddLikelySubtagsMethod = null;
            Log.w((String)TAG, (Throwable)exception);
            return;
        }
    }

    ICUCompatIcs() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String addLikelySubtags(Locale object) {
        object = ((Locale)object).toString();
        try {
            if (sAddLikelySubtagsMethod == null) return object;
            String string2 = (String)sAddLikelySubtagsMethod.invoke(null, object);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (Throwable)illegalAccessException);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)TAG, (Throwable)invocationTargetException);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getScript(String string2) {
        try {
            if (sGetScriptMethod == null) return null;
            return (String)sGetScriptMethod.invoke(null, string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (Throwable)illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)TAG, (Throwable)invocationTargetException);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String maximizeAndGetScript(Locale object) {
        if ((object = ICUCompatIcs.addLikelySubtags((Locale)object)) == null) return null;
        return ICUCompatIcs.getScript((String)object);
    }
}

