/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;

public final class GestureDetectorCompat {
    private final GestureDetectorCompatImpl mImpl;

    public GestureDetectorCompat(Context context, GestureDetector.OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GestureDetectorCompat(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
        if (Build.VERSION.SDK_INT > 17) {
            this.mImpl = new GestureDetectorCompatImplJellybeanMr2(context, onGestureListener, handler);
            return;
        }
        this.mImpl = new GestureDetectorCompatImplBase(context, onGestureListener, handler);
    }

    public boolean isLongpressEnabled() {
        return this.mImpl.isLongpressEnabled();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.mImpl.onTouchEvent(motionEvent);
    }

    public void setIsLongpressEnabled(boolean bl2) {
        this.mImpl.setIsLongpressEnabled(bl2);
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mImpl.setOnDoubleTapListener(onDoubleTapListener);
    }

    static interface GestureDetectorCompatImpl {
        public boolean isLongpressEnabled();

        public boolean onTouchEvent(MotionEvent var1);

        public void setIsLongpressEnabled(boolean var1);

        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener var1);
    }

    static class GestureDetectorCompatImplBase
    implements GestureDetectorCompatImpl {
        private static final int DOUBLE_TAP_TIMEOUT;
        private static final int LONGPRESS_TIMEOUT;
        private static final int LONG_PRESS = 2;
        private static final int SHOW_PRESS = 1;
        private static final int TAP = 3;
        private static final int TAP_TIMEOUT;
        private boolean mAlwaysInBiggerTapRegion;
        private boolean mAlwaysInTapRegion;
        private MotionEvent mCurrentDownEvent;
        private boolean mDeferConfirmSingleTap;
        private GestureDetector.OnDoubleTapListener mDoubleTapListener;
        private int mDoubleTapSlopSquare;
        private float mDownFocusX;
        private float mDownFocusY;
        private final Handler mHandler;
        private boolean mInLongPress;
        private boolean mIsDoubleTapping;
        private boolean mIsLongpressEnabled;
        private float mLastFocusX;
        private float mLastFocusY;
        private final GestureDetector.OnGestureListener mListener;
        private int mMaximumFlingVelocity;
        private int mMinimumFlingVelocity;
        private MotionEvent mPreviousUpEvent;
        private boolean mStillDown;
        private int mTouchSlopSquare;
        private VelocityTracker mVelocityTracker;

        static {
            LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
            TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
            DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
        }

        /*
         * Enabled aggressive block sorting
         */
        public GestureDetectorCompatImplBase(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
            this.mHandler = handler != null ? new GestureHandler(handler) : new GestureHandler();
            this.mListener = onGestureListener;
            if (onGestureListener instanceof GestureDetector.OnDoubleTapListener) {
                this.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)onGestureListener);
            }
            this.init(context);
        }

        static /* synthetic */ boolean access$502(GestureDetectorCompatImplBase gestureDetectorCompatImplBase, boolean bl2) {
            gestureDetectorCompatImplBase.mDeferConfirmSingleTap = bl2;
            return bl2;
        }

        private void cancel() {
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
            this.mIsDoubleTapping = false;
            this.mStillDown = false;
            this.mAlwaysInTapRegion = false;
            this.mAlwaysInBiggerTapRegion = false;
            this.mDeferConfirmSingleTap = false;
            if (this.mInLongPress) {
                this.mInLongPress = false;
            }
        }

        private void cancelTaps() {
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mIsDoubleTapping = false;
            this.mAlwaysInTapRegion = false;
            this.mAlwaysInBiggerTapRegion = false;
            this.mDeferConfirmSingleTap = false;
            if (this.mInLongPress) {
                this.mInLongPress = false;
            }
        }

        private void dispatchLongPress() {
            this.mHandler.removeMessages(3);
            this.mDeferConfirmSingleTap = false;
            this.mInLongPress = true;
            this.mListener.onLongPress(this.mCurrentDownEvent);
        }

        private void init(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("OnGestureListener must not be null");
            }
            this.mIsLongpressEnabled = true;
            context = ViewConfiguration.get((Context)context);
            int n2 = context.getScaledTouchSlop();
            int n3 = context.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = context.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = context.getScaledMaximumFlingVelocity();
            this.mTouchSlopSquare = n2 * n2;
            this.mDoubleTapSlopSquare = n3 * n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
            boolean bl2 = false;
            if (!this.mAlwaysInBiggerTapRegion) {
                return bl2;
            }
            boolean bl3 = bl2;
            if (motionEvent3.getEventTime() - motionEvent2.getEventTime() > (long)DOUBLE_TAP_TIMEOUT) return bl3;
            int n2 = (int)motionEvent.getX() - (int)motionEvent3.getX();
            int n3 = (int)motionEvent.getY() - (int)motionEvent3.getY();
            bl3 = bl2;
            if (n2 * n2 + n3 * n3 >= this.mDoubleTapSlopSquare) return bl3;
            return true;
        }

        @Override
        public boolean isLongpressEnabled() {
            return this.mIsLongpressEnabled;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean onTouchEvent(MotionEvent var1_1) {
            block30: {
                block29: {
                    block28: {
                        block32: {
                            block31: {
                                var2_2 = 0;
                                var3_3 = var1_1.getAction();
                                if (this.mVelocityTracker == null) {
                                    this.mVelocityTracker = VelocityTracker.obtain();
                                }
                                this.mVelocityTracker.addMovement(var1_1);
                                if ((var3_3 & 255) != 6) break block31;
                                var4_4 = 1;
lbl8:
                                // 2 sources

                                while (var4_4 != 0) {
                                    var5_5 = MotionEventCompat.getActionIndex(var1_1);
lbl10:
                                    // 2 sources

                                    while (true) {
                                        var6_6 = MotionEventCompat.getPointerCount(var1_1);
                                        var8_8 = 0.0f;
                                        var9_9 = 0.0f;
                                        block11: for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
                                            if (var5_5 == var7_7) lbl-1000:
                                            // 2 sources

                                            {
                                                continue block11;
                                            }
                                            break block28;
                                        }
                                        break block29;
                                        break;
                                    }
                                }
                                break block32;
                            }
                            var4_4 = 0;
                            ** GOTO lbl8
                        }
                        var5_5 = -1;
                        ** while (true)
                    }
                    var9_9 += MotionEventCompat.getX(var1_1, var7_7);
                    var8_8 += MotionEventCompat.getY(var1_1, var7_7);
                    ** while (true)
                }
                if (var4_4 == 0) ** GOTO lbl43
                var4_4 = var6_6 - 1;
                block13: while (true) {
                    var9_9 /= (float)var4_4;
                    var8_8 /= (float)var4_4;
                    var10_10 = var2_2;
                    switch (var3_3 & 255) {
                        default: {
                            var10_10 = var2_2;
                        }
lbl41:
                        // 13 sources

                        case 4: {
                            return (boolean)var10_10;
                        }
lbl43:
                        // 1 sources

                        var4_4 = var6_6;
                        continue block13;
                        case 5: {
                            this.mLastFocusX = var9_9;
                            this.mDownFocusX = var9_9;
                            this.mLastFocusY = var8_8;
                            this.mDownFocusY = var8_8;
                            this.cancelTaps();
                            var10_10 = var2_2;
                            ** GOTO lbl41
                        }
                        case 6: {
                            this.mLastFocusX = var9_9;
                            this.mDownFocusX = var9_9;
                            this.mLastFocusY = var8_8;
                            this.mDownFocusY = var8_8;
                            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                            var5_5 = MotionEventCompat.getActionIndex(var1_1);
                            var4_4 = MotionEventCompat.getPointerId(var1_1, var5_5);
                            var8_8 = VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, var4_4);
                            var11_11 = VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, var4_4);
                            var4_4 = 0;
                            block15: while (true) {
                                var10_10 = var2_2;
                                if (var4_4 >= var6_6) ** GOTO lbl41
                                if (var4_4 != var5_5) break;
                                while (true) {
                                    ++var4_4;
                                    continue block15;
                                    break;
                                }
                                break;
                            }
                            var7_7 = MotionEventCompat.getPointerId(var1_1, var4_4);
                            var9_9 = VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, var7_7);
                            if (!(VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, var7_7) * var11_11 + var9_9 * var8_8 < 0.0f)) ** continue;
                            this.mVelocityTracker.clear();
                            var10_10 = var2_2;
                            ** GOTO lbl41
                        }
                        case 0: {
                            if (this.mDoubleTapListener == null) ** GOTO lbl108
                            var10_10 = this.mHandler.hasMessages(3);
                            if (var10_10 != 0) {
                                this.mHandler.removeMessages(3);
                            }
                            if (this.mCurrentDownEvent == null || this.mPreviousUpEvent == null || var10_10 == 0 || !this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, var1_1)) ** GOTO lbl106
                            this.mIsDoubleTapping = true;
                            var4_4 = this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent) | false | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
lbl85:
                            // 2 sources

                            while (true) {
                                this.mLastFocusX = var9_9;
                                this.mDownFocusX = var9_9;
                                this.mLastFocusY = var8_8;
                                this.mDownFocusY = var8_8;
                                if (this.mCurrentDownEvent != null) {
                                    this.mCurrentDownEvent.recycle();
                                }
                                this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)var1_1);
                                this.mAlwaysInTapRegion = true;
                                this.mAlwaysInBiggerTapRegion = true;
                                this.mStillDown = true;
                                this.mInLongPress = false;
                                this.mDeferConfirmSingleTap = false;
                                if (this.mIsLongpressEnabled) {
                                    this.mHandler.removeMessages(2);
                                    this.mHandler.sendEmptyMessageAtTime(2, this.mCurrentDownEvent.getDownTime() + (long)GestureDetectorCompatImplBase.TAP_TIMEOUT + (long)GestureDetectorCompatImplBase.LONGPRESS_TIMEOUT);
                                }
                                this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)GestureDetectorCompatImplBase.TAP_TIMEOUT);
                                var10_10 = var4_4 | this.mListener.onDown(var1_1);
                                ** GOTO lbl41
                                break;
                            }
lbl106:
                            // 1 sources

                            this.mHandler.sendEmptyMessageDelayed(3, (long)GestureDetectorCompatImplBase.DOUBLE_TAP_TIMEOUT);
lbl108:
                            // 2 sources

                            var4_4 = 0;
                            ** continue;
                        }
                        case 2: {
                            var10_10 = var2_2;
                            if (this.mInLongPress) ** GOTO lbl41
                            var11_12 = this.mLastFocusX - var9_9;
                            var12_13 = this.mLastFocusY - var8_8;
                            if (!this.mIsDoubleTapping) ** GOTO lbl118
                            var10_10 = 0 | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
                            ** GOTO lbl41
lbl118:
                            // 1 sources

                            if (!this.mAlwaysInTapRegion) ** GOTO lbl133
                            var5_5 = (int)(var9_9 - this.mDownFocusX);
                            var4_4 = (int)(var8_8 - this.mDownFocusY);
                            if ((var4_4 = var5_5 * var5_5 + var4_4 * var4_4) <= this.mTouchSlopSquare) break block30;
                            var10_10 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var11_12, var12_13);
                            this.mLastFocusX = var9_9;
                            this.mLastFocusY = var8_8;
                            this.mAlwaysInTapRegion = false;
                            this.mHandler.removeMessages(3);
                            this.mHandler.removeMessages(1);
                            this.mHandler.removeMessages(2);
lbl129:
                            // 2 sources

                            while (true) {
                                if (var4_4 > this.mTouchSlopSquare) {
                                    this.mAlwaysInBiggerTapRegion = false;
                                }
                                ** GOTO lbl41
                                break;
                            }
lbl133:
                            // 1 sources

                            if (Math.abs(var11_12) >= 1.0f) ** GOTO lbl136
                            var10_10 = var2_2;
                            if (!(Math.abs(var12_13) >= 1.0f)) ** GOTO lbl41
lbl136:
                            // 2 sources

                            var10_10 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var11_12, var12_13);
                            this.mLastFocusX = var9_9;
                            this.mLastFocusY = var8_8;
                            ** GOTO lbl41
                        }
                        case 1: {
                            this.mStillDown = false;
                            var13_14 = MotionEvent.obtain((MotionEvent)var1_1);
                            if (!this.mIsDoubleTapping) ** GOTO lbl157
                            var10_10 = this.mDoubleTapListener.onDoubleTapEvent(var1_1) | 0;
lbl145:
                            // 7 sources

                            while (true) {
                                if (this.mPreviousUpEvent != null) {
                                    this.mPreviousUpEvent.recycle();
                                }
                                this.mPreviousUpEvent = var13_14;
                                if (this.mVelocityTracker != null) {
                                    this.mVelocityTracker.recycle();
                                    this.mVelocityTracker = null;
                                }
                                this.mIsDoubleTapping = false;
                                this.mDeferConfirmSingleTap = false;
                                this.mHandler.removeMessages(1);
                                this.mHandler.removeMessages(2);
                                ** GOTO lbl41
                                break;
                            }
lbl157:
                            // 1 sources

                            if (!this.mInLongPress) ** GOTO lbl162
                            this.mHandler.removeMessages(3);
                            this.mInLongPress = false;
                            var10_10 = 0;
                            ** GOTO lbl145
lbl162:
                            // 1 sources

                            if (!this.mAlwaysInTapRegion) ** GOTO lbl171
                            var10_10 = var2_2 = this.mListener.onSingleTapUp(var1_1);
                            if (!this.mDeferConfirmSingleTap) ** GOTO lbl145
                            var10_10 = var2_2;
                            if (this.mDoubleTapListener == null) ** GOTO lbl145
                            this.mDoubleTapListener.onSingleTapConfirmed(var1_1);
                            var10_10 = var2_2;
                            ** GOTO lbl145
lbl171:
                            // 1 sources

                            var14_15 = this.mVelocityTracker;
                            var4_4 = MotionEventCompat.getPointerId(var1_1, 0);
                            var14_15.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                            var9_9 = VelocityTrackerCompat.getYVelocity(var14_15, var4_4);
                            var8_8 = VelocityTrackerCompat.getXVelocity(var14_15, var4_4);
                            if (!(Math.abs(var9_9) > (float)this.mMinimumFlingVelocity) && !(Math.abs(var8_8) > (float)this.mMinimumFlingVelocity)) break block13;
                            var10_10 = this.mListener.onFling(this.mCurrentDownEvent, var1_1, var8_8, var9_9);
                            ** GOTO lbl145
                        }
                        case 3: {
                            this.cancel();
                            var10_10 = var2_2;
                            ** GOTO lbl41
                        }
                    }
                    break;
                }
                var10_10 = 0;
                ** while (true)
            }
            var10_10 = 0;
            ** while (true)
        }

        @Override
        public void setIsLongpressEnabled(boolean bl2) {
            this.mIsLongpressEnabled = bl2;
        }

        @Override
        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
            this.mDoubleTapListener = onDoubleTapListener;
        }

        private class GestureHandler
        extends Handler {
            GestureHandler() {
            }

            GestureHandler(Handler handler) {
                super(handler.getLooper());
            }

            /*
             * Enabled aggressive block sorting
             */
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        throw new RuntimeException("Unknown message " + message);
                    }
                    case 1: {
                        GestureDetectorCompatImplBase.this.mListener.onShowPress(GestureDetectorCompatImplBase.this.mCurrentDownEvent);
                        return;
                    }
                    case 2: {
                        GestureDetectorCompatImplBase.this.dispatchLongPress();
                        return;
                    }
                    case 3: 
                }
                if (GestureDetectorCompatImplBase.this.mDoubleTapListener == null) return;
                if (!GestureDetectorCompatImplBase.this.mStillDown) {
                    GestureDetectorCompatImplBase.this.mDoubleTapListener.onSingleTapConfirmed(GestureDetectorCompatImplBase.this.mCurrentDownEvent);
                    return;
                }
                GestureDetectorCompatImplBase.access$502(GestureDetectorCompatImplBase.this, true);
            }
        }
    }

    static class GestureDetectorCompatImplJellybeanMr2
    implements GestureDetectorCompatImpl {
        private final GestureDetector mDetector;

        public GestureDetectorCompatImplJellybeanMr2(Context context, GestureDetector.OnGestureListener onGestureListener, Handler handler) {
            this.mDetector = new GestureDetector(context, onGestureListener, handler);
        }

        @Override
        public boolean isLongpressEnabled() {
            return this.mDetector.isLongpressEnabled();
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return this.mDetector.onTouchEvent(motionEvent);
        }

        @Override
        public void setIsLongpressEnabled(boolean bl2) {
            this.mDetector.setIsLongpressEnabled(bl2);
        }

        @Override
        public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
            this.mDetector.setOnDoubleTapListener(onDoubleTapListener);
        }
    }
}

