/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompatHoneycomb;
import android.support.v4.view.MenuItemCompatIcs;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;

public final class MenuItemCompat {
    static final MenuVersionImpl IMPL;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    private static final String TAG = "MenuItemCompat";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 14) {
            IMPL = new IcsMenuVersionImpl();
            return;
        }
        if (n2 >= 11) {
            IMPL = new HoneycombMenuVersionImpl();
            return;
        }
        IMPL = new BaseMenuVersionImpl();
    }

    private MenuItemCompat() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collapseActionView(MenuItem menuItem) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.collapseActionView(menuItem);
        return ((SupportMenuItem)menuItem).collapseActionView();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean expandActionView(MenuItem menuItem) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.expandActionView(menuItem);
        return ((SupportMenuItem)menuItem).expandActionView();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionProvider getActionProvider(MenuItem object) {
        void var0_2;
        if (object instanceof SupportMenuItem) {
            ActionProvider actionProvider = ((SupportMenuItem)object).getSupportActionProvider();
            return var0_2;
        }
        Log.w((String)TAG, (String)"getActionProvider: item does not implement SupportMenuItem; returning null");
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static View getActionView(MenuItem menuItem) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.getActionView(menuItem);
        return ((SupportMenuItem)menuItem).getActionView();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isActionViewExpanded(MenuItem menuItem) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.isActionViewExpanded(menuItem);
        return ((SupportMenuItem)menuItem).isActionViewExpanded();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuItem setActionProvider(MenuItem menuItem, ActionProvider actionProvider) {
        if (menuItem instanceof SupportMenuItem) {
            return ((SupportMenuItem)menuItem).setSupportActionProvider(actionProvider);
        }
        Log.w((String)TAG, (String)"setActionProvider: item does not implement SupportMenuItem; ignoring");
        return menuItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuItem setActionView(MenuItem menuItem, int n2) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.setActionView(menuItem, n2);
        return ((SupportMenuItem)menuItem).setActionView(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuItem setActionView(MenuItem menuItem, View view) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.setActionView(menuItem, view);
        return ((SupportMenuItem)menuItem).setActionView(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuItem setOnActionExpandListener(MenuItem menuItem, OnActionExpandListener onActionExpandListener) {
        if (!(menuItem instanceof SupportMenuItem)) return IMPL.setOnActionExpandListener(menuItem, onActionExpandListener);
        return ((SupportMenuItem)menuItem).setSupportOnActionExpandListener(onActionExpandListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setShowAsAction(MenuItem menuItem, int n2) {
        if (menuItem instanceof SupportMenuItem) {
            ((SupportMenuItem)menuItem).setShowAsAction(n2);
            return;
        }
        IMPL.setShowAsAction(menuItem, n2);
    }

    static class BaseMenuVersionImpl
    implements MenuVersionImpl {
        BaseMenuVersionImpl() {
        }

        @Override
        public boolean collapseActionView(MenuItem menuItem) {
            return false;
        }

        @Override
        public boolean expandActionView(MenuItem menuItem) {
            return false;
        }

        @Override
        public View getActionView(MenuItem menuItem) {
            return null;
        }

        @Override
        public boolean isActionViewExpanded(MenuItem menuItem) {
            return false;
        }

        @Override
        public MenuItem setActionView(MenuItem menuItem, int n2) {
            return menuItem;
        }

        @Override
        public MenuItem setActionView(MenuItem menuItem, View view) {
            return menuItem;
        }

        @Override
        public MenuItem setOnActionExpandListener(MenuItem menuItem, OnActionExpandListener onActionExpandListener) {
            return menuItem;
        }

        @Override
        public void setShowAsAction(MenuItem menuItem, int n2) {
        }
    }

    static class HoneycombMenuVersionImpl
    implements MenuVersionImpl {
        HoneycombMenuVersionImpl() {
        }

        @Override
        public boolean collapseActionView(MenuItem menuItem) {
            return false;
        }

        @Override
        public boolean expandActionView(MenuItem menuItem) {
            return false;
        }

        @Override
        public View getActionView(MenuItem menuItem) {
            return MenuItemCompatHoneycomb.getActionView(menuItem);
        }

        @Override
        public boolean isActionViewExpanded(MenuItem menuItem) {
            return false;
        }

        @Override
        public MenuItem setActionView(MenuItem menuItem, int n2) {
            return MenuItemCompatHoneycomb.setActionView(menuItem, n2);
        }

        @Override
        public MenuItem setActionView(MenuItem menuItem, View view) {
            return MenuItemCompatHoneycomb.setActionView(menuItem, view);
        }

        @Override
        public MenuItem setOnActionExpandListener(MenuItem menuItem, OnActionExpandListener onActionExpandListener) {
            return menuItem;
        }

        @Override
        public void setShowAsAction(MenuItem menuItem, int n2) {
            MenuItemCompatHoneycomb.setShowAsAction(menuItem, n2);
        }
    }

    static class IcsMenuVersionImpl
    extends HoneycombMenuVersionImpl {
        IcsMenuVersionImpl() {
        }

        @Override
        public boolean collapseActionView(MenuItem menuItem) {
            return MenuItemCompatIcs.collapseActionView(menuItem);
        }

        @Override
        public boolean expandActionView(MenuItem menuItem) {
            return MenuItemCompatIcs.expandActionView(menuItem);
        }

        @Override
        public boolean isActionViewExpanded(MenuItem menuItem) {
            return MenuItemCompatIcs.isActionViewExpanded(menuItem);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public MenuItem setOnActionExpandListener(MenuItem menuItem, final OnActionExpandListener onActionExpandListener) {
            if (onActionExpandListener != null) return MenuItemCompatIcs.setOnActionExpandListener(menuItem, new MenuItemCompatIcs.SupportActionExpandProxy(){

                @Override
                public boolean onMenuItemActionCollapse(MenuItem menuItem) {
                    return onActionExpandListener.onMenuItemActionCollapse(menuItem);
                }

                @Override
                public boolean onMenuItemActionExpand(MenuItem menuItem) {
                    return onActionExpandListener.onMenuItemActionExpand(menuItem);
                }
            });
            return MenuItemCompatIcs.setOnActionExpandListener(menuItem, null);
        }
    }

    static interface MenuVersionImpl {
        public boolean collapseActionView(MenuItem var1);

        public boolean expandActionView(MenuItem var1);

        public View getActionView(MenuItem var1);

        public boolean isActionViewExpanded(MenuItem var1);

        public MenuItem setActionView(MenuItem var1, int var2);

        public MenuItem setActionView(MenuItem var1, View var2);

        public MenuItem setOnActionExpandListener(MenuItem var1, OnActionExpandListener var2);

        public void setShowAsAction(MenuItem var1, int var2);
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionCollapse(MenuItem var1);

        public boolean onMenuItemActionExpand(MenuItem var1);
    }
}

