/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewParentCompat;
import android.view.View;
import android.view.ViewParent;

public class NestedScrollingChildHelper {
    private boolean mIsNestedScrollingEnabled;
    private ViewParent mNestedScrollingParent;
    private int[] mTempNestedScrollConsumed;
    private final View mView;

    public NestedScrollingChildHelper(View view) {
        this.mView = view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchNestedFling(float f2, float f3, boolean bl2) {
        if (!this.isNestedScrollingEnabled()) return false;
        if (this.mNestedScrollingParent == null) return false;
        return ViewParentCompat.onNestedFling(this.mNestedScrollingParent, this.mView, f2, f3, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchNestedPreFling(float f2, float f3) {
        if (!this.isNestedScrollingEnabled()) return false;
        if (this.mNestedScrollingParent == null) return false;
        return ViewParentCompat.onNestedPreFling(this.mNestedScrollingParent, this.mView, f2, f3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4;
        int n5;
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (!this.isNestedScrollingEnabled()) return bl3;
        bl3 = bl2;
        if (this.mNestedScrollingParent == null) return bl3;
        if (n2 == 0 && n3 == 0) {
            bl3 = bl2;
            if (nArray2 == null) return bl3;
            nArray2[0] = 0;
            nArray2[1] = 0;
            return bl2;
        }
        if (nArray2 != null) {
            this.mView.getLocationInWindow(nArray2);
            n5 = nArray2[0];
            n4 = nArray2[1];
        } else {
            n4 = 0;
            n5 = 0;
        }
        int[] nArray3 = nArray;
        if (nArray == null) {
            if (this.mTempNestedScrollConsumed == null) {
                this.mTempNestedScrollConsumed = new int[2];
            }
            nArray3 = this.mTempNestedScrollConsumed;
        }
        nArray3[0] = 0;
        nArray3[1] = 0;
        ViewParentCompat.onNestedPreScroll(this.mNestedScrollingParent, this.mView, n2, n3, nArray3);
        if (nArray2 != null) {
            this.mView.getLocationInWindow(nArray2);
            nArray2[0] = nArray2[0] - n5;
            nArray2[1] = nArray2[1] - n4;
        }
        if (nArray3[0] != 0) return true;
        bl3 = bl2;
        if (nArray3[1] == 0) return bl3;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7;
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (!this.isNestedScrollingEnabled()) return bl3;
        bl3 = bl2;
        if (this.mNestedScrollingParent == null) return bl3;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            bl3 = bl2;
            if (nArray == null) return bl3;
            nArray[0] = 0;
            nArray[1] = 0;
            return bl2;
        }
        if (nArray != null) {
            this.mView.getLocationInWindow(nArray);
            n7 = nArray[0];
            n6 = nArray[1];
        } else {
            n6 = 0;
            n7 = 0;
        }
        ViewParentCompat.onNestedScroll(this.mNestedScrollingParent, this.mView, n2, n3, n4, n5);
        if (nArray == null) return true;
        this.mView.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n7;
        nArray[1] = nArray[1] - n6;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNestedScrollingParent() {
        if (this.mNestedScrollingParent == null) return false;
        return true;
    }

    public boolean isNestedScrollingEnabled() {
        return this.mIsNestedScrollingEnabled;
    }

    public void onDetachedFromWindow() {
        ViewCompat.stopNestedScroll(this.mView);
    }

    public void onStopNestedScroll(View view) {
        ViewCompat.stopNestedScroll(this.mView);
    }

    public void setNestedScrollingEnabled(boolean bl2) {
        if (this.mIsNestedScrollingEnabled) {
            ViewCompat.stopNestedScroll(this.mView);
        }
        this.mIsNestedScrollingEnabled = bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startNestedScroll(int n2) {
        if (this.hasNestedScrollingParent()) {
            return true;
        }
        if (!this.isNestedScrollingEnabled()) return false;
        ViewParent viewParent = this.mView.getParent();
        View view = this.mView;
        while (viewParent != null) {
            if (ViewParentCompat.onStartNestedScroll(viewParent, view, this.mView, n2)) {
                this.mNestedScrollingParent = viewParent;
                ViewParentCompat.onNestedScrollAccepted(viewParent, view, this.mView, n2);
                return true;
            }
            if (viewParent instanceof View) {
                view = (View)viewParent;
            }
            viewParent = viewParent.getParent();
        }
        return false;
    }

    public void stopNestedScroll() {
        if (this.mNestedScrollingParent != null) {
            ViewParentCompat.onStopNestedScroll(this.mNestedScrollingParent, this.mView);
            this.mNestedScrollingParent = null;
        }
    }
}

