/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompatICS;
import android.support.v4.view.ViewPropertyAnimatorCompatJB;
import android.support.v4.view.ViewPropertyAnimatorCompatJellybeanMr2;
import android.support.v4.view.ViewPropertyAnimatorCompatKK;
import android.support.v4.view.ViewPropertyAnimatorCompatLollipop;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.view.View;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class ViewPropertyAnimatorCompat {
    static final ViewPropertyAnimatorCompatImpl IMPL;
    static final int LISTENER_TAG_ID = 0x7E000000;
    private static final String TAG = "ViewAnimatorCompat";
    private Runnable mEndAction = null;
    private int mOldLayerType = -1;
    private Runnable mStartAction = null;
    private WeakReference<View> mView;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21) {
            IMPL = new LollipopViewPropertyAnimatorCompatImpl();
            return;
        }
        if (n2 >= 19) {
            IMPL = new KitKatViewPropertyAnimatorCompatImpl();
            return;
        }
        if (n2 >= 18) {
            IMPL = new JBMr2ViewPropertyAnimatorCompatImpl();
            return;
        }
        if (n2 >= 16) {
            IMPL = new JBViewPropertyAnimatorCompatImpl();
            return;
        }
        if (n2 >= 14) {
            IMPL = new ICSViewPropertyAnimatorCompatImpl();
            return;
        }
        IMPL = new BaseViewPropertyAnimatorCompatImpl();
    }

    ViewPropertyAnimatorCompat(View view) {
        this.mView = new WeakReference<View>(view);
    }

    static /* synthetic */ Runnable access$002(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, Runnable runnable) {
        viewPropertyAnimatorCompat.mEndAction = runnable;
        return runnable;
    }

    static /* synthetic */ Runnable access$102(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, Runnable runnable) {
        viewPropertyAnimatorCompat.mStartAction = runnable;
        return runnable;
    }

    static /* synthetic */ int access$402(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, int n2) {
        viewPropertyAnimatorCompat.mOldLayerType = n2;
        return n2;
    }

    public ViewPropertyAnimatorCompat alpha(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alpha(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat alphaBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alphaBy(this, view, f2);
        }
        return this;
    }

    public void cancel() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.cancel(this, view);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDuration() {
        View view = (View)this.mView.get();
        if (view == null) return 0L;
        return IMPL.getDuration(this, view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Interpolator getInterpolator() {
        View view = (View)this.mView.get();
        if (view == null) return null;
        return IMPL.getInterpolator(this, view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getStartDelay() {
        View view = (View)this.mView.get();
        if (view == null) return 0L;
        return IMPL.getStartDelay(this, view);
    }

    public ViewPropertyAnimatorCompat rotation(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotation(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationX(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationX(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationXBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationXBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationY(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationY(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationYBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationYBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleX(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleX(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleXBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleXBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleY(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleY(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleYBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleYBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setDuration(long l2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setDuration(this, view, l2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setInterpolator(Interpolator interpolator) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setInterpolator(this, view, interpolator);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setListener(ViewPropertyAnimatorListener viewPropertyAnimatorListener) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setListener(this, view, viewPropertyAnimatorListener);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setStartDelay(long l2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setStartDelay(this, view, l2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setUpdateListener(ViewPropertyAnimatorUpdateListener viewPropertyAnimatorUpdateListener) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setUpdateListener(this, view, viewPropertyAnimatorUpdateListener);
        }
        return this;
    }

    public void start() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.start(this, view);
        }
    }

    public ViewPropertyAnimatorCompat translationX(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationX(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationXBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationXBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationY(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationY(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationYBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationYBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationZ(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationZ(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationZBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationZBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withEndAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withEndAction(this, view, runnable);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withLayer() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withLayer(this, view);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withStartAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withStartAction(this, view, runnable);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat x(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.x(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat xBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.xBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat y(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.y(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat yBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.yBy(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat z(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.z(this, view, f2);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat zBy(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.zBy(this, view, f2);
        }
        return this;
    }

    static class BaseViewPropertyAnimatorCompatImpl
    implements ViewPropertyAnimatorCompatImpl {
        WeakHashMap<View, Runnable> mStarterMap = null;

        BaseViewPropertyAnimatorCompatImpl() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void postStartMessage(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            Runnable runnable = this.mStarterMap != null ? this.mStarterMap.get(view) : null;
            Runnable runnable2 = runnable;
            if (runnable == null) {
                runnable2 = new Starter(viewPropertyAnimatorCompat, view);
                if (this.mStarterMap == null) {
                    this.mStarterMap = new WeakHashMap();
                }
                this.mStarterMap.put(view, runnable2);
            }
            view.removeCallbacks(runnable2);
            view.post(runnable2);
        }

        private void removeStartMessage(View view) {
            Runnable runnable;
            if (this.mStarterMap != null && (runnable = this.mStarterMap.get(view)) != null) {
                view.removeCallbacks(runnable);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void startAnimation(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            Object object = view.getTag(0x7E000000);
            object = object instanceof ViewPropertyAnimatorListener ? (ViewPropertyAnimatorListener)object : null;
            Runnable runnable = viewPropertyAnimatorCompat.mStartAction;
            Runnable runnable2 = viewPropertyAnimatorCompat.mEndAction;
            ViewPropertyAnimatorCompat.access$102(viewPropertyAnimatorCompat, null);
            ViewPropertyAnimatorCompat.access$002(viewPropertyAnimatorCompat, null);
            if (runnable != null) {
                runnable.run();
            }
            if (object != null) {
                object.onAnimationStart(view);
                object.onAnimationEnd(view);
            }
            if (runnable2 != null) {
                runnable2.run();
            }
            if (this.mStarterMap != null) {
                this.mStarterMap.remove(view);
            }
        }

        @Override
        public void alpha(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void alphaBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void cancel(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public long getDuration(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return 0L;
        }

        @Override
        public Interpolator getInterpolator(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return null;
        }

        @Override
        public long getStartDelay(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return 0L;
        }

        @Override
        public void rotation(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void rotationBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void rotationX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void rotationXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void rotationY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void rotationYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void scaleX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void scaleXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void scaleY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void scaleYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void setDuration(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, long l2) {
        }

        @Override
        public void setInterpolator(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Interpolator interpolator) {
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, ViewPropertyAnimatorListener viewPropertyAnimatorListener) {
            view.setTag(0x7E000000, (Object)viewPropertyAnimatorListener);
        }

        @Override
        public void setStartDelay(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, long l2) {
        }

        @Override
        public void setUpdateListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, ViewPropertyAnimatorUpdateListener viewPropertyAnimatorUpdateListener) {
        }

        @Override
        public void start(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            this.removeStartMessage(view);
            this.startAnimation(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void translationX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void translationXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void translationY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void translationYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void translationZ(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
        }

        @Override
        public void translationZBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompat.access$002(viewPropertyAnimatorCompat, runnable);
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompat.access$102(viewPropertyAnimatorCompat, runnable);
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void x(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void xBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void y(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void yBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            this.postStartMessage(viewPropertyAnimatorCompat, view);
        }

        @Override
        public void z(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
        }

        @Override
        public void zBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
        }

        class Starter
        implements Runnable {
            WeakReference<View> mViewRef;
            ViewPropertyAnimatorCompat mVpa;

            private Starter(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
                this.mViewRef = new WeakReference<View>(view);
                this.mVpa = viewPropertyAnimatorCompat;
            }

            @Override
            public void run() {
                View view = (View)this.mViewRef.get();
                if (view != null) {
                    BaseViewPropertyAnimatorCompatImpl.this.startAnimation(this.mVpa, view);
                }
            }
        }
    }

    static class ICSViewPropertyAnimatorCompatImpl
    extends BaseViewPropertyAnimatorCompatImpl {
        WeakHashMap<View, Integer> mLayerMap = null;

        ICSViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void alpha(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.alpha(view, f2);
        }

        @Override
        public void alphaBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.alphaBy(view, f2);
        }

        @Override
        public void cancel(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            ViewPropertyAnimatorCompatICS.cancel(view);
        }

        @Override
        public long getDuration(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return ViewPropertyAnimatorCompatICS.getDuration(view);
        }

        @Override
        public long getStartDelay(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return ViewPropertyAnimatorCompatICS.getStartDelay(view);
        }

        @Override
        public void rotation(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotation(view, f2);
        }

        @Override
        public void rotationBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotationBy(view, f2);
        }

        @Override
        public void rotationX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotationX(view, f2);
        }

        @Override
        public void rotationXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotationXBy(view, f2);
        }

        @Override
        public void rotationY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotationY(view, f2);
        }

        @Override
        public void rotationYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.rotationYBy(view, f2);
        }

        @Override
        public void scaleX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.scaleX(view, f2);
        }

        @Override
        public void scaleXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.scaleXBy(view, f2);
        }

        @Override
        public void scaleY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.scaleY(view, f2);
        }

        @Override
        public void scaleYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.scaleYBy(view, f2);
        }

        @Override
        public void setDuration(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, long l2) {
            ViewPropertyAnimatorCompatICS.setDuration(view, l2);
        }

        @Override
        public void setInterpolator(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Interpolator interpolator) {
            ViewPropertyAnimatorCompatICS.setInterpolator(view, interpolator);
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, ViewPropertyAnimatorListener viewPropertyAnimatorListener) {
            view.setTag(0x7E000000, (Object)viewPropertyAnimatorListener);
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(viewPropertyAnimatorCompat));
        }

        @Override
        public void setStartDelay(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, long l2) {
            ViewPropertyAnimatorCompatICS.setStartDelay(view, l2);
        }

        @Override
        public void start(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            ViewPropertyAnimatorCompatICS.start(view);
        }

        @Override
        public void translationX(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.translationX(view, f2);
        }

        @Override
        public void translationXBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.translationXBy(view, f2);
        }

        @Override
        public void translationY(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.translationY(view, f2);
        }

        @Override
        public void translationYBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.translationYBy(view, f2);
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(viewPropertyAnimatorCompat));
            ViewPropertyAnimatorCompat.access$002(viewPropertyAnimatorCompat, runnable);
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            ViewPropertyAnimatorCompat.access$402(viewPropertyAnimatorCompat, ViewCompat.getLayerType(view));
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(viewPropertyAnimatorCompat));
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(viewPropertyAnimatorCompat));
            ViewPropertyAnimatorCompat.access$102(viewPropertyAnimatorCompat, runnable);
        }

        @Override
        public void x(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.x(view, f2);
        }

        @Override
        public void xBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.xBy(view, f2);
        }

        @Override
        public void y(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.y(view, f2);
        }

        @Override
        public void yBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatICS.yBy(view, f2);
        }

        static class MyVpaListener
        implements ViewPropertyAnimatorListener {
            boolean mAnimEndCalled;
            ViewPropertyAnimatorCompat mVpa;

            MyVpaListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat) {
                this.mVpa = viewPropertyAnimatorCompat;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onAnimationCancel(View view) {
                Object object = view.getTag(0x7E000000);
                if (!(object instanceof ViewPropertyAnimatorListener)) return;
                object = (ViewPropertyAnimatorListener)object;
                if (object == null) return;
                object.onAnimationCancel(view);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(View view) {
                if (this.mVpa.mOldLayerType >= 0) {
                    ViewCompat.setLayerType(view, this.mVpa.mOldLayerType, null);
                    ViewPropertyAnimatorCompat.access$402(this.mVpa, -1);
                }
                if (Build.VERSION.SDK_INT >= 16 || !this.mAnimEndCalled) {
                    Object object;
                    if (this.mVpa.mEndAction != null) {
                        object = this.mVpa.mEndAction;
                        ViewPropertyAnimatorCompat.access$002(this.mVpa, null);
                        object.run();
                    }
                    if ((object = (object = view.getTag(0x7E000000)) instanceof ViewPropertyAnimatorListener ? (ViewPropertyAnimatorListener)object : null) != null) {
                        object.onAnimationEnd(view);
                    }
                    this.mAnimEndCalled = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onAnimationStart(View view) {
                Object object;
                this.mAnimEndCalled = false;
                if (this.mVpa.mOldLayerType >= 0) {
                    ViewCompat.setLayerType(view, 2, null);
                }
                if (this.mVpa.mStartAction != null) {
                    object = this.mVpa.mStartAction;
                    ViewPropertyAnimatorCompat.access$102(this.mVpa, null);
                    object.run();
                }
                if (!((object = view.getTag(0x7E000000)) instanceof ViewPropertyAnimatorListener)) return;
                object = (ViewPropertyAnimatorListener)object;
                if (object == null) return;
                object.onAnimationStart(view);
            }
        }
    }

    static class JBMr2ViewPropertyAnimatorCompatImpl
    extends JBViewPropertyAnimatorCompatImpl {
        JBMr2ViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public Interpolator getInterpolator(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            return ViewPropertyAnimatorCompatJellybeanMr2.getInterpolator(view);
        }
    }

    static class JBViewPropertyAnimatorCompatImpl
    extends ICSViewPropertyAnimatorCompatImpl {
        JBViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, ViewPropertyAnimatorListener viewPropertyAnimatorListener) {
            ViewPropertyAnimatorCompatJB.setListener(view, viewPropertyAnimatorListener);
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withEndAction(view, runnable);
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view) {
            ViewPropertyAnimatorCompatJB.withLayer(view);
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withStartAction(view, runnable);
        }
    }

    static class KitKatViewPropertyAnimatorCompatImpl
    extends JBMr2ViewPropertyAnimatorCompatImpl {
        KitKatViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setUpdateListener(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, ViewPropertyAnimatorUpdateListener viewPropertyAnimatorUpdateListener) {
            ViewPropertyAnimatorCompatKK.setUpdateListener(view, viewPropertyAnimatorUpdateListener);
        }
    }

    static class LollipopViewPropertyAnimatorCompatImpl
    extends KitKatViewPropertyAnimatorCompatImpl {
        LollipopViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void translationZ(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatLollipop.translationZ(view, f2);
        }

        @Override
        public void translationZBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatLollipop.translationZBy(view, f2);
        }

        @Override
        public void z(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatLollipop.z(view, f2);
        }

        @Override
        public void zBy(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, View view, float f2) {
            ViewPropertyAnimatorCompatLollipop.zBy(view, f2);
        }
    }

    static interface ViewPropertyAnimatorCompatImpl {
        public void alpha(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void alphaBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void cancel(ViewPropertyAnimatorCompat var1, View var2);

        public long getDuration(ViewPropertyAnimatorCompat var1, View var2);

        public Interpolator getInterpolator(ViewPropertyAnimatorCompat var1, View var2);

        public long getStartDelay(ViewPropertyAnimatorCompat var1, View var2);

        public void rotation(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void setDuration(ViewPropertyAnimatorCompat var1, View var2, long var3);

        public void setInterpolator(ViewPropertyAnimatorCompat var1, View var2, Interpolator var3);

        public void setListener(ViewPropertyAnimatorCompat var1, View var2, ViewPropertyAnimatorListener var3);

        public void setStartDelay(ViewPropertyAnimatorCompat var1, View var2, long var3);

        public void setUpdateListener(ViewPropertyAnimatorCompat var1, View var2, ViewPropertyAnimatorUpdateListener var3);

        public void start(ViewPropertyAnimatorCompat var1, View var2);

        public void translationX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationZ(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationZBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void withEndAction(ViewPropertyAnimatorCompat var1, View var2, Runnable var3);

        public void withLayer(ViewPropertyAnimatorCompat var1, View var2);

        public void withStartAction(ViewPropertyAnimatorCompat var1, View var2, Runnable var3);

        public void x(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void xBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void y(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void yBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void z(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void zBy(ViewPropertyAnimatorCompat var1, View var2, float var3);
    }
}

