/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.util.Log;
import android.widget.PopupWindow;
import java.lang.reflect.Field;

class PopupWindowCompatApi21 {
    private static final String TAG = "PopupWindowCompatApi21";
    private static Field sOverlapAnchorField;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            sOverlapAnchorField = PopupWindow.class.getDeclaredField("mOverlapAnchor");
            sOverlapAnchorField.setAccessible(true);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.i((String)TAG, (String)"Could not fetch mOverlapAnchor field from PopupWindow", (Throwable)noSuchFieldException);
            return;
        }
    }

    PopupWindowCompatApi21() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean getOverlapAnchor(PopupWindow popupWindow) {
        if (sOverlapAnchorField == null) return false;
        try {
            return (Boolean)sOverlapAnchorField.get(popupWindow);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.i((String)TAG, (String)"Could not get overlap anchor field in PopupWindow", (Throwable)illegalAccessException);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setOverlapAnchor(PopupWindow popupWindow, boolean bl2) {
        if (sOverlapAnchorField == null) return;
        try {
            sOverlapAnchorField.set(popupWindow, bl2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.i((String)TAG, (String)"Could not set overlap anchor field in PopupWindow", (Throwable)illegalAccessException);
            return;
        }
    }
}

