/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SlidingPaneLayout
extends ViewGroup {
    private static final int DEFAULT_FADE_COLOR = -858993460;
    private static final int DEFAULT_OVERHANG_SIZE = 32;
    static final SlidingPanelLayoutImpl IMPL;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final String TAG = "SlidingPaneLayout";
    private boolean mCanSlide;
    private int mCoveredFadeColor;
    private final ViewDragHelper mDragHelper;
    private boolean mFirstLayout = true;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsUnableToDrag;
    private final int mOverhangSize;
    private PanelSlideListener mPanelSlideListener;
    private int mParallaxBy;
    private float mParallaxOffset;
    private final ArrayList<DisableLayerRunnable> mPostedRunnables;
    private boolean mPreservedOpenState;
    private Drawable mShadowDrawableLeft;
    private Drawable mShadowDrawableRight;
    private float mSlideOffset;
    private int mSlideRange;
    private View mSlideableView;
    private int mSliderFadeColor = -858993460;
    private final Rect mTmpRect = new Rect();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 17) {
            IMPL = new SlidingPanelLayoutImplJBMR1();
            return;
        }
        if (n2 >= 16) {
            IMPL = new SlidingPanelLayoutImplJB();
            return;
        }
        IMPL = new SlidingPanelLayoutImplBase();
    }

    public SlidingPaneLayout(Context context) {
        this(context, null);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mPostedRunnables = new ArrayList();
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mOverhangSize = (int)(32.0f * f2 + 0.5f);
        ViewConfiguration.get((Context)context);
        this.setWillNotDraw(false);
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegate());
        ViewCompat.setImportantForAccessibility((View)this, 1);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new DragHelperCallback());
        this.mDragHelper.setMinVelocity(f2 * 400.0f);
    }

    static /* synthetic */ boolean access$502(SlidingPaneLayout slidingPaneLayout, boolean bl2) {
        slidingPaneLayout.mPreservedOpenState = bl2;
        return bl2;
    }

    private boolean closePane(View view, int n2) {
        boolean bl2 = false;
        if (this.mFirstLayout || this.smoothSlideTo(0.0f, n2)) {
            this.mPreservedOpenState = false;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void dimChildView(View object, float f2, int n2) {
        void var3_4;
        void var2_3;
        LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
        if (var2_3 > 0.0f && var3_4 != false) {
            int n3 = (int)((float)((0xFF000000 & var3_4) >>> 24) * var2_3);
            if (layoutParams.dimPaint == null) {
                layoutParams.dimPaint = new Paint();
            }
            layoutParams.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(n3 << 24 | 0xFFFFFF & var3_4, PorterDuff.Mode.SRC_OVER));
            if (ViewCompat.getLayerType(object) != 2) {
                ViewCompat.setLayerType(object, 2, layoutParams.dimPaint);
            }
            this.invalidateChildRegion((View)object);
            return;
        }
        if (ViewCompat.getLayerType(object) == 0) return;
        if (layoutParams.dimPaint != null) {
            layoutParams.dimPaint.setColorFilter(null);
        }
        DisableLayerRunnable disableLayerRunnable = new DisableLayerRunnable((View)object);
        this.mPostedRunnables.add(disableLayerRunnable);
        ViewCompat.postOnAnimation((View)this, disableLayerRunnable);
    }

    private void invalidateChildRegion(View view) {
        IMPL.invalidateChildRegion(this, view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLayoutRtlSupport() {
        boolean bl2 = true;
        if (ViewCompat.getLayoutDirection((View)this) != 1) return false;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onPanelDragged(int n2) {
        if (this.mSlideableView == null) {
            this.mSlideOffset = 0.0f;
            return;
        }
        boolean bl2 = this.isLayoutRtlSupport();
        LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
        int n3 = this.mSlideableView.getWidth();
        int n4 = n2;
        if (bl2) {
            n4 = this.getWidth() - n2 - n3;
        }
        n2 = bl2 ? this.getPaddingRight() : this.getPaddingLeft();
        n3 = bl2 ? layoutParams.rightMargin : layoutParams.leftMargin;
        this.mSlideOffset = (float)(n4 - (n3 + n2)) / (float)this.mSlideRange;
        if (this.mParallaxBy != 0) {
            this.parallaxOtherViews(this.mSlideOffset);
        }
        if (layoutParams.dimWhenOffset) {
            this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean openPane(View view, int n2) {
        boolean bl2 = true;
        if (!this.mFirstLayout) {
            if (!this.smoothSlideTo(1.0f, n2)) return false;
        }
        this.mPreservedOpenState = true;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parallaxOtherViews(float f2) {
        int n2;
        boolean bl2 = this.isLayoutRtlSupport();
        LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
        n2 = layoutParams.dimWhenOffset && (n2 = bl2 ? layoutParams.rightMargin : layoutParams.leftMargin) <= 0 ? 1 : 0;
        int n3 = this.getChildCount();
        int n4 = 0;
        while (n4 < n3) {
            layoutParams = this.getChildAt(n4);
            if (layoutParams != this.mSlideableView) {
                int n5;
                int n6 = (int)((1.0f - this.mParallaxOffset) * (float)this.mParallaxBy);
                this.mParallaxOffset = f2;
                n6 = n5 = n6 - (int)((1.0f - f2) * (float)this.mParallaxBy);
                if (bl2) {
                    n6 = -n5;
                }
                layoutParams.offsetLeftAndRight(n6);
                if (n2 != 0) {
                    float f3 = bl2 ? this.mParallaxOffset - 1.0f : 1.0f - this.mParallaxOffset;
                    this.dimChildView((View)layoutParams, f3, this.mCoveredFadeColor);
                }
            }
            ++n4;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean viewIsOpaque(View view) {
        boolean bl2 = true;
        if (ViewCompat.isOpaque(view)) {
            return bl2;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return false;
        }
        if ((view = view.getBackground()) == null) return false;
        if (view.getOpacity() == -1) return bl2;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        boolean bl3 = true;
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = viewGroup.getChildCount() - 1; i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return bl3;
            }
        }
        if (!bl2) return false;
        if (!this.isLayoutRtlSupport()) {
            n2 = -n2;
        }
        bl2 = bl3;
        if (ViewCompat.canScrollHorizontally(view, n2)) return bl2;
        return false;
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) return false;
        if (!super.checkLayoutParams(layoutParams)) return false;
        return true;
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeScroll() {
        block4: {
            block3: {
                if (!this.mDragHelper.continueSettling(true)) break block3;
                if (this.mCanSlide) break block4;
                this.mDragHelper.abort();
            }
            return;
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    void dispatchOnPanelClosed(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelOpened(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelSlide(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(view, this.mSlideOffset);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        int n2;
        int n3;
        super.draw(canvas);
        Drawable drawable2 = this.isLayoutRtlSupport() ? this.mShadowDrawableRight : this.mShadowDrawableLeft;
        View view = this.getChildCount() > 1 ? this.getChildAt(1) : null;
        if (view == null) return;
        if (drawable2 == null) {
            return;
        }
        int n4 = view.getTop();
        int n5 = view.getBottom();
        int n6 = drawable2.getIntrinsicWidth();
        if (this.isLayoutRtlSupport()) {
            n3 = view.getRight();
            n2 = n3 + n6;
        } else {
            n2 = view.getLeft();
            n3 = n2 - n6;
        }
        drawable2.setBounds(n3, n4, n2, n5);
        drawable2.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        boolean bl2;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n2 = canvas.save(2);
        if (this.mCanSlide && !layoutParams.slideable && this.mSlideableView != null) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.isLayoutRtlSupport()) {
                this.mTmpRect.left = Math.max(this.mTmpRect.left, this.mSlideableView.getRight());
            } else {
                this.mTmpRect.right = Math.min(this.mTmpRect.right, this.mSlideableView.getLeft());
            }
            canvas.clipRect(this.mTmpRect);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            bl2 = super.drawChild(canvas, view, l2);
        } else if (layoutParams.dimWhenOffset && this.mSlideOffset > 0.0f) {
            Bitmap bitmap;
            if (!view.isDrawingCacheEnabled()) {
                view.setDrawingCacheEnabled(true);
            }
            if ((bitmap = view.getDrawingCache()) != null) {
                canvas.drawBitmap(bitmap, (float)view.getLeft(), (float)view.getTop(), layoutParams.dimPaint);
                bl2 = false;
            } else {
                Log.e((String)TAG, (String)("drawChild: child view " + view + " returned null drawing cache"));
                bl2 = super.drawChild(canvas, view, l2);
            }
        } else {
            if (view.isDrawingCacheEnabled()) {
                view.setDrawingCacheEnabled(false);
            }
            bl2 = super.drawChild(canvas, view, l2);
        }
        canvas.restoreToCount(n2);
        return bl2;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams object) {
        void var1_3;
        if (object instanceof ViewGroup.MarginLayoutParams) {
            LayoutParams layoutParams = new LayoutParams((ViewGroup.MarginLayoutParams)object);
            return var1_3;
        }
        LayoutParams layoutParams = new LayoutParams((ViewGroup.LayoutParams)object);
        return var1_3;
    }

    @ColorInt
    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public int getParallaxDistance() {
        return this.mParallaxBy;
    }

    @ColorInt
    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDimmed(View object) {
        boolean bl2 = false;
        if (object == null) {
            return bl2;
        }
        LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
        if (!this.mCanSlide) return false;
        if (!layoutParams.dimWhenOffset) return false;
        if (!(this.mSlideOffset > 0.0f)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (!this.mCanSlide) return true;
        if (this.mSlideOffset != 1.0f) return false;
        return true;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int n2 = this.mPostedRunnables.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mPostedRunnables.get(i2).run();
        }
        this.mPostedRunnables.clear();
    }

    /*
     * Unable to fully structure code
     */
    public boolean onInterceptTouchEvent(MotionEvent var1_1) {
        block12: {
            var2_2 = false;
            var3_3 = MotionEventCompat.getActionMasked(var1_1);
            if (this.mCanSlide || var3_3 != 0 || this.getChildCount() <= 1 || (var4_4 = this.getChildAt(1)) == null) ** GOTO lbl8
            if (!this.mDragHelper.isViewUnder(var4_4, (int)var1_1.getX(), (int)var1_1.getY())) {
                var5_5 = true;
lbl6:
                // 2 sources

                while (true) {
                    this.mPreservedOpenState = var5_5;
lbl8:
                    // 2 sources

                    if (!this.mCanSlide || this.mIsUnableToDrag && var3_3 != 0) {
                        this.mDragHelper.cancel();
                        var5_5 = super.onInterceptTouchEvent(var1_1);
lbl11:
                        // 5 sources

                        return var5_5;
                    }
                    break;
                }
            } else {
                var5_5 = false;
                ** continue;
            }
            if (var3_3 != 3 && var3_3 != 1) break block12;
            this.mDragHelper.cancel();
            var5_5 = var2_2;
            ** GOTO lbl11
        }
        switch (var3_3) lbl-1000:
        // 2 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var3_3 = 0;
lbl25:
                    // 2 sources

                    while (true) {
                        if (this.mDragHelper.shouldInterceptTouchEvent(var1_1)) ** GOTO lbl29
                        var5_5 = var2_2;
                        if (var3_3 == 0) ** GOTO lbl11
lbl29:
                        // 2 sources

                        var5_5 = true;
                        ** GOTO lbl11
                        break;
                    }
                    break;
                }
            }
            case 0: {
                this.mIsUnableToDrag = false;
                var6_6 = var1_1.getX();
                var7_8 = var1_1.getY();
                this.mInitialMotionX = var6_6;
                this.mInitialMotionY = var7_8;
                if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)var6_6, (int)var7_8) || !this.isDimmed(this.mSlideableView)) ** GOTO lbl-1000
                var3_3 = 1;
                ** continue;
            }
            case 2: 
        }
        var7_9 = var1_1.getX();
        var6_7 = var1_1.getY();
        var7_9 = Math.abs(var7_9 - this.mInitialMotionX);
        var6_7 = Math.abs(var6_7 - this.mInitialMotionY);
        ** while (!(var7_9 > (float)this.mDragHelper.getTouchSlop()) || !(var6_7 > var7_9))
lbl46:
        // 1 sources

        this.mDragHelper.cancel();
        this.mIsUnableToDrag = true;
        var5_5 = var2_2;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        boolean bl3 = this.isLayoutRtlSupport();
        if (bl3) {
            this.mDragHelper.setEdgeTrackingEnabled(2);
        } else {
            this.mDragHelper.setEdgeTrackingEnabled(1);
        }
        int n6 = n4 - n2;
        n2 = bl3 ? this.getPaddingRight() : this.getPaddingLeft();
        n5 = bl3 ? this.getPaddingLeft() : this.getPaddingRight();
        int n7 = this.getPaddingTop();
        int n8 = this.getChildCount();
        if (this.mFirstLayout) {
            float f2 = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
            this.mSlideOffset = f2;
        }
        n3 = n2;
        for (int i2 = 0; i2 < n8; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) {
                n4 = n2;
                n2 = n3;
                n3 = n4;
            } else {
                int n9;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n10 = view.getMeasuredWidth();
                if (layoutParams.slideable) {
                    n4 = layoutParams.leftMargin;
                    n9 = layoutParams.rightMargin;
                    this.mSlideRange = n9 = Math.min(n2, n6 - n5 - this.mOverhangSize) - n3 - (n4 + n9);
                    n4 = bl3 ? layoutParams.rightMargin : layoutParams.leftMargin;
                    bl2 = n3 + n4 + n9 + n10 / 2 > n6 - n5;
                    layoutParams.dimWhenOffset = bl2;
                    n9 = (int)((float)n9 * this.mSlideOffset);
                    n3 += n4 + n9;
                    this.mSlideOffset = (float)n9 / (float)this.mSlideRange;
                    n4 = 0;
                } else if (this.mCanSlide && this.mParallaxBy != 0) {
                    n4 = (int)((1.0f - this.mSlideOffset) * (float)this.mParallaxBy);
                    n3 = n2;
                } else {
                    n4 = 0;
                    n3 = n2;
                }
                if (bl3) {
                    n4 = n6 - n3 + n4;
                    n9 = n4 - n10;
                } else {
                    n9 = n3 - n4;
                    n4 = n9 + n10;
                }
                view.layout(n9, n7, n4, view.getMeasuredHeight() + n7);
                n4 = view.getWidth() + n2;
                n2 = n3;
                n3 = n4;
            }
            n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        if (this.mFirstLayout) {
            if (this.mCanSlide) {
                if (this.mParallaxBy != 0) {
                    this.parallaxOtherViews(this.mSlideOffset);
                }
                if (((LayoutParams)this.mSlideableView.getLayoutParams()).dimWhenOffset) {
                    this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
                }
            } else {
                for (n2 = 0; n2 < n8; ++n2) {
                    this.dimChildView(this.getChildAt(n2), 0.0f, this.mSliderFadeColor);
                }
            }
            this.updateObscuredViewsVisibility(this.mSlideableView);
        }
        this.mFirstLayout = false;
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block27: {
            block37: {
                block26: {
                    block28: {
                        block36: {
                            block34: {
                                block35: {
                                    block33: {
                                        block32: {
                                            var3_3 = View.MeasureSpec.getMode((int)var1_1);
                                            var4_4 = View.MeasureSpec.getSize((int)var1_1);
                                            var5_5 = View.MeasureSpec.getMode((int)var2_2);
                                            var1_1 = View.MeasureSpec.getSize((int)var2_2);
                                            if (var3_3 == 0x40000000) ** GOTO lbl45
                                            if (!this.isInEditMode()) ** GOTO lbl44
                                            if (var3_3 != -2147483648) ** GOTO lbl39
                                            var2_2 = var4_4;
                                            var4_4 = var5_5;
lbl10:
                                            // 2 sources

                                            block4: while (true) {
                                                switch (var4_4) {
                                                    default: {
                                                        var1_1 = 0;
                                                        var3_3 = -1;
lbl15:
                                                        // 3 sources

                                                        while (true) {
                                                            var6_7 = false;
                                                            var7_8 = var2_2 - this.getPaddingLeft() - this.getPaddingRight();
                                                            var8_9 = this.getChildCount();
                                                            if (var8_9 > 2) {
                                                                Log.e((String)"SlidingPaneLayout", (String)"onMeasure: More than two child views are not supported.");
                                                            }
                                                            this.mSlideableView = null;
                                                            var5_5 = var7_8;
                                                            var10_11 = 0.0f;
                                                            block6: for (var9_10 = 0; var9_10 < var8_9; ++var9_10) {
                                                                var11_12 = this.getChildAt(var9_10);
                                                                var12_13 = (LayoutParams)var11_12.getLayoutParams();
                                                                if (var11_12.getVisibility() != 8) break block4;
                                                                var12_13.dimWhenOffset = false;
                                                                var13_6 = var5_5;
                                                                var5_5 = var1_1;
                                                                var1_1 = var13_6;
lbl33:
                                                                // 3 sources

                                                                while (true) {
                                                                    var13_6 = var5_5;
                                                                    var5_5 = var1_1;
                                                                    var1_1 = var13_6;
                                                                    continue block6;
                                                                    break;
                                                                }
                                                            }
                                                            break block26;
                                                            break;
                                                        }
                                                    }
lbl39:
                                                    // 1 sources

                                                    if (var3_3 == 0) {
                                                        var4_4 = var5_5;
                                                        var2_2 = 300;
                                                        continue block4;
                                                    }
                                                    break block27;
lbl44:
                                                    // 1 sources

                                                    throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
lbl45:
                                                    // 1 sources

                                                    if (var5_5 != 0) break block27;
                                                    if (this.isInEditMode()) {
                                                        if (var5_5 == 0) {
                                                            var5_5 = -2147483648;
                                                            var2_2 = var4_4;
                                                            var1_1 = 300;
                                                            var4_4 = var5_5;
                                                            continue block4;
                                                        }
                                                        break block27;
                                                    }
                                                    throw new IllegalStateException("Height must not be UNSPECIFIED");
                                                    case 0x40000000: {
                                                        var3_3 = var1_1 = var1_1 - this.getPaddingTop() - this.getPaddingBottom();
                                                        ** GOTO lbl15
                                                    }
                                                    case -2147483648: {
                                                        var3_3 = this.getPaddingTop();
                                                        var13_6 = this.getPaddingBottom();
                                                        var5_5 = 0;
                                                        var3_3 = var1_1 - var3_3 - var13_6;
                                                        var1_1 = var5_5;
                                                        ** continue;
                                                    }
                                                }
                                                break;
                                            }
                                            var14_14 = var10_11;
                                            if (!(var12_13.weight > 0.0f)) break block32;
                                            var14_14 = var10_11 += var12_13.weight;
                                            if (var12_13.width != 0) break block32;
                                            var13_6 = var1_1;
                                            var1_1 = var5_5;
                                            var5_5 = var13_6;
                                            ** GOTO lbl33
                                        }
                                        var13_6 = var12_13.leftMargin + var12_13.rightMargin;
                                        if (var12_13.width != -2) break block33;
                                        var13_6 = View.MeasureSpec.makeMeasureSpec((int)(var7_8 - var13_6), (int)-2147483648);
lbl77:
                                        // 3 sources

                                        while (var12_13.height == -2) {
                                            var15_15 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)-2147483648);
lbl79:
                                            // 3 sources

                                            while (true) {
                                                var11_12.measure(var13_6, var15_15);
                                                var15_15 = var11_12.getMeasuredWidth();
                                                var16_16 = var11_12.getMeasuredHeight();
                                                var13_6 = var1_1;
                                                if (var4_4 == -2147483648) {
                                                    var13_6 = var1_1;
                                                    if (var16_16 > var1_1) {
                                                        var13_6 = Math.min(var16_16, var3_3);
                                                    }
                                                }
                                                if ((var1_1 = var5_5 - var15_15) >= 0) break block28;
                                                var17_17 = true;
lbl90:
                                                // 2 sources

                                                while (true) {
                                                    var12_13.slideable = var17_17;
                                                    if (var12_13.slideable) {
                                                        this.mSlideableView = var11_12;
                                                    }
                                                    var5_5 = var13_6;
                                                    var6_7 = var17_17 | var6_7;
                                                    var10_11 = var14_14;
                                                    ** continue;
                                                    break;
                                                }
                                                break;
                                            }
lbl98:
                                            // 1 sources

                                            ** GOTO lbl33
                                        }
                                        break block34;
                                    }
                                    if (var12_13.width != -1) break block35;
                                    var13_6 = View.MeasureSpec.makeMeasureSpec((int)(var7_8 - var13_6), (int)0x40000000);
                                    ** GOTO lbl77
                                }
                                var13_6 = View.MeasureSpec.makeMeasureSpec((int)var12_13.width, (int)0x40000000);
                                ** GOTO lbl77
                            }
                            if (var12_13.height != -1) break block36;
                            var15_15 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)0x40000000);
                            ** GOTO lbl79
                        }
                        var15_15 = View.MeasureSpec.makeMeasureSpec((int)var12_13.height, (int)0x40000000);
                        ** while (true)
                    }
                    var17_17 = false;
                    ** while (true)
                }
                if (!var6_7 && !(var10_11 > 0.0f)) break block37;
                var9_10 = var7_8 - this.mOverhangSize;
                block11: for (var13_6 = 0; var13_6 < var8_9; ++var13_6) {
                    block43: {
                        block41: {
                            block44: {
                                block42: {
                                    block31: {
                                        block29: {
                                            block40: {
                                                block30: {
                                                    block39: {
                                                        block38: {
                                                            var11_12 = this.getChildAt(var13_6);
                                                            if (var11_12.getVisibility() == 8) lbl-1000:
                                                            // 8 sources

                                                            {
                                                                continue block11;
                                                            }
                                                            var12_13 = (LayoutParams)var11_12.getLayoutParams();
                                                            if (var11_12.getVisibility() == 8) ** GOTO lbl-1000
                                                            if (var12_13.width != 0 || !(var12_13.weight > 0.0f)) break block38;
                                                            var4_4 = 1;
lbl129:
                                                            // 2 sources

                                                            while (var4_4 != 0) {
                                                                var15_15 = 0;
lbl131:
                                                                // 2 sources

                                                                while (var6_7 && var11_12 != this.mSlideableView) {
                                                                    if (var12_13.width >= 0 || var15_15 <= var9_10 && !(var12_13.weight > 0.0f)) ** GOTO lbl-1000
                                                                    if (var4_4 == 0) break block29;
                                                                    if (var12_13.height != -2) break block30;
                                                                    var4_4 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)-2147483648);
lbl136:
                                                                    // 4 sources

                                                                    while (true) {
                                                                        var11_12.measure(View.MeasureSpec.makeMeasureSpec((int)var9_10, (int)0x40000000), var4_4);
                                                                        ** GOTO lbl-1000
                                                                        break;
                                                                    }
                                                                }
                                                                break block31;
                                                            }
                                                            break block39;
                                                        }
                                                        var4_4 = 0;
                                                        ** GOTO lbl129
                                                    }
                                                    var15_15 = var11_12.getMeasuredWidth();
                                                    ** GOTO lbl131
                                                }
                                                if (var12_13.height != -1) break block40;
                                                var4_4 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)0x40000000);
                                                ** GOTO lbl136
                                            }
                                            var4_4 = View.MeasureSpec.makeMeasureSpec((int)var12_13.height, (int)0x40000000);
                                            ** GOTO lbl136
                                        }
                                        var4_4 = View.MeasureSpec.makeMeasureSpec((int)var11_12.getMeasuredHeight(), (int)0x40000000);
                                        ** continue;
                                    }
                                    if (!(var12_13.weight > 0.0f)) ** GOTO lbl-1000
                                    if (var12_13.width != 0) break block41;
                                    if (var12_13.height != -2) break block42;
                                    var4_4 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)-2147483648);
lbl162:
                                    // 4 sources

                                    while (var6_7) {
                                        var16_16 = var12_13.leftMargin;
                                        var16_16 = var7_8 - (var12_13.rightMargin + var16_16);
                                        var18_18 = View.MeasureSpec.makeMeasureSpec((int)var16_16, (int)0x40000000);
                                        if (var15_15 == var16_16) ** GOTO lbl-1000
                                        var11_12.measure(var18_18, var4_4);
                                        ** GOTO lbl-1000
                                    }
                                    break block43;
                                }
                                if (var12_13.height != -1) break block44;
                                var4_4 = View.MeasureSpec.makeMeasureSpec((int)var3_3, (int)0x40000000);
                                ** GOTO lbl162
                            }
                            var4_4 = View.MeasureSpec.makeMeasureSpec((int)var12_13.height, (int)0x40000000);
                            ** GOTO lbl162
                        }
                        var4_4 = View.MeasureSpec.makeMeasureSpec((int)var11_12.getMeasuredHeight(), (int)0x40000000);
                        ** GOTO lbl162
                    }
                    var16_16 = Math.max(0, var5_5);
                    var11_12.measure(View.MeasureSpec.makeMeasureSpec((int)((int)(var12_13.weight * (float)var16_16 / var10_11) + var15_15), (int)0x40000000), var4_4);
                    ** continue;
                }
            }
            this.setMeasuredDimension(var2_2, this.getPaddingTop() + var1_1 + this.getPaddingBottom());
            this.mCanSlide = var6_7;
            if (this.mDragHelper.getViewDragState() != 0 && !var6_7) {
                this.mDragHelper.abort();
            }
            return;
        }
        var2_2 = var4_4;
        var4_4 = var5_5;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        SavedState savedState = (SavedState)((Object)object);
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = savedState.isOpen;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        boolean bl2 = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        savedState.isOpen = bl2;
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.mFirstLayout = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mCanSlide) {
            return super.onTouchEvent(motionEvent);
        }
        this.mDragHelper.processTouchEvent(motionEvent);
        int n2 = motionEvent.getAction();
        boolean bl2 = true;
        switch (n2 & 0xFF) {
            default: {
                return bl2;
            }
            case 0: {
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                this.mInitialMotionX = f2;
                this.mInitialMotionY = f3;
                return bl2;
            }
            case 1: 
        }
        boolean bl3 = bl2;
        if (!this.isDimmed(this.mSlideableView)) return bl3;
        float f4 = motionEvent.getX();
        float f5 = motionEvent.getY();
        float f6 = f4 - this.mInitialMotionX;
        float f7 = f5 - this.mInitialMotionY;
        n2 = this.mDragHelper.getTouchSlop();
        bl3 = bl2;
        if (!(f6 * f6 + f7 * f7 < (float)(n2 * n2))) return bl3;
        bl3 = bl2;
        if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)f4, (int)f5)) return bl3;
        this.closePane(this.mSlideableView, 0);
        return bl2;
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            boolean bl2 = view == this.mSlideableView;
            this.mPreservedOpenState = bl2;
        }
    }

    void setAllChildrenVisible() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 4) continue;
            view.setVisibility(0);
        }
    }

    public void setCoveredFadeColor(@ColorInt int n2) {
        this.mCoveredFadeColor = n2;
    }

    public void setPanelSlideListener(PanelSlideListener panelSlideListener) {
        this.mPanelSlideListener = panelSlideListener;
    }

    public void setParallaxDistance(int n2) {
        this.mParallaxBy = n2;
        this.requestLayout();
    }

    @Deprecated
    public void setShadowDrawable(Drawable drawable2) {
        this.setShadowDrawableLeft(drawable2);
    }

    public void setShadowDrawableLeft(Drawable drawable2) {
        this.mShadowDrawableLeft = drawable2;
    }

    public void setShadowDrawableRight(Drawable drawable2) {
        this.mShadowDrawableRight = drawable2;
    }

    @Deprecated
    public void setShadowResource(@DrawableRes int n2) {
        this.setShadowDrawable(this.getResources().getDrawable(n2));
    }

    public void setShadowResourceLeft(int n2) {
        this.setShadowDrawableLeft(this.getResources().getDrawable(n2));
    }

    public void setShadowResourceRight(int n2) {
        this.setShadowDrawableRight(this.getResources().getDrawable(n2));
    }

    public void setSliderFadeColor(@ColorInt int n2) {
        this.mSliderFadeColor = n2;
    }

    @Deprecated
    public void smoothSlideClosed() {
        this.closePane();
    }

    @Deprecated
    public void smoothSlideOpen() {
        this.openPane();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean smoothSlideTo(float f2, int n2) {
        if (!this.mCanSlide) {
            return false;
        }
        boolean bl2 = this.isLayoutRtlSupport();
        LayoutParams layoutParams = (LayoutParams)this.mSlideableView.getLayoutParams();
        if (bl2) {
            int n3 = this.getPaddingRight();
            int n4 = layoutParams.rightMargin;
            n2 = this.mSlideableView.getWidth();
            n2 = (int)((float)this.getWidth() - ((float)(n4 + n3) + (float)this.mSlideRange * f2 + (float)n2));
        } else {
            n2 = this.getPaddingLeft();
            n2 = (int)((float)(layoutParams.leftMargin + n2) + (float)this.mSlideRange * f2);
        }
        if (!this.mDragHelper.smoothSlideViewTo(this.mSlideableView, n2, this.mSlideableView.getTop())) return false;
        this.setAllChildrenVisible();
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateObscuredViewsVisibility(View view) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2 = this.isLayoutRtlSupport();
        int n6 = bl2 ? this.getWidth() - this.getPaddingRight() : this.getPaddingLeft();
        int n7 = bl2 ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight();
        int n8 = this.getPaddingTop();
        int n9 = this.getHeight();
        int n10 = this.getPaddingBottom();
        if (view != null && SlidingPaneLayout.viewIsOpaque(view)) {
            n5 = view.getLeft();
            n4 = view.getRight();
            n3 = view.getTop();
            n2 = view.getBottom();
        } else {
            n2 = 0;
            n3 = 0;
            n4 = 0;
            n5 = 0;
        }
        int n11 = this.getChildCount();
        int n12 = 0;
        View view2;
        while (n12 < n11 && (view2 = this.getChildAt(n12)) != view) {
            int n13 = bl2 ? n7 : n6;
            int n14 = Math.max(n13, view2.getLeft());
            int n15 = Math.max(n8, view2.getTop());
            n13 = bl2 ? n6 : n7;
            int n16 = Math.min(n13, view2.getRight());
            n13 = Math.min(n9 - n10, view2.getBottom());
            n13 = n14 >= n5 && n15 >= n3 && n16 <= n4 && n13 <= n2 ? 4 : 0;
            view2.setVisibility(n13);
            ++n12;
        }
        return;
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2) {
            Rect rect = this.mTmpRect;
            accessibilityNodeInfoCompat2.getBoundsInParent(rect);
            accessibilityNodeInfoCompat.setBoundsInParent(rect);
            accessibilityNodeInfoCompat2.getBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setVisibleToUser(accessibilityNodeInfoCompat2.isVisibleToUser());
            accessibilityNodeInfoCompat.setPackageName(accessibilityNodeInfoCompat2.getPackageName());
            accessibilityNodeInfoCompat.setClassName(accessibilityNodeInfoCompat2.getClassName());
            accessibilityNodeInfoCompat.setContentDescription(accessibilityNodeInfoCompat2.getContentDescription());
            accessibilityNodeInfoCompat.setEnabled(accessibilityNodeInfoCompat2.isEnabled());
            accessibilityNodeInfoCompat.setClickable(accessibilityNodeInfoCompat2.isClickable());
            accessibilityNodeInfoCompat.setFocusable(accessibilityNodeInfoCompat2.isFocusable());
            accessibilityNodeInfoCompat.setFocused(accessibilityNodeInfoCompat2.isFocused());
            accessibilityNodeInfoCompat.setAccessibilityFocused(accessibilityNodeInfoCompat2.isAccessibilityFocused());
            accessibilityNodeInfoCompat.setSelected(accessibilityNodeInfoCompat2.isSelected());
            accessibilityNodeInfoCompat.setLongClickable(accessibilityNodeInfoCompat2.isLongClickable());
            accessibilityNodeInfoCompat.addAction(accessibilityNodeInfoCompat2.getActions());
            accessibilityNodeInfoCompat.setMovementGranularities(accessibilityNodeInfoCompat2.getMovementGranularities());
        }

        public boolean filter(View view) {
            return SlidingPaneLayout.this.isDimmed(view);
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)SlidingPaneLayout.class.getName());
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = AccessibilityNodeInfoCompat.obtain(accessibilityNodeInfoCompat);
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat2);
            this.copyNodeInfoNoChildren(accessibilityNodeInfoCompat, accessibilityNodeInfoCompat2);
            accessibilityNodeInfoCompat2.recycle();
            accessibilityNodeInfoCompat.setClassName(SlidingPaneLayout.class.getName());
            accessibilityNodeInfoCompat.setSource(view);
            view = ViewCompat.getParentForAccessibility(view);
            if (view instanceof View) {
                accessibilityNodeInfoCompat.setParent(view);
            }
            int n2 = SlidingPaneLayout.this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                view = SlidingPaneLayout.this.getChildAt(i2);
                if (this.filter(view) || view.getVisibility() != 0) continue;
                ViewCompat.setImportantForAccessibility(view, 1);
                accessibilityNodeInfoCompat.addChild(view);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            if (this.filter(view)) return false;
            return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
        }
    }

    private class DisableLayerRunnable
    implements Runnable {
        final View mChildView;

        DisableLayerRunnable(View view) {
            this.mChildView = view;
        }

        @Override
        public void run() {
            if (this.mChildView.getParent() == SlidingPaneLayout.this) {
                ViewCompat.setLayerType(this.mChildView, 0, null);
                SlidingPaneLayout.this.invalidateChildRegion(this.mChildView);
            }
            SlidingPaneLayout.this.mPostedRunnables.remove(this);
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int clampViewPositionHorizontal(View object, int n2, int n3) {
            int n4;
            int n5;
            LayoutParams layoutParams = (LayoutParams)SlidingPaneLayout.this.mSlideableView.getLayoutParams();
            if (SlidingPaneLayout.this.isLayoutRtlSupport()) {
                int n6 = SlidingPaneLayout.this.getWidth();
                n5 = SlidingPaneLayout.this.getPaddingRight();
                n6 -= layoutParams.rightMargin + n5 + SlidingPaneLayout.this.mSlideableView.getWidth();
                n5 = SlidingPaneLayout.this.mSlideRange;
                return Math.max(Math.min(n4, n6), n6 - n5);
            }
            n5 = SlidingPaneLayout.this.getPaddingLeft();
            int n7 = layoutParams.leftMargin + n5;
            n5 = SlidingPaneLayout.this.mSlideRange;
            return Math.min(Math.max(n4, n7), n5 + n7);
        }

        @Override
        public int clampViewPositionVertical(View view, int n2, int n3) {
            return view.getTop();
        }

        @Override
        public int getViewHorizontalDragRange(View view) {
            return SlidingPaneLayout.this.mSlideRange;
        }

        @Override
        public void onEdgeDragStarted(int n2, int n3) {
            SlidingPaneLayout.this.mDragHelper.captureChildView(SlidingPaneLayout.this.mSlideableView, n3);
        }

        @Override
        public void onViewCaptured(View view, int n2) {
            SlidingPaneLayout.this.setAllChildrenVisible();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onViewDragStateChanged(int n2) {
            block4: {
                block3: {
                    if (SlidingPaneLayout.this.mDragHelper.getViewDragState() != 0) break block3;
                    if (SlidingPaneLayout.this.mSlideOffset != 0.0f) break block4;
                    SlidingPaneLayout.this.updateObscuredViewsVisibility(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.dispatchOnPanelClosed(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.access$502(SlidingPaneLayout.this, false);
                }
                return;
            }
            SlidingPaneLayout.this.dispatchOnPanelOpened(SlidingPaneLayout.this.mSlideableView);
            SlidingPaneLayout.access$502(SlidingPaneLayout.this, true);
        }

        @Override
        public void onViewPositionChanged(View view, int n2, int n3, int n4, int n5) {
            SlidingPaneLayout.this.onPanelDragged(n2);
            SlidingPaneLayout.this.invalidate();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onViewReleased(View view, float f2, float f3) {
            int n2;
            block7: {
                int n3;
                block8: {
                    LayoutParams layoutParams;
                    block4: {
                        int n4;
                        block6: {
                            block5: {
                                layoutParams = (LayoutParams)view.getLayoutParams();
                                if (!SlidingPaneLayout.this.isLayoutRtlSupport()) break block4;
                                n2 = SlidingPaneLayout.this.getPaddingRight();
                                n4 = layoutParams.rightMargin + n2;
                                if (f2 < 0.0f) break block5;
                                n2 = n4;
                                if (f2 != 0.0f) break block6;
                                n2 = n4;
                                if (!(SlidingPaneLayout.this.mSlideOffset > 0.5f)) break block6;
                            }
                            n2 = n4 + SlidingPaneLayout.this.mSlideRange;
                        }
                        n4 = SlidingPaneLayout.this.mSlideableView.getWidth();
                        n2 = SlidingPaneLayout.this.getWidth() - n2 - n4;
                        break block7;
                    }
                    n2 = SlidingPaneLayout.this.getPaddingLeft();
                    n3 = layoutParams.leftMargin + n2;
                    if (f2 > 0.0f) break block8;
                    n2 = n3;
                    if (f2 != 0.0f) break block7;
                    n2 = n3;
                    if (!(SlidingPaneLayout.this.mSlideOffset > 0.5f)) break block7;
                }
                n2 = n3 + SlidingPaneLayout.this.mSlideRange;
            }
            SlidingPaneLayout.this.mDragHelper.settleCapturedViewAt(n2, view.getTop());
            SlidingPaneLayout.this.invalidate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean tryCaptureView(View view, int n2) {
            if (!SlidingPaneLayout.this.mIsUnableToDrag) return ((LayoutParams)view.getLayoutParams()).slideable;
            return false;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        Paint dimPaint;
        boolean dimWhenOffset;
        boolean slideable;
        public float weight = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, ATTRS);
            this.weight = context.getFloat(0, 0.0f);
            context.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.weight = layoutParams.weight;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    public static interface PanelSlideListener {
        public void onPanelClosed(View var1);

        public void onPanelOpened(View var1);

        public void onPanelSlide(View var1, float var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        boolean isOpen;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl2 = parcel.readInt() != 0;
            this.isOpen = bl2;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            n2 = this.isOpen ? 1 : 0;
            parcel.writeInt(n2);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelClosed(View view) {
        }

        @Override
        public void onPanelOpened(View view) {
        }

        @Override
        public void onPanelSlide(View view, float f2) {
        }
    }

    static interface SlidingPanelLayoutImpl {
        public void invalidateChildRegion(SlidingPaneLayout var1, View var2);
    }

    static class SlidingPanelLayoutImplBase
    implements SlidingPanelLayoutImpl {
        SlidingPanelLayoutImplBase() {
        }

        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            ViewCompat.postInvalidateOnAnimation((View)slidingPaneLayout, view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    static class SlidingPanelLayoutImplJB
    extends SlidingPanelLayoutImplBase {
        private Method mGetDisplayList;
        private Field mRecreateDisplayList;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        SlidingPanelLayoutImplJB() {
            try {
                this.mGetDisplayList = View.class.getDeclaredMethod("getDisplayList", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch getDisplayList method; dimming won't work right.", (Throwable)noSuchMethodException);
            }
            try {
                this.mRecreateDisplayList = View.class.getDeclaredField("mRecreateDisplayList");
                this.mRecreateDisplayList.setAccessible(true);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.e((String)SlidingPaneLayout.TAG, (String)"Couldn't fetch mRecreateDisplayList field; dimming will be slow.", (Throwable)noSuchFieldException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            if (this.mGetDisplayList != null && this.mRecreateDisplayList != null) {
                try {
                    this.mRecreateDisplayList.setBoolean(view, true);
                    this.mGetDisplayList.invoke((Object)view, (Object[])null);
                }
                catch (Exception exception) {
                    Log.e((String)SlidingPaneLayout.TAG, (String)"Error refreshing display list state", (Throwable)exception);
                }
                super.invalidateChildRegion(slidingPaneLayout, view);
                return;
            }
            view.invalidate();
        }
    }

    static class SlidingPanelLayoutImplJBMR1
    extends SlidingPanelLayoutImplBase {
        SlidingPanelLayoutImplJBMR1() {
        }

        @Override
        public void invalidateChildRegion(SlidingPaneLayout slidingPaneLayout, View view) {
            ViewCompat.setLayerPaint(view, ((LayoutParams)view.getLayoutParams()).dimPaint);
        }
    }
}

