/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

final class SwipeProgressBar {
    private static final int ANIMATION_DURATION_MS = 2000;
    private static final int COLOR1 = -1291845632;
    private static final int COLOR2 = Integer.MIN_VALUE;
    private static final int COLOR3 = 0x4D000000;
    private static final int COLOR4 = 0x1A000000;
    private static final int FINISH_ANIMATION_DURATION_MS = 1000;
    private static final Interpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private Rect mBounds;
    private final RectF mClipRect;
    private int mColor1;
    private int mColor2;
    private int mColor3;
    private int mColor4;
    private long mFinishTime;
    private final Paint mPaint = new Paint();
    private View mParent;
    private boolean mRunning;
    private long mStartTime;
    private float mTriggerPercentage;

    public SwipeProgressBar(View view) {
        this.mClipRect = new RectF();
        this.mBounds = new Rect();
        this.mParent = view;
        this.mColor1 = -1291845632;
        this.mColor2 = Integer.MIN_VALUE;
        this.mColor3 = 0x4D000000;
        this.mColor4 = 0x1A000000;
    }

    private void drawCircle(Canvas canvas, float f2, float f3, int n2, float f4) {
        this.mPaint.setColor(n2);
        canvas.save();
        canvas.translate(f2, f3);
        f3 = INTERPOLATOR.getInterpolation(f4);
        canvas.scale(f3, f3);
        canvas.drawCircle(0.0f, 0.0f, f2, this.mPaint);
        canvas.restore();
    }

    private void drawTrigger(Canvas canvas, int n2, int n3) {
        this.mPaint.setColor(this.mColor1);
        canvas.drawCircle((float)n2, (float)n3, (float)n2 * this.mTriggerPercentage, this.mPaint);
    }

    /*
     * Enabled aggressive block sorting
     */
    void draw(Canvas canvas) {
        int n2;
        block20: {
            float f2;
            float f3;
            long l2;
            int n3;
            int n4;
            int n5;
            block19: {
                block18: {
                    block17: {
                        n2 = this.mBounds.width();
                        int n6 = this.mBounds.height();
                        n5 = n2 / 2;
                        n4 = n6 / 2;
                        n3 = canvas.save();
                        canvas.clipRect(this.mBounds);
                        if (!this.mRunning && this.mFinishTime <= 0L) break block17;
                        long l3 = AnimationUtils.currentAnimationTimeMillis();
                        long l4 = this.mStartTime;
                        l2 = (l3 - this.mStartTime) / 2000L;
                        f3 = (float)((l3 - l4) % 2000L) / 20.0f;
                        if (this.mRunning) break block18;
                        if (l3 - this.mFinishTime >= 1000L) {
                            this.mFinishTime = 0L;
                            return;
                        }
                        f2 = (float)((l3 - this.mFinishTime) % 1000L) / 10.0f / 100.0f;
                        float f4 = n2 / 2;
                        f2 = INTERPOLATOR.getInterpolation(f2) * f4;
                        this.mClipRect.set((float)n5 - f2, 0.0f, f2 + (float)n5, (float)n6);
                        canvas.saveLayerAlpha(this.mClipRect, 0, 0);
                        n2 = 1;
                        break block19;
                    }
                    n2 = n3;
                    if (this.mTriggerPercentage > 0.0f) {
                        n2 = n3;
                        if ((double)this.mTriggerPercentage <= 1.0) {
                            this.drawTrigger(canvas, n5, n4);
                            n2 = n3;
                        }
                    }
                    break block20;
                }
                n2 = 0;
            }
            if (l2 == 0L) {
                canvas.drawColor(this.mColor1);
            } else if (f3 >= 0.0f && f3 < 25.0f) {
                canvas.drawColor(this.mColor4);
            } else if (f3 >= 25.0f && f3 < 50.0f) {
                canvas.drawColor(this.mColor1);
            } else if (f3 >= 50.0f && f3 < 75.0f) {
                canvas.drawColor(this.mColor2);
            } else {
                canvas.drawColor(this.mColor3);
            }
            if (f3 >= 0.0f && f3 <= 25.0f) {
                f2 = (25.0f + f3) * 2.0f / 100.0f;
                this.drawCircle(canvas, n5, n4, this.mColor1, f2);
            }
            if (f3 >= 0.0f && f3 <= 50.0f) {
                f2 = 2.0f * f3 / 100.0f;
                this.drawCircle(canvas, n5, n4, this.mColor2, f2);
            }
            if (f3 >= 25.0f && f3 <= 75.0f) {
                f2 = (f3 - 25.0f) * 2.0f / 100.0f;
                this.drawCircle(canvas, n5, n4, this.mColor3, f2);
            }
            if (f3 >= 50.0f && f3 <= 100.0f) {
                f2 = (f3 - 50.0f) * 2.0f / 100.0f;
                this.drawCircle(canvas, n5, n4, this.mColor4, f2);
            }
            if (f3 >= 75.0f && f3 <= 100.0f) {
                f3 = (f3 - 75.0f) * 2.0f / 100.0f;
                this.drawCircle(canvas, n5, n4, this.mColor1, f3);
            }
            if (this.mTriggerPercentage > 0.0f && n2 != 0) {
                canvas.restoreToCount(n3);
                n3 = canvas.save();
                canvas.clipRect(this.mBounds);
                this.drawTrigger(canvas, n5, n4);
            }
            ViewCompat.postInvalidateOnAnimation(this.mParent, this.mBounds.left, this.mBounds.top, this.mBounds.right, this.mBounds.bottom);
            n2 = n3;
        }
        canvas.restoreToCount(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRunning() {
        if (this.mRunning) return true;
        if (this.mFinishTime <= 0L) return false;
        return true;
    }

    void setBounds(int n2, int n3, int n4, int n5) {
        this.mBounds.left = n2;
        this.mBounds.top = n3;
        this.mBounds.right = n4;
        this.mBounds.bottom = n5;
    }

    void setColorScheme(int n2, int n3, int n4, int n5) {
        this.mColor1 = n2;
        this.mColor2 = n3;
        this.mColor3 = n4;
        this.mColor4 = n5;
    }

    void setTriggerPercentage(float f2) {
        this.mTriggerPercentage = f2;
        this.mStartTime = 0L;
        ViewCompat.postInvalidateOnAnimation(this.mParent, this.mBounds.left, this.mBounds.top, this.mBounds.right, this.mBounds.bottom);
    }

    void start() {
        if (!this.mRunning) {
            this.mTriggerPercentage = 0.0f;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mRunning = true;
            this.mParent.postInvalidate();
        }
    }

    void stop() {
        if (this.mRunning) {
            this.mTriggerPercentage = 0.0f;
            this.mFinishTime = AnimationUtils.currentAnimationTimeMillis();
            this.mRunning = false;
            this.mParent.postInvalidate();
        }
    }
}

