/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatCallback;
import android.support.v7.app.AppCompatDelegateImplV11;
import android.support.v7.app.AppCompatDelegateImplV14;
import android.support.v7.app.AppCompatDelegateImplV23;
import android.support.v7.app.AppCompatDelegateImplV7;
import android.support.v7.view.ActionMode;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class AppCompatDelegate {
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;
    public static final int FEATURE_SUPPORT_ACTION_BAR = 108;
    public static final int FEATURE_SUPPORT_ACTION_BAR_OVERLAY = 109;
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_FOLLOW_SYSTEM = -1;
    public static final int MODE_NIGHT_NO = 1;
    static final int MODE_NIGHT_UNSPECIFIED = -100;
    public static final int MODE_NIGHT_YES = 2;
    static final String TAG = "AppCompatDelegate";
    private static boolean sCompatVectorFromResourcesEnabled;
    private static int sDefaultNightMode;

    static {
        sDefaultNightMode = -1;
        sCompatVectorFromResourcesEnabled = false;
    }

    AppCompatDelegate() {
    }

    public static AppCompatDelegate create(Activity activity, AppCompatCallback appCompatCallback) {
        return AppCompatDelegate.create((Context)activity, activity.getWindow(), appCompatCallback);
    }

    public static AppCompatDelegate create(Dialog dialog, AppCompatCallback appCompatCallback) {
        return AppCompatDelegate.create(dialog.getContext(), dialog.getWindow(), appCompatCallback);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AppCompatDelegate create(Context object, Window window, AppCompatCallback appCompatCallback) {
        void var0_2;
        void var2_7;
        void var1_6;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 23) {
            AppCompatDelegateImplV23 appCompatDelegateImplV23 = new AppCompatDelegateImplV23((Context)object, (Window)var1_6, (AppCompatCallback)var2_7);
            return var0_2;
        }
        if (n2 >= 14) {
            AppCompatDelegateImplV14 appCompatDelegateImplV14 = new AppCompatDelegateImplV14((Context)object, (Window)var1_6, (AppCompatCallback)var2_7);
            return var0_2;
        }
        if (n2 >= 11) {
            AppCompatDelegateImplV11 appCompatDelegateImplV11 = new AppCompatDelegateImplV11((Context)object, (Window)var1_6, (AppCompatCallback)var2_7);
            return var0_2;
        }
        AppCompatDelegateImplV7 appCompatDelegateImplV7 = new AppCompatDelegateImplV7((Context)object, (Window)var1_6, (AppCompatCallback)var2_7);
        return var0_2;
    }

    public static int getDefaultNightMode() {
        return sDefaultNightMode;
    }

    public static boolean isCompatVectorFromResourcesEnabled() {
        return sCompatVectorFromResourcesEnabled;
    }

    public static void setCompatVectorFromResourcesEnabled(boolean bl2) {
        sCompatVectorFromResourcesEnabled = bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultNightMode(int n2) {
        switch (n2) {
            default: {
                Log.d((String)TAG, (String)"setDefaultNightMode() called with an unknown mode");
                return;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
        }
        sDefaultNightMode = n2;
    }

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract boolean applyDayNight();

    public abstract View createView(@Nullable View var1, String var2, @NonNull Context var3, @NonNull AttributeSet var4);

    @Nullable
    public abstract View findViewById(@IdRes int var1);

    @Nullable
    public abstract ActionBarDrawerToggle.Delegate getDrawerToggleDelegate();

    public abstract MenuInflater getMenuInflater();

    @Nullable
    public abstract ActionBar getSupportActionBar();

    public abstract boolean hasWindowFeature(int var1);

    public abstract void installViewFactory();

    public abstract void invalidateOptionsMenu();

    public abstract boolean isHandleNativeActionModesEnabled();

    public abstract void onConfigurationChanged(Configuration var1);

    public abstract void onCreate(Bundle var1);

    public abstract void onDestroy();

    public abstract void onPostCreate(Bundle var1);

    public abstract void onPostResume();

    public abstract void onSaveInstanceState(Bundle var1);

    public abstract void onStop();

    public abstract boolean requestWindowFeature(int var1);

    public abstract void setContentView(@LayoutRes int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void setHandleNativeActionModesEnabled(boolean var1);

    public abstract void setLocalNightMode(int var1);

    public abstract void setSupportActionBar(@Nullable Toolbar var1);

    public abstract void setTitle(@Nullable CharSequence var1);

    @Nullable
    public abstract ActionMode startSupportActionMode(@NonNull ActionMode.Callback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NightMode {
    }
}

