/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuView;
import android.support.v7.view.menu.SubMenuBuilder;
import android.support.v7.widget.AppCompatDrawableManager;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public final class MenuItemImpl
implements SupportMenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    private static final int IS_ACTION = 32;
    static final int NO_ICON = 0;
    private static final int SHOW_AS_ACTION_MASK = 3;
    private static final String TAG = "MenuItemImpl";
    private static String sDeleteShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sPrependShortcutLabel;
    private static String sSpaceShortcutLabel;
    private ActionProvider mActionProvider;
    private View mActionView;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;
    private final int mGroup;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private final int mId;
    private Intent mIntent;
    private boolean mIsActionViewExpanded = false;
    private Runnable mItemCallback;
    private MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private MenuItemCompat.OnActionExpandListener mOnActionExpandListener;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private char mShortcutNumericChar;
    private int mShowAsAction = 0;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;

    MenuItemImpl(MenuBuilder menuBuilder, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6) {
        this.mMenu = menuBuilder;
        this.mId = n3;
        this.mGroup = n2;
        this.mCategoryOrder = n4;
        this.mOrdering = n5;
        this.mTitle = charSequence;
        this.mShowAsAction = n6;
    }

    static /* synthetic */ MenuBuilder access$000(MenuItemImpl menuItemImpl) {
        return menuItemImpl.mMenu;
    }

    public void actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean collapseActionView() {
        boolean bl2 = false;
        if ((this.mShowAsAction & 8) == 0) {
            return bl2;
        }
        if (this.mActionView == null) {
            return true;
        }
        if (this.mOnActionExpandListener == null) return this.mMenu.collapseItemActionView(this);
        if (!this.mOnActionExpandListener.onMenuItemActionCollapse(this)) return bl2;
        return this.mMenu.collapseItemActionView(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean expandActionView() {
        boolean bl2 = false;
        if (!this.hasCollapsibleActionView()) {
            return bl2;
        }
        if (this.mOnActionExpandListener == null) return this.mMenu.expandItemActionView(this);
        if (!this.mOnActionExpandListener.onMenuItemActionExpand(this)) return bl2;
        return this.mMenu.expandItemActionView(this);
    }

    public android.view.ActionProvider getActionProvider() {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.getActionProvider()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getActionView() {
        if (this.mActionView != null) {
            return this.mActionView;
        }
        if (this.mActionProvider == null) return null;
        this.mActionView = this.mActionProvider.onCreateActionView(this);
        return this.mActionView;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId == 0) return null;
        Drawable drawable2 = AppCompatDrawableManager.get().getDrawable(this.mMenu.getContext(), this.mIconResId);
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        return drawable2;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    char getShortcut() {
        if (!this.mMenu.isQwertyMode()) char c2;
        return c2 = this.mShortcutNumericChar;
        char c3 = this.mShortcutAlphabeticChar;
        return c3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getShortcutLabel() {
        char c2 = this.getShortcut();
        if (c2 == '\u0000') {
            return "";
        }
        CharSequence charSequence = new StringBuilder(sPrependShortcutLabel);
        switch (c2) {
            default: {
                ((StringBuilder)charSequence).append(c2);
                return ((StringBuilder)charSequence).toString();
            }
            case '\n': {
                ((StringBuilder)charSequence).append(sEnterShortcutLabel);
                return ((StringBuilder)charSequence).toString();
            }
            case '\b': {
                ((StringBuilder)charSequence).append(sDeleteShortcutLabel);
                return ((StringBuilder)charSequence).toString();
            }
            case ' ': 
        }
        ((StringBuilder)charSequence).append(sSpaceShortcutLabel);
        return ((StringBuilder)charSequence).toString();
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    @Override
    public ActionProvider getSupportActionProvider() {
        return this.mActionProvider;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CharSequence getTitleCondensed() {
        CharSequence charSequence = this.mTitleCondensed != null ? this.mTitleCondensed : this.mTitle;
        CharSequence charSequence2 = charSequence;
        if (Build.VERSION.SDK_INT >= 18) return charSequence2;
        charSequence2 = charSequence;
        if (charSequence == null) return charSequence2;
        charSequence2 = charSequence;
        if (charSequence instanceof String) return charSequence2;
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CharSequence getTitleForItemView(MenuView.ItemView object) {
        void var1_3;
        if (object != null && object.prefersCondensedTitle()) {
            CharSequence charSequence = this.getTitleCondensed();
            return var1_3;
        }
        CharSequence charSequence = this.getTitle();
        return var1_3;
    }

    public boolean hasCollapsibleActionView() {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if ((this.mShowAsAction & 8) != 0) {
            if (this.mActionView == null && this.mActionProvider != null) {
                this.mActionView = this.mActionProvider.onCreateActionView(this);
            }
            bl3 = bl2;
            if (this.mActionView != null) {
                bl3 = true;
            }
        }
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSubMenu() {
        if (this.mSubMenu == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke() {
        boolean bl2 = true;
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick((MenuItem)this)) {
            return bl2;
        }
        boolean bl3 = bl2;
        if (this.mMenu.dispatchMenuItemSelected(this.mMenu.getRootMenu(), (MenuItem)this)) return bl3;
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return bl2;
        }
        if (this.mIntent != null) {
            try {
                this.mMenu.getContext().startActivity(this.mIntent);
                return bl2;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.e((String)TAG, (String)"Can't find activity to handle intent; ignoring", (Throwable)activityNotFoundException);
            }
        }
        if (this.mActionProvider == null) return false;
        bl3 = bl2;
        if (this.mActionProvider.onPerformDefaultAction()) return bl3;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActionButton() {
        if ((this.mFlags & 0x20) != 32) return false;
        return true;
    }

    @Override
    public boolean isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCheckable() {
        boolean bl2 = true;
        if ((this.mFlags & 1) != 1) return false;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChecked() {
        if ((this.mFlags & 2) != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled() {
        if ((this.mFlags & 0x10) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExclusiveCheckable() {
        if ((this.mFlags & 4) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVisible() {
        boolean bl2 = true;
        if (this.mActionProvider != null && this.mActionProvider.overridesItemVisibility()) {
            if ((this.mFlags & 8) != 0) return false;
            if (!this.mActionProvider.isVisible()) return false;
            return bl2;
        }
        if ((this.mFlags & 8) == 0) return bl2;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestsActionButton() {
        boolean bl2 = true;
        if ((this.mShowAsAction & 1) != 1) return false;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requiresActionButton() {
        if ((this.mShowAsAction & 2) != 2) return false;
        return true;
    }

    public MenuItem setActionProvider(android.view.ActionProvider actionProvider) {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.setActionProvider()");
    }

    @Override
    public SupportMenuItem setActionView(int n2) {
        Context context = this.mMenu.getContext();
        this.setActionView(LayoutInflater.from((Context)context).inflate(n2, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    @Override
    public SupportMenuItem setActionView(View view) {
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && this.mId > 0) {
            view.setId(this.mId);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    public void setActionViewExpanded(boolean bl2) {
        this.mIsActionViewExpanded = bl2;
        this.mMenu.onItemsChanged(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MenuItem setAlphabeticShortcut(char c2) {
        if (this.mShortcutAlphabeticChar == c2) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setCallback(Runnable runnable) {
        this.mItemCallback = runnable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuItem setCheckable(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = this.mFlags;
        int n4 = bl2 ? 1 : 0;
        this.mFlags = n4 | n3 & 0xFFFFFFFE;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MenuItem setChecked(boolean bl2) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked((MenuItem)this);
            return this;
        }
        this.setCheckedInt(bl2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCheckedInt(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = this.mFlags;
        int n4 = bl2 ? 2 : 0;
        this.mFlags = n4 | n3 & 0xFFFFFFFD;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuItem setEnabled(boolean bl2) {
        this.mFlags = bl2 ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExclusiveCheckable(boolean bl2) {
        int n2 = this.mFlags;
        int n3 = bl2 ? 4 : 0;
        this.mFlags = n3 | n2 & 0xFFFFFFFB;
    }

    public MenuItem setIcon(int n2) {
        this.mIconDrawable = null;
        this.mIconResId = n2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIsActionButton(boolean bl2) {
        if (bl2) {
            this.mFlags |= 0x20;
            return;
        }
        this.mFlags &= 0xFFFFFFDF;
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MenuItem setNumericShortcut(char c2) {
        if (this.mShortcutNumericChar == c2) {
            return this;
        }
        this.mShortcutNumericChar = c2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.setOnActionExpandListener()");
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char c2, char c3) {
        this.mShortcutNumericChar = c2;
        this.mShortcutAlphabeticChar = Character.toLowerCase(c3);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public void setShowAsAction(int n2) {
        switch (n2 & 3) {
            default: {
                throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mShowAsAction = n2;
        this.mMenu.onItemActionRequestChanged(this);
    }

    @Override
    public SupportMenuItem setShowAsActionFlags(int n2) {
        this.setShowAsAction(n2);
        return this;
    }

    public void setSubMenu(SubMenuBuilder subMenuBuilder) {
        this.mSubMenu = subMenuBuilder;
        subMenuBuilder.setHeaderTitle(this.getTitle());
    }

    @Override
    public SupportMenuItem setSupportActionProvider(ActionProvider actionProvider) {
        if (this.mActionProvider != null) {
            this.mActionProvider.reset();
        }
        this.mActionView = null;
        this.mActionProvider = actionProvider;
        this.mMenu.onItemsChanged(true);
        if (this.mActionProvider != null) {
            this.mActionProvider.setVisibilityListener((ActionProvider.VisibilityListener)new 1(this));
        }
        return this;
    }

    @Override
    public SupportMenuItem setSupportOnActionExpandListener(MenuItemCompat.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
        return this;
    }

    public MenuItem setTitle(int n2) {
        return this.setTitle(this.mMenu.getContext().getString(n2));
    }

    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemsChanged(false);
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(charSequence);
        }
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
            charSequence = this.mTitle;
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setVisible(boolean bl2) {
        if (this.setVisibleInt(bl2)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setVisibleInt(boolean bl2) {
        boolean bl3 = false;
        int n2 = this.mFlags;
        int n3 = this.mFlags;
        int n4 = bl2 ? 0 : 8;
        this.mFlags = n4 | n3 & 0xFFFFFFF7;
        bl2 = bl3;
        if (n2 == this.mFlags) return bl2;
        return true;
    }

    public boolean shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean shouldShowShortcut() {
        if (!this.mMenu.isShortcutsVisible()) return false;
        if (this.getShortcut() == '\u0000') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showsTextAsAction() {
        if ((this.mShowAsAction & 4) != 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.mTitle == null) return null;
        return this.mTitle.toString();
    }
}

