/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.TintTypedArray;
import android.support.v7.widget.ViewUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LinearLayoutCompat
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    private boolean mBaselineAligned = true;
    private int mBaselineAlignedChildIndex = -1;
    private int mBaselineChildTop = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    private int mGravity = 0x800033;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private int mOrientation;
    private int mShowDividers;
    private int mTotalLength;
    private boolean mUseLargestChild;
    private float mWeightSum;

    public LinearLayoutCompat(Context context) {
        this(context, null);
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LinearLayoutCompat(Context object, AttributeSet attributeSet, int n2) {
        super((Context)object, attributeSet, n2);
        boolean bl2;
        object = TintTypedArray.obtainStyledAttributes((Context)object, attributeSet, R.styleable.LinearLayoutCompat, n2, 0);
        n2 = ((TintTypedArray)object).getInt(R.styleable.LinearLayoutCompat_android_orientation, -1);
        if (n2 >= 0) {
            this.setOrientation(n2);
        }
        if ((n2 = ((TintTypedArray)object).getInt(R.styleable.LinearLayoutCompat_android_gravity, -1)) >= 0) {
            this.setGravity(n2);
        }
        if (!(bl2 = ((TintTypedArray)object).getBoolean(R.styleable.LinearLayoutCompat_android_baselineAligned, true))) {
            this.setBaselineAligned(bl2);
        }
        this.mWeightSum = ((TintTypedArray)object).getFloat(R.styleable.LinearLayoutCompat_android_weightSum, -1.0f);
        this.mBaselineAlignedChildIndex = ((TintTypedArray)object).getInt(R.styleable.LinearLayoutCompat_android_baselineAlignedChildIndex, -1);
        this.mUseLargestChild = ((TintTypedArray)object).getBoolean(R.styleable.LinearLayoutCompat_measureWithLargestChild, false);
        this.setDividerDrawable(((TintTypedArray)object).getDrawable(R.styleable.LinearLayoutCompat_divider));
        this.mShowDividers = ((TintTypedArray)object).getInt(R.styleable.LinearLayoutCompat_showDividers, 0);
        this.mDividerPadding = ((TintTypedArray)object).getDimensionPixelSize(R.styleable.LinearLayoutCompat_dividerPadding, 0);
        ((TintTypedArray)object).recycle();
    }

    private void forceUniformHeight(int n2, int n3) {
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getVirtualChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.height != -1) continue;
            int n5 = layoutParams.width;
            layoutParams.width = view.getMeasuredWidth();
            this.measureChildWithMargins(view, n3, 0, n4, 0);
            layoutParams.width = n5;
        }
    }

    private void forceUniformWidth(int n2, int n3) {
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getVirtualChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.width != -1) continue;
            int n5 = layoutParams.height;
            layoutParams.height = view.getMeasuredHeight();
            this.measureChildWithMargins(view, n4, 0, n3, 0);
            layoutParams.height = n5;
        }
    }

    private void setChildFrame(View view, int n2, int n3, int n4, int n5) {
        view.layout(n2, n3, n2 + n4, n3 + n5);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersHorizontal(Canvas canvas) {
        LayoutParams layoutParams;
        View view;
        int n2;
        int n3 = this.getVirtualChildCount();
        boolean bl2 = ViewUtils.isLayoutRtl((View)this);
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            view = this.getVirtualChildAt(n2);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(n2)) continue;
            layoutParams = (LayoutParams)view.getLayoutParams();
            if (bl2) {
                n4 = view.getRight();
                n4 = layoutParams.rightMargin + n4;
            } else {
                n4 = view.getLeft() - layoutParams.leftMargin - this.mDividerWidth;
            }
            this.drawVerticalDivider(canvas, n4);
        }
        if (this.hasDividerBeforeChildAt(n3)) {
            view = this.getVirtualChildAt(n3 - 1);
            if (view == null) {
                n2 = bl2 ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                layoutParams = (LayoutParams)view.getLayoutParams();
                if (bl2) {
                    n2 = view.getLeft() - layoutParams.leftMargin - this.mDividerWidth;
                } else {
                    n2 = view.getRight();
                    n2 = layoutParams.rightMargin + n2;
                }
            }
            this.drawVerticalDivider(canvas, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersVertical(Canvas canvas) {
        int n2;
        int n3 = this.getVirtualChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getVirtualChildAt(n2);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(n2)) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            this.drawHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin - this.mDividerHeight);
        }
        if (this.hasDividerBeforeChildAt(n3)) {
            View view = this.getVirtualChildAt(n3 - 1);
            if (view == null) {
                n2 = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                n2 = view.getBottom();
                n2 = layoutParams.bottomMargin + n2;
            }
            this.drawHorizontalDivider(canvas, n2);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n2, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, this.mDividerHeight + n2);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(n2, this.getPaddingTop() + this.mDividerPadding, this.mDividerWidth + n2, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -2);
        }
        if (this.mOrientation != 1) return null;
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getBaseline() {
        int n2 = -1;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View view = this.getChildAt(this.mBaselineAlignedChildIndex);
        int n3 = view.getBaseline();
        if (n3 == -1) {
            if (this.mBaselineAlignedChildIndex == 0) return n2;
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        n2 = this.mBaselineChildTop;
        if (this.mOrientation != 1) return ((LayoutParams)view.getLayoutParams()).topMargin + n2 + n3;
        int n4 = this.mGravity & 0x70;
        if (n4 == 48) return ((LayoutParams)view.getLayoutParams()).topMargin + n2 + n3;
        switch (n4) {
            case 80: {
                n2 = this.getBottom() - this.getTop() - this.getPaddingBottom() - this.mTotalLength;
            }
            default: {
                return ((LayoutParams)view.getLayoutParams()).topMargin + n2 + n3;
            }
            case 16: {
                n2 += (this.getBottom() - this.getTop() - this.getPaddingTop() - this.getPaddingBottom() - this.mTotalLength) / 2;
            }
        }
        return ((LayoutParams)view.getLayoutParams()).topMargin + n2 + n3;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View view, int n2) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    int getLocationOffset(View view) {
        return 0;
    }

    int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    View getVirtualChildAt(int n2) {
        return this.getChildAt(n2);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasDividerBeforeChildAt(int n2) {
        boolean bl2;
        boolean bl3 = true;
        if (n2 == 0) {
            if ((this.mShowDividers & 1) == 0) return false;
            return bl3;
        }
        if (n2 == this.getChildCount()) {
            bl2 = bl3;
            if ((this.mShowDividers & 4) != 0) return bl2;
            return false;
        }
        if ((this.mShowDividers & 2) == 0) return false;
        --n2;
        while (n2 >= 0) {
            bl2 = bl3;
            if (this.getChildAt(n2).getVisibility() != 8) return bl2;
            --n2;
        }
        return false;
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutHorizontal(int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl2 = ViewUtils.isLayoutRtl((View)this);
        int n7 = this.getPaddingTop();
        int n8 = n5 - n3;
        int n9 = this.getPaddingBottom();
        int n10 = this.getPaddingBottom();
        int n11 = this.getVirtualChildCount();
        n3 = this.mGravity;
        int n12 = this.mGravity;
        boolean bl3 = this.mBaselineAligned;
        int[] nArray = this.mMaxAscent;
        int[] nArray2 = this.mMaxDescent;
        switch (GravityCompat.getAbsoluteGravity(n3 & 0x800007, ViewCompat.getLayoutDirection((View)this))) {
            default: {
                n2 = this.getPaddingLeft();
                break;
            }
            case 5: {
                n2 = this.getPaddingLeft() + n4 - n2 - this.mTotalLength;
                break;
            }
            case 1: {
                n2 = this.getPaddingLeft() + (n4 - n2 - this.mTotalLength) / 2;
            }
        }
        if (bl2) {
            n6 = -1;
            n5 = n11 - 1;
        } else {
            n6 = 1;
            n5 = 0;
        }
        n3 = 0;
        n4 = n2;
        while (true) {
            block16: {
                block17: {
                    block14: {
                        int n13;
                        View view;
                        int n14;
                        block15: {
                            if (n3 >= n11) break block14;
                            n14 = n5 + n6 * n3;
                            view = this.getVirtualChildAt(n14);
                            if (view != null) break block15;
                            n4 += this.measureNullChild(n14);
                            n2 = n3;
                            break block16;
                        }
                        if (view.getVisibility() == 8) break block17;
                        int n15 = view.getMeasuredWidth();
                        int n16 = view.getMeasuredHeight();
                        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                        int n17 = bl3 && layoutParams.height != -1 ? view.getBaseline() : -1;
                        n2 = n13 = layoutParams.gravity;
                        if (n13 < 0) {
                            n2 = n12 & 0x70;
                        }
                        switch (n2 & 0x70) {
                            default: {
                                n2 = n7;
                                break;
                            }
                            case 48: {
                                n2 = n13 = n7 + layoutParams.topMargin;
                                if (n17 == -1) break;
                                n2 = n13 + (nArray[1] - n17);
                                break;
                            }
                            case 16: {
                                n2 = (n8 - n7 - n10 - n16) / 2 + n7 + layoutParams.topMargin - layoutParams.bottomMargin;
                                break;
                            }
                            case 80: {
                                n2 = n13 = n8 - n9 - n16 - layoutParams.bottomMargin;
                                if (n17 == -1) break;
                                n2 = view.getMeasuredHeight();
                                n2 = n13 - (nArray2[2] - (n2 - n17));
                            }
                        }
                        if (this.hasDividerBeforeChildAt(n14)) {
                            n4 = this.mDividerWidth + n4;
                        }
                        this.setChildFrame(view, (n4 += layoutParams.leftMargin) + this.getLocationOffset(view), n2, n15, n16);
                        n4 += layoutParams.rightMargin + n15 + this.getNextLocationOffset(view);
                        n2 = this.getChildrenSkipCount(view, n14) + n3;
                        break block16;
                    }
                    return;
                }
                n2 = n3;
            }
            n3 = n2 + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutVertical(int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingLeft();
        int n7 = n4 - n2;
        int n8 = this.getPaddingRight();
        int n9 = this.getPaddingRight();
        int n10 = this.getVirtualChildCount();
        n2 = this.mGravity;
        int n11 = this.mGravity;
        switch (n2 & 0x70) {
            default: {
                n2 = this.getPaddingTop();
                break;
            }
            case 80: {
                n2 = this.getPaddingTop() + n5 - n3 - this.mTotalLength;
                break;
            }
            case 16: {
                n2 = this.getPaddingTop() + (n5 - n3 - this.mTotalLength) / 2;
            }
        }
        n4 = 0;
        n3 = n2;
        for (n2 = n4; n2 < n10; ++n2) {
            View view = this.getVirtualChildAt(n2);
            if (view == null) {
                n3 += this.measureNullChild(n2);
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n12 = view.getMeasuredWidth();
            int n13 = view.getMeasuredHeight();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            n4 = n5 = layoutParams.gravity;
            if (n5 < 0) {
                n4 = n11 & 0x800007;
            }
            switch (GravityCompat.getAbsoluteGravity(n4, ViewCompat.getLayoutDirection((View)this)) & 7) {
                default: {
                    n4 = n6 + layoutParams.leftMargin;
                    break;
                }
                case 1: {
                    n4 = (n7 - n6 - n9 - n12) / 2 + n6 + layoutParams.leftMargin - layoutParams.rightMargin;
                    break;
                }
                case 5: {
                    n4 = n7 - n8 - n12 - layoutParams.rightMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(n2)) {
                n3 = this.mDividerHeight + n3;
            }
            this.setChildFrame(view, n4, (n3 += layoutParams.topMargin) + this.getLocationOffset(view), n12, n13);
            n3 += layoutParams.bottomMargin + n13 + this.getNextLocationOffset(view);
            n2 = this.getChildrenSkipCount(view, n2) + n2;
        }
    }

    void measureChildBeforeLayout(View view, int n2, int n3, int n4, int n5, int n6) {
        this.measureChildWithMargins(view, n3, n4, n5, n6);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void measureHorizontal(int var1_1, int var2_2) {
        block53: {
            block71: {
                block52: {
                    block57: {
                        block56: {
                            block55: {
                                block54: {
                                    block58: {
                                        block70: {
                                            block67: {
                                                block69: {
                                                    block68: {
                                                        block66: {
                                                            block51: {
                                                                this.mTotalLength = 0;
                                                                var3_3 = 0;
                                                                var4_4 = 0;
                                                                var5_5 = 0;
                                                                var6_6 = 0;
                                                                var7_7 = 1;
                                                                var8_8 = 0.0f;
                                                                var9_9 = this.getVirtualChildCount();
                                                                var10_10 = View.MeasureSpec.getMode((int)var1_1);
                                                                var11_11 = View.MeasureSpec.getMode((int)var2_2);
                                                                var12_12 = 0;
                                                                var13_13 = 0;
                                                                if (this.mMaxAscent == null || this.mMaxDescent == null) {
                                                                    this.mMaxAscent = new int[4];
                                                                    this.mMaxDescent = new int[4];
                                                                }
                                                                var14_14 = this.mMaxAscent;
                                                                var15_15 /* !! */  = this.mMaxDescent;
                                                                var14_14[3] = -1;
                                                                var14_14[2] = -1;
                                                                var14_14[1] = -1;
                                                                var14_14[0] = -1;
                                                                var15_15 /* !! */ [3] = -1;
                                                                var15_15 /* !! */ [2] = -1;
                                                                var15_15 /* !! */ [1] = -1;
                                                                var15_15 /* !! */ [0] = -1;
                                                                var16_16 = this.mBaselineAligned;
                                                                var17_17 = this.mUseLargestChild;
                                                                if (var10_10 == 0x40000000) {
                                                                    var18_18 = true;
lbl30:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var19_19 = -2147483648;
                                                                        block1: for (var20_20 = 0; var20_20 < var9_9; ++var20_20) {
                                                                            var21_21 /* !! */  = this.getVirtualChildAt(var20_20);
                                                                            if (var21_21 /* !! */  == null) {
                                                                                this.mTotalLength += this.measureNullChild(var20_20);
                                                                                var22_22 = var19_19;
                                                                                var23_23 = var13_13;
                                                                                var19_19 = var3_3;
                                                                                var13_13 = var4_4;
                                                                                var3_3 = var7_7;
                                                                                var7_7 = var23_23;
                                                                                var4_4 = var22_22;
lbl43:
                                                                                // 3 sources

                                                                                while (true) {
                                                                                    var23_23 = var3_3;
                                                                                    var3_3 = var13_13;
                                                                                    var22_22 = var19_19;
                                                                                    var19_19 = var4_4;
                                                                                    var13_13 = var7_7;
                                                                                    var7_7 = var23_23;
                                                                                    var4_4 = var3_3;
                                                                                    var3_3 = var22_22;
                                                                                    continue block1;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            break block51;
                                                                        }
                                                                        break block52;
                                                                        break;
                                                                    }
                                                                }
                                                                var18_18 = false;
                                                                ** while (true)
                                                            }
                                                            if (var21_21 /* !! */ .getVisibility() != 8) break block66;
                                                            var24_24 = var20_20 + this.getChildrenSkipCount(var21_21 /* !! */ , var20_20);
                                                            var20_20 = var19_19;
                                                            var23_23 = var13_13;
                                                            var19_19 = var7_7;
                                                            var13_13 = var4_4;
                                                            var22_22 = var3_3;
                                                            var4_4 = var20_20;
                                                            var7_7 = var23_23;
                                                            var20_20 = var24_24;
                                                            var3_3 = var19_19;
                                                            var19_19 = var22_22;
                                                            ** GOTO lbl43
                                                        }
                                                        if (this.hasDividerBeforeChildAt(var20_20)) {
                                                            this.mTotalLength += this.mDividerWidth;
                                                        }
                                                        var25_25 = (LayoutParams)var21_21 /* !! */ .getLayoutParams();
                                                        var8_8 += var25_25.weight;
                                                        if (var10_10 != 0x40000000 || var25_25.width != 0 || !(var25_25.weight > 0.0f)) break block67;
                                                        if (!var18_18) break block68;
                                                        this.mTotalLength += var25_25.leftMargin + var25_25.rightMargin;
lbl79:
                                                        // 2 sources

                                                        while (var16_16) {
                                                            var22_22 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                                                            var21_21 /* !! */ .measure(var22_22, var22_22);
                                                            var23_23 = var13_13;
                                                            var22_22 = var19_19;
lbl84:
                                                            // 4 sources

                                                            block4: while (true) {
                                                                var13_13 = 0;
                                                                if (var11_11 == 0x40000000 || var25_25.height != -1) break block53;
                                                                var19_19 = 1;
                                                                var13_13 = 1;
lbl89:
                                                                // 2 sources

                                                                while (true) {
                                                                    var12_12 = var25_25.topMargin;
                                                                    var24_24 = var25_25.bottomMargin + var12_12;
                                                                    var12_12 = var21_21 /* !! */ .getMeasuredHeight() + var24_24;
                                                                    var26_26 = ViewUtils.combineMeasuredStates(var4_4, ViewCompat.getMeasuredState(var21_21 /* !! */ ));
                                                                    if (!var16_16 || (var27_27 = var21_21 /* !! */ .getBaseline()) == -1) ** GOTO lbl101
                                                                    if (var25_25.gravity >= 0) break block54;
                                                                    var4_4 = this.mGravity;
lbl97:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var4_4 = ((var4_4 & 112) >> 4 & -2) >> 1;
                                                                        var14_14[var4_4] = Math.max(var14_14[var4_4], var27_27);
                                                                        var15_15 /* !! */ [var4_4] = Math.max(var15_15 /* !! */ [var4_4], var12_12 - var27_27);
lbl101:
                                                                        // 2 sources

                                                                        var27_27 = Math.max(var3_3, var12_12);
                                                                        if (var7_7 == 0 || var25_25.height != -1) break block55;
                                                                        var3_3 = 1;
lbl104:
                                                                        // 2 sources

                                                                        while (var25_25.weight > 0.0f) {
                                                                            if (var13_13 != 0) {
                                                                                var7_7 = var24_24;
lbl107:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    var4_4 = Math.max(var6_6, var7_7);
                                                                                    var7_7 = var5_5;
lbl110:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var20_20 += this.getChildrenSkipCount(var21_21 /* !! */ , var20_20);
                                                                                        var6_6 = var4_4;
                                                                                        var5_5 = var7_7;
                                                                                        var12_12 = var27_27;
                                                                                        var4_4 = var22_22;
                                                                                        var13_13 = var26_26;
                                                                                        var22_22 = var19_19;
                                                                                        var7_7 = var23_23;
                                                                                        var19_19 = var12_12;
                                                                                        var12_12 = var22_22;
                                                                                        ** continue;
                                                                                        break;
                                                                                    }
                                                                                    break;
                                                                                }
lbl122:
                                                                                // 1 sources

                                                                                break block4;
                                                                            }
                                                                            break block56;
                                                                        }
                                                                        break block57;
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                            ** GOTO lbl43
                                                        }
                                                        break block69;
                                                    }
                                                    var22_22 = this.mTotalLength;
                                                    this.mTotalLength = Math.max(var22_22, var25_25.leftMargin + var22_22 + var25_25.rightMargin);
                                                    ** GOTO lbl79
                                                }
                                                var23_23 = 1;
                                                var22_22 = var19_19;
                                                ** GOTO lbl84
                                            }
                                            var22_22 = var23_23 = -2147483648;
                                            if (var25_25.width == 0) {
                                                var22_22 = var23_23;
                                                if (var25_25.weight > 0.0f) {
                                                    var22_22 = 0;
                                                    var25_25.width = -2;
                                                }
                                            }
                                            if (var8_8 != 0.0f) break block70;
                                            var23_23 = this.mTotalLength;
lbl144:
                                            // 2 sources

                                            while (true) {
                                                this.measureChildBeforeLayout(var21_21 /* !! */ , var20_20, var1_1, var23_23, var2_2, 0);
                                                if (var22_22 != -2147483648) {
                                                    var25_25.width = var22_22;
                                                }
                                                var24_24 = var21_21 /* !! */ .getMeasuredWidth();
                                                if (!var18_18) break block58;
                                                this.mTotalLength += var25_25.leftMargin + var24_24 + var25_25.rightMargin + this.getNextLocationOffset(var21_21 /* !! */ );
lbl151:
                                                // 2 sources

                                                while (true) {
                                                    var22_22 = var19_19;
                                                    var23_23 = var13_13;
                                                    if (!var17_17) ** GOTO lbl84
                                                    var22_22 = Math.max(var24_24, var19_19);
                                                    var23_23 = var13_13;
                                                    ** continue;
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        var23_23 = 0;
                                        ** while (true)
                                    }
                                    var22_22 = this.mTotalLength;
                                    this.mTotalLength = Math.max(var22_22, var22_22 + var24_24 + var25_25.leftMargin + var25_25.rightMargin + this.getNextLocationOffset(var21_21 /* !! */ ));
                                    ** while (true)
                                }
                                var4_4 = var25_25.gravity;
                                ** while (true)
                            }
                            var3_3 = 0;
                            ** GOTO lbl104
                        }
                        var7_7 = var12_12;
                        ** while (true)
                    }
                    if (var13_13 != 0) {
                        var12_12 = var24_24;
                    }
                    var7_7 = Math.max(var5_5, var12_12);
                    var4_4 = var6_6;
                    ** while (true)
                }
                if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(var9_9)) {
                    this.mTotalLength += this.mDividerWidth;
                }
                if (var14_14[1] == -1 && var14_14[0] == -1 && var14_14[2] == -1 && var14_14[3] == -1) break block71;
                var20_20 = Math.max(var3_3, Math.max(var14_14[3], Math.max(var14_14[0], Math.max(var14_14[1], var14_14[2]))) + Math.max(var15_15 /* !! */ [3], Math.max(var15_15 /* !! */ [0], Math.max(var15_15 /* !! */ [1], var15_15 /* !! */ [2]))));
lbl185:
                // 2 sources

                while (true) {
                    block59: {
                        block79: {
                            block65: {
                                block75: {
                                    block78: {
                                        block77: {
                                            block72: {
                                                if (!var17_17 || var10_10 != -2147483648 && var10_10 != 0) break block72;
                                                this.mTotalLength = 0;
                                                block13: for (var3_3 = 0; var3_3 < var9_9; ++var3_3) {
                                                    block74: {
                                                        block73: {
                                                            var21_21 /* !! */  = this.getVirtualChildAt(var3_3);
                                                            if (var21_21 /* !! */  == null) {
                                                                this.mTotalLength += this.measureNullChild(var3_3);
lbl192:
                                                                // 4 sources

                                                                continue block13;
                                                            }
                                                            if (var21_21 /* !! */ .getVisibility() != 8) break block73;
                                                            var3_3 = this.getChildrenSkipCount(var21_21 /* !! */ , var3_3) + var3_3;
                                                            ** GOTO lbl192
                                                        }
                                                        var25_25 = (LayoutParams)var21_21 /* !! */ .getLayoutParams();
                                                        if (!var18_18) break block74;
                                                        var22_22 = this.mTotalLength;
                                                        var23_23 = var25_25.leftMargin;
                                                        this.mTotalLength = var25_25.rightMargin + (var23_23 + var19_19) + this.getNextLocationOffset(var21_21 /* !! */ ) + var22_22;
                                                        ** GOTO lbl192
                                                    }
                                                    var23_23 = this.mTotalLength;
                                                    var22_22 = var25_25.leftMargin;
                                                    this.mTotalLength = Math.max(var23_23, var25_25.rightMargin + (var23_23 + var19_19 + var22_22) + this.getNextLocationOffset(var21_21 /* !! */ ));
                                                    ** continue;
                                                }
                                            }
                                            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
                                            var24_24 = ViewCompat.resolveSizeAndState(Math.max(this.mTotalLength, this.getSuggestedMinimumWidth()), var1_1, 0);
                                            var3_3 = (0xFFFFFF & var24_24) - this.mTotalLength;
                                            if (var13_13 == 0 && (var3_3 == 0 || !(var8_8 > 0.0f))) break block75;
                                            if (this.mWeightSum > 0.0f) {
                                                var8_8 = this.mWeightSum;
                                            }
                                            var14_14[3] = -1;
                                            var14_14[2] = -1;
                                            var14_14[1] = -1;
                                            var14_14[0] = -1;
                                            var15_15 /* !! */ [3] = -1;
                                            var15_15 /* !! */ [2] = -1;
                                            var15_15 /* !! */ [1] = -1;
                                            var15_15 /* !! */ [0] = -1;
                                            this.mTotalLength = 0;
                                            var20_20 = 0;
                                            var6_6 = var5_5;
                                            var13_13 = var4_4;
                                            var19_19 = var3_3;
                                            var3_3 = -1;
                                            var5_5 = var20_20;
                                            var4_4 = var6_6;
                                            block15: while (var5_5 < var9_9) {
                                                block63: {
                                                    block62: {
                                                        block61: {
                                                            block64: {
                                                                block60: {
                                                                    block76: {
                                                                        var25_25 = this.getVirtualChildAt(var5_5);
                                                                        if (var25_25 == null) break block59;
                                                                        if (var25_25.getVisibility() == 8) {
                                                                            var6_6 = var19_19;
                                                                            var19_19 = var3_3;
                                                                            var3_3 = var4_4;
                                                                            var4_4 = var7_7;
                                                                            var7_7 = var6_6;
lbl241:
                                                                            // 3 sources

                                                                            while (true) {
                                                                                var6_6 = var5_5 + 1;
                                                                                var5_5 = var19_19;
                                                                                var19_19 = var7_7;
                                                                                var7_7 = var4_4;
                                                                                var4_4 = var3_3;
                                                                                var3_3 = var5_5;
                                                                                var5_5 = var6_6;
                                                                                continue block15;
                                                                                break;
                                                                            }
                                                                        }
                                                                        var21_21 /* !! */  = (LayoutParams)var25_25.getLayoutParams();
                                                                        var28_28 = var21_21 /* !! */ .weight;
                                                                        if (!(var28_28 > 0.0f)) ** GOTO lbl265
                                                                        var20_20 = (int)((float)var19_19 * var28_28 / var8_8);
                                                                        var6_6 = var19_19 - var20_20;
                                                                        var22_22 = LinearLayoutCompat.getChildMeasureSpec((int)var2_2, (int)(this.getPaddingTop() + this.getPaddingBottom() + var21_21 /* !! */ .topMargin + var21_21 /* !! */ .bottomMargin), (int)var21_21 /* !! */ .height);
                                                                        if (var21_21 /* !! */ .width == 0 && var10_10 == 0x40000000) break block76;
                                                                        var19_19 = var20_20 += var25_25.getMeasuredWidth();
                                                                        if (var20_20 < 0) {
                                                                            var19_19 = 0;
                                                                        }
                                                                        var25_25.measure(View.MeasureSpec.makeMeasureSpec((int)var19_19, (int)0x40000000), var22_22);
lbl261:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            var13_13 = ViewUtils.combineMeasuredStates(var13_13, ViewCompat.getMeasuredState((View)var25_25) & -16777216);
                                                                            var8_8 -= var28_28;
                                                                            var19_19 = var6_6;
lbl265:
                                                                            // 2 sources

                                                                            if (!var18_18) break block60;
                                                                            this.mTotalLength += var25_25.getMeasuredWidth() + var21_21 /* !! */ .leftMargin + var21_21 /* !! */ .rightMargin + this.getNextLocationOffset((View)var25_25);
lbl267:
                                                                            // 2 sources

                                                                            while (var11_11 != 0x40000000 && var21_21 /* !! */ .height == -1) {
                                                                                var6_6 = 1;
lbl269:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    var23_23 = var21_21 /* !! */ .topMargin + var21_21 /* !! */ .bottomMargin;
                                                                                    var22_22 = var25_25.getMeasuredHeight() + var23_23;
                                                                                    var20_20 = Math.max(var3_3, var22_22);
                                                                                    if (var6_6 == 0) break block61;
                                                                                    var3_3 = var23_23;
lbl275:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var3_3 = Math.max(var4_4, var3_3);
                                                                                        if (var7_7 == 0 || var21_21 /* !! */ .height != -1) break block62;
                                                                                        var7_7 = 1;
lbl279:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            if (!var16_16 || (var6_6 = var25_25.getBaseline()) == -1) ** GOTO lbl287
                                                                                            if (var21_21 /* !! */ .gravity >= 0) break block63;
                                                                                            var4_4 = this.mGravity;
lbl283:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                var4_4 = ((var4_4 & 112) >> 4 & -2) >> 1;
                                                                                                var14_14[var4_4] = Math.max(var14_14[var4_4], var6_6);
                                                                                                var15_15 /* !! */ [var4_4] = Math.max(var15_15 /* !! */ [var4_4], var22_22 - var6_6);
lbl287:
                                                                                                // 2 sources

                                                                                                var4_4 = var7_7;
                                                                                                var7_7 = var19_19;
                                                                                                var19_19 = var20_20;
                                                                                                ** GOTO lbl241
                                                                                                break;
                                                                                            }
                                                                                            break;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                    break;
                                                                                }
                                                                            }
                                                                            break block64;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if (var20_20 > 0) {
                                                                        var19_19 = var20_20;
lbl295:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            var25_25.measure(View.MeasureSpec.makeMeasureSpec((int)var19_19, (int)0x40000000), var22_22);
                                                                            ** continue;
                                                                            break;
                                                                        }
                                                                    }
                                                                    var19_19 = 0;
                                                                    ** continue;
                                                                }
                                                                var6_6 = this.mTotalLength;
                                                                this.mTotalLength = Math.max(var6_6, var25_25.getMeasuredWidth() + var6_6 + var21_21 /* !! */ .leftMargin + var21_21 /* !! */ .rightMargin + this.getNextLocationOffset((View)var25_25));
                                                                ** GOTO lbl267
                                                            }
                                                            var6_6 = 0;
                                                            ** continue;
                                                        }
                                                        var3_3 = var22_22;
                                                        ** continue;
                                                    }
                                                    var7_7 = 0;
                                                    ** continue;
                                                }
                                                var4_4 = var21_21 /* !! */ .gravity;
                                                ** continue;
                                            }
                                            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
                                            if (var14_14[1] != -1 || var14_14[0] != -1 || var14_14[2] != -1) break block77;
                                            var19_19 = var3_3;
                                            if (var14_14[3] == -1) break block78;
                                        }
                                        var19_19 = Math.max(var3_3, Math.max(var14_14[3], Math.max(var14_14[0], Math.max(var14_14[1], var14_14[2]))) + Math.max(var15_15 /* !! */ [3], Math.max(var15_15 /* !! */ [0], Math.max(var15_15 /* !! */ [1], var15_15 /* !! */ [2]))));
                                    }
                                    var3_3 = var7_7;
                                    var7_7 = var13_13;
                                    var13_13 = var3_3;
                                    var3_3 = var4_4;
lbl327:
                                    // 2 sources

                                    while (true) {
                                        if (var13_13 == 0 && var11_11 != 0x40000000) lbl-1000:
                                        // 2 sources

                                        {
                                            while (true) {
                                                this.setMeasuredDimension(-16777216 & var7_7 | var24_24, ViewCompat.resolveSizeAndState(Math.max(var3_3 + (this.getPaddingTop() + this.getPaddingBottom()), this.getSuggestedMinimumHeight()), var2_2, var7_7 << 16));
                                                if (var12_12 != 0) {
                                                    this.forceUniformHeight(var9_9, var1_1);
                                                }
                                                return;
                                            }
                                        }
                                        break block65;
                                        break;
                                    }
                                }
                                var13_13 = Math.max(var5_5, var6_6);
                                if (!var17_17 || var10_10 == 0x40000000) break block79;
                                block26: for (var3_3 = 0; var3_3 < var9_9; ++var3_3) {
                                    var15_15 /* !! */  = (int[])this.getVirtualChildAt(var3_3);
                                    if (var15_15 /* !! */  == null || var15_15 /* !! */ .getVisibility() == 8) lbl-1000:
                                    // 3 sources

                                    {
                                        continue block26;
                                    }
                                    if (!(((LayoutParams)var15_15 /* !! */ .getLayoutParams()).weight > 0.0f)) ** GOTO lbl-1000
                                    var15_15 /* !! */ .measure(View.MeasureSpec.makeMeasureSpec((int)var19_19, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)var15_15 /* !! */ .getMeasuredHeight(), (int)0x40000000));
                                    ** continue;
                                }
                                break block79;
                            }
                            var3_3 = var19_19;
                            ** continue;
                        }
                        var3_3 = var13_13;
                        var19_19 = var20_20;
                        var13_13 = var7_7;
                        var7_7 = var4_4;
                        ** continue;
                    }
                    var6_6 = var19_19;
                    var19_19 = var3_3;
                    var3_3 = var4_4;
                    var4_4 = var7_7;
                    var7_7 = var6_6;
                    ** continue;
                    break;
                }
            }
            var20_20 = var3_3;
            ** while (true)
        }
        var19_19 = var12_12;
        ** while (true)
    }

    int measureNullChild(int n2) {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    void measureVertical(int var1_1, int var2_2) {
        block42: {
            block44: {
                block57: {
                    block48: {
                        block55: {
                            block53: {
                                this.mTotalLength = 0;
                                var3_3 = 0;
                                var4_4 = 0;
                                var5_5 = 0;
                                var6_6 = 0;
                                var7_7 = 1;
                                var8_8 = 0.0f;
                                var9_9 = this.getVirtualChildCount();
                                var10_10 = View.MeasureSpec.getMode((int)var1_1);
                                var11_11 = View.MeasureSpec.getMode((int)var2_2);
                                var12_12 = 0;
                                var13_13 = 0;
                                var14_14 = this.mBaselineAlignedChildIndex;
                                var15_15 = this.mUseLargestChild;
                                var16_16 = -2147483648;
                                block0: for (var17_17 = 0; var17_17 < var9_9; ++var17_17) {
                                    block41: {
                                        block50: {
                                            block49: {
                                                var18_18 = this.getVirtualChildAt(var17_17);
                                                if (var18_18 == null) {
                                                    this.mTotalLength += this.measureNullChild(var17_17);
                                                    var19_19 = var16_16;
                                                    var20_20 = var13_13;
                                                    var13_13 = var7_7;
                                                    var16_16 = var3_3;
                                                    var7_7 = var4_4;
                                                    var3_3 = var20_20;
                                                    var4_4 = var19_19;
lbl27:
                                                    // 3 sources

                                                    while (true) {
                                                        var20_20 = var4_4;
                                                        var4_4 = var13_13;
                                                        var19_19 = var7_7;
                                                        var21_21 = var16_16;
                                                        var16_16 = var20_20;
                                                        var13_13 = var3_3;
                                                        var7_7 = var4_4;
                                                        var4_4 = var19_19;
                                                        var3_3 = var21_21;
                                                        continue block0;
                                                        break;
                                                    }
                                                }
                                                if (var18_18.getVisibility() != 8) break block49;
                                                var20_20 = var17_17 + this.getChildrenSkipCount(var18_18, var17_17);
                                                var19_19 = var16_16;
                                                var17_17 = var13_13;
                                                var13_13 = var7_7;
                                                var7_7 = var4_4;
                                                var16_16 = var3_3;
                                                var4_4 = var19_19;
                                                var3_3 = var17_17;
                                                var17_17 = var20_20;
                                                ** GOTO lbl27
                                            }
                                            if (this.hasDividerBeforeChildAt(var17_17)) {
                                                this.mTotalLength += this.mDividerHeight;
                                            }
                                            var22_22 = (LayoutParams)var18_18.getLayoutParams();
                                            var8_8 += var22_22.weight;
                                            if (var11_11 == 0x40000000 && var22_22.height == 0 && var22_22.weight > 0.0f) {
                                                var13_13 = this.mTotalLength;
                                                this.mTotalLength = Math.max(var13_13, var22_22.topMargin + var13_13 + var22_22.bottomMargin);
                                                var20_20 = 1;
                                                var19_19 = var16_16;
lbl59:
                                                // 3 sources

                                                while (true) {
                                                    if (var14_14 >= 0 && var14_14 == var17_17 + 1) {
                                                        this.mBaselineChildTop = this.mTotalLength;
                                                    }
                                                    if (var17_17 < var14_14 && var22_22.weight > 0.0f) {
                                                        throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
                                                    }
                                                    break block41;
                                                    break;
                                                }
                                            }
                                            var19_19 = var20_20 = -2147483648;
                                            if (var22_22.height == 0) {
                                                var19_19 = var20_20;
                                                if (var22_22.weight > 0.0f) {
                                                    var19_19 = 0;
                                                    var22_22.height = -2;
                                                }
                                            }
                                            if (var8_8 != 0.0f) break block50;
                                            var20_20 = this.mTotalLength;
lbl73:
                                            // 2 sources

                                            while (true) {
                                                this.measureChildBeforeLayout(var18_18, var17_17, var1_1, 0, var2_2, var20_20);
                                                if (var19_19 != -2147483648) {
                                                    var22_22.height = var19_19;
                                                }
                                                var21_21 = var18_18.getMeasuredHeight();
                                                var19_19 = this.mTotalLength;
                                                this.mTotalLength = Math.max(var19_19, var19_19 + var21_21 + var22_22.topMargin + var22_22.bottomMargin + this.getNextLocationOffset(var18_18));
                                                var19_19 = var16_16;
                                                var20_20 = var13_13;
                                                if (!var15_15) ** GOTO lbl59
                                                var19_19 = Math.max(var21_21, var16_16);
                                                var20_20 = var13_13;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        var20_20 = 0;
                                        ** continue;
                                    }
                                    var13_13 = 0;
                                    if (var10_10 == 0x40000000 || var22_22.width != -1) break block42;
                                    var16_16 = 1;
                                    var12_12 = 1;
lbl94:
                                    // 2 sources

                                    while (true) {
                                        block52: {
                                            block43: {
                                                block51: {
                                                    var13_13 = var22_22.leftMargin;
                                                    var21_21 = var22_22.rightMargin + var13_13;
                                                    var23_23 = var18_18.getMeasuredWidth() + var21_21;
                                                    var24_24 = Math.max(var3_3, var23_23);
                                                    var25_25 = ViewUtils.combineMeasuredStates(var4_4, ViewCompat.getMeasuredState(var18_18));
                                                    if (var7_7 == 0 || var22_22.width != -1) break block51;
                                                    var13_13 = 1;
lbl102:
                                                    // 2 sources

                                                    while (var22_22.weight > 0.0f) {
                                                        if (var12_12 == 0) break block43;
lbl104:
                                                        // 2 sources

                                                        while (true) {
                                                            var3_3 = Math.max(var6_6, var21_21);
                                                            var4_4 = var5_5;
lbl107:
                                                            // 2 sources

                                                            while (true) {
                                                                var17_17 += this.getChildrenSkipCount(var18_18, var17_17);
                                                                var6_6 = var3_3;
                                                                var5_5 = var4_4;
                                                                var12_12 = var24_24;
                                                                var4_4 = var19_19;
                                                                var7_7 = var25_25;
                                                                var19_19 = var16_16;
                                                                var3_3 = var20_20;
                                                                var16_16 = var12_12;
                                                                var12_12 = var19_19;
                                                                ** continue;
                                                                break;
                                                            }
                                                            break;
                                                        }
lbl119:
                                                        // 1 sources

                                                        ** GOTO lbl27
                                                    }
                                                    break block52;
                                                }
                                                var13_13 = 0;
                                                ** GOTO lbl102
                                            }
                                            var21_21 = var23_23;
                                            ** continue;
                                        }
                                        if (var12_12 != 0) lbl-1000:
                                        // 2 sources

                                        {
                                            while (true) {
                                                var4_4 = Math.max(var5_5, var21_21);
                                                var3_3 = var6_6;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        var21_21 = var23_23;
                                        ** continue;
                                        break;
                                    }
                                }
                                if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(var9_9)) {
                                    this.mTotalLength += this.mDividerHeight;
                                }
                                if (!var15_15 || var11_11 != -2147483648 && var11_11 != 0) break block53;
                                this.mTotalLength = 0;
                                block9: for (var17_17 = 0; var17_17 < var9_9; ++var17_17) {
                                    block54: {
                                        var18_18 = this.getVirtualChildAt(var17_17);
                                        if (var18_18 == null) {
                                            this.mTotalLength += this.measureNullChild(var17_17);
lbl143:
                                            // 3 sources

                                            continue block9;
                                        }
                                        if (var18_18.getVisibility() != 8) break block54;
                                        var17_17 = this.getChildrenSkipCount(var18_18, var17_17) + var17_17;
                                        ** GOTO lbl143
                                    }
                                    var22_22 = (LayoutParams)var18_18.getLayoutParams();
                                    var19_19 = this.mTotalLength;
                                    var20_20 = var22_22.topMargin;
                                    this.mTotalLength = Math.max(var19_19, var22_22.bottomMargin + (var19_19 + var16_16 + var20_20) + this.getNextLocationOffset(var18_18));
                                    ** continue;
                                }
                            }
                            this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
                            var20_20 = ViewCompat.resolveSizeAndState(Math.max(this.mTotalLength, this.getSuggestedMinimumHeight()), var2_2, 0);
                            var17_17 = (0xFFFFFF & var20_20) - this.mTotalLength;
                            if (var13_13 == 0 && (var17_17 == 0 || !(var8_8 > 0.0f))) break block55;
                            if (this.mWeightSum > 0.0f) {
                                var8_8 = this.mWeightSum;
                            }
                            this.mTotalLength = 0;
                            var16_16 = 0;
                            var13_13 = var7_7;
                            var7_7 = var5_5;
                            var5_5 = var17_17;
                            var17_17 = var16_16;
                            var16_16 = var3_3;
                            var3_3 = var13_13;
                            var13_13 = var5_5;
                            block11: while (var17_17 < var9_9) {
                                block46: {
                                    block47: {
                                        block45: {
                                            block56: {
                                                var18_18 = this.getVirtualChildAt(var17_17);
                                                if (var18_18.getVisibility() == 8) {
                                                    var5_5 = var7_7;
                                                    var7_7 = var16_16;
                                                    var16_16 = var5_5;
lbl176:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var17_17;
                                                        var5_5 = var7_7;
                                                        var7_7 = var16_16;
                                                        var16_16 = var5_5;
                                                        continue block11;
                                                        break;
                                                    }
                                                }
                                                var22_22 = (LayoutParams)var18_18.getLayoutParams();
                                                var26_26 = var22_22.weight;
                                                if (!(var26_26 > 0.0f)) break block44;
                                                var6_6 = (int)((float)var13_13 * var26_26 / var8_8);
                                                var21_21 = LinearLayoutCompat.getChildMeasureSpec((int)var1_1, (int)(this.getPaddingLeft() + this.getPaddingRight() + var22_22.leftMargin + var22_22.rightMargin), (int)var22_22.width);
                                                if (var22_22.height == 0 && var11_11 == 0x40000000) break block56;
                                                var5_5 = var19_19 = var6_6 + var18_18.getMeasuredHeight();
                                                if (var19_19 < 0) {
                                                    var5_5 = 0;
                                                }
                                                var18_18.measure(var21_21, View.MeasureSpec.makeMeasureSpec((int)var5_5, (int)0x40000000));
lbl192:
                                                // 2 sources

                                                while (true) {
                                                    var5_5 = ViewUtils.combineMeasuredStates(var4_4, ViewCompat.getMeasuredState(var18_18) & -256);
                                                    var4_4 = var13_13 - var6_6;
                                                    var13_13 = var5_5;
                                                    var8_8 -= var26_26;
lbl197:
                                                    // 2 sources

                                                    while (true) {
                                                        var6_6 = var22_22.leftMargin + var22_22.rightMargin;
                                                        var19_19 = var18_18.getMeasuredWidth() + var6_6;
                                                        var5_5 = Math.max(var16_16, var19_19);
                                                        if (var10_10 == 0x40000000 || var22_22.width != -1) break block45;
                                                        var16_16 = 1;
lbl203:
                                                        // 2 sources

                                                        while (var16_16 != 0) {
                                                            var16_16 = var6_6;
lbl205:
                                                            // 2 sources

                                                            while (true) {
                                                                var16_16 = Math.max(var7_7, var16_16);
                                                                if (var3_3 == 0 || var22_22.width != -1) break block46;
                                                                var3_3 = 1;
lbl209:
                                                                // 2 sources

                                                                while (true) {
                                                                    var19_19 = this.mTotalLength;
                                                                    var6_6 = var18_18.getMeasuredHeight();
                                                                    var7_7 = var22_22.topMargin;
                                                                    this.mTotalLength = Math.max(var19_19, var22_22.bottomMargin + (var6_6 + var19_19 + var7_7) + this.getNextLocationOffset(var18_18));
                                                                    var7_7 = var5_5;
                                                                    var5_5 = var4_4;
                                                                    var4_4 = var13_13;
                                                                    var13_13 = var5_5;
                                                                    ** continue;
                                                                    break;
                                                                }
                                                                break;
                                                            }
lbl219:
                                                            // 1 sources

                                                            ** GOTO lbl176
                                                        }
                                                        break block47;
                                                        break;
                                                    }
                                                    break;
                                                }
                                            }
                                            if (var6_6 > 0) {
                                                var5_5 = var6_6;
lbl224:
                                                // 2 sources

                                                while (true) {
                                                    var18_18.measure(var21_21, View.MeasureSpec.makeMeasureSpec((int)var5_5, (int)0x40000000));
                                                    ** continue;
                                                    break;
                                                }
                                            }
                                            var5_5 = 0;
                                            ** continue;
                                        }
                                        var16_16 = 0;
                                        ** GOTO lbl203
                                    }
                                    var16_16 = var19_19;
                                    ** continue;
                                }
                                var3_3 = 0;
                                ** continue;
                            }
                            this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
                            var13_13 = var3_3;
                            var3_3 = var16_16;
                            var16_16 = var7_7;
lbl242:
                            // 2 sources

                            while (true) {
                                if (var13_13 == 0 && var10_10 != 0x40000000) lbl-1000:
                                // 2 sources

                                {
                                    while (true) {
                                        this.setMeasuredDimension(ViewCompat.resolveSizeAndState(Math.max(var16_16 + (this.getPaddingLeft() + this.getPaddingRight()), this.getSuggestedMinimumWidth()), var1_1, var4_4), var20_20);
                                        if (var12_12 != 0) {
                                            this.forceUniformWidth(var9_9, var2_2);
                                        }
                                        return;
                                    }
                                }
                                break block48;
                                break;
                            }
                        }
                        var5_5 = Math.max(var5_5, var6_6);
                        if (!var15_15 || var11_11 == 0x40000000) break block57;
                        block21: for (var13_13 = 0; var13_13 < var9_9; ++var13_13) {
                            var22_22 = this.getVirtualChildAt(var13_13);
                            if (var22_22 == null || var22_22.getVisibility() == 8) lbl-1000:
                            // 3 sources

                            {
                                continue block21;
                            }
                            if (!(((LayoutParams)var22_22.getLayoutParams()).weight > 0.0f)) ** GOTO lbl-1000
                            var22_22.measure(View.MeasureSpec.makeMeasureSpec((int)var22_22.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)var16_16, (int)0x40000000));
                            ** continue;
                        }
                        break block57;
                    }
                    var16_16 = var3_3;
                    ** while (true)
                }
                var16_16 = var5_5;
                var13_13 = var7_7;
                ** while (true)
            }
            var5_5 = var4_4;
            var4_4 = var13_13;
            var13_13 = var5_5;
            ** while (true)
        }
        var16_16 = var12_12;
        var12_12 = var13_13;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
            return;
        }
        this.drawDividersHorizontal(canvas);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onInitializeAccessibilityEvent(accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)LinearLayoutCompat.class.getName());
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
            accessibilityNodeInfo.setClassName((CharSequence)LinearLayoutCompat.class.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        if (this.mOrientation == 1) {
            this.layoutVertical(n2, n3, n4, n5);
            return;
        }
        this.layoutHorizontal(n2, n3, n4, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int n2, int n3) {
        if (this.mOrientation == 1) {
            this.measureVertical(n2, n3);
            return;
        }
        this.measureHorizontal(n2, n3);
    }

    public void setBaselineAligned(boolean bl2) {
        this.mBaselineAligned = bl2;
    }

    public void setBaselineAlignedChildIndex(int n2) {
        if (n2 < 0 || n2 >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDividerDrawable(Drawable drawable2) {
        boolean bl2 = false;
        if (drawable2 == this.mDivider) {
            return;
        }
        this.mDivider = drawable2;
        if (drawable2 != null) {
            this.mDividerWidth = drawable2.getIntrinsicWidth();
            this.mDividerHeight = drawable2.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        if (drawable2 == null) {
            bl2 = true;
        }
        this.setWillNotDraw(bl2);
        this.requestLayout();
    }

    public void setDividerPadding(int n2) {
        this.mDividerPadding = n2;
    }

    public void setGravity(int n2) {
        if (this.mGravity != n2) {
            if ((0x800007 & n2) == 0) {
                n2 = 0x800003 | n2;
            }
            int n3 = n2;
            if ((n2 & 0x70) == 0) {
                n3 = n2 | 0x30;
            }
            this.mGravity = n3;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int n2) {
        if ((this.mGravity & 0x800007) != (n2 &= 0x800007)) {
            this.mGravity = n2 | this.mGravity & 0xFF7FFFF8;
            this.requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean bl2) {
        this.mUseLargestChild = bl2;
    }

    public void setOrientation(int n2) {
        if (this.mOrientation != n2) {
            this.mOrientation = n2;
            this.requestLayout();
        }
    }

    public void setShowDividers(int n2) {
        if (n2 != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = n2;
    }

    public void setVerticalGravity(int n2) {
        if ((this.mGravity & 0x70) != (n2 &= 0x70)) {
            this.mGravity = n2 | this.mGravity & 0xFFFFFF8F;
            this.requestLayout();
        }
    }

    public void setWeightSum(float f2) {
        this.mWeightSum = Math.max(0.0f, f2);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;
        public float weight;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
            this.weight = 0.0f;
        }

        public LayoutParams(int n2, int n3, float f2) {
            super(n2, n3);
            this.weight = f2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.LinearLayoutCompat_Layout);
            this.weight = context.getFloat(R.styleable.LinearLayoutCompat_Layout_android_layout_weight, 0.0f);
            this.gravity = context.getInt(R.styleable.LinearLayoutCompat_Layout_android_layout_gravity, -1);
            context.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.weight = layoutParams.weight;
            this.gravity = layoutParams.gravity;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

