/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.android.gmacs.activity.GmacsContactDetailInfoActivity;
import com.android.gmacs.activity.GmacsContactRemarkActivity;
import com.android.gmacs.event.AddContactMsgEvent;
import com.android.gmacs.event.RemarkEvent;
import com.android.gmacs.event.StarEvent;
import com.android.gmacs.logic.ContactLogic;
import com.android.gmacs.view.GmacsDialog;
import com.android.gmacs.view.NetworkImageView;
import com.android.gmacs.view.TitleBar;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.parse.contact.Contact;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.utils.GmacsUiUtil;
import com.common.gmacs.utils.ImageUtil;
import com.common.gmacs.utils.ToastUtil;
import com.wuba.wchat.api.Define;
import org.greenrobot.eventbus.ThreadMode;
import org.greenrobot.eventbus.c;
import org.greenrobot.eventbus.j;

public class GmacsContactDetailInfoActivity
extends BaseActivity
implements View.OnClickListener {
    protected String deviceId = "";
    private View mContactLine;
    private NetworkImageView mIvAvatar;
    private LinearLayout mLlContactDetailPhoneAll;
    private RelativeLayout mRlContactDetailRemark;
    private RelativeLayout mRlContactDetailRemarkContentInfo;
    protected boolean mStar;
    private TextView mTvContactChatbtn;
    private TextView mTvContactDetailName;
    private TextView mTvContactDetailPhoneNum;
    private TextView mTvContactDetailRename;
    private TextView mTvContactRemarkContent;
    public int talkType;
    protected String userId;
    protected Contact userInfo;
    protected int userSource;

    /*
     * Enabled aggressive block sorting
     */
    private void updateRemarkInfo() {
        int n2 = 8;
        if (TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_telephone) && TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_info)) {
            this.mRlContactDetailRemark.setVisibility(8);
        } else {
            this.mRlContactDetailRemark.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_name)) {
            this.mTvContactDetailRename.setVisibility(0);
            this.mTvContactDetailRename.setText((CharSequence)this.userInfo.remark.remark_name);
        } else {
            this.mTvContactDetailRename.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_telephone)) {
            this.mLlContactDetailPhoneAll.setVisibility(0);
            this.mTvContactDetailPhoneNum.setText((CharSequence)this.userInfo.remark.remark_telephone);
        } else {
            this.mLlContactDetailPhoneAll.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_info)) {
            this.mRlContactDetailRemarkContentInfo.setVisibility(8);
            this.mContactLine.setVisibility(8);
            return;
        }
        this.mRlContactDetailRemarkContentInfo.setVisibility(0);
        this.mTvContactRemarkContent.setText((CharSequence)this.userInfo.remark.remark_info);
        View view = this.mContactLine;
        if (!TextUtils.isEmpty((CharSequence)this.userInfo.remark.remark_telephone)) {
            n2 = 0;
        }
        view.setVisibility(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void initData() {
        this.userId = this.getIntent().getStringExtra("userid");
        this.userSource = this.getIntent().getIntExtra("usersource", 0);
        this.deviceId = this.getIntent().getStringExtra("deviceId");
        if (this.userId == null) {
            this.mRlContactDetailRemark.setVisibility(8);
        }
        this.talkType = this.getIntent().getIntExtra("talkType", Gmacs.TalkType.TALKETYPE_NORMAL.getValue());
        TextView textView = this.mTvContactDetailName;
        String string2 = this.userInfo == null ? "" : this.userInfo.getUserName();
        textView.setText((CharSequence)string2);
        c.a().a(this);
        ContactLogic.getInstance().getUserInfo(this.userId, this.userSource);
    }

    @Override
    protected void initView() {
        this.setTitle(this.getText(R.string.contact_detail));
        this.mIvAvatar = (NetworkImageView)this.findViewById(R.id.iv_avatar);
        this.mTvContactDetailName = (TextView)this.findViewById(R.id.tv_contact_detail_name);
        this.mTvContactDetailRename = (TextView)this.findViewById(R.id.tv_contact_detail_rename);
        this.mTvContactChatbtn = (TextView)this.findViewById(R.id.tv_contact_chatbtn);
        RelativeLayout relativeLayout = (RelativeLayout)this.findViewById(R.id.rl_contact_detail_phone);
        this.mTvContactDetailPhoneNum = (TextView)this.findViewById(R.id.tv_contact_detail_phone_num);
        this.mTvContactRemarkContent = (TextView)this.findViewById(R.id.tv_contact_remark_content);
        this.mLlContactDetailPhoneAll = (LinearLayout)this.findViewById(R.id.ll_contact_detail_phone_all);
        this.mRlContactDetailRemarkContentInfo = (RelativeLayout)this.findViewById(R.id.rl_contact_detail_remark_content_info);
        RelativeLayout relativeLayout2 = (RelativeLayout)this.findViewById(R.id.rl_contact_detail_remark_content);
        this.mRlContactDetailRemark = (RelativeLayout)this.findViewById(R.id.rl_contact_detail_remark);
        this.mContactLine = this.findViewById(R.id.contact_line);
        if (this.mTvContactChatbtn != null) {
            this.mTvContactChatbtn.setOnClickListener((View.OnClickListener)this);
        }
        relativeLayout.setOnClickListener((View.OnClickListener)this);
        relativeLayout2.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @j(a=ThreadMode.MAIN)
    public void onAddContactMsg(AddContactMsgEvent addContactMsgEvent) {
        if (addContactMsgEvent.getAcceptFriendMessage() == null) {
            ToastUtil.showToast(this.getText(R.string.add_contact_sent));
            return;
        }
        this.updateTitleBar(true);
        this.mTitleBar.setSubRightImageView(R.drawable.gmacs_ic_unstars);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onClick(View object) {
        int n2 = object.getId();
        if (n2 == R.id.tv_contact_chatbtn) {
            Message.MessageUserInfo messageUserInfo = new Message.MessageUserInfo();
            messageUserInfo.mUserId = this.userId;
            messageUserInfo.mUserSource = this.userSource;
            messageUserInfo.mTalkType = this.talkType;
            messageUserInfo.mDeviceId = this.deviceId;
            this.startActivity(new Intent(GmacsUiUtil.createToChatActivity((Context)this, "", messageUserInfo)));
            this.overridePendingTransition(R.anim.gmacs_push_left_in, R.anim.gmacs_push_left_out);
            return;
        }
        if (n2 == R.id.rl_contact_detail_phone) {
            Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + this.mTvContactDetailPhoneNum.getText())));
            intent.setFlags(0x10000000);
            this.startActivity(intent);
            return;
        }
        if (n2 != R.id.rl_contact_detail_remark_content) return;
        Intent intent = new Intent((Context)this, GmacsContactRemarkActivity.class);
        intent.putExtra("userid", this.userId);
        intent.putExtra("usersource", this.userSource);
        if (this.userInfo != null) {
            intent.putExtra("remark", (Parcelable)this.userInfo.remark);
        }
        this.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_contact_detail_info);
    }

    @Override
    protected void onDestroy() {
        c.a().b(this);
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    @j(a=ThreadMode.MAIN)
    public void onGetOtherUserInfo(Contact object) {
        if (!this.userId.equals(((Contact)object).getUserId())) return;
        if (this.userSource != ((Contact)object).getUserSource()) return;
        this.userInfo = object;
        this.mStar = this.userInfo.isStar();
        object = this.userInfo.getUserName();
        this.mTvContactDetailName.setText((CharSequence)object);
        this.mIvAvatar.setDefaultImageResId(R.drawable.gmacs_ic_default_avatar).setErrorImageResId(R.drawable.gmacs_ic_default_avatar).setImageUrl(ImageUtil.makeUpUrl(this.userInfo.getAvatar(), NetworkImageView.IMG_RESIZE, NetworkImageView.IMG_RESIZE));
        if (!this.userId.equals(Gmacs.getInstance().getGmacsUserInfo().userId) || this.userSource != Gmacs.getInstance().getGmacsUserInfo().userSource) {
            this.updateTitleBar(this.userInfo.isContact());
            this.mTvContactChatbtn.setVisibility(0);
        } else {
            this.mTitleBar.setSubRightImageView(0);
            this.mTitleBar.setRightImageView(0);
            this.mTvContactChatbtn.setVisibility(8);
        }
        if (Gmacs.TalkType.TALKETYPE_OFFICIAL.getValue() == this.talkType) {
            this.mTvContactDetailRename.setVisibility(8);
            this.mRlContactDetailRemark.setVisibility(8);
            return;
        }
        this.updateRemarkInfo();
    }

    @j(a=ThreadMode.MAIN)
    public void onRemark(RemarkEvent remarkEvent) {
        if (this.userId.equals(remarkEvent.getUserId()) && this.userSource == remarkEvent.getUserSource() && Gmacs.TalkType.TALKETYPE_OFFICIAL.getValue() != this.talkType) {
            this.userInfo.remark = remarkEvent.getRemark();
            this.updateRemarkInfo();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @j(a=ThreadMode.MAIN)
    public void onStarEvent(StarEvent starEvent) {
        block4: {
            block3: {
                if (!this.userId.equals(starEvent.getUserId()) || this.userSource != starEvent.getUserSource()) break block3;
                if (!starEvent.isStar()) break block4;
                ToastUtil.showToast(this.getText(R.string.starred_ok));
                this.mTitleBar.setSubRightImageView(R.drawable.gmacs_ic_stars);
                this.mStar = true;
            }
            return;
        }
        ToastUtil.showToast(this.getText(R.string.unstarred_ok));
        this.mTitleBar.setSubRightImageView(R.drawable.gmacs_ic_unstars);
        this.mStar = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateTitleBar(final boolean bl2) {
        this.mTitleBar.setRightImageView(R.drawable.gmacs_ic_contact_edit);
        TitleBar titleBar = this.mTitleBar;
        int n2 = bl2 ? (this.mStar ? R.drawable.gmacs_ic_stars : R.drawable.gmacs_ic_unstars) : 0;
        titleBar.setSubRightImageView(n2);
        this.mTitleBar.setRightImageViewListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View object) {
                object = new GmacsDialog.Builder(object.getContext(), 1);
                if (bl2) {
                    ((GmacsDialog.Builder)object).initDialog((AdapterView.OnItemClickListener)new 1(this, (GmacsDialog.Builder)object)).setListTexts(new String[]{GmacsContactDetailInfoActivity.this.getString(R.string.edit_remark), GmacsContactDetailInfoActivity.this.getString(R.string.report), GmacsContactDetailInfoActivity.this.getString(R.string.delete_contact)}).create().show();
                    return;
                }
                ((GmacsDialog.Builder)object).initDialog((AdapterView.OnItemClickListener)new 2(this, (GmacsDialog.Builder)object)).setListTexts(new String[]{GmacsContactDetailInfoActivity.this.getString(R.string.add_contact)}).create().show();
            }
        });
        this.mTitleBar.setSubRightImageViewListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (ClientManager.getInstance().getConnectionStatus() == Define.ConnectionStatus.STATUS_CONNECTED.getValue()) {
                    if (GmacsContactDetailInfoActivity.this.mStar) {
                        ContactLogic.getInstance().unStar(GmacsContactDetailInfoActivity.this.userId, GmacsContactDetailInfoActivity.this.userSource);
                        return;
                    }
                    ContactLogic.getInstance().star(GmacsContactDetailInfoActivity.this.userId, GmacsContactDetailInfoActivity.this.userSource);
                    return;
                }
                ToastUtil.showToast(GmacsContactDetailInfoActivity.this.getText(R.string.connection_error_or_kickedoff));
            }
        });
    }
}

