/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.android.gmacs.activity.GmacsMapActivity;
import com.android.gmacs.view.GmacsDialog;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.search.core.SearchResult;
import com.baidu.mapapi.search.geocode.GeoCodeResult;
import com.baidu.mapapi.search.geocode.GeoCoder;
import com.baidu.mapapi.search.geocode.OnGetGeoCoderResultListener;
import com.baidu.mapapi.search.geocode.ReverseGeoCodeOption;
import com.baidu.mapapi.search.geocode.ReverseGeoCodeResult;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.ToastUtil;

public class GmacsMapActivity
extends BaseActivity
implements OnGetGeoCoderResultListener {
    public static final String ADDRESS = "address";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    private final long fLocationTimeout;
    private GeoCoder geoCoder = null;
    private boolean isOnlyShow;
    private String mAddress;
    private BaiduMap mBaiduMap;
    private Point mCenterPoint = null;
    private Handler mHandler;
    private double mLantitude;
    private LocationClient mLocClient = null;
    private MyLocationListener mLocationListener = new MyLocationListener();
    private double mLongtitude;
    private MapView mMapView;
    private View mMarker;
    private View mProgressBar;
    private GmacsDialog mProgressDialog;
    private Runnable mRunnable;
    private TextView mTextView;
    private View mViewShow;
    BaiduMap.OnMapTouchListener touchListener = new BaiduMap.OnMapTouchListener(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onTouch(MotionEvent motionEvent) {
            switch (motionEvent.getAction()) {
                case 2: {
                    GmacsMapActivity.this.mTextView.setText(null);
                    GmacsMapActivity.this.mViewShow.setVisibility(8);
                }
                default: {
                    return;
                }
                case 1: 
            }
            GmacsMapActivity.this.mMarker.startAnimation(AnimationUtils.loadAnimation((Context)GmacsMapActivity.this, (int)R.anim.gmacs_translate_up));
            GmacsMapActivity.this.mViewShow.setVisibility(0);
            GmacsMapActivity.this.mProgressBar.setVisibility(0);
        }
    };

    public GmacsMapActivity() {
        this.fLocationTimeout = 60000L;
    }

    static /* synthetic */ Point access$202(GmacsMapActivity gmacsMapActivity, Point point) {
        gmacsMapActivity.mCenterPoint = point;
        return point;
    }

    static /* synthetic */ Runnable access$600(GmacsMapActivity gmacsMapActivity) {
        return gmacsMapActivity.mRunnable;
    }

    static /* synthetic */ Handler access$700(GmacsMapActivity gmacsMapActivity) {
        return gmacsMapActivity.mHandler;
    }

    private void initMyLocation() {
        this.mBaiduMap.setMyLocationEnabled(true);
        this.mLocClient = new LocationClient((Context)this);
        this.mLocClient.registerLocationListener(this.mLocationListener);
        LocationClientOption locationClientOption = new LocationClientOption();
        locationClientOption.setOpenGps(true);
        locationClientOption.setCoorType("bd09ll");
        locationClientOption.setScanSpan(1000);
        locationClientOption.setIsNeedAddress(true);
        locationClientOption.setNeedDeviceDirect(true);
        this.mLocClient.setLocOption(locationClientOption);
        this.mLocClient.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reverseGeoCode(LatLng latLng) {
        if (this.isFinishing()) {
            return;
        }
        if (this.geoCoder == null) {
            this.geoCoder = GeoCoder.newInstance();
        }
        this.mLantitude = latLng.latitude;
        this.mLongtitude = latLng.longitude;
        this.geoCoder.setOnGetGeoCodeResultListener(this);
        this.geoCoder.reverseGeoCode(new ReverseGeoCodeOption().location(latLng));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rightViewClickTodo() {
        if (this.isOnlyShow) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                Uri uri = Uri.parse((String)stringBuilder.append("geo:").append(this.mLantitude).append(",").append(this.mLongtitude).append("?z=").append(16).toString());
                stringBuilder = new Intent("android.intent.action.VIEW", uri);
                this.startActivity((Intent)stringBuilder);
                return;
            }
            catch (Exception exception) {
                ToastUtil.showToast(this.getText(R.string.action_not_handle));
                return;
            }
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        Intent intent = new Intent();
        intent.putExtra(ADDRESS, this.mAddress);
        intent.putExtra(LONGITUDE, this.mLongtitude);
        intent.putExtra(LATITUDE, this.mLantitude);
        this.setResult(-1, intent);
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showAddress() {
        this.mViewShow.setVisibility(0);
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        this.mTextView.setVisibility(0);
        this.mProgressBar.setVisibility(8);
        if (TextUtils.isEmpty((CharSequence)this.mAddress)) {
            this.mTextView.setText((CharSequence)(this.mLantitude + "," + this.mLongtitude));
        } else {
            this.mTextView.setText((CharSequence)this.mAddress);
        }
        this.mTitleBar.mRightTextView.setClickable(true);
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        if (this.mLocClient != null && this.mLocationListener != null) {
            this.mLocClient.stop();
            this.mLocClient.unRegisterLocationListener(this.mLocationListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void initData() {
        Intent intent = this.getIntent();
        this.mAddress = intent.getStringExtra(ADDRESS);
        double d2 = intent.getDoubleExtra(LONGITUDE, -1.0);
        double d3 = intent.getDoubleExtra(LATITUDE, -1.0);
        boolean bl2 = d2 != -1.0 && d3 != -1.0;
        this.isOnlyShow = bl2;
        if (!this.isOnlyShow) {
            this.mHandler = new Handler();
            this.mRunnable = new Runnable(){

                @Override
                public void run() {
                    if (GmacsMapActivity.this.mProgressDialog != null) {
                        GmacsMapActivity.this.mProgressDialog.dismiss();
                    }
                    ToastUtil.showToast(GmacsMapActivity.this.getText(R.string.location_unavailable));
                    GmacsMapActivity.this.finish();
                }
            };
            this.mHandler.postDelayed(this.mRunnable, 60000L);
            this.mMarker.setVisibility(0);
            this.mTitleBar.mRightTextView.setClickable(false);
            this.mProgressDialog = new GmacsDialog.Builder((Context)this, 4).initDialog(this.getText(R.string.requesting)).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    GmacsMapActivity.this.onBackPressed();
                }
            }).create();
            this.mProgressDialog.show();
            this.initMyLocation();
            this.mBaiduMap.setOnMapTouchListener(this.touchListener);
            this.mBaiduMap.setOnMapStatusChangeListener(new BaiduMap.OnMapStatusChangeListener(){

                @Override
                public void onMapStatusChange(MapStatus mapStatus) {
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void onMapStatusChangeFinish(MapStatus object) {
                    if (GmacsMapActivity.this.isFinishing()) {
                        return;
                    }
                    LatLng latLng = GmacsMapActivity.this.mBaiduMap.getProjection().fromScreenLocation(GmacsMapActivity.this.mCenterPoint);
                    new Handler().postDelayed((Runnable)new 1(this, latLng), 500L);
                }

                @Override
                public void onMapStatusChangeStart(MapStatus mapStatus) {
                }
            });
            return;
        }
        this.mTitleBar.setRightText(this.getText(R.string.location_detail));
        this.mBaiduMap.clear();
        LatLng latLng = new LatLng(d3, d2);
        Object object = BitmapDescriptorFactory.fromResource(R.drawable.gmacs_map_marker);
        object = new MarkerOptions().position(latLng).icon((BitmapDescriptor)object).zIndex(5);
        this.mBaiduMap.addOverlay((OverlayOptions)object);
        this.mViewShow.setVisibility(8);
        this.mViewShow = this.getLayoutInflater().inflate(R.layout.gmacs_widget_map_pop, null);
        this.mTextView = (TextView)this.mViewShow.findViewById(R.id.textview_map_pop);
        object = new InfoWindow(this.mViewShow, latLng, 0);
        this.mBaiduMap.showInfoWindow((InfoWindow)object);
        object = MapStatusUpdateFactory.newLatLng(latLng);
        this.mBaiduMap.animateMapStatus((MapStatusUpdate)object);
        if (TextUtils.isEmpty((CharSequence)this.mAddress)) {
            this.reverseGeoCode(latLng);
            return;
        }
        this.mTextView.setText((CharSequence)this.mAddress);
    }

    @Override
    protected void initView() {
        this.setTitle(this.getText(R.string.location_info));
        this.mMarker = this.findViewById(R.id.imageview);
        this.mViewShow = this.findViewById(R.id.framelayout_map_pop);
        this.mTextView = (TextView)this.findViewById(R.id.textview_map_pop);
        this.mProgressBar = this.findViewById(R.id.progressbar_map_pop);
        this.mMapView = (MapView)this.findViewById(R.id.mapview);
        this.mTitleBar.setRightText(this.getText(R.string.send));
        this.mTitleBar.setRightTextListener(new View.OnClickListener(){

            public void onClick(View view) {
                GmacsMapActivity.this.rightViewClickTodo();
            }
        });
        this.mBaiduMap = this.mMapView.getMap();
        MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.zoomTo(17.0f);
        this.mBaiduMap.setMapStatus(mapStatusUpdate);
        this.mBaiduMap.setOnMapLoadedCallback(new BaiduMap.OnMapLoadedCallback(){

            @Override
            public void onMapLoaded() {
                GmacsMapActivity.access$202(GmacsMapActivity.this, new Point());
                ((GmacsMapActivity)GmacsMapActivity.this).mCenterPoint.x = GmacsMapActivity.this.mMapView.getWidth() / 2;
                ((GmacsMapActivity)GmacsMapActivity.this).mCenterPoint.y = GmacsMapActivity.this.mMapView.getHeight() / 2;
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(new MapStatus.Builder().targetScreen(GmacsMapActivity.this.mCenterPoint).build());
                GmacsMapActivity.this.mBaiduMap.setMapStatus(mapStatusUpdate);
            }
        });
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_activity_map);
    }

    @Override
    protected void onDestroy() {
        if (this.geoCoder != null) {
            this.geoCoder.destroy();
        }
        if (this.mLocClient != null) {
            this.mLocClient.stop();
        }
        this.mBaiduMap.setMyLocationEnabled(false);
        this.mMapView.onDestroy();
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        super.onDestroy();
    }

    @Override
    public void onGetGeoCodeResult(GeoCodeResult geoCodeResult) {
        if (geoCodeResult == null || geoCodeResult.error != SearchResult.ERRORNO.NO_ERROR) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onGetReverseGeoCodeResult(ReverseGeoCodeResult reverseGeoCodeResult) {
        this.mAddress = reverseGeoCodeResult == null || reverseGeoCodeResult.error != SearchResult.ERRORNO.NO_ERROR ? null : reverseGeoCodeResult.getAddress();
        this.showAddress();
    }

    private class MyLocationListener
    implements BDLocationListener {
        private MyLocationListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onReceiveLocation(BDLocation object) {
            if (object == null || GmacsMapActivity.this.mMapView == null) {
                ToastUtil.showToast(GmacsMapActivity.this.getText(R.string.locate_failed));
                return;
            }
            try {
                Object object2 = new MyLocationData.Builder();
                object2 = ((MyLocationData.Builder)object2).accuracy(((BDLocation)object).getRadius()).latitude(((BDLocation)object).getLatitude()).longitude(((BDLocation)object).getLongitude()).build();
                GmacsMapActivity.this.mBaiduMap.setMyLocationData((MyLocationData)object2);
                object2 = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, true, null);
                GmacsMapActivity.this.mBaiduMap.setMyLocationConfigeration((MyLocationConfiguration)object2);
                object2 = new LatLng(((BDLocation)object).getLatitude(), ((BDLocation)object).getLongitude());
                object = MapStatusUpdateFactory.newLatLng((LatLng)object2);
                GmacsMapActivity.this.mBaiduMap.animateMapStatus((MapStatusUpdate)object);
                GmacsMapActivity.this.mLocClient.unRegisterLocationListener(GmacsMapActivity.this.mLocationListener);
                GmacsMapActivity.this.mLocClient.stop();
                GmacsMapActivity.this.reverseGeoCode((LatLng)object2);
                return;
            }
            catch (Exception exception) {
                GLog.e(GmacsMapActivity.this.TAG, exception.getMessage());
                ToastUtil.showToast(GmacsMapActivity.this.getText(R.string.baidu_map_init_failed));
                GmacsMapActivity.this.finish();
                return;
            }
        }

        public void onReceivePoi(BDLocation bDLocation) {
        }
    }
}

