/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.common.gmacs.utils.ToastUtil;

public class GmacsWebViewActivity
extends BaseActivity {
    public static final String EXTRA_TITLE = "extra_title";
    public static final String EXTRA_URL = "extra_url";
    private WebView mWebView;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPermission(Uri uri) {
        if (Build.VERSION.SDK_INT < 23) return;
        try {
            ContextCompat.class.getMethod("checkSelfPermission", Context.class, String.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return;
        }
    }

    @Override
    protected void initData() {
    }

    @Override
    protected void initView() {
        this.mWebView = (WebView)this.findViewById(R.id.wv_gmacs_webview);
        String string2 = this.getIntent().getStringExtra(EXTRA_URL);
        this.setTitle(this.getIntent().getStringExtra(EXTRA_TITLE));
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mWebView.loadUrl(string2);
            this.mWebView.setWebViewClient(new WebViewClient(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                    if (string2.startsWith("tel:")) {
                        GmacsWebViewActivity.this.checkPermission(Uri.parse((String)string2));
                        return true;
                    }
                    if (string2.startsWith("wtai:")) {
                        GmacsWebViewActivity.this.checkPermission(Uri.parse((String)string2.replace("wtai://wp/mc;", "tel:")));
                        return true;
                    }
                    webView.loadUrl(string2);
                    return true;
                }
            });
        }
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_webview);
    }

    @Override
    protected void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.destroy();
        }
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onRequestPermissionsResult(int n2, @NonNull String[] object, @NonNull int[] object2) {
        if (((int[])object2).length == 0) {
            return;
        }
        object = this.getIntent().getStringExtra(EXTRA_URL);
        if (n2 != 6) return;
        if (object2[0] != 0) {
            ToastUtil.showToast("\u60a8\u7981\u6b62\u4e86\u62e8\u6253\u7535\u8bdd\u6743\u9650");
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)((String)object).replace("wtai://wp/mc;", "tel:")));
            this.startActivity(intent);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }
}

