/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.album;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.android.gmacs.album.GmacsAlbumAdapter;
import com.android.gmacs.album.GmacsImageDao;
import com.android.gmacs.album.GmacsImgDirsActivity;
import com.android.gmacs.album.GmacsPhotoBrowseActivity;
import com.android.gmacs.album.ImageUrlArrayListWrapper;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.ToastUtil;
import java.util.ArrayList;

public class GmacsAlbumActivity
extends BaseActivity {
    private String currentDir = null;
    private String currentDirName = null;
    private ArrayList<String> dataList = new ArrayList();
    private GmacsAlbumAdapter gridImageAdapter;
    private GridView gridView;
    private int mMaxCount;
    private TextView mPreviewBtn;
    private TextView mSelectAlbumBtn;
    private boolean rawPicture;
    private ArrayList<String> selectedDataList = new ArrayList();

    static /* synthetic */ String access$602(GmacsAlbumActivity gmacsAlbumActivity, String string2) {
        gmacsAlbumActivity.currentDirName = string2;
        return string2;
    }

    static /* synthetic */ String access$702(GmacsAlbumActivity gmacsAlbumActivity, String string2) {
        gmacsAlbumActivity.currentDir = string2;
        return string2;
    }

    private void gotoGmacsImgDirsActivity() {
        ToastUtil.cancelToast();
        this.startActivityForResult(new Intent((Context)this, GmacsImgDirsActivity.class), 1000);
        this.overridePendingTransition(R.anim.gmacs_push_left_in, R.anim.gmacs_push_left_out);
    }

    private void initBottomView() {
        this.mSelectAlbumBtn = (TextView)this.findViewById(R.id.select_album);
        this.mPreviewBtn = (TextView)this.findViewById(R.id.preview_button);
    }

    private void initBottomViewListener() {
        this.mSelectAlbumBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GmacsAlbumActivity.this.gotoGmacsImgDirsActivity();
            }
        });
        this.mPreviewBtn.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (GmacsAlbumActivity.this.selectedDataList.size() > 0) {
                    GmacsAlbumActivity.this.startPhotoBrowseActivity(0, true);
                    return;
                }
                ToastUtil.showToast(GmacsAlbumActivity.this.getText(R.string.select_picture_first));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyCountInfo(int n2) {
        if (n2 > 0) {
            this.mTitleBar.mRightTextView.setText((CharSequence)String.format(this.getString(R.string.send_count), n2, this.mMaxCount));
            this.mPreviewBtn.setText((CharSequence)String.format(this.getString(R.string.preview_count), n2));
            this.mPreviewBtn.setEnabled(true);
            return;
        }
        this.mTitleBar.mRightTextView.setText(R.string.send);
        this.mPreviewBtn.setText(R.string.preview);
        this.mPreviewBtn.setEnabled(false);
    }

    private void onOk(ArrayList<String> arrayList, boolean bl2) {
        ToastUtil.cancelToast();
        Intent intent = new Intent();
        intent.putExtra("selected_img_data", (Parcelable)new ImageUrlArrayListWrapper(arrayList));
        intent.putExtra("raw", bl2);
        this.setResult(-1, intent);
        this.finish();
    }

    private void refreshData(String string2) {
        new AsyncTask<String, Void, GmacsImageDao.ImgDir>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected GmacsImageDao.ImgDir doInBackground(String ... object) {
                void var1_3;
                GmacsImageDao.destroy();
                if (TextUtils.isEmpty((CharSequence)object[0])) {
                    GmacsImageDao.instance((Context)GmacsEnvi.appContext).loadAllImgDirs();
                    GmacsImageDao.ImgDir imgDir = GmacsImageDao.instance((Context)GmacsEnvi.appContext).getDefaultDir();
                    return var1_3;
                }
                GmacsImageDao.ImgDir imgDir = GmacsImageDao.instance((Context)GmacsEnvi.appContext).getImgListByDir(object[0]);
                return var1_3;
            }

            /*
             * Enabled aggressive block sorting
             */
            protected void onPostExecute(GmacsImageDao.ImgDir imgDir) {
                if (GmacsAlbumActivity.this.isFinishing()) {
                    return;
                }
                if (imgDir != null) {
                    GmacsAlbumActivity.this.dataList.clear();
                    GmacsAlbumActivity.this.dataList.addAll(imgDir.dataList);
                    GmacsAlbumActivity.access$602(GmacsAlbumActivity.this, imgDir.dirName);
                    GmacsAlbumActivity.access$702(GmacsAlbumActivity.this, imgDir.dirPath);
                } else {
                    GmacsAlbumActivity.this.dataList.clear();
                    GmacsAlbumActivity.access$702(GmacsAlbumActivity.this, null);
                    GmacsAlbumActivity.access$602(GmacsAlbumActivity.this, null);
                    ToastUtil.showToast(GmacsAlbumActivity.this.getText(R.string.no_available_picture));
                }
                GmacsAlbumActivity.this.setTitle(GmacsAlbumActivity.this.getText(R.string.local_album));
                GmacsAlbumActivity.this.gridImageAdapter.notifyDataSetChanged();
                GmacsAlbumActivity.this.mSelectAlbumBtn.setText((CharSequence)GmacsAlbumActivity.this.currentDirName);
            }

            protected void onPreExecute() {
                super.onPreExecute();
            }
        }.execute((Object[])new String[]{string2});
    }

    private void startPhotoBrowseActivity(int n2, boolean bl2) {
        Intent intent = new Intent((Context)this, GmacsPhotoBrowseActivity.class);
        intent.putExtra("selected_img_data", (Parcelable)new ImageUrlArrayListWrapper(this.selectedDataList));
        intent.putExtra("isPreview", bl2);
        intent.putExtra("img_position", n2);
        intent.putExtra("dirPath", this.currentDir);
        intent.putExtra("raw", this.rawPicture);
        intent.putExtra("photoMaxCount", this.mMaxCount);
        this.startActivityForResult(intent, 1001);
    }

    @Override
    protected void initData() {
        this.currentDir = this.getIntent().getStringExtra("dirPath");
        this.mMaxCount = this.getIntent().getIntExtra("photoMaxCount", 10);
        this.gridImageAdapter = new GmacsAlbumAdapter((Context)this, this.dataList, this.selectedDataList, this.mMaxCount);
        this.gridView.setAdapter((ListAdapter)this.gridImageAdapter);
        this.gridImageAdapter.setOnItemClickListener(new GmacsAlbumAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int n2) {
                GmacsAlbumActivity.this.notifyCountInfo(n2);
            }
        });
        this.gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                GmacsAlbumActivity.this.startPhotoBrowseActivity(n2, false);
            }
        });
        this.initBottomViewListener();
        this.updateData();
    }

    @Override
    protected void initView() {
        this.setTitle("");
        this.mTitleBar.setBackListener(new View.OnClickListener(){

            public void onClick(View view) {
                ToastUtil.cancelToast();
                GmacsAlbumActivity.this.onBackPressed();
            }
        });
        this.mTitleBar.mRightTextView.setVisibility(0);
        this.mTitleBar.mRightTextView.setText(this.getText(R.string.send));
        this.mTitleBar.mRightTextView.setTextColor(this.getResources().getColor(R.color.gmacs_text_color_enabled));
        this.mTitleBar.mRightTextView.setBackgroundResource(R.drawable.gmacs_btn_gray);
        this.mTitleBar.mRightTextView.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (GmacsAlbumActivity.this.selectedDataList.size() > 0) {
                    GmacsAlbumActivity.this.onOk(GmacsAlbumActivity.this.selectedDataList, false);
                    return;
                }
                ToastUtil.showToast(GmacsAlbumActivity.this.getText(R.string.select_picture_first));
            }
        });
        this.gridView = (GridView)this.findViewById(R.id.myGrid);
        this.initBottomView();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (n3 == -1) {
            if (n2 == 1000) {
                if (intent != null && "update".equals(intent.getStringExtra("func"))) {
                    this.currentDir = intent.getStringExtra("dirPath");
                    this.updateData();
                }
            } else if (n2 == 1001 && intent != null) {
                ImageUrlArrayListWrapper imageUrlArrayListWrapper = (ImageUrlArrayListWrapper)intent.getParcelableExtra("selected_img_data");
                this.selectedDataList.clear();
                if ("ok".equals(intent.getStringExtra("func"))) {
                    this.onOk(imageUrlArrayListWrapper.mList, intent.getBooleanExtra("raw", false));
                } else if ("update".equals(intent.getStringExtra("func"))) {
                    this.rawPicture = intent.getBooleanExtra("raw", false);
                    if (imageUrlArrayListWrapper.mList != null) {
                        this.selectedDataList.addAll(imageUrlArrayListWrapper.mList);
                    }
                    this.gridImageAdapter.notifyDataSetChanged();
                    int n4 = intent.getIntExtra("img_position", -1);
                    if (n4 != -1) {
                        try {
                            this.gridView.smoothScrollToPosition(n4);
                        }
                        catch (Exception exception) {}
                    }
                    this.notifyCountInfo(this.selectedDataList.size());
                }
            }
        }
        super.onActivityResult(n2, n3, intent);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_activity_album_choose);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void updateData() {
        if (!TextUtils.isEmpty((CharSequence)this.currentDir)) {
            try {
                this.currentDirName = this.currentDir.substring(this.currentDir.lastIndexOf("/") + 1, this.currentDir.length());
            }
            catch (Exception exception) {
                GLog.d(this.TAG, exception.getMessage());
            }
        }
        this.dataList.clear();
        this.selectedDataList.clear();
        this.notifyCountInfo(0);
        this.refreshData(this.currentDir);
    }
}

